/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ferrari;

import oracle.jdevimpl.debugger.ferrari.DebugFerrari;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariThreadInfo;
import oracle.jdevimpl.debugger.support.DebugRegisterInfo;

final class DebugFerrariRegisterInfo
implements DebugRegisterInfo {
    DebugFerrari df;
    int stoppedCount;
    DebugFerrariThreadInfo thread;
    int offset;
    String name;
    String value;
    String hexValue;
    private int hashCode;

    DebugFerrariRegisterInfo(DebugFerrari df, DebugFerrariThreadInfo thread, int offset, String name, String value, String hexValue) {
        this.df = df;
        this.stoppedCount = df.stoppedCount;
        this.thread = thread;
        this.offset = offset;
        this.name = name;
        this.value = value;
        this.hexValue = hexValue;
    }

    public boolean hasExpired() {
        return this.df.stoppedCount != this.stoppedCount;
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new IllegalStateException("RegisterInfo has expired");
        }
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getHexValue() {
        return this.hexValue;
    }

    public boolean modifyRegister(String newValue) {
        this.throwIfExpired();
        return this.df.modifyRegister(this, newValue);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.thread.hashCode() + this.offset;
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof DebugFerrariRegisterInfo) {
            DebugFerrariRegisterInfo other = (DebugFerrariRegisterInfo)o;
            return this.df.equals(other.df) && this.thread.equals(other.thread) && this.offset == other.offset;
        }
        return false;
    }
}

