/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ferrari;

import java.lang.ref.SoftReference;
import oracle.jdevimpl.debugger.ferrari.DebugFerrari;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariStackSlotInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariStoppedListener;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariThreadInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariVariableInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugStackSlotInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;

final class DebugFerrariStackFrameInfo
implements DebugStackFrameInfo,
DebugFerrariStoppedListener {
    DebugFerrari df;
    int stoppedCount;
    DebugFerrariThreadInfo thread;
    int frame;
    DebugLocation location;
    private boolean stoppedListener;
    private SoftReference sfArguments;
    private SoftReference sfLocals;
    private SoftReference sfSlots;
    private int hashCode;

    DebugFerrariStackFrameInfo(DebugFerrari df, DebugFerrariThreadInfo thread, int frame, DebugLocation location) {
        this.df = df;
        this.stoppedCount = df.stoppedCount;
        this.thread = thread;
        this.frame = frame;
        this.location = location;
    }

    public void stoppedOrResuming(boolean stopped) {
        this.sfArguments = null;
        this.sfLocals = null;
        this.sfSlots = null;
        this.stoppedListener = false;
        this.df.removeStoppedListener(this);
    }

    DebugFerrariStackFrameInfo(DebugFerrari df, DebugFerrariThreadInfo thread, int frame) {
        this.df = df;
        this.thread = thread;
        this.frame = frame;
    }

    public boolean hasExpired() {
        return this.df.stoppedCount != this.stoppedCount;
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new IllegalStateException("StackFrame has expired");
        }
    }

    public int getFrameNumber() {
        return this.frame;
    }

    public DebugLocation getLocation() {
        return this.location;
    }

    public DebugVariableInfo[] listArguments() {
        Object o;
        this.throwIfExpired();
        if (this.sfArguments != null && (o = this.sfArguments.get()) != null) {
            return (DebugVariableInfo[])o;
        }
        DebugVariableInfo[] arguments = this.df.listArguments(this);
        this.sfArguments = new SoftReference<DebugFerrariVariableInfo[]>((DebugFerrariVariableInfo[])arguments);
        if (!this.stoppedListener) {
            this.stoppedListener = true;
            this.df.addStoppedListener(this);
        }
        return arguments;
    }

    public DebugVariableInfo[] listLocals() {
        Object o;
        this.throwIfExpired();
        if (this.sfLocals != null && (o = this.sfLocals.get()) != null) {
            return (DebugVariableInfo[])o;
        }
        DebugVariableInfo[] locals = this.df.listLocals(this);
        this.sfLocals = new SoftReference<DebugFerrariVariableInfo[]>((DebugFerrariVariableInfo[])locals);
        if (!this.stoppedListener) {
            this.stoppedListener = true;
            this.df.addStoppedListener(this);
        }
        return locals;
    }

    public DebugVariableInfo getVariable(String name) {
        return null;
    }

    public DebugStackSlotInfo[] listSlots() {
        Object o;
        this.throwIfExpired();
        if (this.sfSlots != null && (o = this.sfSlots.get()) != null) {
            return (DebugStackSlotInfo[])o;
        }
        DebugStackSlotInfo[] slots = this.df.listSlots(this);
        this.sfSlots = new SoftReference<DebugFerrariStackSlotInfo[]>((DebugFerrariStackSlotInfo[])slots);
        if (!this.stoppedListener) {
            this.stoppedListener = true;
            this.df.addStoppedListener(this);
        }
        return slots;
    }

    public int getLanguage() {
        return 1;
    }

    public boolean popBackToHere() {
        this.throwIfExpired();
        if (this.df.canPopFrames()) {
            return this.df.popBackToHere(this);
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.thread.hashCode() + this.frame;
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof DebugFerrariStackFrameInfo) {
            DebugFerrariStackFrameInfo other = (DebugFerrariStackFrameInfo)o;
            return this.df.equals(other.df) && this.thread.equals(other.thread) && this.frame == other.frame && (this.location == null ? other.location == null : this.location.equals(other.location));
        }
        return false;
    }
}

