/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ferrari;

import oracle.jdevimpl.debugger.ferrari.DebugFerrari;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariDataCompositeInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariVariableInfo;
import oracle.jdevimpl.debugger.shared.DebugSharedPrimitives;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugStackSlotInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;

final class DebugFerrariStackSlotInfo
implements DebugStackSlotInfo {
    DebugFerrari df;
    int stoppedCount;
    int index;
    long place;
    String hexValue;
    DebugFerrariVariableInfo variable;
    long possibleAddress;
    String decValue;
    DebugFerrariDataCompositeInfo data;
    private int hashCode;

    DebugFerrariStackSlotInfo(DebugFerrari df, int index, long place, String hexValue, DebugFerrariVariableInfo variable) {
        this.df = df;
        this.stoppedCount = df.stoppedCount;
        this.index = index;
        this.place = place;
        this.hexValue = hexValue;
        this.variable = variable;
        this.possibleAddress = 0L;
        this.decValue = "";
        if (hexValue.length() > 0) {
            try {
                this.possibleAddress = DebugSharedPrimitives.longFromHexString(hexValue);
                this.decValue = Long.toString(this.possibleAddress);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
    }

    public boolean hasExpired() {
        return this.df.stoppedCount != this.stoppedCount;
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new IllegalStateException("StackSlot has expired");
        }
    }

    public int getIndex() {
        return this.index;
    }

    public String getValue() {
        return this.decValue;
    }

    public String getHexValue() {
        return this.hexValue;
    }

    public DebugDataCompositeInfo getDataInfo() {
        if (this.data != null) {
            return this.data;
        }
        this.throwIfExpired();
        if (this.data == null) {
            this.data = this.df.getObjectFromAddress(this.possibleAddress);
        }
        return this.data;
    }

    public DebugVariableInfo getVariableInfo() {
        return this.variable;
    }

    public boolean modifySlot(String newValue) {
        this.throwIfExpired();
        if (this.variable != null && this.variable.data != null) {
            return this.variable.data.modifyDataWithString(newValue);
        }
        return this.df.modifySlot(this, newValue);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.index + (int)this.place;
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof DebugFerrariStackSlotInfo) {
            DebugFerrariStackSlotInfo other = (DebugFerrariStackSlotInfo)o;
            return this.df.equals(other.df) && this.index == other.index && this.place == other.place;
        }
        return false;
    }
}

