/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ferrari;

import oracle.jdevimpl.debugger.ferrari.DebugFerrari;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugThreadGroupInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;

final class DebugFerrariThreadGroupInfo
implements DebugThreadGroupInfo {
    DebugFerrari df;
    int stoppedCount;
    long groupPtr;
    String name;
    private int hashCode;

    DebugFerrariThreadGroupInfo(DebugFerrari df, long groupPtr, String name) {
        this.df = df;
        this.stoppedCount = df.stoppedCount;
        this.groupPtr = groupPtr;
        this.name = name;
    }

    public boolean hasExpired() {
        return this.df.stoppedCount != this.stoppedCount;
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new IllegalStateException("ThreadGroup has expired");
        }
    }

    public String getName() {
        return this.name;
    }

    public DebugDataObjectInfo getThreadGroupObject() {
        this.throwIfExpired();
        return this.df.getThreadGroupObject(this);
    }

    public DebugThreadGroupInfo getParent() {
        this.throwIfExpired();
        return this.df.getThreadGroupParent(this);
    }

    public DebugThreadGroupInfo[] listGroups() {
        this.throwIfExpired();
        return this.df.listThreadGroupGroups(this);
    }

    public DebugThreadInfo[] listThreads() {
        this.throwIfExpired();
        return this.df.listThreadGroupThreads(this);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = (int)this.groupPtr;
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof DebugFerrariThreadGroupInfo) {
            DebugFerrariThreadGroupInfo other = (DebugFerrariThreadGroupInfo)o;
            return this.groupPtr == other.groupPtr;
        }
        return false;
    }
}

