/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ferrari;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import oracle.ide.util.IdeProfile;
import oracle.jdevimpl.debugger.ferrari.DebugFerrari;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariConnection;

final class DebugFerrariTransport {
    private DebugFerrariConnection connection;
    private DataInputStream inputStream;
    private DataOutputStream outputStream;
    private int pointerSize;
    DebugFerrari df;
    private static final boolean loggingSend = true;
    private static final boolean loggingReceived = true;
    private static final int eventId_OJVM_SEND_MESSAGE = 3799;
    private static final boolean eventOn_OJVM_SEND_MESSAGE = IdeProfile.isEventActive((int)3799);
    private static final int eventId_OJVM_RECV_MESSAGE = 3798;
    private static final boolean eventOn_OJVM_RECV_MESSAGE = IdeProfile.isEventActive((int)3798);

    DebugFerrariTransport(DebugFerrariConnection connection) throws IOException {
        this.connection = connection;
        this.inputStream = new DataInputStream(new BufferedInputStream(connection.getInputStream(), 16384));
        this.outputStream = new DataOutputStream(new BufferedOutputStream(connection.getOutputStream()));
        this.pointerSize = 4;
    }

    int getPointerSize() {
        return this.pointerSize;
    }

    void setPointerSize(int pointerSize) {
        this.pointerSize = pointerSize;
    }

    boolean isConnected() {
        return this.inputStream != null && this.outputStream != null;
    }

    synchronized void disconnect() {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.connection != null) {
                this.connection.closeConnection();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.inputStream = null;
        this.outputStream = null;
        this.connection = null;
    }

    private synchronized void sendStringImpl(String s) {
        if (this.outputStream == null) {
            return;
        }
        try {
            if (s != null) {
                byte[] buffer = s.getBytes("UTF8");
                this.outputStream.writeInt(buffer.length);
                this.outputStream.write(buffer);
            } else {
                this.outputStream.writeInt(0);
            }
        }
        catch (Exception e) {
            this.disconnect();
        }
    }

    synchronized String receiveString() {
        String s = "";
        try {
            int length = this.inputStream.readInt();
            if (length != 0) {
                byte[] buffer = new byte[length];
                this.inputStream.readFully(buffer);
                s = new String(buffer, "UTF8");
            }
        }
        catch (Exception e) {
            this.disconnect();
        }
        if (this.df != null && this.df.logging) {
            this.df.log("r       \"" + s + "\"");
        }
        return s;
    }

    private synchronized void sendBytesImpl(byte[] b) {
        if (this.outputStream == null) {
            return;
        }
        try {
            if (b != null) {
                this.outputStream.writeInt(b.length);
                this.outputStream.write(b);
            } else {
                this.outputStream.writeInt(0);
            }
        }
        catch (Exception e) {
            this.disconnect();
        }
    }

    synchronized void sendBytes(byte[] b) {
        this.sendBytesImpl(b);
        this.flush();
    }

    private synchronized void sendByteImpl(int b) {
        if (this.outputStream == null) {
            return;
        }
        try {
            this.outputStream.writeByte(b);
        }
        catch (Exception e) {
            this.disconnect();
        }
    }

    synchronized int receiveByte() {
        int b = 0;
        try {
            b = this.inputStream.readUnsignedByte();
        }
        catch (Exception e) {
            this.disconnect();
        }
        if (this.df != null && this.df.logging) {
            this.df.log("r       " + b);
        }
        return b;
    }

    synchronized byte[] receiveByteArray(int length) {
        byte[] buffer = null;
        try {
            buffer = new byte[length];
            if (length != 0) {
                this.inputStream.readFully(buffer);
            }
        }
        catch (Exception e) {
            this.disconnect();
        }
        if (this.df != null && this.df.logging) {
            this.df.log("r       byte[" + length + "]");
        }
        return buffer;
    }

    synchronized short[] receiveShortArray(int length) {
        short[] buffer = null;
        try {
            buffer = new short[length];
            int i = 0;
            while (i < length) {
                buffer[i] = this.inputStream.readShort();
                ++i;
            }
        }
        catch (Exception e) {
            this.disconnect();
        }
        if (this.df != null && this.df.logging) {
            this.df.log("r       short[" + length + "]");
        }
        return buffer;
    }

    synchronized int[] receiveIntArray(int length) {
        int[] buffer = null;
        try {
            buffer = new int[length];
            int i = 0;
            while (i < length) {
                buffer[i] = this.inputStream.readInt();
                ++i;
            }
        }
        catch (Exception e) {
            this.disconnect();
        }
        if (this.df != null && this.df.logging) {
            this.df.log("r       int[" + length + "]");
        }
        return buffer;
    }

    private synchronized void sendPointerArrayImpl(long[] a) {
        if (this.outputStream == null) {
            return;
        }
        try {
            int length = a.length;
            this.outputStream.writeInt(length);
            if (this.pointerSize == 8) {
                int i = 0;
                while (i < length) {
                    this.outputStream.writeLong(a[i]);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < length) {
                    this.outputStream.writeInt((int)a[i]);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            this.disconnect();
        }
    }

    synchronized long[] receivePointerArray(int length) {
        long[] buffer = null;
        try {
            buffer = new long[length];
            if (this.pointerSize == 8) {
                int i = 0;
                while (i < length) {
                    buffer[i] = this.inputStream.readLong();
                    ++i;
                }
            } else {
                int i = 0;
                while (i < length) {
                    int readInt = this.inputStream.readInt();
                    buffer[i] = readInt < 0 ? (long)readInt - -4294967296L : (long)readInt;
                    ++i;
                }
            }
        }
        catch (Exception e) {
            this.disconnect();
        }
        if (this.df != null && this.df.logging) {
            this.df.log("r       pointer[" + length + "]");
        }
        return buffer;
    }

    synchronized long[] receiveLongArray(int length) {
        long[] buffer = null;
        try {
            buffer = new long[length];
            int i = 0;
            while (i < length) {
                buffer[i] = this.inputStream.readLong();
                ++i;
            }
        }
        catch (Exception e) {
            this.disconnect();
        }
        if (this.df != null && this.df.logging) {
            this.df.log("r       long[" + length + "]");
        }
        return buffer;
    }

    private synchronized void sendIntImpl(int i) {
        if (this.outputStream == null) {
            return;
        }
        try {
            this.outputStream.writeInt(i);
        }
        catch (Exception e) {
            this.disconnect();
        }
    }

    synchronized int receiveInt() {
        int i = 0;
        try {
            i = this.inputStream.readInt();
        }
        catch (Exception e) {
            this.disconnect();
        }
        if (this.df != null && this.df.logging) {
            this.df.log("r       " + i);
        }
        return i;
    }

    private synchronized void sendPointerImpl(long p) {
        if (this.outputStream == null) {
            return;
        }
        try {
            if (this.pointerSize == 8) {
                this.outputStream.writeLong(p);
            } else {
                this.outputStream.writeInt((int)p);
            }
        }
        catch (Exception e) {
            this.disconnect();
        }
    }

    synchronized void sendPointer(long p) {
        this.sendPointerImpl(p);
        this.flush();
    }

    synchronized long receivePointer() {
        long p = 0L;
        try {
            int readInt;
            p = this.pointerSize == 8 ? this.inputStream.readLong() : ((readInt = this.inputStream.readInt()) < 0 ? (long)readInt - -4294967296L : (long)readInt);
        }
        catch (Exception e) {
            this.disconnect();
        }
        if (this.df != null && this.df.logging) {
            this.df.log("r       0x" + Long.toHexString(p));
        }
        return p;
    }

    synchronized short receiveShort() {
        short s = 0;
        try {
            s = this.inputStream.readShort();
        }
        catch (Exception e) {
            this.disconnect();
        }
        if (this.df != null && this.df.logging) {
            this.df.log("r       " + s);
        }
        return s;
    }

    synchronized long receiveLong() {
        long l = 0L;
        try {
            l = this.inputStream.readLong();
        }
        catch (Exception e) {
            this.disconnect();
        }
        if (this.df != null && this.df.logging) {
            this.df.log("r       " + l);
        }
        return l;
    }

    synchronized void flush() {
        try {
            this.outputStream.flush();
        }
        catch (Exception e) {
            this.disconnect();
        }
    }

    private void sendMessageByte(int m) {
        if (eventOn_OJVM_SEND_MESSAGE) {
            IdeProfile.pulseEvent((int)3799, (String)DebugFerrari.logStrings[m]);
        }
        this.sendByteImpl(m);
    }

    synchronized void sendMessage(int m) {
        if (this.df != null) {
            if (this.df.messageArguments(m) != 0) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(m).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[m]);
            }
        }
        this.sendMessageByte(m);
        this.flush();
    }

    synchronized void sendMessage(int m, String s) {
        if (this.df != null) {
            if (this.df.messageArguments(m) != 65536) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(m).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[m], "s       \"" + s + "\"");
            }
        }
        this.sendMessageByte(m);
        this.sendStringImpl(s);
        this.flush();
    }

    synchronized void sendMessage(int m, int i1) {
        if (this.df != null) {
            if (this.df.messageArguments(m) != 1) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(m).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[m], "s       " + i1);
            }
        }
        this.sendMessageByte(m);
        this.sendIntImpl(i1);
        this.flush();
    }

    synchronized void sendMessage(int m, long p1) {
        if (this.df != null) {
            if (this.df.messageArguments(m) != 256) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(m).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[m], "s       " + Long.toHexString(p1));
            }
        }
        this.sendMessageByte(m);
        this.sendPointerImpl(p1);
        this.flush();
    }

    synchronized void sendMessage(int m, int i1, String s) {
        if (this.df != null) {
            if (this.df.messageArguments(m) != 65537) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(m).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[m], "s       " + i1, "s       \"" + s + "\"");
            }
        }
        this.sendMessageByte(m);
        this.sendIntImpl(i1);
        this.sendStringImpl(s);
        this.flush();
    }

    synchronized void sendMessage(int m, long p1, String s) {
        if (this.df != null) {
            if (this.df.messageArguments(m) != 65792) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(m).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[m], "s       " + Long.toHexString(p1), "s       \"" + s + "\"");
            }
        }
        this.sendMessageByte(m);
        this.sendPointerImpl(p1);
        this.sendStringImpl(s);
        this.flush();
    }

    synchronized void sendMessage(int m, long p1, byte[] b) {
        if (this.df != null) {
            if (this.df.messageArguments(m) != 131328) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(m).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[m], "s       " + Long.toHexString(p1), "s       byte[" + b.length + "]");
            }
        }
        this.sendMessageByte(m);
        this.sendPointerImpl(p1);
        this.sendBytesImpl(b);
        this.flush();
    }

    synchronized void sendMessage(int m, int i1, int i2) {
        if (this.df != null) {
            if (this.df.messageArguments(m) != 3) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(m).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[m], "s       " + i1, "s       " + i2);
            }
        }
        this.sendMessageByte(m);
        this.sendIntImpl(i1);
        this.sendIntImpl(i2);
        this.flush();
    }

    synchronized void sendMessage(int m, long p1, int i2) {
        if (this.df != null) {
            if (this.df.messageArguments(m) != 258) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(m).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[m], "s       " + Long.toHexString(p1), "s       " + i2);
            }
        }
        this.sendMessageByte(m);
        this.sendPointerImpl(p1);
        this.sendIntImpl(i2);
        this.flush();
    }

    synchronized void sendMessage(int m, long p1, long p2) {
        if (this.df != null) {
            if (this.df.messageArguments(m) != 768) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(m).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[m], "s       " + Long.toHexString(p1), "s       " + Long.toHexString(p2));
            }
        }
        this.sendMessageByte(m);
        this.sendPointerImpl(p1);
        this.sendPointerImpl(p2);
        this.flush();
    }

    synchronized void sendMessage(int m, int i1, int i2, String s) {
        if (this.df != null) {
            if (this.df.messageArguments(m) != 65539) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(m).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[m], "s       " + i1, "s       " + i2, "s       \"" + s + "\"");
            }
        }
        this.sendMessageByte(m);
        this.sendIntImpl(i1);
        this.sendIntImpl(i2);
        this.sendStringImpl(s);
        this.flush();
    }

    synchronized void sendMessage(int m, long p1, int i2, String s) {
        if (this.df != null) {
            if (this.df.messageArguments(m) != 65794) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(m).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[m], "s       " + Long.toHexString(p1), "s       " + i2, "s       \"" + s + "\"");
            }
        }
        this.sendMessageByte(m);
        this.sendPointerImpl(p1);
        this.sendIntImpl(i2);
        this.sendStringImpl(s);
        this.flush();
    }

    synchronized void sendMessage(int m, long p1, long p2, String s) {
        if (this.df != null) {
            if (this.df.messageArguments(m) != 66304) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(m).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[m], "s       " + Long.toHexString(p1), "s       " + Long.toHexString(p2), "s       \"" + s + "\"");
            }
        }
        this.sendMessageByte(m);
        this.sendPointerImpl(p1);
        this.sendPointerImpl(p2);
        this.sendStringImpl(s);
        this.flush();
    }

    synchronized void sendMessage(int m, int i1, int i2, int i3) {
        if (this.df != null) {
            if (this.df.messageArguments(m) != 7) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(m).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[m], "s       " + i1, "s       " + i2, "s       " + i3);
            }
        }
        this.sendMessageByte(m);
        this.sendIntImpl(i1);
        this.sendIntImpl(i2);
        this.sendIntImpl(i3);
        this.flush();
    }

    synchronized void sendMessage(int m, long p1, int i2, int i3) {
        if (this.df != null) {
            if (this.df.messageArguments(m) != 262) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(m).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[m], "s       " + Long.toHexString(p1), "s       " + i2, "s       " + i3);
            }
        }
        this.sendMessageByte(m);
        this.sendPointerImpl(p1);
        this.sendIntImpl(i2);
        this.sendIntImpl(i3);
        this.flush();
    }

    synchronized void sendMessage(int m, long p1, long p2, int i3) {
        if (this.df != null) {
            if (this.df.messageArguments(m) != 772) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(m).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[m], "s       " + Long.toHexString(p1), "s       " + Long.toHexString(p2), "s       " + i3);
            }
        }
        this.sendMessageByte(m);
        this.sendPointerImpl(p1);
        this.sendPointerImpl(p2);
        this.sendIntImpl(i3);
        this.flush();
    }

    synchronized void sendMessage(int m, int i1, int i2, int i3, String s) {
        if (this.df != null) {
            if (this.df.messageArguments(m) != 65543) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(m).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[m], "s       " + i1, "s       " + i2, "s       " + i3, "s       \"" + s + "\"");
            }
        }
        this.sendMessageByte(m);
        this.sendIntImpl(i1);
        this.sendIntImpl(i2);
        this.sendIntImpl(i3);
        this.sendStringImpl(s);
        this.flush();
    }

    synchronized void sendMessage(int m, long p1, long p2, long p3, String s) {
        if (this.df != null) {
            if (this.df.messageArguments(m) != 67328) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(m).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[m], "s       " + Long.toHexString(p1), "s       " + Long.toHexString(p2), "s       " + Long.toHexString(p3), "s       \"" + s + "\"");
            }
        }
        this.sendMessageByte(m);
        this.sendPointerImpl(p1);
        this.sendPointerImpl(p2);
        this.sendPointerImpl(p3);
        this.sendStringImpl(s);
        this.flush();
    }

    synchronized void sendMessage(int m, int i1, int i2, int i3, int i4) {
        if (this.df != null) {
            if (this.df.messageArguments(m) != 15) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(m).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[m], "s       " + i1, "s       " + i2, "s       " + i3, "s       " + i4);
            }
        }
        this.sendMessageByte(m);
        this.sendIntImpl(i1);
        this.sendIntImpl(i2);
        this.sendIntImpl(i3);
        this.sendIntImpl(i4);
        this.flush();
    }

    synchronized void sendMessage(int m, long p1, int i2, int i3, int i4) {
        if (this.df != null) {
            if (this.df.messageArguments(m) != 270) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(m).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[m], "s       " + Long.toHexString(p1), "s       " + i2, "s       " + i3, "s       " + i4);
            }
        }
        this.sendMessageByte(m);
        this.sendPointerImpl(p1);
        this.sendIntImpl(i2);
        this.sendIntImpl(i3);
        this.sendIntImpl(i4);
        this.flush();
    }

    synchronized void sendMessage(int m, int i1, int i2, int i3, int i4, String s) {
        if (this.df != null) {
            if (this.df.messageArguments(m) != 65551) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(m).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[m], "s       " + i1, "s       " + i2, "s       " + i3, "s       " + i4, "s       \"" + s + "\"");
            }
        }
        this.sendMessageByte(m);
        this.sendIntImpl(i1);
        this.sendIntImpl(i2);
        this.sendIntImpl(i3);
        this.sendIntImpl(i4);
        this.sendStringImpl(s);
        this.flush();
    }

    synchronized void sendMessage(int m, long p1, int i2, int i3, int i4, String s) {
        if (this.df != null) {
            if (this.df.messageArguments(m) != 65806) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(m).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[m], "s       " + Long.toHexString(p1), "s       " + i2, "s       " + i3, "s       " + i4, "s       \"" + s + "\"");
            }
        }
        this.sendMessageByte(m);
        this.sendPointerImpl(p1);
        this.sendIntImpl(i2);
        this.sendIntImpl(i3);
        this.sendIntImpl(i4);
        this.sendStringImpl(s);
        this.flush();
    }

    synchronized void sendMessage(int m, int i1, int i2, int i3, int i4, int i5) {
        if (this.df != null) {
            if (this.df.messageArguments(m) != 31) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(m).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[m], "s       " + i1, "s       " + i2, "s       " + i3, "s       " + i4, "s       " + i5);
            }
        }
        this.sendMessageByte(m);
        this.sendIntImpl(i1);
        this.sendIntImpl(i2);
        this.sendIntImpl(i3);
        this.sendIntImpl(i4);
        this.sendIntImpl(i5);
        this.flush();
    }

    synchronized void sendMessage(int m, long p1, int i2, int i3, int i4, int i5) {
        if (this.df != null) {
            if (this.df.messageArguments(m) != 286) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(m).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[m], "s       " + Long.toHexString(p1), "s       " + i2, "s       " + i3, "s       " + i4, "s       " + i5);
            }
        }
        this.sendMessageByte(m);
        this.sendPointerImpl(p1);
        this.sendIntImpl(i2);
        this.sendIntImpl(i3);
        this.sendIntImpl(i4);
        this.sendIntImpl(i5);
        this.flush();
    }

    synchronized void sendMessage(int m, int i1, int i2, int i3, int i4, int i5, String s) {
        if (this.df != null) {
            if (this.df.messageArguments(m) != 65567) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(m).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[m], "s       " + i1, "s       " + i2, "s       " + i3, "s       " + i4, "s       " + i5, "s       \"" + s + "\"");
            }
        }
        this.sendMessageByte(m);
        this.sendIntImpl(i1);
        this.sendIntImpl(i2);
        this.sendIntImpl(i3);
        this.sendIntImpl(i4);
        this.sendIntImpl(i5);
        this.sendStringImpl(s);
        this.flush();
    }

    synchronized void sendMessage(int m, long[] pa) {
        if (this.df != null) {
            if (this.df.messageArguments(m) != 0x100000) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(m).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[m], "s       pointer[" + pa.length + "]");
            }
        }
        this.sendMessageByte(m);
        this.sendPointerArrayImpl(pa);
        this.flush();
    }

    synchronized void sendJBoolean(Boolean b) {
        if (this.outputStream == null) {
            return;
        }
        try {
            this.outputStream.writeBoolean(b);
        }
        catch (Exception e) {
            this.disconnect();
        }
    }

    synchronized void sendJChar(Character c) {
        if (this.outputStream == null) {
            return;
        }
        try {
            this.outputStream.writeChar(c.charValue());
        }
        catch (Exception e) {
            this.disconnect();
        }
    }

    synchronized void sendJByte(Byte b) {
        if (this.outputStream == null) {
            return;
        }
        try {
            this.outputStream.writeByte(b.byteValue());
        }
        catch (Exception e) {
            this.disconnect();
        }
    }

    synchronized void sendJShort(Short s) {
        if (this.outputStream == null) {
            return;
        }
        try {
            this.outputStream.writeShort(s.shortValue());
        }
        catch (Exception e) {
            this.disconnect();
        }
    }

    synchronized void sendJInt(Integer i) {
        if (this.outputStream == null) {
            return;
        }
        try {
            this.outputStream.writeInt(i);
        }
        catch (Exception e) {
            this.disconnect();
        }
    }

    synchronized void sendJLong(Long l) {
        if (this.outputStream == null) {
            return;
        }
        try {
            this.outputStream.writeLong(l);
        }
        catch (Exception e) {
            this.disconnect();
        }
    }

    synchronized void sendJFloat(Float f) {
        if (this.outputStream == null) {
            return;
        }
        try {
            this.outputStream.writeFloat(f.floatValue());
        }
        catch (Exception e) {
            this.disconnect();
        }
    }

    synchronized void sendJDouble(Double d) {
        if (this.outputStream == null) {
            return;
        }
        try {
            this.outputStream.writeDouble(d);
        }
        catch (Exception e) {
            this.disconnect();
        }
    }

    synchronized int receiveMessage() {
        int m = 0;
        try {
            m = this.inputStream.readUnsignedByte();
        }
        catch (Exception e) {
            this.disconnect();
        }
        if (eventOn_OJVM_RECV_MESSAGE) {
            IdeProfile.pulseEvent((int)3798, (String)DebugFerrari.logStrings[m]);
        }
        if (this.df != null && this.df.logging) {
            this.df.log("recv    " + DebugFerrari.logStrings[m]);
        }
        return m;
    }
}

