/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ferrari;

import oracle.jdevimpl.debugger.ferrari.DebugFerrari;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariClassInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariDataInfo;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;

final class DebugFerrariVariableInfo
implements DebugVariableInfo {
    DebugFerrari df;
    int stoppedCount;
    DebugFerrariClassInfo clazz;
    long localDescPtr;
    String name;
    DebugFerrariDataInfo data;
    int varType;
    static final int VAR_TYPE_UNKNOWN = 0;
    static final int VAR_TYPE_ARGUMENT = 1;
    static final int VAR_TYPE_LOCAL = 2;
    static final int VAR_TYPE_RETURN = 3;
    static final int VAR_TYPE_RETURNED = 4;
    private int hashCode;

    DebugFerrariVariableInfo(DebugFerrari df, DebugFerrariClassInfo clazz, long localDescPtr, String name, DebugFerrariDataInfo data, int varType) {
        this.df = df;
        this.stoppedCount = df.stoppedCount;
        this.clazz = clazz;
        this.localDescPtr = localDescPtr;
        this.name = name;
        this.data = data;
        if (data != null) {
            data.setDeclaredClass(clazz);
        }
        this.varType = varType;
    }

    public boolean hasExpired() {
        return this.df.stoppedCount != this.stoppedCount;
    }

    public DebugClassInfo getClassInfo() {
        return this.clazz;
    }

    public String getGenericSignature() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public boolean isInScope() {
        return this.data != null;
    }

    public boolean isArgument() {
        return this.varType == 1;
    }

    public boolean isLocal() {
        return this.varType == 2;
    }

    public boolean isReturn() {
        return this.varType == 3;
    }

    public boolean isReturned() {
        return this.varType == 4;
    }

    public DebugDataInfo getDataInfo() {
        return this.data;
    }

    public int getSlotSize() {
        if (this.clazz.isPrimitive()) {
            String name = this.clazz.getName();
            if (name.equals("long") || name.equals("double")) {
                return 2;
            }
            return 1;
        }
        return this.df.getPointerSlotSize();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.clazz.hashCode() + this.name.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof DebugFerrariVariableInfo) {
            DebugFerrariVariableInfo other = (DebugFerrariVariableInfo)o;
            return this.clazz.equals(other.clazz) && this.name.equals(other.name);
        }
        return false;
    }
}

