/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ferrari;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import oracle.jdevimpl.debugger.ferrari.DebugFerrari;

public class Relay {
    private RelaySocket listen;
    private RelaySocket attach;

    public static void main(String[] args) throws Exception {
        if (args.length == 2) {
            try {
                int listenPort = Integer.parseInt(args[0]);
                int attachPort = Integer.parseInt(args[1]);
                Relay relay = new Relay(listenPort, attachPort);
                relay.start();
            }
            catch (NumberFormatException e) {
                Relay.usage();
            }
        } else {
            Relay.usage();
        }
    }

    private static void usage() {
        System.out.println("usage: java oracle.jdevimpl.debugger.ferrari.Relay <debugger port> <debuggee port>");
    }

    public Relay(int listenPort, int attachPort) {
        this.listen = new RelaySocket("", listenPort);
        this.attach = new RelaySocket("\t\t\t\t\t\t", attachPort);
    }

    public void start() throws Exception {
        this.listen.listen();
        this.attach.attach();
        new RelayThread(this.listen, this.attach).start();
        new RelayThread(this.attach, this.listen).start();
    }

    class RelayThread
    extends Thread {
        RelaySocket rs1;
        RelaySocket rs2;
        private byte[] buffer;

        RelayThread(RelaySocket rs1, RelaySocket rs2) {
            super("RelayThread - port " + RelaySocket.ra$port(rs1));
            this.rs1 = rs1;
            this.rs2 = rs2;
            this.buffer = new byte[131072];
        }

        public void run() {
            System.out.println(RelaySocket.ra$prefix(this.rs1) + "port " + RelaySocket.ra$port(this.rs1));
            try {
                int len;
                while ((len = RelaySocket.ra$is(this.rs1).read(this.buffer)) != -1) {
                    if (len <= 0) continue;
                    RelaySocket relaySocket = this.rs1;
                    RelaySocket.wa$countPackets(relaySocket, RelaySocket.ra$countPackets(relaySocket) + 1);
                    RelaySocket relaySocket2 = this.rs1;
                    RelaySocket.wa$countBytes(relaySocket2, RelaySocket.ra$countBytes(relaySocket2) + len);
                    if (RelaySocket.ra$countPackets(this.rs2) > 1) {
                        System.out.println(RelaySocket.ra$prefix(this.rs2) + RelaySocket.ra$countPackets(this.rs2) + " packets, " + RelaySocket.ra$countBytes(this.rs2) + " bytes");
                    }
                    RelaySocket.wa$countPackets(this.rs2, 0);
                    RelaySocket.wa$countBytes(this.rs2, 0);
                    int command = this.buffer[0];
                    if (command < 0) {
                        command += 256;
                    }
                    System.out.println(RelaySocket.ra$prefix(this.rs1) + len + " bytes (" + DebugFerrari.logStrings[command] + ")");
                    RelaySocket.ra$os(this.rs2).write(this.buffer, 0, len);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.println(RelaySocket.ra$prefix(this.rs1) + "end of I/O");
        }
    }

    class RelaySocket {
        private String prefix;
        private int port;
        private InputStream is;
        private OutputStream os;
        private volatile int countPackets;
        private volatile int countBytes;

        RelaySocket(String prefix, int port) {
            this.prefix = prefix;
            this.port = port;
        }

        void listen() throws Exception {
            ServerSocket serverSock = new ServerSocket(this.port);
            Socket socket = serverSock.accept();
            socket.setTcpNoDelay(true);
            this.is = socket.getInputStream();
            this.os = socket.getOutputStream();
        }

        void attach() throws Exception {
            Socket socket = new Socket(InetAddress.getLocalHost(), this.port);
            this.is = socket.getInputStream();
            this.os = socket.getOutputStream();
        }

        static String ra$prefix(RelaySocket relaySocket) {
            return relaySocket.prefix;
        }

        static int ra$port(RelaySocket relaySocket) {
            return relaySocket.port;
        }

        static InputStream ra$is(RelaySocket relaySocket) {
            return relaySocket.is;
        }

        static int ra$countPackets(RelaySocket relaySocket) {
            return relaySocket.countPackets;
        }

        static void wa$countPackets(RelaySocket relaySocket, int n) {
            relaySocket.countPackets = n;
        }

        static int ra$countBytes(RelaySocket relaySocket) {
            return relaySocket.countBytes;
        }

        static void wa$countBytes(RelaySocket relaySocket, int n) {
            relaySocket.countBytes = n;
        }

        static OutputStream ra$os(RelaySocket relaySocket) {
            return relaySocket.os;
        }
    }
}

