/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.javascript;

import java.net.URL;
import oracle.ide.Ide;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.model.J2eeSettings;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxClassLoaderInfo;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxDataInfo;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxJavaScript;
import oracle.jdevimpl.debugger.javascript.MozillaFireFoxJavaScriptFileSystemHelper;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugClassLoaderInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;

public class DebugMozillaFireFoxClassInfo
implements DebugClassInfo {
    private static final boolean DEBUG = false;
    private String name;
    private int count;
    private DebugMozillaFireFoxClassLoaderInfo classLoaderInfo;
    private String fileName;
    private boolean isObject;
    private DebugMozillaFireFoxJavaScript debugger;
    static final /* synthetic */ boolean $assertionsDisabled;

    private void $init$() {
        this.isObject = false;
    }

    public DebugMozillaFireFoxClassInfo(String name, int count, DebugMozillaFireFoxClassLoaderInfo classLoaderInfo, DebugMozillaFireFoxJavaScript debugger) {
        this.$init$();
        this.name = name;
        this.count = count;
        this.classLoaderInfo = classLoaderInfo;
        this.fileName = name;
        this.debugger = debugger;
    }

    public DebugMozillaFireFoxClassInfo(int type, DebugMozillaFireFoxClassInfo classInfo, DebugMozillaFireFoxJavaScript debugger) {
        this.$init$();
        this.setNameFromType(type);
        this.count = -1;
        if (classInfo != null) {
            this.classLoaderInfo = (DebugMozillaFireFoxClassLoaderInfo)classInfo.getClassLoader();
            this.fileName = classInfo.getFileName();
        }
        this.debugger = debugger;
    }

    public boolean hasExpired() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getPackage() {
        return "";
    }

    public String getPackagePath() {
        return "";
    }

    public String getNameWithoutPackage() {
        return this.name;
    }

    public String getGenericSignature() {
        return null;
    }

    public int getAccess() {
        return 0;
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isPrimitive() {
        return this.isObject ^ true;
    }

    public boolean isObject() {
        return this.isObject;
    }

    public boolean isArray() {
        return false;
    }

    public int getSizeOfObject() {
        return 0;
    }

    public long countObjectsOfClass() {
        return this.count;
    }

    public int countMemoryOfClass() {
        return 0;
    }

    public DebugDataObjectInfo getClassObject() {
        return null;
    }

    public DebugDataObjectInfo getClassLoaderObject() {
        return null;
    }

    public DebugClassLoaderInfo getClassLoader() {
        return this.classLoaderInfo;
    }

    public String getPrimarySourceFilename() {
        return this.getSourceFilename();
    }

    public String getSourceFilename() {
        URL url = this.getSourceNameUrl();
        return url == null ? "" : url.getFile();
    }

    public DebugClassInfo getSuperClass(int level) {
        return null;
    }

    public int getMethodCount() {
        return 0;
    }

    public DebugMethodInfo[] getMethods() {
        return new DebugMethodInfo[0];
    }

    public int getStaticFieldCount() {
        return 0;
    }

    public DebugFieldInfo[] getStaticFields() {
        return new DebugFieldInfo[0];
    }

    public DebugFieldInfo getStaticField(int index) {
        return null;
    }

    public int getStaticFieldCount(int classLevel) {
        return 0;
    }

    public DebugFieldInfo[] getStaticFields(int classLevel) {
        return new DebugFieldInfo[0];
    }

    public DebugFieldInfo getStaticField(int classLevel, int index) {
        return null;
    }

    public int getStaticFieldCount(int classLevel, boolean noFinal) {
        return 0;
    }

    public DebugFieldInfo[] getStaticFields(int classLevel, boolean noFinal) {
        return new DebugFieldInfo[0];
    }

    public DebugFieldInfo getStaticField(int classLevel, boolean noFinal, int index) {
        return null;
    }

    public DebugFieldInfo getStaticField(String name) {
        return null;
    }

    public int getFieldCount(int classLevel) {
        return 0;
    }

    public DebugFieldInfo[] getFields(int classLevel) {
        return new DebugFieldInfo[0];
    }

    public DebugFieldInfo getField(int classLevel, int index) {
        return null;
    }

    public int getFieldCount(int classLevel, boolean noFinal) {
        return 0;
    }

    public DebugFieldInfo[] getFields(int classLevel, boolean noFinal) {
        return new DebugFieldInfo[0];
    }

    public DebugFieldInfo getField(int classLevel, boolean noFinal, int index) {
        return null;
    }

    public int getFieldCount(int classLevel, boolean noFinal, boolean noStatic) {
        return 0;
    }

    public DebugFieldInfo[] getFields(int classLevel, boolean noFinal, boolean noStatic) {
        return new DebugFieldInfo[0];
    }

    public DebugFieldInfo getField(int classLevel, boolean noFinal, boolean noStatic, int index) {
        return null;
    }

    public boolean isDebuggable() {
        return true;
    }

    public void setDebuggable(boolean debuggable) {
    }

    public boolean isObfuscated() {
        return false;
    }

    public boolean isCodeCoverage() {
        return false;
    }

    public void setCodeCoverage(boolean codeCoverage) {
    }

    public void discardCodeCoverage() {
    }

    public double getCodeCoverageRatio() {
        return 0.0;
    }

    public DebugClassInfo[] getInterfaces() {
        return new DebugClassInfo[0];
    }

    public DebugClassInfo[] getInterfaces(int classLevel) {
        return new DebugClassInfo[0];
    }

    public int getLanguage() {
        return 16;
    }

    public boolean isEnum() {
        return false;
    }

    public DebugFieldInfo[] getEnumConstants() {
        return new DebugFieldInfo[0];
    }

    static {
        $assertionsDisabled = DebugMozillaFireFoxClassInfo.class.desiredAssertionStatus() ^ true;
    }

    public URL getSourceNameUrl() {
        URL newUrl;
        URL url = URLFactory.newURL((String)this.name);
        if (url != null && url.getProtocol().equals("file")) {
            return url;
        }
        url = MozillaFireFoxJavaScriptFileSystemHelper.getInstance(true).addSourceName(this.debugger, this.name, 0);
        if (url == null && (newUrl = URLFactory.newURL((String)this.name)) != null) {
            String file = newUrl.getFile();
            URL htmlRoot = J2eeSettings.getInstance(Ide.getActiveProject()).getHtmlRootDirectory();
            while (true) {
                URL u;
                if ((u = URLFactory.newURL((URL)htmlRoot, (String)("." + file))) != null && URLFileSystem.exists((URL)u)) {
                    return u;
                }
                int index = file.indexOf("/", 1);
                if (index == -1) break;
                file = file.substring(index);
            }
        }
        return url;
    }

    public String getFileName() {
        return this.fileName;
    }

    private void setNameFromType(int type) {
        switch (type) {
            case 0: {
                this.name = "boolean";
                break;
            }
            case 1: {
                this.name = "double";
                break;
            }
            case 2: {
                this.name = "int";
                break;
            }
            case 3: {
                this.name = "function";
                break;
            }
            case 4: {
                this.name = "null";
                break;
            }
            case 5: {
                this.name = "object";
                break;
            }
            case 6: {
                this.name = "string";
                break;
            }
            case 7: {
                this.name = "void";
                break;
            }
            default: {
                this.name = "unknown";
            }
        }
        this.isObject = DebugMozillaFireFoxDataInfo.isObject(type);
    }
}

