/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.javascript;

import oracle.jdevimpl.debugger.javascript.DebugJavaScriptArb;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxJavaScript;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxJavaScriptStackFrameInfo;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxEvaluateExpression;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;

public class DebugMozillaFireFoxDataInfo
implements DebugDataInfo {
    private boolean expired;
    private DebugMozillaFireFoxJavaScript debugger;
    private String value;
    private String name;
    private DebugClassInfo classInfo;
    private int type;
    protected DebugMozillaFireFoxJavaScriptStackFrameInfo stackFrameInfo;
    protected DebugMozillaFireFoxDataInfo parent;
    private long valueId;

    private void $init$() {
        this.expired = false;
        this.type = -1;
        this.parent = null;
        this.valueId = 0L;
    }

    public DebugMozillaFireFoxDataInfo(String name, String value, int type, DebugClassInfo classInfo, DebugVirtualMachine debugger, DebugMozillaFireFoxJavaScriptStackFrameInfo stackFrameInfo, DebugMozillaFireFoxDataInfo parent, long valueId) {
        this.$init$();
        this.name = name;
        this.debugger = (DebugMozillaFireFoxJavaScript)debugger;
        this.value = value;
        this.type = type;
        this.classInfo = classInfo;
        this.stackFrameInfo = stackFrameInfo;
        this.parent = parent;
        this.valueId = valueId;
    }

    public DebugVirtualMachine getVM() {
        return this.debugger;
    }

    public void setExpired(boolean b) {
        this.expired = b;
        if (b) {
            this.name = null;
            this.value = null;
        }
    }

    public boolean hasExpired() {
        return this.expired;
    }

    public DebugClassInfo getClassInfo() {
        return this.classInfo;
    }

    public String getValue() {
        if (this.value == null) {
            return "null";
        }
        return this.value;
    }

    public String getHexValue() {
        String value = this.getValue();
        if (value != null) {
            try {
                Long l = new Long(value);
                if (l != null) {
                    String string = Long.toHexString(l);
                    return string;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Double dbl = new Double(value);
                if (dbl != null) {
                    String string = Double.toHexString(dbl);
                    return string;
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean canModifyDataWithString() {
        return true;
    }

    public boolean modifyDataWithString(String value) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName() + " = ");
        sb.append((6 == this.type ? "\"" + value + "\"" : value) + ";");
        DebugMozillaFireFoxDataInfo temp = this.parent;
        while (temp != null) {
            if (!temp.getName().equals(DebugJavaScriptArb.getString(3))) {
                sb.insert(0, temp.getName() + ".");
            }
            temp = temp.parent;
        }
        MozillaFireFoxEvaluateExpression evalRequest = this.debugger.getRequestManager().createEvaluateExpressionRequest(sb.toString(), 3000L, this.stackFrameInfo, this.valueId);
        evalRequest.setEnabled(true);
        evalRequest.sendSyncRequest();
        boolean successfull = evalRequest.isSuccessful();
        if (successfull) {
            this.type = evalRequest.getType();
            this.value = evalRequest.getStringValue();
        } else {
            this.debugger.errorEvent(evalRequest.getStringValue(), null, -1, -1, -1, -1, 0);
        }
        return successfull;
    }

    public boolean canModifyDataWithData() {
        return false;
    }

    public boolean modifyDataWithData(DebugDataInfo value) {
        return false;
    }

    public boolean canModifyDataWithNewObject() {
        return false;
    }

    public boolean modifyDataWithNewObject(DebugMethodInfo method, String[] arguments) {
        return false;
    }

    public static boolean isObject(int type) {
        switch (type) {
            case 0: {
                return false;
            }
            case 1: {
                return false;
            }
            case 2: {
                return false;
            }
            case 3: {
                return true;
            }
            case 4: {
                return false;
            }
            case 5: {
                return true;
            }
            case 6: {
                return false;
            }
            case 7: {
                return false;
            }
        }
        return false;
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public DebugMozillaFireFoxJavaScript getDebugger() {
        return this.debugger;
    }

    long getUniqueId() {
        return this.valueId;
    }

    DebugMozillaFireFoxJavaScriptStackFrameInfo getStackFrameInfo() {
        return this.stackFrameInfo;
    }
}

