/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.javascript;

import java.net.MalformedURLException;
import java.net.URL;
import oracle.ide.Ide;
import oracle.ide.util.ModelUtil;
import oracle.jdeveloper.model.J2eeSettings;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxBreakpoint;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxJavaScript;
import oracle.jdevimpl.debugger.support.DebugBreakpointFileLine;
import oracle.jdevimpl.debugger.support.DebugBreakpointPackageFileLine;

public class DebugMozillaFireFoxFileLineBreakpoint
extends DebugMozillaFireFoxBreakpoint
implements DebugBreakpointFileLine,
DebugBreakpointPackageFileLine {
    private String filename;
    private String relativeFileName;
    private int line;
    private int timesSet;

    DebugMozillaFireFoxFileLineBreakpoint(DebugMozillaFireFoxJavaScript js, String filename, int line) {
        super(js);
        this.filename = filename;
        this.line = line;
        this.setRelativeFileName();
    }

    public String getFilename() {
        return this.filename;
    }

    public String getRelativeFilename() {
        return this.relativeFileName;
    }

    public int getLine() {
        return this.line;
    }

    public void setFileLine(String filename, int line) {
        if (ModelUtil.areDifferent((Object)this.filename, (Object)filename) || this.line != line) {
            this.prepareForChange();
            this.filename = filename;
            this.setRelativeFileName();
            this.line = line;
            this.afterChange();
        }
    }

    public synchronized void eventSet(int numBpts) {
        int oldTimes = this.timesSet;
        this.timesSet = numBpts;
        if (oldTimes == 0 && this.timesSet >= 1) {
            this.js.updateBreakpoints(this);
        }
    }

    public synchronized void eventUnset(int numBpts) {
        int oldTimes = this.timesSet;
        this.timesSet = numBpts;
        if (oldTimes > 0 && this.timesSet == 0) {
            this.js.updateBreakpoints(this);
        }
    }

    public synchronized boolean isSet() {
        return this.timesSet != 0;
    }

    public synchronized void eventHit(int numBpts) {
        this.js.bptHit(this);
    }

    public synchronized void eventPassCountDeced(int numBpts) {
        this.setPassCount(this.getPassCount() - 1);
    }

    public String getPackage() {
        return "";
    }

    public void setPackageFileLine(String pkg, String filename, int line) {
        this.filename = filename;
        this.line = line;
        this.setRelativeFileName();
    }

    private void setRelativeFileName() {
        if (Ide.getActiveProject() != null) {
            URL rootUrl = J2eeSettings.getInstance(Ide.getActiveProject()).getHtmlRootDirectory();
            URL thisUrl = null;
            try {
                thisUrl = new URL(this.filename);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (thisUrl != null && thisUrl.toString().startsWith(rootUrl.toString()) && !thisUrl.toString().equals(rootUrl.toString())) {
                String prefix = null;
                if (rootUrl.toString().endsWith("/")) {
                    prefix = "/";
                }
                this.relativeFileName = thisUrl.toString().substring(rootUrl.toString().length() - (prefix == null ? 0 : 1));
            }
        }
    }
}

