/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.javascript;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import oracle.jdevimpl.debugger.javascript.DebugJavaScriptArb;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxJavaScript;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxJavaScriptConnectArg;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxJavaScriptTransport;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxClearAllBreakpoints;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxDetachRequest;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxEnableDebugStatementRequest;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxErrorMessagesRequest;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxEventHandler;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxExceptionsRequest;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxGetVersionRequest;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxInitDoneRequest;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxRequestManager;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxResumeRequest;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxScriptRequest;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxStopInChromeRequest;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxStopOnErrorRequest;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxTerminateRequest;
import oracle.jdevimpl.debugger.support.DebugConnectArg;
import oracle.jdevimpl.debugger.support.DebugConnectionListener;
import oracle.jdevimpl.debugger.support.DebugConnector;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.debug.DbgArb;

public class DebugMozillaFireFoxJavaScriptConnector
implements DebugConnector {
    private static final int JS_ENABLE_DEBUG_STATEMENT_INDEX = 3;
    private MozillaFireFoxRequestManager requestManager;
    private MozillaFireFoxEventHandler eventHandler;
    private DebugMozillaFireFoxJavaScript debugger;
    private String host;
    private String port;

    public static String getVersion() {
        return "1.0";
    }

    public DebugMozillaFireFoxJavaScriptConnectArg[] getConnectArgs() {
        DebugMozillaFireFoxJavaScriptConnectArg[] args = new DebugMozillaFireFoxJavaScriptConnectArg[]{new DebugMozillaFireFoxJavaScriptConnectArg("hostname", DebugJavaScriptArb.getString(11), true), new DebugMozillaFireFoxJavaScriptConnectArg("port", DebugJavaScriptArb.getString(15), false), new DebugMozillaFireFoxJavaScriptConnectArg("timeout", DebugJavaScriptArb.getString(14), true)};
        return args;
    }

    public DebugVirtualMachine connect(DebugConnectArg[] connectArgs) throws Exception {
        int timeout;
        String host = connectArgs[0].getValue();
        int port = Integer.parseInt(connectArgs[1].getValue());
        this.host = host;
        if (this.host == null || this.host.length() == 0) {
            this.host = "localhost";
        }
        this.port = connectArgs[1].getValue();
        try {
            timeout = Integer.parseInt(connectArgs[2].getValue()) * 1000;
        }
        catch (NumberFormatException nfe) {
            timeout = 0;
        }
        boolean enableDebugStatement = true;
        boolean stopOnError = true;
        boolean stopOnException = false;
        boolean transferErrors = true;
        boolean stopInChrome = true;
        boolean transferErrors2 = true;
        boolean remoteDebugAttach = false;
        int i = 3;
        while (i < connectArgs.length) {
            if (connectArgs[i].getName().equals("javascript_enable_debug_stat")) {
                String jsEnableDebugStr = connectArgs[i].getValue();
                enableDebugStatement = jsEnableDebugStr == null || !jsEnableDebugStr.equals(DbgArb.getString(441));
            } else if (connectArgs[i].getName().equals("javascript_stop_on_error")) {
                String jsStopOnErrorStr = connectArgs[i].getValue();
                stopOnError = jsStopOnErrorStr == null || !jsStopOnErrorStr.equals(DbgArb.getString(441));
            } else if (connectArgs[i].getName().equals("javascript_stop_on_exception")) {
                String jsStopOnExceptionStr = connectArgs[i].getValue();
                stopOnException = jsStopOnExceptionStr != null && jsStopOnExceptionStr.equals(DbgArb.getString(87));
            } else if (connectArgs[i].getName().equals("javascript_transfer_errors")) {
                String jsTransferErrorsStr = connectArgs[i].getValue();
                transferErrors = jsTransferErrorsStr == null || !jsTransferErrorsStr.equals(DbgArb.getString(441));
            } else if (connectArgs[i].getName().equals("javascript_stop_in_chrome")) {
                String jsStopInChromeStr = connectArgs[i].getValue();
                stopInChrome = jsStopInChromeStr == null || !jsStopInChromeStr.equals(DbgArb.getString(441));
            } else if (connectArgs[i].getName().equals("javascript_remote_attached")) {
                String jsRemoteAttachStr = connectArgs[i].getValue();
                remoteDebugAttach = jsRemoteAttachStr != null && jsRemoteAttachStr.equals(DbgArb.getString(87));
            } else if (connectArgs[i].getName().equals("javascript_transfer_errors2")) {
                String jsTransferErrorsStr2 = connectArgs[i].getValue();
                transferErrors2 = jsTransferErrorsStr2 == null || !jsTransferErrorsStr2.equals(DbgArb.getString(441));
            }
            ++i;
        }
        Socket socket = new Socket();
        InetAddress address = InetAddress.getByName(host);
        InetSocketAddress socketAddress = new InetSocketAddress(address, port);
        socket.connect(socketAddress, timeout);
        socket.setTcpNoDelay(true);
        DebugMozillaFireFoxJavaScriptTransport transport = new DebugMozillaFireFoxJavaScriptTransport(socket, this);
        this.doStartup(transport, socket, enableDebugStatement, remoteDebugAttach, stopOnError, stopOnException, transferErrors, stopInChrome);
        this.debugger = new DebugMozillaFireFoxJavaScript(transport, this, this.requestManager, remoteDebugAttach);
        this.debugger.setStopOnDebuggerStatement(enableDebugStatement);
        this.debugger.setStopOnError(stopOnError);
        this.debugger.setStopOnException(stopOnException);
        this.debugger.setTransferErrors(transferErrors);
        this.debugger.setStopInChrome(stopInChrome);
        this.debugger.setTransferErrors2(transferErrors2);
        this.setDebugger(this.debugger);
        MozillaFireFoxInitDoneRequest reqID = this.requestManager.createInitDoneRequest();
        reqID.setEnabled(true);
        reqID.sendSyncRequest();
        return this.debugger;
    }

    public synchronized void startListening(DebugConnectArg[] connectArgs, DebugConnectionListener connectionListener) throws Exception {
        throw new UnsupportedOperationException("Listening not supported.");
    }

    public synchronized void stopListening() {
        throw new UnsupportedOperationException("Listening not supported.");
    }

    private void doStartup(DebugMozillaFireFoxJavaScriptTransport transport, Socket socket, boolean enableDebugStatement, boolean remoteAttach, boolean stopOnError, boolean stopOnException, boolean transferErrors, boolean stopInChrome) {
        this.requestManager = new MozillaFireFoxRequestManager(transport, this);
        this.eventHandler = new MozillaFireFoxEventHandler(this, transport, socket, this.requestManager);
        transport.setEventHandler(this.eventHandler);
        this.eventHandler.start();
        MozillaFireFoxGetVersionRequest req = this.requestManager.createGetVersionRequest();
        req.setEnabled(true);
        req.sendSyncRequest();
        MozillaFireFoxEnableDebugStatementRequest reqEDS = this.requestManager.createEnableDebugStatementRequest(enableDebugStatement);
        reqEDS.setEnabled(true);
        reqEDS.sendAsyncRequest();
        MozillaFireFoxErrorMessagesRequest reqEM = this.requestManager.createErrorMessagesRequest(transferErrors);
        reqEM.setEnabled(true);
        reqEM.sendAsyncRequest();
        MozillaFireFoxScriptRequest reqSR = this.requestManager.createScriptMessagesRequest(true);
        reqSR.setEnabled(true);
        reqSR.sendAsyncRequest();
        MozillaFireFoxExceptionsRequest reqER = this.requestManager.createExceptionsRequest(stopOnException);
        reqER.setEnabled(true);
        reqER.sendAsyncRequest();
        MozillaFireFoxStopOnErrorRequest reqSE = this.requestManager.createStopOnErrorRequest(stopOnError);
        reqSE.setEnabled(true);
        reqSE.sendAsyncRequest();
        MozillaFireFoxStopInChromeRequest reqSC = this.requestManager.createStopInChromeRequest(stopInChrome);
        reqSC.setEnabled(true);
        reqSC.sendSyncRequest();
    }

    public void terminate() {
        this.prepareForDetachTerminate();
        MozillaFireFoxTerminateRequest mfftr = this.requestManager.createTerminateRequest();
        mfftr.setEnabled(true);
        mfftr.sendAsyncRequest();
    }

    public void detach() {
        this.prepareForDetachTerminate();
        MozillaFireFoxDetachRequest mfftr = this.requestManager.createDetachRequest();
        mfftr.setEnabled(true);
        mfftr.sendSyncRequest();
    }

    public void disconnect(boolean isShutDown) {
        if (this.debugger != null) {
            this.debugger.setInShutDown(isShutDown);
            if (isShutDown) {
                this.debugger.connectionLost();
            }
            this.debugger.disconnect(isShutDown);
        }
    }

    void setDebugger(DebugMozillaFireFoxJavaScript debugger) {
        this.debugger = debugger;
    }

    public DebugMozillaFireFoxJavaScript getDebugger() {
        return this.debugger;
    }

    private void prepareForDetachTerminate() {
        MozillaFireFoxClearAllBreakpoints clearAllBpts = this.requestManager.createClearAllBreakpoints();
        clearAllBpts.setEnabled(true);
        clearAllBpts.sendSyncRequest();
        MozillaFireFoxResumeRequest mffrr = this.requestManager.createResumeRequest();
        mffrr.setEnabled(true);
        mffrr.sendSyncRequest();
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }
}

