/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.javascript;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxJavaScript;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxJavaScriptConnector;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxEventHandler;

public class DebugMozillaFireFoxJavaScriptTransport {
    private Socket socket;
    private MozillaFireFoxEventHandler eventHandler;
    private DataInputStream inputStream;
    private DataOutputStream outputStream;
    private Object inputLock;
    private Object outputLock;
    private DebugMozillaFireFoxJavaScriptConnector connector;
    public static final int HANDSHAKE_TIMEOUT = 3000;
    private static final String HANDSHAKE = "MaGic_Oracle_Js_DeBuG_AgEnT_MaGiC";

    private void $init$() {
        this.inputLock = new Object();
        this.outputLock = new Object();
    }

    public DebugMozillaFireFoxJavaScriptTransport(Socket socket, DebugMozillaFireFoxJavaScriptConnector connector) throws IOException {
        this.$init$();
        this.socket = socket;
        this.connector = connector;
        this.doHandshake();
        socket.setTcpNoDelay(true);
        this.inputStream = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
        this.outputStream = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
    }

    public boolean isConnected() {
        return this.inputStream != null && this.outputStream != null;
    }

    public void disconnect() {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.eventHandler != null) {
            this.eventHandler.shutDown();
        }
        this.inputStream = null;
        this.outputStream = null;
        this.socket = null;
    }

    public void sendMessage(int message) {
        try {
            this.outputStream.writeByte(message);
            this.flush();
        }
        catch (IOException ioe) {
            this.disconnect();
        }
    }

    public void flush() {
        try {
            this.outputStream.flush();
        }
        catch (IOException e) {
            this.disconnect();
        }
    }

    public int receiveMessage() {
        int m = 0;
        try {
            m = this.inputStream.readUnsignedByte();
        }
        catch (IOException e) {
            this.disconnect();
        }
        return m;
    }

    public boolean receiveBoolean() {
        boolean b = false;
        try {
            b = this.inputStream.readBoolean();
        }
        catch (IOException ioe) {
            this.disconnect();
        }
        return b;
    }

    public byte receiveByte() {
        byte i = 0;
        try {
            i = this.inputStream.readByte();
        }
        catch (IOException ioe) {
            this.disconnect();
        }
        return i;
    }

    public int receiveInteger() {
        int i = 0;
        try {
            i = this.inputStream.readInt();
        }
        catch (IOException ioe) {
            this.disconnect();
        }
        return i;
    }

    public long receiveLong() {
        long i = 0L;
        try {
            i = this.inputStream.readLong();
        }
        catch (IOException ioe) {
            this.disconnect();
        }
        return i;
    }

    public String receiveString() {
        String s = null;
        try {
            boolean isNull;
            boolean bl = isNull = this.inputStream.readByte() == 0;
            if (!isNull) {
                int length = this.inputStream.readInt();
                if (length > 0) {
                    byte[] b = new byte[length];
                    this.inputStream.readFully(b);
                    s = new String(b, "UTF-8");
                } else {
                    s = "";
                }
            }
        }
        catch (IOException ioe) {
            this.disconnect();
        }
        return s;
    }

    public String receiveUTF16String() {
        String s = null;
        try {
            boolean isNull;
            boolean bl = isNull = this.inputStream.readByte() == 0;
            if (!isNull) {
                int length = this.inputStream.readInt();
                if (length > 0) {
                    byte[] b = new byte[length];
                    this.inputStream.readFully(b);
                    s = new String(b, "UTF-16LE");
                } else {
                    s = "";
                }
            }
        }
        catch (IOException ioe) {
            this.disconnect();
        }
        return s;
    }

    public void sendBoolean(boolean b) {
        try {
            this.outputStream.writeBoolean(b);
        }
        catch (IOException ioe) {
            this.disconnect();
        }
    }

    public void sendInteger(int i) {
        try {
            this.outputStream.writeInt(i);
        }
        catch (IOException ioe) {
            this.disconnect();
        }
    }

    public void sendLong(long i) {
        try {
            this.outputStream.writeLong(i);
        }
        catch (IOException ioe) {
            this.disconnect();
        }
    }

    public void sendByte(byte b) {
        try {
            this.outputStream.writeByte(b);
        }
        catch (IOException ioe) {
            this.disconnect();
        }
    }

    public void sendString(String s) {
        try {
            if (s != null) {
                this.outputStream.writeByte(0);
                byte[] b = s.getBytes("UTF-8");
                this.outputStream.writeInt(b.length);
                this.outputStream.write(b);
            } else {
                this.outputStream.writeByte(1);
            }
        }
        catch (IOException ioe) {
            this.disconnect();
        }
    }

    public void sendStringUTF16(String s) {
        try {
            if (s != null) {
                this.outputStream.writeByte(0);
                byte[] b = s.getBytes("UTF-16LE");
                this.outputStream.writeInt(b.length);
                this.outputStream.write(b);
            } else {
                this.outputStream.writeByte(1);
            }
        }
        catch (IOException ioe) {
            this.disconnect();
        }
    }

    private void doHandshake() throws IOException {
        this.socket.setSoTimeout(3000);
        byte[] handshake = HANDSHAKE.getBytes("UTF-8");
        this.socket.getOutputStream().write(handshake);
        int len = handshake.length;
        byte[] b = new byte[len];
        int read = 0;
        InputStream inputStream = this.socket.getInputStream();
        while (read < len) {
            int n = inputStream.read(b, read, len - read);
            if (n < 0) {
                this.socket.close();
                throw new IOException("Target failed to handshake.");
            }
            read += n;
        }
        int i = 0;
        while (i < len) {
            if (b[i] != handshake[i]) {
                throw new IOException("Target failed to handshake.");
            }
            ++i;
        }
        this.socket.setSoTimeout(0);
    }

    public int getInt(byte[] b, int offset) {
        return (b[offset] << 24) + (b[offset + 1] << 16) + (b[offset + 2] << 8) + (b[offset + 3] << 0);
    }

    public void putInt(byte[] b, int offset, int value) {
        b[offset] = (byte)(value >>> 24 & 0xFF);
        b[offset + 1] = (byte)(value >>> 16 & 0xFF);
        b[offset + 2] = (byte)(value >>> 8 & 0xFF);
        b[offset + 3] = (byte)(value >>> 0 & 0xFF);
    }

    public String getString(byte[] b, int offset) {
        int len = this.getInt(b, offset);
        return new String(b, offset + 4, len);
    }

    public void setEventHandler(MozillaFireFoxEventHandler handler) {
        this.eventHandler = handler;
    }

    public MozillaFireFoxEventHandler getEventHandler() {
        return this.eventHandler;
    }

    public Object getInputLock() {
        return this.inputLock;
    }

    public Object getOutputLock() {
        return this.outputLock;
    }

    public DebugMozillaFireFoxJavaScript getDebugger() {
        return this.connector.getDebugger();
    }
}

