/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.javascript;

import java.util.ArrayList;
import java.util.List;
import oracle.jdevimpl.debugger.javascript.DebugJavaScriptArb;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxJavaScript;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxJavaScriptStackFrameInfo;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxFetchFramesRequest;
import oracle.jdevimpl.debugger.support.DebugClassLoaderInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMonitorInfo;
import oracle.jdevimpl.debugger.support.DebugRegisterInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadGroupInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;

public class DebugMozillaFireFoxThreadInfo
implements DebugThreadInfo {
    DebugThreadGroupInfo parent;
    DebugMozillaFireFoxJavaScript debugger;
    private ArrayList<DebugStackFrameInfo> frames;
    private boolean expiredInfo;
    static final /* synthetic */ boolean $assertionsDisabled;

    private void $init$() {
        this.expiredInfo = false;
    }

    public DebugMozillaFireFoxThreadInfo(DebugThreadGroupInfo parent, DebugMozillaFireFoxJavaScript debugger) {
        this.$init$();
        this.parent = parent;
        this.debugger = debugger;
    }

    public boolean hasExited() {
        return false;
    }

    public long getThreadId() {
        return 0L;
    }

    public String getName() {
        return DebugJavaScriptArb.getString(8);
    }

    public String getGroupName() {
        return this.parent == null ? null : this.parent.getName();
    }

    public DebugThreadGroupInfo getThreadGroup() {
        return this.parent;
    }

    public int getStatus() {
        return 5;
    }

    public boolean isThreadSuspended() {
        return this.debugger.isStopped();
    }

    public void suspendThread() {
        this.debugger.pauseProgram();
    }

    public void resumeThread() {
        this.debugger.resume();
    }

    public void interruptThread() {
    }

    public void stopThread() {
    }

    public DebugDataObjectInfo getThreadObject() {
        return null;
    }

    public void stepInto() {
        this.debugger.stepInto();
    }

    public void stepOver() {
        this.debugger.stepOver();
    }

    public void stepIntoBC() {
        this.stepInto();
    }

    public void stepOverBC() {
        this.stepOver();
    }

    public void stepOut() {
        this.debugger.stepOut();
    }

    public boolean isAtEndOfMethod() {
        return false;
    }

    public void stepToEndOfMethod() {
    }

    public void stepIntoMethod(String methodName, String callerPackage, String callerFileName, int callerLine) {
    }

    public int getStackFrameCount() {
        this.fillStackFrames();
        return this.frames.size();
    }

    public DebugStackFrameInfo getStackFrame(int frame) {
        this.fillStackFrames();
        if (frame >= this.frames.size()) {
            return null;
        }
        return this.frames.get(frame);
    }

    public DebugStackFrameInfo[] listStack() {
        this.fillStackFrames();
        return this.frames.toArray(new DebugMozillaFireFoxJavaScriptStackFrameInfo[this.frames.size()]);
    }

    public DebugMonitorInfo[] listOwnedMonitors() {
        return new DebugMonitorInfo[0];
    }

    public DebugMonitorInfo getMonitorThreadWaitingFor() {
        return null;
    }

    public DebugMonitorInfo getMonitorThreadBlockedFor() {
        return null;
    }

    public DebugRegisterInfo[] listRegisters() {
        return new DebugRegisterInfo[0];
    }

    public DebugRegisterInfo[] listFloatRegisters() {
        return new DebugRegisterInfo[0];
    }

    public DebugVariableInfo getReturnValue() {
        return null;
    }

    public DebugVariableInfo getReturnedValue() {
        return null;
    }

    public boolean setLocation(DebugLocation location) {
        return false;
    }

    public DebugDataObjectInfo getContextClassLoaderObject() {
        return null;
    }

    public DebugClassLoaderInfo getContextClassLoader() {
        return null;
    }

    public boolean isThreadInterrupted() {
        return false;
    }

    public boolean isThreadDebuggerStopped() {
        return false;
    }

    public boolean canDebuggerStopThread() {
        return false;
    }

    static {
        $assertionsDisabled = DebugMozillaFireFoxThreadInfo.class.desiredAssertionStatus() ^ true;
    }

    private void fillStackFrames() {
        if (!$assertionsDisabled && this.debugger == null) {
            throw new AssertionError((Object)"Debugger can't be null");
        }
        if (!$assertionsDisabled && !this.debugger.isStopped()) {
            throw new AssertionError((Object)"Debugger must be stopped when asking for call stack!");
        }
        if (!this.expiredInfo && this.frames != null) {
            return;
        }
        this.expiredInfo = false;
        MozillaFireFoxFetchFramesRequest mfffsf = this.debugger.getRequestManager().createFetchStackFrames();
        mfffsf.setEnabled(true);
        mfffsf.sendSyncRequest();
        this.frames = new ArrayList();
        List<MozillaFireFoxFetchFramesRequest.StackFrameInfo> internalSFs = mfffsf.getStackFrames();
        if (internalSFs != null) {
            int i = 0;
            while (i < internalSFs.size()) {
                this.frames.add(new DebugMozillaFireFoxJavaScriptStackFrameInfo(i, internalSFs.get(i), this.debugger));
                ++i;
            }
        }
    }

    public void invalidate() {
        this.expiredInfo = true;
        this.frames = null;
    }

    void setExpired(boolean b) {
        this.expiredInfo = b;
        this.invalidate();
    }
}

