/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.javascript.event;

import java.net.Socket;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxJavaScriptConnector;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxJavaScriptTransport;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxRequest;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxRequestManager;

public class MozillaFireFoxEventHandler {
    private DebugMozillaFireFoxJavaScriptConnector connector;
    private DebugMozillaFireFoxJavaScriptTransport transport;
    private Socket socket;
    private MozillaFireFoxRequestManager requestManager;
    private EventHandlerThread handlerThread;
    static final /* synthetic */ boolean $assertionsDisabled;

    private void $init$() {
        this.handlerThread = null;
    }

    public MozillaFireFoxEventHandler(DebugMozillaFireFoxJavaScriptConnector connector, DebugMozillaFireFoxJavaScriptTransport transport, Socket socket, MozillaFireFoxRequestManager requestManager) {
        this.$init$();
        this.connector = connector;
        this.transport = transport;
        this.socket = socket;
        this.requestManager = requestManager;
        this.handlerThread = new EventHandlerThread(connector, transport, socket, requestManager);
    }

    static {
        $assertionsDisabled = MozillaFireFoxEventHandler.class.desiredAssertionStatus() ^ true;
    }

    public void start() {
        if (!$assertionsDisabled && this.handlerThread == null) {
            throw new AssertionError((Object)"Handler thread can't be null!");
        }
        this.handlerThread.startHandlerThread();
    }

    public void shutDown() {
        if (!$assertionsDisabled && this.handlerThread == null) {
            throw new AssertionError((Object)"Handler thread can't be null!");
        }
        this.handlerThread.exitHandlerThread();
        this.requestManager.disconnect(true);
    }

    static class EventHandlerThread
    extends Thread {
        private DebugMozillaFireFoxJavaScriptConnector connector;
        private DebugMozillaFireFoxJavaScriptTransport transport;
        private Socket socket;
        private MozillaFireFoxRequestManager requestManager;
        private boolean exit;
        static final /* synthetic */ boolean $assertionsDisabled;

        private void $init$() {
            this.exit = false;
        }

        EventHandlerThread(DebugMozillaFireFoxJavaScriptConnector connector, DebugMozillaFireFoxJavaScriptTransport transport, Socket socket, MozillaFireFoxRequestManager requestManager) {
            this.$init$();
            this.connector = connector;
            this.transport = transport;
            this.socket = socket;
            this.requestManager = requestManager;
            this.setName("MozzilaFireFoxEvent listening thread");
        }

        public void run() {
            while (!this.exit) {
                try {
                    int reqId = this.transport.receiveInteger();
                    this.handleEventReceived(reqId);
                }
                catch (Exception e) {
                    this.exitHandlerThread();
                }
            }
        }

        void exitHandlerThread() {
            this.exit = true;
        }

        void startHandlerThread() {
            super.start();
        }

        static {
            $assertionsDisabled = EventHandlerThread.class.desiredAssertionStatus() ^ true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleEventReceived(int reqId) {
            if (this.exit) {
                return;
            }
            Object object = this.transport.getInputLock();
            synchronized (object) {
                MozillaFireFoxRequest req = this.requestManager.getRequestFromRequestId(reqId);
                if (!$assertionsDisabled && req == null) {
                    throw new AssertionError((Object)"An event must be requested first!");
                }
                req.readResponse(this.transport);
                req.setResponded(true);
                if (req.isOneTimeRequest()) {
                    this.requestManager.removeRequest(req);
                }
                if (req.isSyncRequest()) {
                    MozillaFireFoxRequest mozillaFireFoxRequest = req;
                    synchronized (mozillaFireFoxRequest) {
                        req.notifyAll();
                    }
                }
            }
        }
    }
}

