/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.javascript.event;

import java.util.ArrayList;
import java.util.List;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxJavaScriptTransport;
import oracle.jdevimpl.debugger.javascript.event.Command;
import oracle.jdevimpl.debugger.javascript.event.CommandGroup;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxOneTimeRequest;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxRequestManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MozillaFireFoxFetchFramesRequest
extends MozillaFireFoxOneTimeRequest {
    private List<StackFrameInfo> stackFrames;

    private void $init$() {
        this.stackFrames = null;
    }

    MozillaFireFoxFetchFramesRequest(MozillaFireFoxRequestManager requestManager, CommandGroup commandGroup, Command command) {
        super(requestManager, commandGroup, command);
        this.$init$();
    }

    @Override
    void writeSpecificBytes(DebugMozillaFireFoxJavaScriptTransport transport) {
    }

    @Override
    protected void readResponse(DebugMozillaFireFoxJavaScriptTransport transport) {
        super.readResponse(transport);
        this.stackFrames = new ArrayList<StackFrameInfo>();
        int numFrames = transport.receiveInteger();
        int i = 0;
        while (i < numFrames) {
            long stackFrameId = transport.receiveLong();
            long thisValueId = transport.receiveLong();
            int thisType = transport.receiveInteger();
            String thisName = transport.receiveString();
            String thisValueStr = transport.receiveString();
            long globalValueId = transport.receiveLong();
            int globalType = transport.receiveInteger();
            String globalName = transport.receiveString();
            String globalValueStr = transport.receiveString();
            String scriptName = transport.receiveString();
            String methodName = transport.receiveString();
            long funValueId = transport.receiveLong();
            int funType = transport.receiveInteger();
            String funStrValue = transport.receiveString();
            boolean isNative = transport.receiveBoolean();
            boolean isDebugger = transport.receiveBoolean();
            boolean isConstructing = transport.receiveBoolean();
            int pc = transport.receiveInteger();
            int line = transport.receiveInteger();
            this.stackFrames.add(new StackFrameInfo(stackFrameId, thisValueId, thisType, thisName, thisValueStr, globalValueId, globalType, globalName, globalValueStr, scriptName, methodName, funValueId, funType, funStrValue, isNative, isDebugger, isConstructing, pc, line));
            ++i;
        }
    }

    public List<StackFrameInfo> getStackFrames() {
        return this.stackFrames;
    }

    public static class StackFrameInfo {
        public long stackFrameId;
        public long thisValueId;
        public int thisType;
        public String thisName;
        public String thisVlaueStr;
        public long globalValueId;
        public int globalType;
        public String globalName;
        public String globalVlaueStr;
        public String scriptName;
        public String methodName;
        public long funValueId;
        public int funType;
        public String funStrValue;
        public boolean isNative;
        public boolean isDebugger;
        public boolean isConstructing;
        public int pc;
        public int line;

        StackFrameInfo(long stackFrameId, long thisValueId, int thisType, String thisName, String thisValueStr, long globalValueId, int globalType, String globalName, String globalValueStr, String scriptName, String methodName, long funValueId, int funType, String funStrValue, boolean isNative, boolean isDebugger, boolean isConstructing, int pc, int line) {
            this.stackFrameId = stackFrameId;
            this.thisValueId = thisValueId;
            this.thisType = thisType;
            this.thisName = thisName;
            this.thisVlaueStr = thisValueStr;
            this.globalValueId = globalValueId;
            this.globalType = globalType;
            this.globalName = globalName;
            this.globalVlaueStr = globalValueStr;
            this.scriptName = scriptName;
            this.methodName = methodName;
            this.funValueId = funValueId;
            this.funType = funType;
            this.funStrValue = funStrValue;
            this.isNative = isNative;
            this.isDebugger = isDebugger;
            this.isConstructing = isConstructing;
            this.pc = pc;
            this.line = line;
        }
    }
}

