/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.javascript.event;

import java.util.ArrayList;
import java.util.List;
import oracle.jdevimpl.debugger.javascript.DebugJavaScriptArb;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxJavaScriptTransport;
import oracle.jdevimpl.debugger.javascript.event.Command;
import oracle.jdevimpl.debugger.javascript.event.CommandGroup;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxOneTimeRequest;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxRequestManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MozillaFireFoxGetPropertiesRequest
extends MozillaFireFoxOneTimeRequest {
    private long address;
    private List<PropertyInfo> properties;

    private void $init$() {
        this.address = -1;
    }

    MozillaFireFoxGetPropertiesRequest(MozillaFireFoxRequestManager requestManager, CommandGroup commandGroup, Command command, long address) {
        super(requestManager, commandGroup, command);
        this.$init$();
        this.address = address;
    }

    @Override
    protected void readResponse(DebugMozillaFireFoxJavaScriptTransport transport) {
        super.readResponse(transport);
        this.properties = new ArrayList<PropertyInfo>();
        int numProps = transport.receiveInteger();
        int i = 0;
        while (i < numProps) {
            int flags = transport.receiveInteger();
            long alias = transport.receiveLong();
            long nameValueId = transport.receiveLong();
            String name = null;
            if (nameValueId != 0L) {
                name = transport.receiveString();
            }
            long valueId = transport.receiveLong();
            int type = 0;
            String valStr = null;
            if (valueId != 0L) {
                type = transport.receiveInteger();
                valStr = transport.receiveString();
            }
            long jdsIObj = 0L;
            String creatorUrl = null;
            int creatorLine = 0;
            String constructorUrl = null;
            int constructorLine = 0;
            long objVal = 0L;
            String objValStr = null;
            if (type == 5 && (jdsIObj = transport.receiveLong()) != 0L) {
                creatorUrl = transport.receiveString();
                creatorLine = transport.receiveInteger();
                constructorUrl = transport.receiveString();
                constructorLine = transport.receiveInteger();
                objVal = transport.receiveLong();
                if (objVal != 0L) {
                    objValStr = transport.receiveString();
                }
            }
            int slotNum = transport.receiveInteger();
            this.properties.add(new PropertyInfo(flags, alias, nameValueId, name, valueId, type, valStr, jdsIObj, creatorUrl, creatorLine, constructorUrl, constructorLine, objVal, objValStr, slotNum));
            ++i;
        }
    }

    @Override
    void writeSpecificBytes(DebugMozillaFireFoxJavaScriptTransport transport) {
        transport.sendLong(this.address);
    }

    public List<PropertyInfo> getProperties() {
        return this.properties;
    }

    public static class PropertyInfo {
        public int flags;
        public long alias;
        public long nameValueId;
        public String name;
        public long valueId;
        public int type;
        private String valStr;
        public long jdsIObj;
        public String creatorUrl;
        public int creatorLine;
        public String constructorUrl;
        public int constructorLine;
        public long objVal;
        private String objValStr;
        public int slotNum;

        PropertyInfo(int flags, long alias, long nameValueId, String name, long valueId, int type, String valStr, long jdsIObj, String creatorUrl, int creatorLine, String constructorUrl, int constructorLine, long objVal, String objValStr, int slotNum) {
            this.flags = flags;
            this.alias = alias;
            this.nameValueId = nameValueId;
            this.name = name;
            this.valueId = valueId;
            this.type = type;
            this.valStr = valStr;
            this.jdsIObj = jdsIObj;
            this.creatorUrl = creatorUrl;
            this.creatorLine = creatorLine;
            this.constructorUrl = constructorUrl;
            this.constructorLine = constructorLine;
            this.objVal = objVal;
            this.objValStr = objValStr;
            this.slotNum = slotNum;
        }

        public String getValue() {
            if ((this.flags & 0x40) != 0) {
                return "";
            }
            if ((this.flags & 0x80) != 0) {
                return DebugJavaScriptArb.getString(1);
            }
            return this.valStr;
        }
    }
}

