/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.javascript.event;

import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxFileLineBreakpoint;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxJavaScriptTransport;
import oracle.jdevimpl.debugger.javascript.event.Command;
import oracle.jdevimpl.debugger.javascript.event.CommandGroup;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxRequestManager;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxTrapRequest;

public class MozillaFireFoxLineBreakpointRequest
extends MozillaFireFoxTrapRequest {
    private DebugMozillaFireFoxFileLineBreakpoint breakpoint;
    static final /* synthetic */ boolean $assertionsDisabled;

    MozillaFireFoxLineBreakpointRequest(MozillaFireFoxRequestManager requestManager, CommandGroup commandGroup, Command command, DebugMozillaFireFoxFileLineBreakpoint breakpoint) {
        super(requestManager, commandGroup, command);
        this.breakpoint = breakpoint;
    }

    void writeSpecificBytes(DebugMozillaFireFoxJavaScriptTransport transport) {
        transport.sendString(this.breakpoint.getFilename());
        transport.sendString(this.breakpoint.getRelativeFilename());
        transport.sendInteger(this.breakpoint.getLine());
        transport.sendInteger(this.breakpoint.getPassCount());
        transport.sendStringUTF16(this.breakpoint.getCondition() == null ? null : this.breakpoint.getCondition().getConditionText());
    }

    static {
        $assertionsDisabled = MozillaFireFoxLineBreakpointRequest.class.desiredAssertionStatus() ^ true;
    }

    protected void readResponse(DebugMozillaFireFoxJavaScriptTransport transport) {
        super.readResponse(transport);
        byte eventType = transport.receiveByte();
        int numBpts = transport.receiveInteger();
        if (eventType == 1) {
            this.breakpoint.eventSet(numBpts);
        } else if (eventType == 2) {
            this.breakpoint.eventUnset(numBpts);
        } else if (eventType == 3) {
            this.breakpoint.eventHit(numBpts);
        } else if (eventType == 4) {
            this.breakpoint.eventPassCountDeced(numBpts);
        } else if (!$assertionsDisabled) {
            throw new AssertionError((Object)"Unnknown event came!");
        }
    }
}

