/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.BooleanType;
import com.sun.jdi.ByteType;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharType;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleType;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.Field;
import com.sun.jdi.FloatType;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerType;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InternalException;
import com.sun.jdi.Location;
import com.sun.jdi.LongType;
import com.sun.jdi.LongValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.OracleExtension;
import com.sun.jdi.OracleReferenceType;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StackFrame;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VoidType;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventIterator;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.event.ModificationWatchpointEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.event.WatchpointEvent;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.ClassUnloadRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import com.sun.jdi.request.StepRequest;
import com.sun.jdi.request.ThreadStartRequest;
import java.awt.List;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import oracle.ide.Ide;
import oracle.ide.log.MessagePage;
import oracle.ide.util.Assert;
import oracle.ide.util.VersionNumber;
import oracle.jdevimpl.debugger.jdi.DebugJDIAnnotationInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIAnonymousBlockManager;
import oracle.jdevimpl.debugger.jdi.DebugJDIAnonymousBlockManagerFactory;
import oracle.jdevimpl.debugger.jdi.DebugJDIArb;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpoint;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpointClass;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpointClassLoad;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpointDeadlock;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpointException;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpointFileLine;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpointMethod;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpointMethodBytecode;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpointPackageFileLine;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpointWatchpoint;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassLoaderInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataArrayInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataCompositeInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataObjectInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataPrimitiveInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIFieldInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIHeapObjectInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDILocation;
import oracle.jdevimpl.debugger.jdi.DebugJDIMonitorInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIPinnedInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIStackFrameInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIStoppedListener;
import oracle.jdevimpl.debugger.jdi.DebugJDIThreadGroupInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIThreadInfo;
import oracle.jdevimpl.debugger.shared.DebugEventMulticaster;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.shared.DebugSharedDisassemble;
import oracle.jdevimpl.debugger.shared.DebugSharedPrimitives;
import oracle.jdevimpl.debugger.support.DebugBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpointAllocationClass;
import oracle.jdevimpl.debugger.support.DebugBreakpointAllocationThreshold;
import oracle.jdevimpl.debugger.support.DebugBreakpointClass;
import oracle.jdevimpl.debugger.support.DebugBreakpointClassLoad;
import oracle.jdevimpl.debugger.support.DebugBreakpointDeadlock;
import oracle.jdevimpl.debugger.support.DebugBreakpointException;
import oracle.jdevimpl.debugger.support.DebugBreakpointFileLine;
import oracle.jdevimpl.debugger.support.DebugBreakpointLogListener;
import oracle.jdevimpl.debugger.support.DebugBreakpointMethod;
import oracle.jdevimpl.debugger.support.DebugBreakpointMethodBytecode;
import oracle.jdevimpl.debugger.support.DebugBreakpointPackageFileLine;
import oracle.jdevimpl.debugger.support.DebugBreakpointWatchpoint;
import oracle.jdevimpl.debugger.support.DebugCapabilities;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugClassLoaderInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.DebugHeapInfo;
import oracle.jdevimpl.debugger.support.DebugHeapObjectInfo;
import oracle.jdevimpl.debugger.support.DebugHeapSubset;
import oracle.jdevimpl.debugger.support.DebugListener;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMonitorInfo;
import oracle.jdevimpl.debugger.support.DebugPinListener;
import oracle.jdevimpl.debugger.support.DebugPinnedInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadGroupInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.debugger.support.UserSelectedURLCacher;
import oracle.jdevimpl.runner.debug.EvaluationInfo;
import oracle.jdevimpl.runner.xslt.XSLTRunnerAddin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DebugJDI
implements DebugVirtualMachine,
DebugCapabilities,
Runnable {
    private static final String JAVA_LANG_BYTE_STRING = "java.lang.Byte";
    private static final String JAVA_LANG_CHARACTER_STRING = "java.lang.Character";
    private static final String JAVA_LANG_DOUBLE_STRING = "java.lang.Double";
    private static final String JAVA_LANG_FLOAT_STRING = "java.lang.Float";
    private static final String JAVA_LANG_INTEGER_STRING = "java.lang.Integer";
    private static final String JAVA_LANG_LONG_STRING = "java.lang.Long";
    private static final String JAVA_LANG_SHORT_STRING = "java.lang.Short";
    private static DebugJDIAnonymousBlockManagerFactory anonymousBlockManagerFactory;
    private static DebugJDIAnonymousBlockManager anonymousBlockManager;
    VirtualMachine vm;
    private boolean vmWasRunning;
    private int languages;
    private java.util.List unhandledEventSets;
    private java.util.List unhandledEventThreads;
    private java.util.List needToResume;
    private EventQueue eq;
    EventRequestManager erm;
    private ClassUnloadRequest cur;
    private ClassPrepareRequest startCPR;
    private ThreadStartRequest startTSR;
    private Map startStepRequests;
    private Location stepLocation;
    private String[] stepStack;
    private StepRequest stepRequest;
    private boolean useMethodExitRequest;
    private MethodExitRequest methodExitRequestForStepToEndOfMethod;
    private Method methodExitRequestForStepToEndOfMethodMethod;
    private MethodExitRequest methodExitRequestForStepOut;
    boolean methodExitEventHasReturnValue;
    private int runCommand;
    private ThreadReference runCommandThread;
    private Thread runningThread;
    private Thread testConnectionThread;
    private java.util.List breakpoints;
    private Set bpRequests;
    private Map cprsByFilter;
    private Map cprBreakpoints;
    private boolean redefineClassesOccurred;
    private java.util.List<DebugJDIClassInfo> classes;
    Map classesByReferenceType;
    private Map classesByName;
    private Map classesByNameWithoutPackage;
    private Set classesCollected;
    private Set classesNotCollected;
    private Set objectsCollected;
    private Set objectsNotCollected;
    private boolean debuggableClassLoaded;
    private boolean lookForAnyUnloadedClassesNeeded;
    private Map<Long, DebugJDIHeapObjectInfo> id2ObjectReference;
    java.util.List debuggable;
    java.util.List nonDebuggable;
    Set nonDebuggableClassExclusionFilters;
    private Map otherWaitingThreads;
    Map threadInfos;
    int stoppedCountThreadContextClassLoaders;
    Map stackFrameInfos;
    Map classLoaderInfos;
    Map classLoaderIds;
    private ClassLoaderReference systemClassLoader;
    private DebugJDIBreakpoint currentBreakpoint;
    private DebugJDIThreadInfo currentThread;
    ThreadReference eventThread;
    private MethodExitRequest returnValuesRequest;
    private Map<Long, MethodExitEvent> threadReturnValues;
    private DebugJDIDataObjectInfo currentThrow;
    private DebugJDILocation currentThrowHandler;
    private DebugJDIDataObjectInfo watchpointObject;
    private DebugJDIFieldInfo watchpointField;
    private DebugJDIDataInfo watchpointFieldFutureValue;
    private java.util.List knownDeadlockedThreads;
    int stoppedCount;
    java.util.List stoppedListeners;
    private Object[] syncObjects;
    private boolean[] syncValues;
    private static final int SYNC_STOPPED = 0;
    private static final int SYNC_PAUSE_REQUESTED = 1;
    private static final int SYNC_TERMINATED = 2;
    private static final int SYNC_DISCONNECT_REQUESTED = 3;
    private static final int SYNC_TERMINATE_REQUESTED = 4;
    private static final int SYNC_CONNECTION_LOGS = 5;
    private static final int SYNC_CONNECTION_LOST = 6;
    private static final int SYNC_SYSTEM_CLASS_LOADER = 7;
    private static final int SYNC_COUNT = 8;
    private java.util.List pins;
    private MessagePage logPage;
    DebugListener debugListener;
    private DebugBreakpointLogListener bpLogListener;
    private java.util.List connectionLogs;
    private static int stdErrCount;
    private static PrintStream stdErr;
    private ClassPrepareRequest prepareRequest;
    private DebugStackFrameInfo currentStackFrame;
    private MethodEntryRequest methodEntryRequestStepIntoMethod;
    private String stepIntoMethodName;
    private String stepIntoMethodCallerPackage;
    private String stepIntoMethodCallerFileName;
    private String stepIntoMethodCallerPath;
    private int stepIntoMethodCallerLine;
    private DebugJDIBreakpoint stepIntoMethodBreakpoint;
    private static Boolean isDebuggerBeforeJDK142;
    boolean printedClassNotPreparedWarning;
    private static final Set plsqlJavaClasses;
    private Boolean isOracleDatabaseVM;
    private static final int RunCommand_StartInto = 0;
    private static final int RunCommand_StartOver = 1;
    private static final int RunCommand_Run = 2;
    private static final int RunCommand_StepInto = 3;
    private static final int RunCommand_StepOver = 4;
    private static final int RunCommand_StepIntoBC = 5;
    private static final int RunCommand_StepOverBC = 6;
    private static final int RunCommand_StepOut = 7;
    private static final int RunCommand_StepToEndOfMethod = 8;
    private static final int RunCommand_ContinueStep = 9;
    private static final int RunCommand_StepIntoMethod = 10;
    private UserSelectedURLCacher userUrlCacher;

    private void $init$() {
        this.languages = 0;
        this.methodExitRequestForStepToEndOfMethodMethod = null;
        this.classes = new ArrayList<DebugJDIClassInfo>();
        this.prepareRequest = null;
        this.printedClassNotPreparedWarning = false;
        this.userUrlCacher = null;
    }

    DebugJDI(VirtualMachine vm) {
        VersionNumber versionNumber;
        String version;
        this.$init$();
        this.initSync();
        this.unhandledEventSets = new ArrayList();
        this.unhandledEventThreads = new ArrayList();
        this.needToResume = new ArrayList();
        this.stoppedCount = 0;
        this.stoppedListeners = new ArrayList();
        this.breakpoints = new ArrayList();
        this.bpRequests = new HashSet();
        this.cprsByFilter = new HashMap();
        this.cprBreakpoints = new HashMap();
        this.classesByReferenceType = new HashMap();
        this.classesByName = new HashMap();
        this.classesByNameWithoutPackage = new HashMap();
        this.classesCollected = new HashSet();
        this.classesNotCollected = new HashSet();
        this.objectsCollected = new HashSet();
        this.objectsNotCollected = new HashSet();
        this.debuggable = new ArrayList();
        this.nonDebuggable = new ArrayList();
        this.nonDebuggableClassExclusionFilters = new HashSet();
        this.otherWaitingThreads = new HashMap();
        this.threadInfos = new HashMap();
        this.stackFrameInfos = new HashMap();
        this.classLoaderInfos = new HashMap();
        this.classLoaderIds = new HashMap();
        this.knownDeadlockedThreads = new ArrayList();
        this.pins = new ArrayList();
        this.vmWasRunning = false;
        this.vm = vm;
        try {
            String log = Ide.getProperty((String)"DebuggerConnectionLog");
            if (log != null) {
                if (log.equals("System.out")) {
                    this.addConnectionLog(System.out);
                } else if (log.equals("System.err")) {
                    this.addConnectionLog(System.err);
                } else if (log.equals("file")) {
                    this.addConnectionLog(File.createTempFile("jpda", null, new File(Ide.getBinDirectory())));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if ((version = vm.version()) != null && (versionNumber = new VersionNumber(version)).isAfter(new VersionNumber("1.4"), true)) {
            this.useMethodExitRequest = true;
        }
        this.eq = vm.eventQueue();
        this.lookForVMStartEvent();
        this.setSyncValue(0, true);
        this.erm = vm.eventRequestManager();
        this.cur = this.erm.createClassUnloadRequest();
        this.cur.setSuspendPolicy(2);
        this.cur.enable();
        this.addPrimitiveClasses();
        for (ReferenceType rt : vm.allClasses()) {
            this.addClassForReferenceType(rt, true);
        }
        this.prepareRequest = this.erm.createClassPrepareRequest();
        this.prepareRequest.setSuspendPolicy(0);
        this.prepareRequest.enable();
    }

    private void addPrimitiveClasses() {
        Type type = (ByteType)this.vm.mirrorOf((byte)0).type();
        if (type != null) {
            this.addClass(new DebugJDIClassInfo(this, type));
        }
        if ((type = (CharType)this.vm.mirrorOf('\u0000').type()) != null) {
            this.addClass(new DebugJDIClassInfo(this, type));
        }
        if ((type = (DoubleType)this.vm.mirrorOf(0.0).type()) != null) {
            this.addClass(new DebugJDIClassInfo(this, type));
        }
        if ((type = (FloatType)this.vm.mirrorOf(0.0f).type()) != null) {
            this.addClass(new DebugJDIClassInfo(this, type));
        }
        if ((type = (IntegerType)this.vm.mirrorOf(0).type()) != null) {
            this.addClass(new DebugJDIClassInfo(this, type));
        }
        if ((type = (LongType)this.vm.mirrorOf(0L).type()) != null) {
            this.addClass(new DebugJDIClassInfo(this, type));
        }
        if ((type = (ShortType)this.vm.mirrorOf((short)0).type()) != null) {
            this.addClass(new DebugJDIClassInfo(this, type));
        }
        if ((type = (BooleanType)this.vm.mirrorOf(false).type()) != null) {
            this.addClass(new DebugJDIClassInfo(this, type));
        }
        if ((type = this.getVoidType()) != null) {
            this.addClass(new DebugJDIClassInfo(this, type));
        }
    }

    private VoidType getVoidType() {
        try {
            for (ReferenceType c : this.vm.allClasses()) {
                if (!(c instanceof ClassType)) continue;
                ClassType ct = (ClassType)c;
                for (Method m : ct.methodsByName("notify")) {
                    Type type = m.returnType();
                    if (!(type instanceof VoidType)) continue;
                    VoidType voidType = (VoidType)type;
                    return voidType;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void afterConnection(MessagePage logPage) {
        if (this.vmWasRunning) {
            this.lookForAnyUnloadedClassesNeeded = true;
        }
        this.logPage = logPage;
        if (logPage != null) {
            int count;
            java.util.List<DebugJDIClassInfo> list = this.classes;
            synchronized (list) {
                count = this.classes.size();
            }
            String sCount = Integer.toString(count);
            logPage.log((Object)DebugJDIArb.format(4, sCount));
        }
        this.preprocessClassLoaders();
        if (logPage != null) {
            logPage.log((Object)DebugJDIArb.getString(7));
        }
    }

    @Override
    public synchronized void addDebugListener(DebugListener l) {
        this.debugListener = DebugEventMulticaster.add(this.debugListener, l);
    }

    @Override
    public synchronized void removeDebugListener(DebugListener l) {
        this.debugListener = DebugEventMulticaster.remove(this.debugListener, l);
    }

    @Override
    public synchronized void addBreakpointLogListener(DebugBreakpointLogListener l) {
        this.bpLogListener = DebugEventMulticaster.add(this.bpLogListener, l);
    }

    @Override
    public synchronized void removeBreakpointLogListener(DebugBreakpointLogListener l) {
        this.bpLogListener = DebugEventMulticaster.remove(this.bpLogListener, l);
    }

    private void lookForVMStartEvent() {
        boolean foundVMStartEvent = false;
        EventSet es = null;
        try {
            es = this.eq.remove(1000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (es != null) {
            Event e;
            EventIterator ei = es.eventIterator();
            if (ei.hasNext() && (e = ei.nextEvent()) instanceof VMStartEvent && es.suspendPolicy() == 2) {
                foundVMStartEvent = true;
                this.needToResume.add(es);
            }
            if (!foundVMStartEvent) {
                es.resume();
            }
        }
        if (!foundVMStartEvent) {
            this.vm.suspend();
            this.needToResume.add(this.vm);
            this.vmWasRunning = true;
        }
    }

    private static synchronized boolean isDebuggerBeforeJDK142() {
        VersionNumber versionNumber;
        if (isDebuggerBeforeJDK142 != null) {
            return isDebuggerBeforeJDK142;
        }
        String javaVersion = System.getProperty("java.version");
        if (javaVersion != null && (versionNumber = new VersionNumber(javaVersion = javaVersion.replace('_', '.'))).isBefore(new VersionNumber("1.4.2"))) {
            isDebuggerBeforeJDK142 = Boolean.TRUE;
            return true;
        }
        isDebuggerBeforeJDK142 = Boolean.FALSE;
        return false;
    }

    private boolean isClassPrepared(ReferenceType rt) {
        try {
            if (this.isRIM()) {
                boolean bl = true;
                return bl;
            }
            if (rt instanceof ArrayType) {
                boolean bl = true;
                return bl;
            }
            if (this.isOracleDatabaseVM()) {
                boolean bl = true;
                return bl;
            }
            if (DebugJDI.isDebuggerBeforeJDK142()) {
                if (rt.isInitialized() || rt.isPrepared()) {
                    boolean bl = true;
                    return bl;
                }
            } else if (rt.isPrepared()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (ObjectCollectedException e) {
            boolean bl = true;
            return bl;
        }
        catch (UnsupportedOperationException e) {
            boolean bl = true;
            return bl;
        }
        catch (VMDisconnectedException e) {
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = true;
            return bl;
        }
        if (!this.printedClassNotPreparedWarning) {
            Assert.println((String)("Unexpected: some debuggee classes (including " + rt.name() + ") are not prepared. This can cause debugger performance problems."));
            this.printedClassNotPreparedWarning = true;
        }
        return false;
    }

    private DebugJDIClassInfo addClassForReferenceType(ReferenceType rt, boolean checkPrepared) {
        if (checkPrepared && !this.isClassPrepared(rt)) {
            return null;
        }
        if (!this.classesByReferenceType.containsKey(rt)) {
            DebugJDIClassInfo clazz = new DebugJDIClassInfo(this, rt);
            if (!this.debuggableClassLoaded && rt instanceof ClassType && clazz.isDebuggable()) {
                this.debuggableClassLoaded = true;
            }
            this.addClass(clazz);
            return clazz;
        }
        return null;
    }

    private OracleReferenceType getOracleReferenceType(ReferenceType rt) {
        try {
            OracleReferenceType oracleReferenceType = OracleExtension.convert((ReferenceType)rt).sourcePrimaryReferenceType();
            return oracleReferenceType;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        plsqlJavaClasses = new HashSet();
        plsqlJavaClasses.add("java.lang.Class");
        plsqlJavaClasses.add("java.lang.ClassLoader");
        plsqlJavaClasses.add("java.lang.Exception");
        plsqlJavaClasses.add("java.lang.Object");
        plsqlJavaClasses.add("java.lang.String");
        plsqlJavaClasses.add("java.lang.Thread");
        plsqlJavaClasses.add("java.lang.ThreadGroup");
        plsqlJavaClasses.add("java.lang.Throwable");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addClass(DebugJDIClassInfo clazz) {
        OracleReferenceType ort;
        if ((this.languages & 1) == 0 && clazz.name.startsWith("java.") && !plsqlJavaClasses.contains(clazz.name)) {
            this.languages |= 1;
        }
        if ((this.languages & 2) == 0 && (clazz.name.startsWith("$Oracle.Package.") || clazz.name.startsWith("$Oracle.PackageBody.") || clazz.name.startsWith("$Oracle.Function.") || clazz.name.startsWith("$Oracle.Procedure.") || clazz.name.startsWith("$Oracle.Type.") || clazz.name.startsWith("$Oracle.TypeBody.") || clazz.name.startsWith("$Oracle.Trigger.") || clazz.name.startsWith("$Oracle.Block."))) {
            this.languages |= 2;
        }
        if ((this.languages & 4) == 0 && clazz.name.startsWith(XSLTRunnerAddin.getXSLTPackage() + ".")) {
            this.languages |= 4;
        }
        java.util.List<DebugJDIClassInfo> list = this.classes;
        synchronized (list) {
            this.classes.add(clazz);
        }
        ReferenceType rt = clazz.getReferenceType();
        if (rt != null) {
            this.classesByReferenceType.put(rt, clazz);
        }
        DebugShared.putClass(this.classesByName, clazz.name, clazz);
        DebugShared.putClass(this.classesByNameWithoutPackage, clazz.getNameWithoutPackage(), clazz);
        if (clazz.name.startsWith("$Oracle.Block.") && (ort = this.getOracleReferenceType(rt)) != null) {
            DebugJDI.makeAnonymousBlockManager();
            if (anonymousBlockManager != null) {
                anonymousBlockManager.add(clazz, ort);
            }
        }
        if (rt instanceof ClassType) {
            this.verifyBreakpoints(rt);
        }
    }

    private synchronized void removeClass(DebugJDIClassInfo clazz) {
        clazz.rtCollected = true;
        this.classes.remove(clazz);
        this.classesByReferenceType.remove(clazz.getReferenceType());
        DebugShared.removeClass(this.classesByName, clazz.name, clazz);
        DebugShared.removeClass(this.classesByNameWithoutPackage, clazz.getNameWithoutPackage(), clazz);
        if (anonymousBlockManager != null) {
            anonymousBlockManager.remove(clazz);
        }
    }

    @Override
    public boolean wasRunning() {
        return this.vmWasRunning;
    }

    @Override
    public synchronized void disconnect() {
        this.disconnect(this.vmWasRunning ^ true);
    }

    @Override
    public synchronized void disconnect(boolean terminate) {
        if (this.vm != null && !this.getSyncValue(2)) {
            this.setSyncValue(4, terminate);
            this.setSyncValue(3, true);
            try {
                if (terminate) {
                    this.pins.clear();
                    this.vm.exit(0);
                } else {
                    this.unpinAll();
                }
                this.vm.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.incrementStoppedCount(false);
            if (!this.isRunning()) {
                this.vm = null;
                this.cleanUp();
            }
        }
    }

    @Override
    public boolean isConnected() {
        return this.vm != null;
    }

    @Override
    public boolean isStopped() {
        return this.getSyncValue(0);
    }

    @Override
    public boolean isRunning() {
        return this.runningThread != null;
    }

    @Override
    public boolean isTerminated() {
        return this.getSyncValue(2);
    }

    public boolean isRIM() {
        return this.vm.name().equals("RIM JVM");
    }

    private void parsePackages(String s, java.util.List v) {
        v.clear();
        while (s != null) {
            String a;
            int semi = s.indexOf(59);
            if (semi == -1) {
                a = s;
                s = null;
            } else {
                a = s.substring(0, semi);
                s = s.substring(semi + 1);
            }
            if (a.length() <= 0) continue;
            v.add(a);
        }
    }

    @Override
    public synchronized void setNonDebuggablePackages(String nonDebuggablePackages) {
        this.setDebuggablePackages(null, nonDebuggablePackages);
    }

    @Override
    public synchronized void setDebuggablePackages(String debuggablePackages, String nonDebuggablePackages) {
        this.parsePackages(debuggablePackages, this.debuggable);
        this.parsePackages(nonDebuggablePackages, this.nonDebuggable);
        this.nonDebuggableClassExclusionFilters.clear();
        this.debuggableClassLoaded = false;
        for (DebugJDIClassInfo clazz : this.classes) {
            try {
                clazz.checkDebuggable();
                if (this.debuggableClassLoaded || !(clazz.type instanceof ClassType) || !clazz.isDebuggable()) continue;
                this.debuggableClassLoaded = true;
            }
            catch (ObjectCollectedException e) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void requestCodeCoverage(String pkg, String filename) {
    }

    @Override
    public void unrequestCodeCoverage(String pkg, String filename) {
    }

    @Override
    public void discardCodeCoverage() {
    }

    @Override
    public synchronized DebugBreakpointPackageFileLine putBreakpointPackageFileLine(String pkg, String filename, int line) {
        DebugJDIBreakpointPackageFileLine bp = new DebugJDIBreakpointPackageFileLine(this, pkg, filename, line);
        this.putBreakpoint(bp);
        return bp;
    }

    @Override
    public synchronized DebugBreakpointFileLine putBreakpointFileLine(String filename, int line) {
        DebugJDIBreakpointFileLine bp = new DebugJDIBreakpointFileLine(this, filename, line);
        this.putBreakpoint(bp);
        return bp;
    }

    @Override
    public synchronized DebugBreakpointMethodBytecode putBreakpointMethodBytecode(String method, int bytecodeOffset) {
        DebugJDIBreakpointMethodBytecode bp = new DebugJDIBreakpointMethodBytecode(this, method, bytecodeOffset);
        this.putBreakpoint(bp);
        return bp;
    }

    @Override
    public synchronized DebugBreakpointMethod putBreakpointMethod(String method) {
        DebugJDIBreakpointMethod bp = new DebugJDIBreakpointMethod(this, method);
        this.putBreakpoint(bp);
        return bp;
    }

    @Override
    public synchronized DebugBreakpointClass putBreakpointClass(String className) {
        DebugJDIBreakpointClass bp = new DebugJDIBreakpointClass(this, className);
        this.putBreakpoint(bp);
        return bp;
    }

    @Override
    public synchronized DebugBreakpointException putBreakpointException(String exception) {
        return this.putBreakpointException(exception, true, true);
    }

    @Override
    public synchronized DebugBreakpointException putBreakpointException(String exception, boolean caught, boolean uncaught) {
        DebugJDIBreakpointException bp = new DebugJDIBreakpointException(this, exception, caught, uncaught);
        this.putBreakpoint(bp);
        return bp;
    }

    @Override
    public synchronized DebugBreakpointClassLoad putBreakpointClassLoad(String className) {
        DebugJDIBreakpointClassLoad bp = new DebugJDIBreakpointClassLoad(this, className);
        this.putBreakpoint(bp);
        return bp;
    }

    @Override
    public synchronized DebugBreakpointAllocationThreshold putBreakpointAllocationThreshold(int threshold) {
        return null;
    }

    @Override
    public synchronized DebugBreakpointAllocationClass putBreakpointAllocationClass(String clazz) {
        return null;
    }

    @Override
    public synchronized DebugBreakpointDeadlock putBreakpointDeadlock() {
        if (this.canPutBreakpointDeadlock()) {
            DebugJDIBreakpointDeadlock bp = new DebugJDIBreakpointDeadlock(this);
            this.putBreakpoint(bp);
            return bp;
        }
        return null;
    }

    @Override
    public synchronized DebugBreakpointWatchpoint putBreakpointWatchpoint(String className, String fieldName, boolean access, boolean modify) {
        if (access ? (modify ? !this.vm.canWatchFieldAccess() && !this.vm.canWatchFieldModification() : !this.vm.canWatchFieldAccess()) : modify && !this.vm.canWatchFieldModification()) {
            return null;
        }
        DebugJDIBreakpointWatchpoint bp = new DebugJDIBreakpointWatchpoint(this, className, fieldName, access, modify);
        this.putBreakpoint(bp);
        return bp;
    }

    @Override
    public synchronized void removeAllBreakpoints() {
        int i = this.breakpoints.size() - 1;
        while (i >= 0) {
            DebugJDIBreakpoint bp = (DebugJDIBreakpoint)this.breakpoints.get(i);
            bp.prepareForChange();
            --i;
        }
        this.breakpoints.clear();
    }

    @Override
    public synchronized void resume() {
        this.doRunCommand(2, null);
    }

    @Override
    public synchronized boolean didStepFinish() {
        return this.startCPR == null && this.startTSR == null && this.stepRequest == null && this.methodExitRequestForStepToEndOfMethod == null && this.methodEntryRequestStepIntoMethod == null;
    }

    @Override
    public synchronized void continueStep() {
        this.doRunCommand(9, null);
    }

    @Override
    public synchronized void start(boolean stepOverClassInit) {
        int command = stepOverClassInit ? 1 : 0;
        this.doRunCommand(command, null);
    }

    @Override
    public synchronized void setPauseInterval(int i) {
    }

    @Override
    public synchronized void pauseProgram() {
        this.setSyncValue(1, true);
        if (this.runningThread != null) {
            this.runningThread.interrupt();
        }
    }

    @Override
    public void cancelPauseProgram() {
        this.setSyncValue(1, false);
    }

    @Override
    public synchronized int getCurrentStatus() {
        if (this.isStopped()) {
            DebugBreakpoint currentBP = this.getCurrentBreakpoint();
            if (currentBP != null) {
                if (currentBP instanceof DebugBreakpointPackageFileLine || currentBP instanceof DebugBreakpointFileLine || currentBP instanceof DebugBreakpointMethodBytecode || currentBP instanceof DebugBreakpointMethod || currentBP instanceof DebugBreakpointClass) {
                    return 1;
                }
                if (currentBP instanceof DebugBreakpointException) {
                    return 2;
                }
                if (currentBP instanceof DebugBreakpointClassLoad) {
                    return 3;
                }
                if (currentBP instanceof DebugBreakpointAllocationClass || currentBP instanceof DebugBreakpointAllocationThreshold) {
                    return 4;
                }
                if (currentBP instanceof DebugBreakpointDeadlock) {
                    return 5;
                }
                if (currentBP instanceof DebugBreakpointWatchpoint) {
                    return 10;
                }
            } else {
                if (this.getCurrentThread() == null) {
                    return 8;
                }
                if (this.getCurrentThrow() != null && this.getCurrentThrowHandler() == null) {
                    return 6;
                }
                return 7;
            }
        }
        return 0;
    }

    @Override
    public synchronized DebugBreakpoint getCurrentBreakpoint() {
        return this.currentBreakpoint;
    }

    @Override
    public synchronized DebugThreadInfo getCurrentThread() {
        return this.currentThread;
    }

    @Override
    public synchronized DebugDataObjectInfo getCurrentThrow() {
        return this.currentThrow;
    }

    @Override
    public synchronized boolean isCurrentThrowHandled() {
        return this.currentThrowHandler != null;
    }

    @Override
    public synchronized DebugLocation getCurrentThrowHandler() {
        return this.currentThrowHandler;
    }

    @Override
    public DebugDataObjectInfo getWatchpointObject() {
        return this.watchpointObject;
    }

    @Override
    public DebugFieldInfo getWatchpointField() {
        return this.watchpointField;
    }

    @Override
    public DebugDataInfo getWatchpointFieldFutureValue() {
        return this.watchpointFieldFutureValue;
    }

    @Override
    public synchronized DebugThreadInfo[][] getDeadlockedThreads() {
        if (this.canGetMonitors()) {
            return DebugShared.getDeadlockedThreads(this);
        }
        return new DebugThreadInfo[0][];
    }

    @Override
    public synchronized DebugThreadGroupInfo[] listTopThreadGroups() {
        ArrayList<DebugJDIThreadGroupInfo> v = new ArrayList<DebugJDIThreadGroupInfo>();
        Iterator<ThreadGroupReference> it = this.vm.topLevelThreadGroups().iterator();
        while (it.hasNext()) {
            v.add(new DebugJDIThreadGroupInfo(this, it.next()));
        }
        return v.toArray(new DebugThreadGroupInfo[v.size()]);
    }

    @Override
    public synchronized DebugThreadGroupInfo[] listAllThreadGroups() {
        HashSet v = new HashSet();
        this.recursiveAddThreadGroups(v, this.vm.topLevelThreadGroups().iterator());
        return v.toArray(new DebugThreadGroupInfo[v.size()]);
    }

    private void recursiveAddThreadGroups(Set v, Iterator itGroups) {
        while (itGroups.hasNext()) {
            ThreadGroupReference tgr = (ThreadGroupReference)itGroups.next();
            DebugJDIThreadGroupInfo group = new DebugJDIThreadGroupInfo(this, tgr);
            if (!v.add(group)) continue;
            this.recursiveAddThreadGroups(v, tgr.threadGroups().iterator());
        }
    }

    @Override
    public synchronized DebugThreadInfo[] listThreads() {
        java.util.List threads = this.allThreads();
        int size = threads.size();
        DebugThreadInfo[] a = new DebugThreadInfo[size];
        int i = 0;
        while (i < size) {
            a[i] = DebugJDIThreadInfo.makeThreadInfo(this, (ThreadReference)threads.get(i));
            ++i;
        }
        return a;
    }

    private java.util.List allThreads() {
        ArrayList list = new ArrayList();
        Iterator<ThreadGroupReference> it = this.vm.topLevelThreadGroups().iterator();
        while (it.hasNext()) {
            DebugJDI.recursiveAddThreads(it.next(), list);
        }
        return list;
    }

    private static void recursiveAddThreads(ThreadGroupReference tgr, java.util.List list) {
        if (tgr.isCollected()) {
            return;
        }
        try {
            list.addAll(tgr.threads());
            java.util.List<ThreadGroupReference> groups = tgr.threadGroups();
            int groupsSize = groups.size();
            int i = 0;
            while (i < groupsSize) {
                DebugJDI.recursiveAddThreads(groups.get(i), list);
                ++i;
            }
        }
        catch (ObjectCollectedException collected) {
            // empty catch block
        }
    }

    ObjectReference getWaitMonitor(ThreadReference tr) {
        try {
            if (tr.status() == 4) {
                ObjectReference or = tr.currentContendedMonitor();
                if (or == null) {
                    int count = tr.frameCount();
                    int i = 0;
                    while (i < count && i < 2) {
                        Method method;
                        ReferenceType rt;
                        Location location;
                        StackFrame sf = tr.frame(i);
                        if (sf != null && (location = sf.location()) != null && (rt = location.declaringType()) != null && rt.name().equals("java.lang.Object") && (method = location.method()) != null && method.name().equals("wait") && (or = sf.thisObject()) != null) {
                            ArrayList<ThreadReference> list = (ArrayList<ThreadReference>)this.otherWaitingThreads.get(or);
                            if (list == null) {
                                list = new ArrayList<ThreadReference>();
                                this.otherWaitingThreads.put(or, list);
                            }
                            list.add(tr);
                            break;
                        }
                        ++i;
                    }
                }
                ObjectReference objectReference = or;
                return objectReference;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    java.util.List getOtherWaitingThreads(ObjectReference or) {
        return (java.util.List)this.otherWaitingThreads.get(or);
    }

    @Override
    public synchronized DebugMonitorInfo[] listMonitorsInUse() {
        if (this.canGetMonitors()) {
            HashSet<ObjectReference> v = new HashSet<ObjectReference>();
            java.util.List threads = this.allThreads();
            int threadsSize = threads.size();
            int i = 0;
            while (i < threadsSize) {
                ThreadReference tr = (ThreadReference)threads.get(i);
                try {
                    switch (tr.status()) {
                        case 3: {
                            ObjectReference or = tr.currentContendedMonitor();
                            if (or == null) break;
                            v.add(or);
                            break;
                        }
                        case 4: {
                            ObjectReference or = this.getWaitMonitor(tr);
                            if (or == null) break;
                            v.add(or);
                            break;
                        }
                    }
                    java.util.List<ObjectReference> ownedMonitors = tr.ownedMonitors();
                    int jsize = ownedMonitors.size();
                    int j = 0;
                    while (j < jsize) {
                        ObjectReference or = ownedMonitors.get(j);
                        if (or != null) {
                            v.add(or);
                        }
                        ++j;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                ++i;
            }
            int size = v.size();
            ObjectReference[] orArray = v.toArray(new ObjectReference[size]);
            DebugMonitorInfo[] monitorArray = new DebugMonitorInfo[size];
            int i2 = 0;
            while (i2 < size) {
                monitorArray[i2] = new DebugJDIMonitorInfo(this, orArray[i2]);
                ++i2;
            }
            return monitorArray;
        }
        return new DebugMonitorInfo[0];
    }

    @Override
    public synchronized DebugThreadInfo[] listWaitingThreads() {
        if (this.canGetMonitors()) {
            java.util.List threads = this.allThreads();
            ArrayList<DebugJDIThreadInfo> v = new ArrayList<DebugJDIThreadInfo>();
            int size = threads.size();
            int i = 0;
            while (i < size) {
                ThreadReference tr = (ThreadReference)threads.get(i);
                try {
                    if (tr.status() == 4) {
                        v.add(DebugJDIThreadInfo.makeThreadInfo(this, tr));
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                ++i;
            }
            DebugThreadInfo[] array = new DebugThreadInfo[v.size()];
            return v.toArray(array);
        }
        return new DebugThreadInfo[0];
    }

    @Override
    public synchronized DebugThreadInfo[] listBlockedThreads() {
        if (this.canGetMonitors()) {
            java.util.List threads = this.allThreads();
            ArrayList<DebugJDIThreadInfo> v = new ArrayList<DebugJDIThreadInfo>();
            int size = threads.size();
            int i = 0;
            while (i < size) {
                ThreadReference tr = (ThreadReference)threads.get(i);
                try {
                    if (tr.status() == 3) {
                        v.add(DebugJDIThreadInfo.makeThreadInfo(this, tr));
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                ++i;
            }
            DebugThreadInfo[] array = new DebugThreadInfo[v.size()];
            return v.toArray(array);
        }
        return new DebugThreadInfo[0];
    }

    private void lookForMissedClasses() {
        if (this.prepareRequest != null) {
            return;
        }
        boolean started = this.startTestConnectionThread("lookForMissedClasses");
        try {
            for (ReferenceType rt : this.vm.allClasses()) {
                if (this.classesByReferenceType.containsKey(rt) || this.classesCollected != null && this.classesCollected.contains(rt)) continue;
                this.addClassForReferenceType(rt, true);
            }
        }
        catch (VMDisconnectedException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (started) {
            this.killTestConnectionThread();
        }
    }

    private synchronized void lookForUnloadedClassesByName(String className) {
        ArrayList<DebugJDIClassInfo> classesMatchingName = new ArrayList<DebugJDIClassInfo>();
        int i = this.classes.size() - 1;
        while (i >= 0) {
            DebugJDIClassInfo clazz = this.classes.get(i);
            if (className.equals(clazz.name)) {
                this.classesNotCollected.remove(clazz.getReferenceType());
                classesMatchingName.add(clazz);
            }
            --i;
        }
        int i2 = classesMatchingName.size() - 1;
        while (i2 >= 0) {
            DebugJDIClassInfo clazz = (DebugJDIClassInfo)classesMatchingName.get(i2);
            if (this.isClassCollected(clazz.getReferenceType())) {
                this.removeClass(clazz);
            }
            --i2;
        }
        java.util.List<ReferenceType> allClasses = this.vm.allClasses();
        for (ReferenceType rt : allClasses) {
            if (this.classesByReferenceType.containsKey(rt) || this.classesCollected != null && this.classesCollected.contains(rt)) continue;
            this.isClassCollected(rt);
        }
    }

    private synchronized void lookForAnyUnloadedClasses() {
        if (!this.lookForAnyUnloadedClassesNeeded) {
            return;
        }
        if (this.logPage != null) {
            this.logPage.log((Object)DebugJDIArb.getString(5));
        }
        DebugJDIClassInfo[] array = this.classes.toArray(new DebugJDIClassInfo[this.classes.size()]);
        int size = array.length;
        int i = 0;
        while (i < size) {
            DebugJDIClassInfo clazz = array[i];
            if (this.isClassCollected(clazz.getReferenceType())) {
                this.removeClass(clazz);
            }
            ++i;
        }
        if (this.logPage != null) {
            this.logPage.log((Object)DebugJDIArb.getString(0));
        }
        if (this.cur != null) {
            this.lookForAnyUnloadedClassesNeeded = false;
        }
    }

    boolean isClassCollected(ReferenceType rt) {
        if (this.isRIM()) {
            return false;
        }
        if (rt == null) {
            return false;
        }
        if (this.classesCollected != null && this.classesCollected.contains(rt)) {
            return true;
        }
        if (this.classesNotCollected.contains(rt)) {
            return false;
        }
        boolean collected = false;
        try {
            ClassObjectReference co = rt.classObject();
            collected = this.isObjectCollected(co);
        }
        catch (ObjectCollectedException e) {
            collected = true;
        }
        catch (UnsupportedOperationException e) {
        }
        catch (VMDisconnectedException e) {
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (collected) {
            if (this.classesCollected == null) {
                this.classesCollected = new HashSet();
            }
            this.classesCollected.add(rt);
        } else {
            if (this.classesNotCollected == null) {
                this.classesNotCollected = new HashSet();
            }
            this.classesNotCollected.add(rt);
        }
        return collected;
    }

    boolean isObjectCollected(ObjectReference or) {
        if (this.objectsCollected.contains(or)) {
            return true;
        }
        if (this.objectsNotCollected.contains(or)) {
            return false;
        }
        boolean collected = false;
        try {
            collected = or.isCollected();
        }
        catch (ObjectCollectedException e) {
            collected = true;
        }
        catch (UnsupportedOperationException e) {
        }
        catch (VMDisconnectedException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (collected) {
            this.objectsCollected.add(or);
        } else {
            this.objectsNotCollected.add(or);
        }
        return collected;
    }

    @Override
    public synchronized DebugClassInfo[] listClasses() {
        return this.listClasses(false);
    }

    @Override
    public synchronized DebugClassInfo[] listClasses(boolean fast) {
        if (!fast) {
            this.lookForAnyUnloadedClasses();
        }
        this.lookForMissedClasses();
        return this.classes.toArray(new DebugClassInfo[this.classes.size()]);
    }

    @Override
    public synchronized int countClasses() {
        this.lookForAnyUnloadedClasses();
        this.lookForMissedClasses();
        return this.classes.size();
    }

    @Override
    public DebugClassInfo findFirstClassByName(String name) {
        return this.findFirstClassByName(name, false);
    }

    @Override
    public DebugClassInfo findFirstClassByName(String name, boolean nameWithoutPackage) {
        DebugJDIClassInfo clazz;
        while ((clazz = (DebugJDIClassInfo)DebugShared.getFirstClass(nameWithoutPackage ? this.classesByNameWithoutPackage : this.classesByName, name)) != null && this.isClassCollected(clazz.getReferenceType())) {
            this.removeClass(clazz);
        }
        return clazz;
    }

    private synchronized void preprocessClassLoaders() {
        for (DebugJDIClassInfo clazz : this.classes) {
            clazz.getClassLoaderReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DebugClassLoaderInfo[] listClassLoaders() {
        java.util.List<DebugJDIClassInfo> list = this.classes;
        synchronized (list) {
            int i = 0;
            while (i < this.classesByReferenceType.size()) {
                DebugJDIClassInfo clazz = this.classes.get(i);
                clazz.getClassLoader();
                ++i;
            }
        }
        DebugJDIThreadInfo.getThreadContextClassLoaders(this);
        ArrayList expired = new ArrayList();
        ArrayList<DebugJDIClassLoaderInfo> v = new ArrayList<DebugJDIClassLoaderInfo>();
        Map map = this.classLoaderInfos;
        synchronized (map) {
            for (Map.Entry entry : this.classLoaderInfos.entrySet()) {
                Object key = entry.getKey();
                DebugJDIClassLoaderInfo classLoader = (DebugJDIClassLoaderInfo)entry.getValue();
                if (classLoader.hasExpired()) {
                    expired.add(key);
                    continue;
                }
                v.add(classLoader);
            }
            for (Object key : expired) {
                this.classLoaderInfos.remove(key);
            }
        }
        return v.toArray(new DebugClassLoaderInfo[v.size()]);
    }

    @Override
    public synchronized int countHeap(DebugHeapSubset subset) {
        return 0;
    }

    @Override
    public synchronized DebugHeapInfo getHeap(DebugHeapSubset subset) {
        return this.getHeap(subset, 0);
    }

    @Override
    public int getSizeOfAddress() {
        return 0;
    }

    @Override
    public synchronized DebugHeapInfo getHeap(DebugHeapSubset subset, int sort) {
        return null;
    }

    @Override
    public synchronized boolean isHeapAddressValid(long address) {
        return false;
    }

    @Override
    public synchronized DebugHeapObjectInfo getHeapObjectAtAddress(long address) {
        return this.id2ObjectReference.get(new Long(address));
    }

    @Override
    public synchronized void doGarbageCollection() {
    }

    @Override
    public DebugCapabilities getCapabilities() {
        return this;
    }

    @Override
    public boolean canPutBreakpointPackageFileLine() {
        return true;
    }

    @Override
    public boolean canPutBreakpointFileLine() {
        return true;
    }

    @Override
    public boolean canPutBreakpointMethodBytecode() {
        return true;
    }

    @Override
    public boolean canPutBreakpointMethod() {
        return true;
    }

    @Override
    public boolean canPutBreakpointClass() {
        return true;
    }

    @Override
    public boolean canPutBreakpointException() {
        return true;
    }

    @Override
    public boolean canPutBreakpointClassLoad() {
        return true;
    }

    @Override
    public boolean canPutBreakpointAllocationThreshold() {
        return false;
    }

    @Override
    public boolean canPutBreakpointAllocationClass() {
        return false;
    }

    @Override
    public synchronized boolean canPutBreakpointDeadlock() {
        if (this.vm != null) {
            return this.vm.canGetCurrentContendedMonitor() && this.vm.canGetMonitorInfo() && this.vm.canGetOwnedMonitorInfo();
        }
        return false;
    }

    @Override
    public boolean canPutBreakpointWatchpoint() {
        if (this.vm != null) {
            return this.vm.canWatchFieldAccess() || this.vm.canWatchFieldModification();
        }
        return false;
    }

    @Override
    public boolean canSetDebuggablePackages() {
        return true;
    }

    @Override
    public boolean canPauseProgram() {
        return true;
    }

    @Override
    public boolean canRedefineClasses() {
        if (this.vm != null) {
            return this.vm.canRedefineClasses();
        }
        return false;
    }

    @Override
    public boolean canCountObjectsOfClass() {
        return false;
    }

    @Override
    public boolean canCountMemoryOfClass() {
        return false;
    }

    @Override
    public boolean canSetDebuggableClass() {
        return true;
    }

    @Override
    public boolean canGetHeap() {
        return false;
    }

    @Override
    public boolean canDoGarbageCollection() {
        return false;
    }

    @Override
    public boolean canDoCodeCoverage() {
        return false;
    }

    @Override
    public synchronized boolean canDisassembleMethod() {
        if (this.vm != null) {
            return this.vm.canGetBytecodes();
        }
        return false;
    }

    @Override
    public synchronized boolean canGetBytecodes() {
        if (this.vm != null) {
            return this.vm.canGetBytecodes();
        }
        return false;
    }

    @Override
    public boolean canInvokeMethod() {
        return true;
    }

    @Override
    public synchronized boolean canGetMonitors() {
        if (this.vm != null) {
            return this.vm.canGetCurrentContendedMonitor() && this.vm.canGetMonitorInfo() && this.vm.canGetOwnedMonitorInfo();
        }
        return false;
    }

    @Override
    public boolean canGetMonitorEntryLocation() {
        return false;
    }

    @Override
    public boolean canListSlots() {
        return false;
    }

    @Override
    public boolean canPopFrames() {
        if (this.vm != null) {
            return this.vm.canPopFrames();
        }
        return false;
    }

    @Override
    public boolean canSuspendThread() {
        return true;
    }

    @Override
    public boolean canResumeThread() {
        return true;
    }

    @Override
    public boolean canInterruptThread() {
        return true;
    }

    @Override
    public boolean canDebuggerStopThread() {
        return true;
    }

    @Override
    public boolean canListRegisters() {
        return false;
    }

    @Override
    public boolean canListFloatRegisters() {
        return false;
    }

    @Override
    public synchronized boolean canStepToEndOfMethod() {
        return this.useMethodExitRequest;
    }

    @Override
    public boolean canStepIntoMethod() {
        return true;
    }

    @Override
    public boolean canContinueStep() {
        return true;
    }

    @Override
    public boolean canGetReturnValue() {
        return this.methodExitEventHasReturnValue;
    }

    @Override
    public boolean canGetReturnedValue() {
        return this.methodExitEventHasReturnValue;
    }

    @Override
    public boolean canSetLocation() {
        return false;
    }

    @Override
    public boolean canPin() {
        return true;
    }

    @Override
    public boolean canGetAddresses() {
        return false;
    }

    @Override
    public boolean canGetUniqueIDs() {
        return true;
    }

    synchronized void throwIfRunning() {
        if (this.runningThread != null) {
            throw new IllegalStateException("Program Is Running");
        }
    }

    synchronized DebugJDIClassInfo findClass(ReferenceType rt) {
        if (rt == null) {
            return null;
        }
        if (this.isClassCollected(rt)) {
            return null;
        }
        DebugJDIClassInfo clazz = (DebugJDIClassInfo)this.classesByReferenceType.get(rt);
        if (clazz != null) {
            return clazz;
        }
        for (ReferenceType rtFromList : this.vm.allClasses()) {
            if (!rtFromList.equals(rt)) continue;
            clazz = this.addClassForReferenceType(rtFromList, true);
            return clazz;
        }
        return null;
    }

    synchronized DebugJDIClassInfo findClassByType(Type t) {
        if (t instanceof ReferenceType) {
            return this.findClass((ReferenceType)t);
        }
        for (DebugJDIClassInfo clazz : this.classes) {
            if (clazz.type == null || !clazz.type.equals(t)) continue;
            return clazz;
        }
        return null;
    }

    synchronized DebugJDIClassInfo findClassByName(String name, boolean makeIt) {
        DebugJDIClassInfo c = (DebugJDIClassInfo)DebugShared.getFirstClass(this.classesByName, name);
        if (c == null && makeIt) {
            c = new DebugJDIClassInfo(name);
        }
        return c;
    }

    synchronized DebugJDIDataInfo makeNullData(DebugJDIClassInfo clazz, Object owner) {
        if (clazz.isArray()) {
            return new DebugJDIDataArrayInfo(this, clazz, null, owner);
        }
        return new DebugJDIDataObjectInfo(this, clazz, null, owner);
    }

    synchronized DebugJDIDataInfo makeData(Value v, Object owner) {
        DebugJDIClassInfo clazz = this.findClassByType(v.type());
        if (v instanceof PrimitiveValue) {
            return new DebugJDIDataPrimitiveInfo(this, clazz, v, owner);
        }
        if (v instanceof ArrayReference) {
            return new DebugJDIDataArrayInfo(this, clazz, v, owner);
        }
        if (v instanceof ObjectReference) {
            return new DebugJDIDataObjectInfo(this, clazz, v, owner);
        }
        return null;
    }

    Value makeValue(Object newValue) {
        if (newValue == null) {
            return null;
        }
        if (newValue instanceof DebugJDIDataInfo) {
            return ((DebugJDIDataInfo)newValue).value;
        }
        if (newValue instanceof Boolean) {
            return this.vm.mirrorOf((Boolean)newValue);
        }
        if (newValue instanceof Byte) {
            return this.vm.mirrorOf((Byte)newValue);
        }
        if (newValue instanceof Character) {
            return this.vm.mirrorOf(((Character)newValue).charValue());
        }
        if (newValue instanceof Double) {
            return this.vm.mirrorOf((Double)newValue);
        }
        if (newValue instanceof Float) {
            return this.vm.mirrorOf(((Float)newValue).floatValue());
        }
        if (newValue instanceof Integer) {
            return this.vm.mirrorOf((Integer)newValue);
        }
        if (newValue instanceof Long) {
            return this.vm.mirrorOf((Long)newValue);
        }
        if (newValue instanceof Short) {
            return this.vm.mirrorOf((Short)newValue);
        }
        if (newValue instanceof String) {
            return this.vm.mirrorOf((String)newValue);
        }
        throw new IllegalArgumentException("Invalid newValue argument");
    }

    Value makeBooleanValue(String newValue) {
        return this.vm.mirrorOf(DebugSharedPrimitives.booleanDecode(newValue));
    }

    Value makeByteValue(String newValue) {
        return this.vm.mirrorOf(DebugSharedPrimitives.byteDecode(newValue));
    }

    Value makeCharValue(String newValue) {
        return this.vm.mirrorOf(DebugSharedPrimitives.charDecode(newValue));
    }

    Value makeDoubleValue(String newValue) {
        return this.vm.mirrorOf(DebugSharedPrimitives.doubleDecode(newValue));
    }

    Value makeFloatValue(String newValue) {
        return this.vm.mirrorOf(DebugSharedPrimitives.floatDecode(newValue));
    }

    Value makeIntegerValue(String newValue) {
        return this.vm.mirrorOf(DebugSharedPrimitives.intDecode(newValue));
    }

    Value makeLongValue(String newValue) {
        return this.vm.mirrorOf(DebugSharedPrimitives.longDecode(newValue));
    }

    Value makeShortValue(String newValue) {
        return this.vm.mirrorOf(DebugSharedPrimitives.shortDecode(newValue));
    }

    StringReference makeStringValue(String newValue) {
        return this.vm.mirrorOf(newValue);
    }

    java.util.List<Value> makeArgumentsFromStrings(Method m, String[] arguments) {
        ArrayList<Value> argList = null;
        try {
            int length = arguments.length;
            java.util.List<Type> argTypes = m.argumentTypes();
            if (argTypes.size() != length) {
                java.util.List<Value> list = null;
                return list;
            }
            argList = new ArrayList<Value>(length);
            int i = 0;
            while (i < length) {
                Type type = argTypes.get(i);
                Value v = null;
                if (type instanceof BooleanType) {
                    v = this.makeBooleanValue(arguments[i]);
                } else if (type instanceof ByteType) {
                    v = this.makeByteValue(arguments[i]);
                } else if (type instanceof CharType) {
                    v = this.makeCharValue(arguments[i]);
                } else if (type instanceof DoubleType) {
                    v = this.makeDoubleValue(arguments[i]);
                } else if (type instanceof FloatType) {
                    v = this.makeFloatValue(arguments[i]);
                } else if (type instanceof IntegerType) {
                    v = this.makeIntegerValue(arguments[i]);
                } else if (type instanceof LongType) {
                    v = this.makeLongValue(arguments[i]);
                } else if (type instanceof ShortType) {
                    v = this.makeShortValue(arguments[i]);
                } else if (type instanceof ClassType && ((ClassType)type).name().equals("java.lang.String")) {
                    v = this.makeStringValue(arguments[i]);
                }
                if (v == null) {
                    java.util.List<Value> list = null;
                    return list;
                }
                argList.add(v);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return argList;
    }

    synchronized DebugPinnedInfo pinObject(ObjectReference or, DebugPinListener pinListener) {
        DebugJDIPinnedInfo pin = new DebugJDIPinnedInfo(this, or, pinListener);
        this.pins.add(pin);
        return pin;
    }

    synchronized void unpinObject(DebugJDIPinnedInfo pin) {
        if (this.pins != null) {
            this.pins.remove(pin);
        }
    }

    private void unpinAll() {
        int i = this.pins.size() - 1;
        while (i >= 0) {
            DebugJDIPinnedInfo pin = (DebugJDIPinnedInfo)this.pins.get(i);
            this.unpinObject(pin);
            --i;
        }
    }

    private synchronized void checkPinnedObjects() {
        ArrayList<DebugJDIPinnedInfo> discardedList = new ArrayList<DebugJDIPinnedInfo>();
        int i = this.pins.size() - 1;
        while (i >= 0) {
            DebugJDIPinnedInfo pin = (DebugJDIPinnedInfo)this.pins.get(i);
            if (this.isObjectCollected(pin.or)) {
                pin.discarded = true;
                discardedList.add(pin);
            }
            --i;
        }
        int i2 = 0;
        while (i2 < discardedList.size()) {
            DebugJDIPinnedInfo pin = (DebugJDIPinnedInfo)discardedList.get(i2);
            this.pins.remove(pin);
            pin.pinListener.pinnedObjectDiscarded(this, pin);
            ++i2;
        }
    }

    synchronized void putBreakpoint(DebugJDIBreakpoint bp) {
        this.breakpoints.add(bp);
        bp.afterChange();
    }

    private boolean isOracleDatabaseVM() {
        if (this.isOracleDatabaseVM != null) {
            return this.isOracleDatabaseVM;
        }
        if (this.vm != null) {
            if ("Oracle Multilanguage Debugger".equals(this.vm.name())) {
                this.isOracleDatabaseVM = Boolean.TRUE;
                return true;
            }
            this.isOracleDatabaseVM = Boolean.FALSE;
            return false;
        }
        return false;
    }

    private synchronized void removeBPClassPrepareRequest(DebugJDIBreakpoint bp, String filter) {
        ClassPrepareRequest cpr;
        if (filter.startsWith("$Oracle.") && this.isOracleDatabaseVM()) {
            filter = "";
        }
        if ((cpr = (ClassPrepareRequest)this.cprsByFilter.get(filter)) != null) {
            java.util.List bps = (java.util.List)this.cprBreakpoints.get(cpr);
            bps.remove(bp);
            if (bps.isEmpty()) {
                cpr.disable();
                this.erm.deleteEventRequest(cpr);
                this.cprBreakpoints.remove(cpr);
                this.cprsByFilter.remove(filter);
            }
        }
    }

    synchronized void breakpointBeforeChange(DebugJDIBreakpoint bp) {
        String filter;
        if (bp.getEnabled() && (filter = bp.getClassPrepareFilter()) != null) {
            this.removeBPClassPrepareRequest(bp, filter);
            if (filter.equals("java.lang.Exception")) {
                this.removeBPClassPrepareRequest(bp, "$Oracle.Builtin.EXCEPTION");
            }
        }
    }

    synchronized void createBPClassPrepareRequest(DebugJDIBreakpoint bp, String filter) {
        ClassPrepareRequest cpr;
        if (filter.startsWith("$Oracle.") && this.isOracleDatabaseVM()) {
            filter = "";
        }
        if ((cpr = (ClassPrepareRequest)this.cprsByFilter.get(filter)) == null) {
            cpr = this.erm.createClassPrepareRequest();
            cpr.setSuspendPolicy(2);
            if (filter.length() > 0) {
                cpr.addClassFilter(filter);
            }
            cpr.enable();
            this.cprsByFilter.put(filter, cpr);
            this.cprBreakpoints.put(cpr, new ArrayList());
        }
        java.util.List bps = (java.util.List)this.cprBreakpoints.get(cpr);
        bps.add(bp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void breakpointAfterChange(DebugJDIBreakpoint bp) {
        String filter;
        if (bp.getEnabled() && (filter = bp.getClassPrepareFilter()) != null) {
            this.createBPClassPrepareRequest(bp, filter);
            if (filter.equals("java.lang.Exception") && this.isOracleDatabaseVM()) {
                this.createBPClassPrepareRequest(bp, "$Oracle.Builtin.EXCEPTION");
            }
        }
        boolean verified = false;
        java.util.List<DebugJDIClassInfo> list = this.classes;
        synchronized (list) {
            for (DebugJDIClassInfo clazz : this.classes) {
                try {
                    ReferenceType rt = clazz.getReferenceType();
                    if (!(rt instanceof ClassType) || !bp.verify(rt)) continue;
                    verified = true;
                }
                catch (ObjectCollectedException e) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (verified && this.debugListener != null) {
            this.debugListener.breakpointChanged(bp);
        }
    }

    synchronized boolean removeBreakpoint(DebugJDIBreakpoint bp) {
        if (this.breakpoints.indexOf(bp) != -1) {
            this.breakpoints.remove(bp);
            return true;
        }
        return false;
    }

    private void setOptionsForStepRequest(EventRequest er) {
        StepRequest sr = er instanceof StepRequest ? (StepRequest)er : null;
        MethodExitRequest mxr = er instanceof MethodExitRequest ? (MethodExitRequest)er : null;
        MethodEntryRequest mer = er instanceof MethodEntryRequest ? (MethodEntryRequest)er : null;
        int size = this.nonDebuggable.size();
        int i = 0;
        while (i < size) {
            String s = (String)this.nonDebuggable.get(i);
            if (sr != null) {
                sr.addClassExclusionFilter(s);
                sr.addClassExclusionFilter(s + ".*");
            } else if (mxr != null) {
                mxr.addClassExclusionFilter(s);
                mxr.addClassExclusionFilter(s + ".*");
            } else if (mer != null) {
                mer.addClassExclusionFilter(s);
                mer.addClassExclusionFilter(s + ".*");
            }
            ++i;
        }
        for (String s : this.nonDebuggableClassExclusionFilters) {
            if (sr != null) {
                sr.addClassExclusionFilter(s);
                continue;
            }
            if (mxr != null) {
                mxr.addClassExclusionFilter(s);
                continue;
            }
            if (mer == null) continue;
            mer.addClassExclusionFilter(s);
        }
        try {
            er.setSuspendPolicy(2);
            er.enable();
        }
        catch (InternalException e) {
        }
        catch (VMDisconnectedException vmde) {
            // empty catch block
        }
    }

    private void createStartCPR() {
        this.startCPR = this.erm.createClassPrepareRequest();
        int size = this.nonDebuggable.size();
        int i = 0;
        while (i < size) {
            String s = (String)this.nonDebuggable.get(i);
            this.startCPR.addClassExclusionFilter(s);
            this.startCPR.addClassExclusionFilter(s + ".*");
            ++i;
        }
        this.startCPR.setSuspendPolicy(2);
        this.startCPR.enable();
    }

    private void removeStartCPR() {
        if (this.startCPR != null) {
            this.startCPR.disable();
            this.erm.deleteEventRequest(this.startCPR);
            this.startCPR = null;
        }
    }

    private void createStartTSR() {
        this.startTSR = this.erm.createThreadStartRequest();
        this.startTSR.setSuspendPolicy(2);
        this.startTSR.enable();
        this.startStepRequests = new HashMap();
        java.util.List threads = this.allThreads();
        int i = threads.size() - 1;
        while (i >= 0) {
            ThreadReference tr = (ThreadReference)threads.get(i);
            int status = tr.status();
            if (status != 5 && status != 0) {
                try {
                    tr.frameCount();
                    this.createStartStepRequest(tr);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            --i;
        }
    }

    private void removeStartTSR() {
        if (this.startTSR != null) {
            this.startTSR.disable();
            this.erm.deleteEventRequest(this.startTSR);
            this.startTSR = null;
        }
    }

    private void createStartStepRequest(ThreadReference tr) {
        if (!this.startStepRequests.containsKey(tr)) {
            StepRequest sr = this.erm.createStepRequest(tr, -2, 1);
            this.setOptionsForStepRequest(sr);
            this.startStepRequests.put(tr, sr);
        }
    }

    private void removeStartRequest() {
        this.removeStartCPR();
        this.removeStartTSR();
        if (this.startStepRequests != null) {
            Iterator i = this.startStepRequests.values().iterator();
            this.startStepRequests = null;
            while (i.hasNext()) {
                StepRequest sr = (StepRequest)i.next();
                sr.disable();
                this.erm.deleteEventRequest(sr);
            }
        }
    }

    private void removeStepRequest() {
        this.removeStartRequest();
        this.stepLocation = null;
        this.stepStack = null;
        if (this.stepRequest != null) {
            this.stepRequest.disable();
            this.erm.deleteEventRequest(this.stepRequest);
            this.stepRequest = null;
        }
        this.removeMethodExitRequestForStepToEndOfMethod();
        this.removeMethodExitRequestForStepOut();
        this.removeMethodEntryRequestStepIntoMethod();
    }

    private boolean shouldStopAtStepEvent(LocatableEvent le) {
        ReferenceType rt;
        if (this.runCommand == 8 && le instanceof MethodExitEvent && this.stepStack != null && this.methodExitRequestForStepToEndOfMethodMethod != null) {
            try {
                if (this.methodExitRequestForStepToEndOfMethodMethod == le.thread().frame(0).location().method()) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (le instanceof MethodExitEvent) {
            return false;
        }
        if (this.runCommand == 10 && le instanceof MethodEntryEvent) {
            try {
                Location callerLocation;
                MethodEntryEvent mee = (MethodEntryEvent)le;
                Method currentMethod = mee.method();
                boolean foundMethod = false;
                if (currentMethod != null) {
                    if (currentMethod.name().equals(this.stepIntoMethodName)) {
                        foundMethod = true;
                    } else if (currentMethod.isConstructor() && this.stepIntoMethodName != null && this.stepIntoMethodName.startsWith("<init>")) {
                        ReferenceType refType = currentMethod.declaringType();
                        String realStepIntoName = this.stepIntoMethodName.substring(6);
                        boolean bl = foundMethod = refType.name().equals(realStepIntoName) || refType.name().endsWith("." + realStepIntoName);
                    }
                }
                if (foundMethod && le.thread().frameCount() > 1 && (callerLocation = le.thread().frame(1).location()).lineNumber() == this.stepIntoMethodCallerLine) {
                    String sourcePath = callerLocation.sourcePath().replace('\\', '/');
                    boolean bl = this.stepIntoMethodCallerPath.equals(sourcePath);
                    return bl;
                }
                boolean found = false;
                int frameCount = le.thread().frameCount();
                int x = 0;
                while (x < frameCount) {
                    String sourcePath;
                    Location callerLocation2 = le.thread().frame(x).location();
                    if (callerLocation2.lineNumber() == this.stepIntoMethodCallerLine && this.stepIntoMethodCallerPath.equals(sourcePath = callerLocation2.sourcePath().replace('\\', '/'))) {
                        found = true;
                        break;
                    }
                    ++x;
                }
                if (!found) {
                    this.removeStepRequest();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            return false;
        }
        Location location = le.location();
        if (location != null && (rt = location.declaringType()) != null) {
            String className = rt.name();
            if (this.isClassDebuggable(className)) {
                Method method = location.method();
                if (this.runCommand == 1) {
                    if (className.startsWith("$Oracle.Block.")) {
                        return false;
                    }
                    if (method.name().equals("<clinit>")) {
                        return false;
                    }
                }
                if (className.startsWith("$Oracle.Block.") && this.getOracleReferenceType(rt) == null) {
                    return false;
                }
                if (this.runCommand != 5 && this.runCommand != 6 && DebugJDI.getLineNumber(location, rt.defaultStratum()) == -1) {
                    return false;
                }
                if (this.runCommand != 5 && this.runCommand != 6 && this.runCommand != 8 && DebugJDI.sameSourceLocation(location, this.stepLocation) && DebugJDI.sameStack(DebugJDI.getStack(le.thread()), this.stepStack)) {
                    return false;
                }
                if (method.isSynthetic()) {
                    return false;
                }
                return this.runCommand != 4 || DebugJDI.getStack(le.thread()).length <= this.stepStack.length;
            }
            String filter = this.getNonDebuggableClassExclusionFilter(className);
            if (filter != null && this.nonDebuggableClassExclusionFilters.add(filter)) {
                EventRequest er = le.request();
                er.disable();
                if (er instanceof StepRequest) {
                    ((StepRequest)er).addClassExclusionFilter(filter);
                } else if (er instanceof MethodExitRequest) {
                    ((MethodExitRequest)er).addClassExclusionFilter(filter);
                }
                er.enable();
            }
        }
        return false;
    }

    private void makeMethodExitRequestForStepToEndOfMethod(ThreadReference tr) {
        if (this.useMethodExitRequest) {
            this.methodExitRequestForStepToEndOfMethod = this.erm.createMethodExitRequest();
            this.methodExitRequestForStepToEndOfMethod.addThreadFilter(tr);
            try {
                this.methodExitRequestForStepToEndOfMethodMethod = tr.frame(0).location().method();
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                // empty catch block
            }
            this.setOptionsForStepRequest(this.methodExitRequestForStepToEndOfMethod);
        }
    }

    private void disableMethodExitRequestForStepToEndOfMethod() {
        if (this.useMethodExitRequest && this.methodExitRequestForStepToEndOfMethod != null) {
            this.methodExitRequestForStepToEndOfMethod.disable();
        }
    }

    private void enableMethodExitRequestForStepToEndOfMethod() {
        if (this.useMethodExitRequest && this.methodExitRequestForStepToEndOfMethod != null) {
            this.methodExitRequestForStepToEndOfMethod.enable();
        }
    }

    private void removeMethodExitRequestForStepToEndOfMethod() {
        if (this.useMethodExitRequest && this.methodExitRequestForStepToEndOfMethod != null) {
            this.methodExitRequestForStepToEndOfMethod.disable();
            this.erm.deleteEventRequest(this.methodExitRequestForStepToEndOfMethod);
            this.methodExitRequestForStepToEndOfMethod = null;
            this.methodExitRequestForStepToEndOfMethodMethod = null;
        }
    }

    private MethodExitRequest makeMethodExitRequestForTopFrame(ThreadReference tr, int suspendPolicy) {
        MethodExitRequest mer = this.erm.createMethodExitRequest();
        mer.addThreadFilter(tr);
        try {
            ObjectReference thisObject;
            StackFrame sf = tr.frame(0);
            Location location = sf.location();
            if (location != null) {
                mer.addClassFilter(location.declaringType());
            }
            if ((thisObject = sf.thisObject()) != null) {
                mer.addInstanceFilter(thisObject);
            }
            mer.setSuspendPolicy(suspendPolicy);
            mer.enable();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mer;
    }

    private void makeMethodExitRequestForStepOut(ThreadReference tr) {
        if (this.useMethodExitRequest && this.methodExitEventHasReturnValue) {
            this.methodExitRequestForStepOut = this.makeMethodExitRequestForTopFrame(tr, 2);
        }
    }

    private void disableMethodExitRequestForStepOut() {
        if (this.useMethodExitRequest && this.methodExitRequestForStepOut != null) {
            this.methodExitRequestForStepOut.disable();
        }
    }

    private void enableMethodExitRequestForStepOut() {
        if (this.useMethodExitRequest && this.methodExitRequestForStepOut != null) {
            this.methodExitRequestForStepOut.enable();
        }
    }

    private void removeMethodExitRequestForStepOut() {
        if (this.useMethodExitRequest && this.methodExitRequestForStepOut != null) {
            this.methodExitRequestForStepOut.disable();
            this.erm.deleteEventRequest(this.methodExitRequestForStepOut);
            this.methodExitRequestForStepOut = null;
        }
    }

    private void makeMethodEntryRequestStepIntoMethod(ThreadReference tr) {
        MethodEntryRequest mer = this.erm.createMethodEntryRequest();
        mer.addThreadFilter(tr);
        this.setOptionsForStepRequest(mer);
        this.methodEntryRequestStepIntoMethod = mer;
    }

    private void removeMethodEntryRequestStepIntoMethod() {
        if (this.methodEntryRequestStepIntoMethod != null) {
            try {
                this.methodEntryRequestStepIntoMethod.disable();
                this.erm.deleteEventRequest(this.methodEntryRequestStepIntoMethod);
            }
            catch (VMDisconnectedException vMDisconnectedException) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.methodEntryRequestStepIntoMethod = null;
            this.stepIntoMethodName = null;
            this.stepIntoMethodCallerPath = null;
            this.stepIntoMethodCallerPackage = null;
            this.stepIntoMethodCallerFileName = null;
            this.stepIntoMethodCallerLine = 0;
        }
    }

    private synchronized void doRunCommand(int command, DebugJDIThreadInfo thread) {
        this.throwIfRunning();
        this.runCommand = command;
        this.runCommandThread = thread != null ? thread.tr : null;
        this.runningThread = new Thread((Runnable)this, "JPDA Event Processor");
        this.runningThread.start();
    }

    private void resumeAsNeeded() {
        while (!this.needToResume.isEmpty()) {
            Object o = this.needToResume.remove(0);
            if (o instanceof EventSet) {
                ((EventSet)o).resume();
                continue;
            }
            if (!(o instanceof VirtualMachine)) continue;
            ((VirtualMachine)o).resume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.killTestConnectionThread();
        if (this.runCommand != 9) {
            this.removeStepRequest();
        }
        if (this.runCommandThread == null) {
            this.runCommandThread = this.currentThread == null ? null : this.currentThread.tr;
        }
        switch (this.runCommand) {
            case 0: 
            case 1: {
                if (this.debuggableClassLoaded) {
                    this.createStartTSR();
                    break;
                }
                this.createStartCPR();
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.stepLocation = DebugJDI.getLocation(this.runCommandThread);
                this.stepStack = DebugJDI.getStack(this.runCommandThread);
                this.stepRequest = this.erm.createStepRequest(this.runCommandThread, -2, 1);
                this.setOptionsForStepRequest(this.stepRequest);
                break;
            }
            case 4: {
                this.stepLocation = DebugJDI.getLocation(this.runCommandThread);
                this.stepStack = DebugJDI.getStack(this.runCommandThread);
                this.stepRequest = this.erm.createStepRequest(this.runCommandThread, -2, 2);
                this.setOptionsForStepRequest(this.stepRequest);
                break;
            }
            case 5: {
                this.stepLocation = DebugJDI.getLocation(this.runCommandThread);
                this.stepStack = DebugJDI.getStack(this.runCommandThread);
                this.stepRequest = this.erm.createStepRequest(this.runCommandThread, -1, 1);
                this.setOptionsForStepRequest(this.stepRequest);
                break;
            }
            case 6: {
                this.stepLocation = DebugJDI.getLocation(this.runCommandThread);
                this.stepStack = DebugJDI.getStack(this.runCommandThread);
                this.stepRequest = this.erm.createStepRequest(this.runCommandThread, -1, 2);
                this.setOptionsForStepRequest(this.stepRequest);
                break;
            }
            case 7: {
                this.stepLocation = DebugJDI.getLocation(this.runCommandThread);
                this.stepStack = DebugJDI.getStack(this.runCommandThread);
                this.stepRequest = this.erm.createStepRequest(this.runCommandThread, -1, 3);
                this.setOptionsForStepRequest(this.stepRequest);
                this.makeMethodExitRequestForStepOut(this.runCommandThread);
                break;
            }
            case 8: {
                this.stepLocation = DebugJDI.getLocation(this.runCommandThread);
                this.stepStack = DebugJDI.getStack(this.runCommandThread);
                this.stepRequest = this.erm.createStepRequest(this.runCommandThread, -1, 3);
                this.setOptionsForStepRequest(this.stepRequest);
                this.makeMethodExitRequestForStepToEndOfMethod(this.runCommandThread);
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                Location location = DebugJDI.getLocation(this.runCommandThread);
                if (location.lineNumber() != this.stepIntoMethodCallerLine || !DebugJDI.getSourceName(location).equals(this.stepIntoMethodCallerFileName) || !this.stepIntoMethodCallerPath.equals(DebugJDI.getSourcePath(location).replace('\\', '/'))) {
                    this.stepIntoMethodBreakpoint = (DebugJDIBreakpointPackageFileLine)this.putBreakpointPackageFileLine(this.stepIntoMethodCallerPackage, this.stepIntoMethodCallerFileName, this.stepIntoMethodCallerLine);
                    break;
                }
                this.makeMethodEntryRequestStepIntoMethod(this.runCommandThread);
                break;
            }
        }
        this.setSyncValue(0, false);
        this.incrementStoppedCount(false);
        this.currentBreakpoint = null;
        this.currentThread = null;
        this.eventThread = null;
        this.threadReturnValues = null;
        this.id2ObjectReference = new HashMap<Long, DebugJDIHeapObjectInfo>();
        this.currentThrow = null;
        this.currentThrowHandler = null;
        this.watchpointObject = null;
        this.watchpointField = null;
        this.watchpointFieldFutureValue = null;
        if (this.otherWaitingThreads == null) {
            this.otherWaitingThreads = new HashMap();
        }
        this.otherWaitingThreads.clear();
        boolean isDeadlockBreakpointSet = this.isDeadlockBreakpointSet();
        int waitTime = isDeadlockBreakpointSet ? 3000 : -1;
        long timeDeadlockChecked = System.currentTimeMillis();
        this.resumeAsNeeded();
        do {
            try {
                EventSet es = null;
                java.util.List list = this.unhandledEventSets;
                synchronized (list) {
                    if (!this.unhandledEventSets.isEmpty()) {
                        es = (EventSet)this.unhandledEventSets.remove(0);
                        ThreadReference tr = (ThreadReference)this.unhandledEventThreads.remove(0);
                        this.vm.suspend();
                        this.needToResume.add(this.vm);
                        tr.resume();
                    }
                }
                if (es == null) {
                    try {
                        es = waitTime != -1 ? this.eq.remove(waitTime) : this.eq.remove();
                        if (es != null) {
                            this.needToResume.add(es);
                        }
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
                if (es != null) {
                    EventIterator ei = es.eventIterator();
                    while (ei.hasNext()) {
                        Event e = ei.nextEvent();
                        EventRequest er = e.request();
                        if (er != null && er == this.startTSR) {
                            ThreadStartEvent tse = (ThreadStartEvent)e;
                            ThreadReference tr = tse.thread();
                            this.createStartStepRequest(tr);
                            continue;
                        }
                        if (er != null && er == this.returnValuesRequest) {
                            this.registerReturnValue((MethodExitEvent)e);
                            continue;
                        }
                        if (e instanceof ClassPrepareEvent) {
                            ClassPrepareEvent cpe = (ClassPrepareEvent)e;
                            ReferenceType rt = cpe.referenceType();
                            if (cpe.request() == this.prepareRequest) {
                                if (this.classesByReferenceType.containsKey(rt) || this.classesCollected != null && this.classesCollected.contains(rt)) continue;
                                this.addClassForReferenceType(rt, true);
                                continue;
                            }
                            this.classesNotCollected.add(rt);
                            if (this.addClassForReferenceType(rt, false) != null && this.checkForBreakpointHit(e, cpe.thread())) {
                                this.setSyncValue(0, true);
                            }
                            if (er == null || er != this.startCPR || !this.debuggableClassLoaded) continue;
                            this.removeStartCPR();
                            this.createStartTSR();
                            continue;
                        }
                        if (e instanceof BreakpointEvent || e instanceof ExceptionEvent || e instanceof WatchpointEvent) {
                            ThreadReference threadReference = ((LocatableEvent)e).thread();
                            if (this.stepIntoMethodBreakpoint != null && this.stepIntoMethodBreakpoint.isThisYourEvent(e, threadReference)) {
                                this.stepIntoMethodBreakpoint.remove();
                                this.stepIntoMethodBreakpoint = null;
                                this.makeMethodEntryRequestStepIntoMethod(threadReference);
                                continue;
                            }
                            if (!this.checkForBreakpointHit(e, threadReference)) continue;
                            this.setSyncValue(0, true);
                            continue;
                        }
                        if (e instanceof StepEvent) {
                            StepEvent se = (StepEvent)e;
                            if (!this.shouldStopAtStepEvent(se)) continue;
                            this.removeStepRequest();
                            this.setSyncValue(0, true);
                            ThreadReference tr = se.thread();
                            this.currentThread = DebugJDIThreadInfo.makeThreadInfo(this, tr);
                            this.eventThread = tr;
                            continue;
                        }
                        if (e instanceof MethodExitEvent) {
                            MethodExitEvent mee = (MethodExitEvent)e;
                            if (!this.shouldStopAtStepEvent(mee)) continue;
                            this.removeStepRequest();
                            this.setSyncValue(0, true);
                            ThreadReference tr = mee.thread();
                            this.currentThread = DebugJDIThreadInfo.makeThreadInfo(this, tr);
                            this.eventThread = tr;
                            continue;
                        }
                        if (e instanceof MethodEntryEvent) {
                            MethodEntryEvent mee = (MethodEntryEvent)e;
                            if (!this.shouldStopAtStepEvent(mee)) continue;
                            this.removeStepRequest();
                            this.setSyncValue(0, true);
                            ThreadReference tr = mee.thread();
                            this.currentThread = DebugJDIThreadInfo.makeThreadInfo(this, tr);
                            this.eventThread = tr;
                            continue;
                        }
                        if (e instanceof ClassUnloadEvent) {
                            this.lookForUnloadedClassesByName(((ClassUnloadEvent)e).className());
                            continue;
                        }
                        if (e instanceof VMDeathEvent) {
                            this.setSyncValue(2, true);
                            this.vm = null;
                            continue;
                        }
                        if (!(e instanceof VMDisconnectEvent)) continue;
                        this.vm = null;
                    }
                    if (!this.getSyncValue(0)) {
                        this.resumeAsNeeded();
                    }
                }
                if (this.vm == null || this.getSyncValue(2) || this.getSyncValue(0)) continue;
                if (this.checkForPause()) {
                    this.needToResume.add(this.vm);
                    this.setSyncValue(0, true);
                    continue;
                }
                if (!isDeadlockBreakpointSet || System.currentTimeMillis() - timeDeadlockChecked < 3000L) continue;
                if (this.checkForDeadlock()) {
                    this.needToResume.add(this.vm);
                    this.setSyncValue(0, true);
                    continue;
                }
                timeDeadlockChecked = System.currentTimeMillis();
            }
            catch (VMDisconnectedException e) {
                this.vm = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } while (this.vm != null && !this.getSyncValue(2) && !this.getSyncValue(0));
        this.runningThread = null;
        this.incrementStoppedCount(true);
        if (this.getSyncValue(2)) {
            if (this.debugListener != null) {
                this.debugListener.programTerminated();
            }
            this.cleanUp();
        } else if (this.getSyncValue(0)) {
            if (this.stepIntoMethodBreakpoint != null) {
                this.stepIntoMethodBreakpoint.remove();
                this.stepIntoMethodBreakpoint = null;
            }
            this.programStopped();
        } else if (this.getSyncValue(3)) {
            if (this.getSyncValue(4) && this.debugListener != null) {
                this.debugListener.programTerminated();
            }
            this.cleanUp();
        } else {
            this.setSyncValue(6, true);
            this.connectionLost();
        }
    }

    private void programStopped() {
        this.startTestConnectionThread("programStopped");
        this.checkPinnedObjects();
        this.lookForMissedClasses();
        if (this.debugListener != null) {
            this.debugListener.programStopped();
        }
    }

    private boolean isAtEndOfAMethodThatReturnsSomething(ThreadReference tr) {
        try {
            StackFrame sf = tr.frame(0);
            Location location = sf.location();
            Method m = location.method();
            if (!(m.returnType() instanceof VoidType) || m.isConstructor()) {
                short opcode;
                long bc = location.codeIndex();
                byte[] bytecodes = m.bytecodes();
                if (bc >= 0L && bc < (long)bytecodes.length && DebugSharedDisassemble.isReturnBytecode(opcode = (short)(bytecodes[(int)bc] & 0xFF))) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }

    private void connectionLost() {
        if (this.debugListener != null) {
            this.debugListener.connectionLost();
        }
        this.cleanUp();
    }

    private boolean startTestConnectionThread(String name) {
        if (this.testConnectionThread != null) {
            return false;
        }
        String threadName = "JPDA Test Connection Thread (" + name + ")";
        this.testConnectionThread = new 1(this, threadName, threadName);
        this.testConnectionThread.start();
        return true;
    }

    private void killTestConnectionThread() {
        this.killThreadAndWait(this.testConnectionThread);
        this.testConnectionThread = null;
    }

    private void killThreadAndWait(Thread t) {
        if (t != null) {
            while (t.isAlive()) {
                t.interrupt();
                try {
                    t.join(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void safeSuspendVM() {
        for (ThreadReference tr : this.allThreads()) {
            try {
                tr.status();
            }
            catch (Exception e) {
                Assert.println((String)("tr.status() threw " + e));
            }
        }
        this.vm.suspend();
    }

    private boolean checkForPause() {
        if (this.setSyncValue(1, false)) {
            this.safeSuspendVM();
            return true;
        }
        return false;
    }

    private synchronized boolean isDeadlockBreakpointSet() {
        int size = this.breakpoints.size();
        int i = 0;
        while (i < size) {
            Object o = this.breakpoints.get(i);
            if (o instanceof DebugJDIBreakpointDeadlock) {
                DebugJDIBreakpointDeadlock bp = (DebugJDIBreakpointDeadlock)o;
                if (bp.enabled && (bp.stop || bp.log || bp.enableOtherBPs != null || bp.disableOtherBPs != null)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkForDeadlock() {
        this.safeSuspendVM();
        if (this.areThreadsDeadlocked()) {
            ThreadReference tr = (ThreadReference)this.knownDeadlockedThreads.get(this.knownDeadlockedThreads.size() - 1);
            this.currentThread = DebugJDIThreadInfo.makeThreadInfo(this, tr);
            DebugJDIBreakpointDeadlock stop = null;
            DebugJDI debugJDI = this;
            synchronized (debugJDI) {
                int size = this.breakpoints.size();
                int i = 0;
                while (i < size) {
                    DebugJDIBreakpointDeadlock bp;
                    Object o = this.breakpoints.get(i);
                    if (o instanceof DebugJDIBreakpointDeadlock && this.doBreakpointActions(bp = (DebugJDIBreakpointDeadlock)o, null, tr)) {
                        stop = bp;
                    }
                    ++i;
                }
            }
            if (stop != null) {
                this.eventThread = null;
                this.currentBreakpoint = stop;
                return true;
            }
            this.currentThread = null;
        }
        this.vm.resume();
        return false;
    }

    private boolean areThreadsDeadlocked() {
        try {
            ArrayList threads = new ArrayList(this.allThreads());
            threads.removeAll(this.knownDeadlockedThreads);
            ArrayList<ThreadReference> possibleDeadlockedThreads = new ArrayList<ThreadReference>();
            while (threads.size() > 0) {
                ThreadReference tr1 = (ThreadReference)threads.remove(0);
                if (tr1.status() == 3) {
                    possibleDeadlockedThreads.add(tr1);
                    ThreadReference tr2 = tr1;
                    while ((tr2 = tr2.currentContendedMonitor().owningThread()) != null) {
                        threads.remove(tr2);
                        if (tr2.status() != 3) break;
                        if (tr2 == tr1) {
                            this.knownDeadlockedThreads.addAll(possibleDeadlockedThreads);
                            boolean bl = true;
                            return bl;
                        }
                        possibleDeadlockedThreads.add(tr2);
                    }
                }
                possibleDeadlockedThreads.clear();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }

    void stepInto(DebugJDIThreadInfo thread) {
        this.doRunCommand(3, thread);
    }

    void stepOver(DebugJDIThreadInfo thread) {
        this.doRunCommand(4, thread);
    }

    void stepIntoBC(DebugJDIThreadInfo thread) {
        this.doRunCommand(5, thread);
    }

    void stepOverBC(DebugJDIThreadInfo thread) {
        this.doRunCommand(6, thread);
    }

    void stepOut(DebugJDIThreadInfo thread) {
        this.doRunCommand(7, thread);
    }

    void stepToEndOfMethod(DebugJDIThreadInfo thread) {
        if (this.useMethodExitRequest) {
            this.doRunCommand(8, thread);
        }
    }

    void stepIntoMethod(DebugJDIThreadInfo thread, String methodName, String callerPackage, String callerFileName, int callerLine) {
        this.stepIntoMethodName = methodName;
        this.stepIntoMethodCallerPackage = callerPackage;
        this.stepIntoMethodCallerFileName = callerFileName;
        this.stepIntoMethodCallerLine = callerLine;
        StringBuilder buf = new StringBuilder();
        if (this.stepIntoMethodCallerPackage.length() > 0) {
            buf.append(this.stepIntoMethodCallerPackage.replace('.', '/'));
            buf.append('/');
        }
        buf.append(this.stepIntoMethodCallerFileName);
        this.stepIntoMethodCallerPath = buf.toString();
        this.doRunCommand(10, thread);
    }

    java.util.List tempDisableRequests() {
        ArrayList<EventRequest> requestsToDisable = new ArrayList<EventRequest>();
        if (this.stepRequest != null && this.stepRequest.isEnabled()) {
            requestsToDisable.add(this.stepRequest);
        }
        if (this.methodExitRequestForStepToEndOfMethod != null && this.methodExitRequestForStepToEndOfMethod.isEnabled()) {
            requestsToDisable.add(this.methodExitRequestForStepToEndOfMethod);
        }
        if (this.methodExitRequestForStepOut != null && this.methodExitRequestForStepOut.isEnabled()) {
            requestsToDisable.add(this.methodExitRequestForStepOut);
        }
        if (this.methodEntryRequestStepIntoMethod != null && this.methodEntryRequestStepIntoMethod.isEnabled()) {
            requestsToDisable.add(this.methodEntryRequestStepIntoMethod);
        }
        if (this.startCPR != null && this.startCPR.isEnabled()) {
            requestsToDisable.add(this.startCPR);
        }
        if (this.startTSR != null && this.startTSR.isEnabled()) {
            requestsToDisable.add(this.startTSR);
        }
        if (this.startStepRequests != null) {
            for (StepRequest sr : this.startStepRequests.values()) {
                if (!sr.isEnabled()) continue;
                requestsToDisable.add(sr);
            }
        }
        int size = requestsToDisable.size();
        int i = 0;
        while (i < size) {
            EventRequest er = (EventRequest)requestsToDisable.get(i);
            er.disable();
            ++i;
        }
        this.tempDisableBreakpoints();
        return requestsToDisable;
    }

    void tempReenableRequests(java.util.List requestsToEnable) {
        int size = requestsToEnable.size();
        int i = 0;
        while (i < size) {
            EventRequest er = (EventRequest)requestsToEnable.get(i);
            er.enable();
            ++i;
        }
        this.tempReenableBreakpoints();
    }

    synchronized void tempDisableBreakpoints() {
        int size = this.breakpoints.size();
        int i = 0;
        while (i < size) {
            DebugJDIBreakpoint bp = (DebugJDIBreakpoint)this.breakpoints.get(i);
            bp.tempDisableRequests();
            ++i;
        }
    }

    synchronized void tempReenableBreakpoints() {
        int size = this.breakpoints.size();
        int i = 0;
        while (i < size) {
            DebugJDIBreakpoint bp = (DebugJDIBreakpoint)this.breakpoints.get(i);
            bp.tempReenableRequests();
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUp() {
        if (this.returnValuesRequest != null) {
            try {
                this.returnValuesRequest.disable();
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
            this.returnValuesRequest = null;
        }
        this.threadReturnValues = null;
        if (anonymousBlockManager != null) {
            anonymousBlockManager.remove(this);
        }
        java.util.List list = this.unhandledEventSets;
        synchronized (list) {
            this.unhandledEventSets.clear();
            this.unhandledEventThreads.clear();
        }
        this.needToResume.clear();
        this.eq = null;
        this.erm = null;
        this.cur = null;
        this.startCPR = null;
        this.startTSR = null;
        if (this.startStepRequests != null) {
            this.startStepRequests.clear();
        }
        this.stepLocation = null;
        this.stepStack = null;
        this.stepRequest = null;
        this.methodExitRequestForStepToEndOfMethod = null;
        this.methodExitRequestForStepToEndOfMethodMethod = null;
        this.methodExitRequestForStepOut = null;
        this.methodEntryRequestStepIntoMethod = null;
        DebugJDI debugJDI = this;
        synchronized (debugJDI) {
            if (this.breakpoints != null) {
                this.disconnectBreakpoints();
                this.breakpoints.clear();
            }
            if (this.cprBreakpoints != null) {
                this.cprBreakpoints.clear();
            }
            this.classes.clear();
        }
        if (this.cprsByFilter != null) {
            this.cprsByFilter.clear();
        }
        if (this.classesByReferenceType != null) {
            this.classesByReferenceType.clear();
        }
        if (this.classesByName != null) {
            this.classesByName.clear();
        }
        if (this.classesByNameWithoutPackage != null) {
            this.classesByNameWithoutPackage.clear();
        }
        if (this.classesCollected != null) {
            this.classesCollected.clear();
        }
        if (this.classesNotCollected != null) {
            this.classesNotCollected.clear();
        }
        if (this.objectsCollected != null) {
            this.objectsCollected.clear();
        }
        if (this.objectsNotCollected != null) {
            this.objectsNotCollected.clear();
        }
        if (this.debuggable != null) {
            this.debuggable.clear();
        }
        if (this.nonDebuggable != null) {
            this.nonDebuggable.clear();
        }
        if (this.nonDebuggableClassExclusionFilters != null) {
            this.nonDebuggableClassExclusionFilters.clear();
        }
        if (this.otherWaitingThreads != null) {
            this.otherWaitingThreads.clear();
        }
        this.threadInfos.clear();
        this.stackFrameInfos.clear();
        this.classLoaderInfos.clear();
        this.classLoaderIds.clear();
        this.systemClassLoader = null;
        this.currentBreakpoint = null;
        this.currentThread = null;
        this.eventThread = null;
        this.currentThrow = null;
        this.currentThrowHandler = null;
        this.watchpointObject = null;
        this.watchpointField = null;
        this.watchpointFieldFutureValue = null;
        if (this.stoppedListeners != null) {
            this.stoppedListeners.clear();
        }
        if (this.pins != null) {
            this.pins.clear();
        }
        this.debugListener = null;
        this.bpLogListener = null;
        Object object = this.syncObjects[5];
        synchronized (object) {
            if (this.connectionLogs != null) {
                if ((stdErrCount -= this.connectionLogs.size()) == 0 && stdErr != null) {
                    System.setErr(stdErr);
                    stdErr = null;
                }
                this.connectionLogs.clear();
            }
        }
    }

    private synchronized void disconnectBreakpoints() {
        int size = this.breakpoints.size();
        int i = 0;
        while (i < size) {
            DebugJDIBreakpoint bp = (DebugJDIBreakpoint)this.breakpoints.get(i);
            bp.requests.clear();
            bp.locations.clear();
            ++i;
        }
        this.bpRequests.clear();
    }

    private boolean checkForBreakpointHit(Event e, ThreadReference tr) {
        if (!this.bpRequests.contains(e.request())) {
            return false;
        }
        boolean started = this.startTestConnectionThread("checkForBreakpointHit");
        this.lookForMissedClasses();
        this.eventThread = tr;
        this.currentThread = DebugJDIThreadInfo.makeThreadInfo(this, tr);
        if (e instanceof ExceptionEvent) {
            ExceptionEvent ee = (ExceptionEvent)e;
            this.currentThrow = (DebugJDIDataObjectInfo)this.makeData(ee.exception(), null);
            Location loc = ee.catchLocation();
            if (loc != null) {
                this.currentThrowHandler = this.makeLocation(loc);
            }
        } else if (e instanceof WatchpointEvent) {
            ModificationWatchpointEvent mwe;
            Value fieldValueToBe;
            DebugJDIClassInfo fieldClass;
            WatchpointEvent we = (WatchpointEvent)e;
            Field f = we.field();
            try {
                fieldClass = this.findClassByType(f.type());
            }
            catch (Exception ex) {
                fieldClass = this.findClassByName(f.typeName(), true);
            }
            ObjectReference object = we.object();
            DebugJDIClassInfo objectClass = this.findClass(f.declaringType());
            this.watchpointObject = object != null ? (DebugJDIDataObjectInfo)this.makeData(object, null) : (DebugJDIDataObjectInfo)this.makeNullData(objectClass, null);
            this.watchpointField = new DebugJDIFieldInfo(this, f, objectClass, object);
            this.watchpointFieldFutureValue = e instanceof ModificationWatchpointEvent ? ((fieldValueToBe = (mwe = (ModificationWatchpointEvent)e).valueToBe()) != null ? this.makeData(fieldValueToBe, null) : this.makeNullData(fieldClass, null)) : null;
        }
        DebugJDIBreakpoint stop = null;
        java.util.List v = this.findBreakpointsForEvent(e, tr);
        int size = v.size();
        int i = 0;
        while (i < size) {
            DebugJDIBreakpoint bp = (DebugJDIBreakpoint)v.get(i);
            if (this.doBreakpointActions(bp, e, tr)) {
                stop = bp;
            }
            ++i;
        }
        if (started) {
            this.killTestConnectionThread();
        }
        if (stop != null) {
            this.eventThread = tr;
            this.currentBreakpoint = stop;
            return true;
        }
        this.eventThread = null;
        this.currentThread = null;
        this.currentThrow = null;
        this.currentThrowHandler = null;
        this.watchpointObject = null;
        this.watchpointField = null;
        this.watchpointFieldFutureValue = null;
        return false;
    }

    private synchronized java.util.List findBreakpointsForEvent(Event e, ThreadReference tr) {
        ArrayList<DebugJDIBreakpoint> v = new ArrayList<DebugJDIBreakpoint>();
        int size = this.breakpoints.size();
        int i = 0;
        while (i < size) {
            DebugJDIBreakpoint bp = (DebugJDIBreakpoint)this.breakpoints.get(i);
            if (bp.isThisYourEvent(e, tr)) {
                v.add(bp);
            }
            ++i;
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doBreakpointActions(DebugJDIBreakpoint bp, Event e, ThreadReference tr) {
        if (bp.enableOtherBPs != null && bp.enableOtherBPs.length() > 0) {
            DebugJDI debugJDI = this;
            synchronized (debugJDI) {
                int size = this.breakpoints.size();
                int i = 0;
                while (i < size) {
                    DebugJDIBreakpoint other = (DebugJDIBreakpoint)this.breakpoints.get(i);
                    if (bp.enableOtherBPs.equals(other.name) && !other.enabled) {
                        other.setEnabled(true);
                        if (this.debugListener != null) {
                            this.debugListener.breakpointChanged(other);
                        }
                    }
                    ++i;
                }
            }
        }
        if (bp.disableOtherBPs != null && bp.disableOtherBPs.length() > 0) {
            DebugJDI debugJDI = this;
            synchronized (debugJDI) {
                int size = this.breakpoints.size();
                int i = 0;
                while (i < size) {
                    DebugJDIBreakpoint other = (DebugJDIBreakpoint)this.breakpoints.get(i);
                    if (bp.disableOtherBPs.equals(other.name) && other.enabled) {
                        other.setEnabled(false);
                        if (this.debugListener != null) {
                            this.debugListener.breakpointChanged(other);
                        }
                    }
                    ++i;
                }
            }
        }
        if (bp.log) {
            this.incrementStoppedCount(false);
            DebugJDIThreadInfo thread = DebugJDIThreadInfo.makeThreadInfo(this, tr);
            DebugStackFrameInfo[] stack = thread.listStack();
            if (bp instanceof DebugJDIBreakpointPackageFileLine || bp instanceof DebugJDIBreakpointFileLine || bp instanceof DebugJDIBreakpointMethodBytecode || bp instanceof DebugJDIBreakpointMethod || bp instanceof DebugJDIBreakpointClass) {
                this.bpLogListener.logBreakpoint(bp, thread, stack);
            } else if (bp instanceof DebugJDIBreakpointException) {
                Value v;
                ObjectReference or = (ObjectReference)this.currentThrow.value;
                ReferenceType rt = or.referenceType();
                String className = rt.name();
                String detail = "";
                Field f = rt.fieldByName("detailMessage");
                if (f != null && (v = or.getValue(f)) != null) {
                    detail = ((StringReference)v).value();
                }
                this.bpLogListener.logException(bp, className, detail, thread, stack);
            } else if (bp instanceof DebugJDIBreakpointClassLoad) {
                ClassPrepareEvent cpe = (ClassPrepareEvent)e;
                ReferenceType rt = cpe.referenceType();
                String className = rt.name();
                this.bpLogListener.logClassLoad(bp, className, thread, stack);
            } else if (bp instanceof DebugJDIBreakpointDeadlock) {
                this.bpLogListener.logDeadlock(bp, thread, stack);
            } else if (bp instanceof DebugJDIBreakpointWatchpoint) {
                this.bpLogListener.logWatchpoint(bp, this.watchpointField, this.watchpointFieldFutureValue, thread, stack);
            }
            this.incrementStoppedCount(false);
        }
        return bp.stop;
    }

    static Location getFirstLocation(java.util.List locations) {
        int index = -1;
        long lowestBC = 0L;
        int size = locations.size();
        int i = 0;
        while (i < size) {
            Location location = (Location)locations.get(i);
            long bc = location.codeIndex();
            if (index == -1 || bc < lowestBC) {
                index = i;
                lowestBC = bc;
            }
            ++i;
        }
        if (index != -1) {
            return (Location)locations.get(index);
        }
        return null;
    }

    DebugJDILocation makeLocation(Location location) {
        return new DebugJDILocation(this, location);
    }

    private void initSync() {
        this.syncObjects = new Object[8];
        int i = 0;
        while (i < 8) {
            this.syncObjects[i] = new Integer(i);
            ++i;
        }
        this.syncValues = new boolean[8];
        int i2 = 0;
        while (i2 < 8) {
            this.syncValues[i2] = false;
            ++i2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setSyncValue(int i, boolean value) {
        Object object = this.syncObjects[i];
        synchronized (object) {
            boolean prevValue = this.syncValues[i];
            this.syncValues[i] = value;
            boolean bl = prevValue;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getSyncValue(int i) {
        Object object = this.syncObjects[i];
        synchronized (object) {
            boolean bl = this.syncValues[i];
            return bl;
        }
    }

    private synchronized void verifyBreakpoints(ReferenceType rt) {
        int size = this.breakpoints.size();
        int i = 0;
        while (i < size) {
            DebugJDIBreakpoint bp = (DebugJDIBreakpoint)this.breakpoints.get(i);
            try {
                if (bp.verify(rt) && this.debugListener != null) {
                    this.debugListener.breakpointChanged(bp);
                }
            }
            catch (ObjectCollectedException e) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnectionLog(Object log) {
        Object object = this.syncObjects[5];
        synchronized (object) {
            boolean needToSetDebugTraceMode = false;
            if (this.connectionLogs == null) {
                this.connectionLogs = new ArrayList();
                needToSetDebugTraceMode = true;
            }
            this.connectionLogs.add(log);
            if (++stdErrCount == 1 && stdErr == null) {
                stdErr = System.err;
                FakePrintStream fake = new FakePrintStream(stdErr);
                System.setErr(fake);
            }
            if (needToSetDebugTraceMode && this.vm != null) {
                this.vm.setDebugTraceMode(3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnectionLog(Object log) {
        Object object = this.syncObjects[5];
        synchronized (object) {
            if (this.connectionLogs != null) {
                this.connectionLogs.remove(log);
                if (this.connectionLogs.size() == 0) {
                    this.connectionLogs = null;
                    if (this.vm != null) {
                        this.vm.setDebugTraceMode(0);
                    }
                }
                if (--stdErrCount == 0 && stdErr != null) {
                    System.setErr(stdErr);
                    stdErr = null;
                }
            }
        }
    }

    @Override
    public synchronized String getName() {
        return this.vm.name();
    }

    @Override
    public int getLanguages() {
        return this.languages;
    }

    @Override
    public synchronized String[] redefineClasses(Map nameToGuts) {
        this.throwIfRunning();
        ArrayList<String> errors = new ArrayList<String>();
        if (this.vm.canRedefineClasses()) {
            String msg;
            Throwable thrown = null;
            try {
                HashMap<ReferenceType, byte[]> rtToGuts = new HashMap<ReferenceType, byte[]>();
                ArrayList<DebugJDIClassInfo> classesAffected = new ArrayList<DebugJDIClassInfo>();
                for (Map.Entry entry : nameToGuts.entrySet()) {
                    Object key = entry.getKey();
                    Object c = this.classesByName.get(key);
                    if (c == null) continue;
                    byte[] guts = (byte[])entry.getValue();
                    if (c instanceof DebugJDIClassInfo) {
                        DebugJDIClassInfo clazz = (DebugJDIClassInfo)c;
                        if (clazz.getReferenceType() == null) continue;
                        this.redefiningClass(clazz);
                        classesAffected.add(clazz);
                        rtToGuts.put(clazz.getReferenceType(), guts);
                        continue;
                    }
                    if (!(c instanceof java.util.List)) continue;
                    java.util.List list = (java.util.List)c;
                    for (DebugJDIClassInfo clazz : list) {
                        if (clazz.getReferenceType() == null) continue;
                        this.redefiningClass(clazz);
                        classesAffected.add(clazz);
                        rtToGuts.put(clazz.getReferenceType(), guts);
                    }
                }
                try {
                    this.redefineClassesOccurred = true;
                    this.vm.redefineClasses(rtToGuts);
                }
                finally {
                    DebugJDIStackFrameInfo.rebuildCache(this);
                }
                if (classesAffected.size() == 0) {
                    String msg2 = DebugJDIArb.getString(8);
                    errors.add(msg2);
                    String[] stringArray = errors.toArray(new String[errors.size()]);
                    return stringArray;
                }
                int i = classesAffected.size() - 1;
                while (i >= 0) {
                    this.redefinedClass((DebugJDIClassInfo)classesAffected.get(i));
                    --i;
                }
                String[] stringArray = null;
                return stringArray;
            }
            catch (VerifyError ve) {
                thrown = ve;
            }
            catch (Exception e) {
                thrown = e;
            }
            if (thrown != null && (msg = thrown.getMessage()) != null) {
                if (msg.endsWith(" not implemented")) {
                    msg = msg.substring(0, msg.length() - 16);
                }
                if (thrown instanceof UnsupportedOperationException) {
                    msg = DebugJDIArb.format(3, msg);
                }
                if (thrown instanceof VerifyError) {
                    msg = DebugJDIArb.format(6, msg);
                }
                if (msg.length() > 0) {
                    errors.add(msg);
                }
            }
        }
        return errors.toArray(new String[errors.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void redefiningClass(DebugJDIClassInfo clazz) {
        clazz.redefiningClass();
        DebugJDI debugJDI = this;
        synchronized (debugJDI) {
            int size = this.breakpoints.size();
            int i = 0;
            while (i < size) {
                DebugJDIBreakpoint bp = (DebugJDIBreakpoint)this.breakpoints.get(i);
                bp.redefiningClass(clazz.getReferenceType());
                ++i;
            }
        }
    }

    private void redefinedClass(DebugJDIClassInfo clazz) {
        this.verifyBreakpoints(clazz.getReferenceType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logToConnectionLogs(String s) {
        Object object = this.syncObjects[5];
        synchronized (object) {
            if (this.connectionLogs != null) {
                int size = this.connectionLogs.size();
                int i = 0;
                while (i < size) {
                    Object log = this.connectionLogs.get(i);
                    try {
                        if (log instanceof List) {
                            List list = (List)log;
                            list.add(s);
                            list.makeVisible(list.getItemCount() - 1);
                        } else if (log instanceof PrintStream) {
                            PrintStream ps = (PrintStream)log;
                            ps.println(s);
                        } else if (log instanceof File) {
                            String filename = ((File)log).getAbsolutePath();
                            PrintWriter writer = new PrintWriter(new FileWriter(filename, true));
                            writer.println(s);
                            writer.flush();
                            writer.close();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        }
    }

    void addStoppedListener(DebugJDIStoppedListener l) {
        this.stoppedListeners.add(l);
    }

    void removeStoppedListener(DebugJDIStoppedListener l) {
        this.stoppedListeners.remove(l);
    }

    void incrementStoppedCount(boolean stopped) {
        ++this.stoppedCount;
        if (this.currentThrow != null) {
            this.currentThrow.stoppedCount = this.stoppedCount;
        }
        if (this.watchpointObject != null) {
            this.watchpointObject.stoppedCount = this.stoppedCount;
        }
        if (this.watchpointField != null) {
            this.watchpointField.stoppedCount = this.stoppedCount;
        }
        if (this.watchpointFieldFutureValue != null) {
            this.watchpointFieldFutureValue.stoppedCount = this.stoppedCount;
        }
        if (this.classesNotCollected != null) {
            this.classesNotCollected.clear();
        }
        if (this.objectsNotCollected != null) {
            this.objectsNotCollected.clear();
        }
        DebugJDIThreadInfo.clearCache(this, stopped);
        DebugJDIStackFrameInfo.clearCache(this);
        if (this.stoppedListeners != null) {
            DebugJDIStoppedListener[] array = this.stoppedListeners.toArray(new DebugJDIStoppedListener[this.stoppedListeners.size()]);
            int i = array.length - 1;
            while (i >= 0) {
                array[i].stopped(stopped);
                --i;
            }
        }
    }

    boolean isClassDebuggable(String className) {
        return DebugShared.isClassOrPackageDebuggable(className, this.debuggable, this.nonDebuggable);
    }

    String getNonDebuggableClassExclusionFilter(String className) {
        if (this.debuggable.size() != 0) {
            int dot = className.indexOf(46);
            while (dot != -1) {
                String part = className.substring(0, dot + 1);
                if (!DebugJDI.findPartialNameInPackageList(part, this.debuggable)) {
                    return part + "*";
                }
                dot = className.indexOf(46, dot + 1);
            }
            return className;
        }
        return null;
    }

    private static boolean findPartialNameInPackageList(String part, java.util.List v) {
        int size = v.size();
        int i = 0;
        while (i < size) {
            String s = (String)v.get(i);
            if (s.startsWith(part)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static Location getLocation(ThreadReference tr) {
        try {
            Location location = tr.frame(0).location();
            return location;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String getSourceName(Location location) {
        try {
            String string = location.sourceName();
            return string;
        }
        catch (Exception e) {
            String string = "";
            return string;
        }
    }

    private static String getSourcePath(Location location) {
        try {
            String string = location.sourcePath();
            return string;
        }
        catch (Exception e) {
            String string = "";
            return string;
        }
    }

    private static boolean sameSourceLocation(Location loc1, Location loc2) {
        try {
            String defaultStratum;
            if (loc1.method().equals(loc2.method()) && DebugJDI.getLineNumber(loc1, defaultStratum = loc1.declaringType().defaultStratum()) == DebugJDI.getLineNumber(loc2, defaultStratum)) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static String[] getStack(ThreadReference tr) {
        try {
            java.util.List<StackFrame> frames = tr.frames();
            int size = frames.size();
            String[] s = new String[size];
            int i = 0;
            while (i < size) {
                s[i] = frames.get(i).toString();
                ++i;
            }
            String[] stringArray = s;
            return stringArray;
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static boolean sameStack(String[] stack1, String[] stack2) {
        try {
            if (stack1 == null || stack2 == null) {
                boolean bl = false;
                return bl;
            }
            int length = stack1.length;
            if (length != stack2.length) {
                boolean bl = false;
                return bl;
            }
            int i = 0;
            while (i < length) {
                if (stack1[i] == null || stack2[i] == null || !stack1[i].equals(stack2[i])) {
                    boolean bl = false;
                    return bl;
                }
                ++i;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }

    void addBPRequest(EventRequest er) {
        this.bpRequests.add(er);
    }

    void removeBPRequest(EventRequest er) {
        this.bpRequests.remove(er);
    }

    boolean isMethodObsolete(Method method) {
        if (this.redefineClassesOccurred) {
            try {
                boolean bl = method.isObsolete();
                return bl;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClassLoaderReference getSystemClassLoader() {
        Object object = this.syncObjects[7];
        synchronized (object) {
            DebugJDIDataObjectInfo systemClassLoaderObject;
            DebugJDIClassInfo classLoaderClass;
            if (this.systemClassLoader == null && (classLoaderClass = this.findClassByName("java.lang.ClassLoader", false)) != null && (systemClassLoaderObject = (DebugJDIDataObjectInfo)DebugShared.getSystemClassLoaderObject(classLoaderClass)) != null) {
                this.systemClassLoader = (ClassLoaderReference)systemClassLoaderObject.value;
            }
            ClassLoaderReference classLoaderReference = this.systemClassLoader;
            return classLoaderReference;
        }
    }

    ClassLoaderReference getClassLoader(ReferenceType rt) throws Exception {
        ClassLoaderReference clr = rt.classLoader();
        if (this.isOracleDatabaseVM() && clr != null && clr.referenceType() == rt) {
            return null;
        }
        return clr;
    }

    static synchronized void setDebugJDIAnonymousBlockManagerFactory(DebugJDIAnonymousBlockManagerFactory factory) {
        anonymousBlockManagerFactory = factory;
    }

    static synchronized void makeAnonymousBlockManager() {
        if (anonymousBlockManager == null && anonymousBlockManagerFactory != null) {
            anonymousBlockManager = anonymousBlockManagerFactory.createInstance();
        }
    }

    static int getLineNumber(Location loc, String stratum) {
        int lineNumber = -1;
        try {
            lineNumber = loc.lineNumber(stratum);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (lineNumber != -1 && DebugJDI.shouldAdjustLineNumbers(loc.declaringType())) {
            ++lineNumber;
        }
        return lineNumber;
    }

    static boolean shouldAdjustLineNumbers(ReferenceType rt) {
        return rt.name().startsWith("$Oracle.") && !rt.name().startsWith("$Oracle.Block.");
    }

    static java.util.List getLocationsOfLine(Object o, String stratum, String filename, int lineNumber) throws AbsentInformationException {
        ReferenceType rt = null;
        if (o instanceof Method) {
            rt = ((Method)o).declaringType();
        } else if (o instanceof ReferenceType) {
            rt = (ReferenceType)o;
        } else {
            throw new IllegalArgumentException();
        }
        if (DebugJDI.shouldAdjustLineNumbers(rt)) {
            --lineNumber;
        }
        if (o instanceof Method) {
            if (stratum == null && filename == null) {
                return ((Method)o).locationsOfLine(lineNumber);
            }
            return ((Method)o).locationsOfLine(stratum, filename, lineNumber);
        }
        return ((ReferenceType)o).locationsOfLine(stratum, filename, lineNumber);
    }

    DebugJDIAnnotationInfo[] getAnnotations(ObjectReference orAnnotatedElement) {
        block7: {
            try {
                ClassType ctAnnotatedElement = (ClassType)orAnnotatedElement.referenceType();
                Method mGetDeclaredAnnotations = ctAnnotatedElement.concreteMethodByName("getDeclaredAnnotations", "()[Ljava/lang/annotation/Annotation;");
                if (mGetDeclaredAnnotations == null) break block7;
                java.util.List prev = this.tempDisableRequests();
                try {
                    ArrayReference arAnnotations = (ArrayReference)orAnnotatedElement.invokeMethod(this.eventThread, mGetDeclaredAnnotations, Collections.EMPTY_LIST, 1);
                    if (arAnnotations == null) break block7;
                    DebugJDIAnnotationInfo[] array = new DebugJDIAnnotationInfo[arAnnotations.length()];
                    int i = 0;
                    for (Value annotation : arAnnotations.getValues()) {
                        array[i] = new DebugJDIAnnotationInfo(this, (ObjectReference)annotation);
                        ++i;
                    }
                    DebugJDIAnnotationInfo[] debugJDIAnnotationInfoArray = array;
                    return debugJDIAnnotationInfoArray;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    DebugJDIStackFrameInfo.rebuildCache(this);
                    this.tempReenableRequests(prev);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return new DebugJDIAnnotationInfo[0];
    }

    @Override
    public boolean canStopOnException() {
        return false;
    }

    @Override
    public boolean canStopOnError() {
        return false;
    }

    @Override
    public boolean canStopOnDebuggerStatement() {
        return false;
    }

    @Override
    public boolean canTransferErrors() {
        return false;
    }

    @Override
    public boolean getStopOnException() {
        return false;
    }

    @Override
    public boolean getStopOnError() {
        return false;
    }

    @Override
    public boolean getStopOnDebuggerStatement() {
        return false;
    }

    @Override
    public boolean getTransferErrors() {
        return false;
    }

    @Override
    public void setStopOnException(boolean b) {
    }

    @Override
    public void setStopOnError(boolean b) {
    }

    @Override
    public void setStopOnDebuggerStatement(boolean b) {
    }

    @Override
    public void setTransferErrors(boolean b) {
    }

    @Override
    public void setCurrentStackFrame(DebugStackFrameInfo sfInfo) {
        this.currentStackFrame = sfInfo;
    }

    @Override
    public DebugStackFrameInfo getCurrentStackFrame() {
        return this.currentStackFrame;
    }

    @Override
    public boolean canStopInChrome() {
        return false;
    }

    @Override
    public boolean getStopInChrome() {
        return false;
    }

    @Override
    public void setStopInChrome(boolean b) {
    }

    private void createReturnValuesRequest() {
        if (this.canGetReturnValue() && this.returnValuesRequest == null && this.vm != null && this.erm != null) {
            this.returnValuesRequest = this.erm.createMethodExitRequest();
            this.returnValuesRequest.setSuspendPolicy(0);
            this.returnValuesRequest.disable();
        }
    }

    private void registerReturnValue(MethodExitEvent e) {
    }

    Value getReturnValueForThread(long threadId) {
        return null;
    }

    MethodExitEvent getMethodExitEventForThread(long threadId) {
        if (this.threadReturnValues != null) {
            MethodExitEvent e = this.threadReturnValues.get(new Long(threadId));
            return e;
        }
        return null;
    }

    DebugHeapObjectInfo[] getHeapObjects(long[] heapAddresses, int start, int count) {
        return null;
    }

    DebugJDIDataCompositeInfo getObjectFromAddress(long address) {
        return null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public Object newObject(String typeName, java.util.List<Object> parameters) throws Exception {
        if ("java.lang.Byte".equals(typeName)) {
            constructor = null;
            values = new ArrayList<ByteValue>();
            o /* !! */  = this.classesByName.get(typeName);
            clazz = null;
            if (o /* !! */  instanceof DebugJDIClassInfo) {
                type = ((DebugJDIClassInfo)o /* !! */ ).getJDIType();
                if (type instanceof ClassType) {
                    clazz = (ClassType)type;
                }
            } else if (o /* !! */  instanceof java.util.List && ((java.util.List)o /* !! */ ).size() > 0 && (o /* !! */  = ((java.util.List)o /* !! */ ).get(0)) != null && (type = ((DebugJDIClassInfo)o /* !! */ ).getJDIType()) instanceof ClassType) {
                clazz = (ClassType)type;
            }
            if (parameters.size() == 0 || parameters.size() == 1 && parameters.get(0) == null) {
                constructors = clazz.methodsByName("<init>");
                for (Method m : constructors) {
                    if (m.arguments().size() != 0) continue;
                    constructor = m;
                    break;
                }
            } else if (parameters.size() == 1 && (param1 = parameters.get(0)) instanceof EvaluationInfo && (param1EI = (EvaluationInfo)param1) != null) {
                try {
                    bv = param1EI.getByteValue();
                    values.add(this.vm.mirrorOf(bv));
                    constructors = clazz.methodsByName("<init>", "(B)V");
                    if (constructors.size() == 0) ** GOTO lbl31
                    constructor = constructors.get(0);
                }
                catch (Throwable ee) {
                    throw new Exception("Unable to evaluate source expression: new object");
                }
            }
            if (values != null && constructor != null && clazz != null && this.currentThread != null && this.currentThread.tr != null && o /* !! */  != null) {
                or = null;
                prev = this.tempDisableRequests();
                try {
                    or = clazz.newInstance(this.currentThread.tr, constructor, values, 1);
                }
                finally {
                    DebugJDIStackFrameInfo.rebuildCache(this);
                    this.tempReenableRequests(prev);
                    this.incrementStoppedCount(false);
                    this.checkPinnedObjects();
                }
                return new DebugJDIDataObjectInfo(this, (DebugJDIClassInfo)o /* !! */ , or, null);
            }
        } else if ("java.lang.Character".equals(typeName)) {
            constructor = null;
            values = new ArrayList<CharValue>();
            o /* !! */  = this.classesByName.get(typeName);
            clazz = null;
            if (o /* !! */  instanceof DebugJDIClassInfo) {
                type = ((DebugJDIClassInfo)o /* !! */ ).getJDIType();
                if (type instanceof ClassType) {
                    clazz = (ClassType)type;
                }
            } else if (o /* !! */  instanceof java.util.List && ((java.util.List)o /* !! */ ).size() > 0 && (o /* !! */  = ((java.util.List)o /* !! */ ).get(0)) != null && (type = ((DebugJDIClassInfo)o /* !! */ ).getJDIType()) instanceof ClassType) {
                clazz = (ClassType)type;
            }
            if (parameters.size() == 0 || parameters.size() == 1 && parameters.get(0) == null) {
                constructors = clazz.methodsByName("<init>");
                for (Method m : constructors) {
                    if (m.arguments().size() != 0) continue;
                    constructor = m;
                    break;
                }
            } else if (parameters.size() == 1 && (param1 = parameters.get(0)) instanceof EvaluationInfo && (param1EI = (EvaluationInfo)param1) != null) {
                try {
                    cv = param1EI.getCharValue();
                    values.add(this.vm.mirrorOf(cv));
                    constructors = clazz.methodsByName("<init>", "(C)V");
                    if (constructors.size() == 0) ** GOTO lbl77
                    constructor = constructors.get(0);
                }
                catch (Throwable ee) {
                    throw new Exception("Unable to evaluate source expression: new object");
                }
            }
            if (values != null && constructor != null && clazz != null && this.currentThread != null && this.currentThread.tr != null && o /* !! */  != null) {
                prev = this.tempDisableRequests();
                or = null;
                try {
                    or = clazz.newInstance(this.currentThread.tr, constructor, values, 1);
                }
                finally {
                    DebugJDIStackFrameInfo.rebuildCache(this);
                    this.tempReenableRequests(prev);
                    this.incrementStoppedCount(false);
                    this.checkPinnedObjects();
                }
                return new DebugJDIDataObjectInfo(this, (DebugJDIClassInfo)o /* !! */ , or, null);
            }
        } else if ("java.lang.Double".equals(typeName)) {
            constructor = null;
            values = new ArrayList<DoubleValue>();
            o /* !! */  = this.classesByName.get(typeName);
            clazz = null;
            if (o /* !! */  instanceof DebugJDIClassInfo) {
                type = ((DebugJDIClassInfo)o /* !! */ ).getJDIType();
                if (type instanceof ClassType) {
                    clazz = (ClassType)type;
                }
            } else if (o /* !! */  instanceof java.util.List && ((java.util.List)o /* !! */ ).size() > 0 && (o /* !! */  = ((java.util.List)o /* !! */ ).get(0)) != null && (type = ((DebugJDIClassInfo)o /* !! */ ).getJDIType()) instanceof ClassType) {
                clazz = (ClassType)type;
            }
            if (parameters.size() == 0 || parameters.size() == 1 && parameters.get(0) == null) {
                constructors = clazz.methodsByName("<init>");
                for (Method m : constructors) {
                    if (m.arguments().size() != 0) continue;
                    constructor = m;
                    break;
                }
            } else if (parameters.size() == 1 && (param1 = parameters.get(0)) instanceof EvaluationInfo && (param1EI = (EvaluationInfo)param1) != null) {
                try {
                    dv = param1EI.getDoubleValue();
                    values.add(this.vm.mirrorOf(dv));
                    constructors = clazz.methodsByName("<init>", "(D)V");
                    if (constructors.size() == 0) ** GOTO lbl123
                    constructor = constructors.get(0);
                }
                catch (Throwable ee) {
                    throw new Exception("Unable to evaluate source expression: new object");
                }
            }
            if (values != null && constructor != null && clazz != null && this.currentThread != null && this.currentThread.tr != null && o /* !! */  != null) {
                or = null;
                prev = this.tempDisableRequests();
                try {
                    or = clazz.newInstance(this.currentThread.tr, constructor, values, 1);
                }
                finally {
                    DebugJDIStackFrameInfo.rebuildCache(this);
                    this.tempReenableRequests(prev);
                    this.incrementStoppedCount(false);
                    this.checkPinnedObjects();
                }
                return new DebugJDIDataObjectInfo(this, (DebugJDIClassInfo)o /* !! */ , or, null);
            }
        } else if ("java.lang.Float".equals(typeName)) {
            constructor = null;
            values = new ArrayList<FloatValue>();
            o /* !! */  = this.classesByName.get(typeName);
            clazz = null;
            if (o /* !! */  instanceof DebugJDIClassInfo) {
                type = ((DebugJDIClassInfo)o /* !! */ ).getJDIType();
                if (type instanceof ClassType) {
                    clazz = (ClassType)type;
                }
            } else if (o /* !! */  instanceof java.util.List && ((java.util.List)o /* !! */ ).size() > 0 && (o /* !! */  = ((java.util.List)o /* !! */ ).get(0)) != null && (type = ((DebugJDIClassInfo)o /* !! */ ).getJDIType()) instanceof ClassType) {
                clazz = (ClassType)type;
            }
            if (parameters.size() == 0 || parameters.size() == 1 && parameters.get(0) == null) {
                constructors = clazz.methodsByName("<init>");
                for (Method m : constructors) {
                    if (m.arguments().size() != 0) continue;
                    constructor = m;
                    break;
                }
            } else if (parameters.size() == 1 && (param1 = parameters.get(0)) instanceof EvaluationInfo && (param1EI = (EvaluationInfo)param1) != null) {
                try {
                    fv = param1EI.getFloatValue();
                    values.add(this.vm.mirrorOf(fv));
                    constructors = clazz.methodsByName("<init>", "(F)V");
                    if (constructors.size() == 0) ** GOTO lbl169
                    constructor = constructors.get(0);
                }
                catch (Throwable ee) {
                    throw new Exception("Unable to evaluate source expression: new object");
                }
            }
            if (values != null && constructor != null && clazz != null && this.currentThread != null && this.currentThread.tr != null && o /* !! */  != null) {
                prev = this.tempDisableRequests();
                or = null;
                try {
                    or = clazz.newInstance(this.currentThread.tr, constructor, values, 1);
                }
                finally {
                    DebugJDIStackFrameInfo.rebuildCache(this);
                    this.tempReenableRequests(prev);
                    this.incrementStoppedCount(false);
                    this.checkPinnedObjects();
                }
                return new DebugJDIDataObjectInfo(this, (DebugJDIClassInfo)o /* !! */ , or, null);
            }
        } else if ("java.lang.Integer".equals(typeName)) {
            constructor = null;
            values = new ArrayList<IntegerValue>();
            o /* !! */  = this.classesByName.get(typeName);
            clazz = null;
            if (o /* !! */  instanceof DebugJDIClassInfo) {
                type = ((DebugJDIClassInfo)o /* !! */ ).getJDIType();
                if (type instanceof ClassType) {
                    clazz = (ClassType)type;
                }
            } else if (o /* !! */  instanceof java.util.List && ((java.util.List)o /* !! */ ).size() > 0 && (o /* !! */  = ((java.util.List)o /* !! */ ).get(0)) != null && (type = ((DebugJDIClassInfo)o /* !! */ ).getJDIType()) instanceof ClassType) {
                clazz = (ClassType)type;
            }
            if (parameters.size() == 0 || parameters.size() == 1 && parameters.get(0) == null) {
                constructors = clazz.methodsByName("<init>");
                for (Method m : constructors) {
                    if (m.arguments().size() != 0) continue;
                    constructor = m;
                    break;
                }
            } else if (parameters.size() == 1 && (param1 = parameters.get(0)) instanceof EvaluationInfo && (param1EI = (EvaluationInfo)param1) != null) {
                try {
                    iv = param1EI.getIntValue();
                    values.add(this.vm.mirrorOf(iv));
                    constructors = clazz.methodsByName("<init>", "(I)V");
                    if (constructors.size() == 0) ** GOTO lbl215
                    constructor = constructors.get(0);
                }
                catch (Throwable ee) {
                    throw new Exception("Unable to evaluate source expression: new object");
                }
            }
            if (values != null && constructor != null && clazz != null && this.currentThread != null && this.currentThread.tr != null && o /* !! */  != null) {
                prev = this.tempDisableRequests();
                or = null;
                try {
                    or = clazz.newInstance(this.currentThread.tr, constructor, values, 1);
                }
                finally {
                    DebugJDIStackFrameInfo.rebuildCache(this);
                    this.tempReenableRequests(prev);
                    this.incrementStoppedCount(false);
                    this.checkPinnedObjects();
                }
                return new DebugJDIDataObjectInfo(this, (DebugJDIClassInfo)o /* !! */ , or, null);
            }
        } else if ("java.lang.Long".equals(typeName)) {
            constructor = null;
            values = new ArrayList<LongValue>();
            o /* !! */  = this.classesByName.get(typeName);
            clazz = null;
            if (o /* !! */  instanceof DebugJDIClassInfo) {
                type = ((DebugJDIClassInfo)o /* !! */ ).getJDIType();
                if (type instanceof ClassType) {
                    clazz = (ClassType)type;
                }
            } else if (o /* !! */  instanceof java.util.List && ((java.util.List)o /* !! */ ).size() > 0 && (o /* !! */  = ((java.util.List)o /* !! */ ).get(0)) != null && (type = ((DebugJDIClassInfo)o /* !! */ ).getJDIType()) instanceof ClassType) {
                clazz = (ClassType)type;
            }
            if (parameters.size() == 0 || parameters.size() == 1 && parameters.get(0) == null) {
                constructors = clazz.methodsByName("<init>");
                for (Method m : constructors) {
                    if (m.arguments().size() != 0) continue;
                    constructor = m;
                    break;
                }
            } else if (parameters.size() == 1 && (param1 = parameters.get(0)) instanceof EvaluationInfo && (param1EI = (EvaluationInfo)param1) != null) {
                try {
                    lv = param1EI.getLongValue();
                    values.add(this.vm.mirrorOf(lv));
                    constructors = clazz.methodsByName("<init>", "(J)V");
                    if (constructors.size() == 0) ** GOTO lbl261
                    constructor = constructors.get(0);
                }
                catch (Throwable ee) {
                    throw new Exception("Unable to evaluate source expression: new object");
                }
            }
            if (values != null && constructor != null && clazz != null && this.currentThread != null && this.currentThread.tr != null && o /* !! */  != null) {
                prev = this.tempDisableRequests();
                or = null;
                try {
                    or = clazz.newInstance(this.currentThread.tr, constructor, values, 1);
                }
                finally {
                    DebugJDIStackFrameInfo.rebuildCache(this);
                    this.tempReenableRequests(prev);
                    this.incrementStoppedCount(false);
                    this.checkPinnedObjects();
                }
                return new DebugJDIDataObjectInfo(this, (DebugJDIClassInfo)o /* !! */ , or, null);
            }
        } else if ("java.lang.Short".equals(typeName)) {
            constructor = null;
            values = new ArrayList<ShortValue>();
            o /* !! */  = this.classesByName.get(typeName);
            clazz = null;
            if (o /* !! */  instanceof DebugJDIClassInfo) {
                type = ((DebugJDIClassInfo)o /* !! */ ).getJDIType();
                if (type instanceof ClassType) {
                    clazz = (ClassType)type;
                }
            } else if (o /* !! */  instanceof java.util.List && ((java.util.List)o /* !! */ ).size() > 0 && (o /* !! */  = ((java.util.List)o /* !! */ ).get(0)) != null && (type = ((DebugJDIClassInfo)o /* !! */ ).getJDIType()) instanceof ClassType) {
                clazz = (ClassType)type;
            }
            if (parameters.size() == 0 || parameters.size() == 1 && parameters.get(0) == null) {
                constructors = clazz.methodsByName("<init>");
                for (Method m : constructors) {
                    if (m.arguments().size() != 0) continue;
                    constructor = m;
                    break;
                }
            } else if (parameters.size() == 1 && (param1 = parameters.get(0)) instanceof EvaluationInfo && (param1EI = (EvaluationInfo)param1) != null) {
                try {
                    sv = param1EI.getShortValue();
                    values.add(this.vm.mirrorOf(sv));
                    constructors = clazz.methodsByName("<init>", "(S)V");
                    if (constructors.size() == 0) ** GOTO lbl307
                    constructor = constructors.get(0);
                }
                catch (Throwable ee) {
                    throw new Exception("Unable to evaluate source expression: new object");
                }
            }
            if (values != null && constructor != null && clazz != null && this.currentThread != null && this.currentThread.tr != null && o /* !! */  != null) {
                prev = this.tempDisableRequests();
                or = null;
                try {
                    or = clazz.newInstance(this.currentThread.tr, constructor, values, 1);
                }
                finally {
                    DebugJDIStackFrameInfo.rebuildCache(this);
                    this.tempReenableRequests(prev);
                    this.incrementStoppedCount(false);
                    this.checkPinnedObjects();
                }
                return new DebugJDIDataObjectInfo(this, (DebugJDIClassInfo)o /* !! */ , or, null);
            }
        }
        throw new Exception("Unable to evaluate source expression: new object");
    }

    @Override
    public void cacheUserFoundURL(String lookedFor, URL foundUrl) {
        if (this.userUrlCacher == null) {
            this.userUrlCacher = new UserSelectedURLCacher();
        }
        this.userUrlCacher.addCachedURL(lookedFor, foundUrl);
    }

    @Override
    public URL getChachedUserFoundLocation(String lookingFor) {
        if (this.userUrlCacher == null) {
            return null;
        }
        return this.userUrlCacher.getCachedUrl(lookingFor);
    }

    static EventQueue ra$eq(DebugJDI debugJDI) {
        return debugJDI.eq;
    }

    static boolean mav$getSyncValue(DebugJDI debugJDI, int n) {
        return debugJDI.getSyncValue(n);
    }

    static boolean mav$setSyncValue(DebugJDI debugJDI, int n, boolean bl) {
        return debugJDI.setSyncValue(n, bl);
    }

    static void mav$connectionLost(DebugJDI debugJDI) {
        debugJDI.connectionLost();
    }

    static Set ra$classesNotCollected(DebugJDI debugJDI) {
        return debugJDI.classesNotCollected;
    }

    static DebugJDIClassInfo mav$addClassForReferenceType(DebugJDI debugJDI, ReferenceType referenceType, boolean bl) {
        return debugJDI.addClassForReferenceType(referenceType, bl);
    }

    static void mav$lookForUnloadedClassesByName(DebugJDI debugJDI, String string) {
        debugJDI.lookForUnloadedClassesByName(string);
    }

    static java.util.List ra$unhandledEventSets(DebugJDI debugJDI) {
        return debugJDI.unhandledEventSets;
    }

    static java.util.List ra$unhandledEventThreads(DebugJDI debugJDI) {
        return debugJDI.unhandledEventThreads;
    }

    static void wa$testConnectionThread(DebugJDI debugJDI, Thread thread) {
        debugJDI.testConnectionThread = thread;
    }

    final class 1
    extends Thread {
        private final /* synthetic */ String v$threadName;
        final /* synthetic */ DebugJDI this$0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block13: {
                try {
                    EventQueue eqLocal;
                    while ((eqLocal = DebugJDI.ra$eq(this.this$0)) != null) {
                        EventSet es = eqLocal.remove(3000L);
                        if (es == null) continue;
                        boolean breakOut = false;
                        EventIterator ei = es.eventIterator();
                        while (ei.hasNext()) {
                            Event e = ei.nextEvent();
                            if (e instanceof VMDisconnectEvent) {
                                boolean connectionLostAlreadyRecognized;
                                if (!DebugJDI.mav$getSyncValue(this.this$0, 3) && !(connectionLostAlreadyRecognized = DebugJDI.mav$setSyncValue(this.this$0, 6, true))) {
                                    DebugJDI.mav$connectionLost(this.this$0);
                                }
                                breakOut = true;
                                continue;
                            }
                            if (e instanceof ClassPrepareEvent) {
                                ClassPrepareEvent cpe = (ClassPrepareEvent)e;
                                ReferenceType rt = cpe.referenceType();
                                DebugJDI.ra$classesNotCollected(this.this$0).add(rt);
                                DebugJDI.mav$addClassForReferenceType(this.this$0, rt, false);
                                continue;
                            }
                            if (e instanceof ClassUnloadEvent) {
                                DebugJDI.mav$lookForUnloadedClassesByName(this.this$0, ((ClassUnloadEvent)e).className());
                                continue;
                            }
                            Assert.println((String)(this.v$threadName + " - got unexpected event " + e));
                            if (!(e instanceof LocatableEvent)) continue;
                            ThreadReference tr = ((LocatableEvent)e).thread();
                            tr.suspend();
                            java.util.List list = DebugJDI.ra$unhandledEventSets(this.this$0);
                            synchronized (list) {
                                DebugJDI.ra$unhandledEventSets(this.this$0).add(es);
                                DebugJDI.ra$unhandledEventThreads(this.this$0).add(tr);
                                break;
                            }
                        }
                        if (!breakOut) {
                            es.resume();
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException e) {
                }
                catch (VMDisconnectedException e) {
                    boolean connectionLostAlreadyRecognized = DebugJDI.mav$setSyncValue(this.this$0, 6, true);
                    if (connectionLostAlreadyRecognized) break block13;
                    DebugJDI.mav$connectionLost(this.this$0);
                }
            }
            DebugJDI.wa$testConnectionThread(this.this$0, null);
        }

        public 1(DebugJDI debugJDI, String string, String string2) {
            this.v$threadName = string2;
            this.this$0 = debugJDI;
            super(string);
        }
    }

    class FakePrintStream
    extends PrintStream {
        String nextLine;
        boolean passOn;

        FakePrintStream(OutputStream stdErr) {
            super(stdErr);
            this.nextLine = "";
        }

        public void print(boolean x) {
            if (this.passOn) {
                super.print(x);
            } else {
                this.nextLine = this.nextLine + (x ? "true" : "false");
            }
        }

        public void print(char x) {
            if (this.passOn) {
                super.print(x);
            } else {
                this.nextLine = this.nextLine + String.valueOf(x);
            }
        }

        public void print(int x) {
            if (this.passOn) {
                super.print(x);
            } else {
                this.nextLine = this.nextLine + String.valueOf(x);
            }
        }

        public void print(long x) {
            if (this.passOn) {
                super.print(x);
            } else {
                this.nextLine = this.nextLine + String.valueOf(x);
            }
        }

        public void print(float x) {
            if (this.passOn) {
                super.print(x);
            } else {
                this.nextLine = this.nextLine + String.valueOf(x);
            }
        }

        public void print(double x) {
            if (this.passOn) {
                super.print(x);
            } else {
                this.nextLine = this.nextLine + String.valueOf(x);
            }
        }

        public void print(char[] x) {
            if (this.passOn) {
                super.print(x);
            } else {
                this.nextLine = this.nextLine + x;
            }
        }

        public void print(String x) {
            if (this.passOn) {
                super.print(x);
            } else {
                if (x == null) {
                    x = "null";
                }
                this.nextLine = this.nextLine + x;
            }
        }

        public void print(Object x) {
            if (this.passOn) {
                super.print(x);
            } else {
                this.nextLine = this.nextLine + String.valueOf(x);
            }
        }

        public void println() {
            if (this.passOn) {
                super.println();
            } else {
                this.log();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void println(boolean x) {
            if (this.passOn) {
                super.println(x);
            } else {
                FakePrintStream fakePrintStream = this;
                synchronized (fakePrintStream) {
                    this.print(x);
                    this.log();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void println(char x) {
            if (this.passOn) {
                super.println(x);
            } else {
                FakePrintStream fakePrintStream = this;
                synchronized (fakePrintStream) {
                    this.print(x);
                    this.log();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void println(int x) {
            if (this.passOn) {
                super.println(x);
            } else {
                FakePrintStream fakePrintStream = this;
                synchronized (fakePrintStream) {
                    this.print(x);
                    this.log();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void println(long x) {
            if (this.passOn) {
                super.println(x);
            } else {
                FakePrintStream fakePrintStream = this;
                synchronized (fakePrintStream) {
                    this.print(x);
                    this.log();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void println(float x) {
            if (this.passOn) {
                super.println(x);
            } else {
                FakePrintStream fakePrintStream = this;
                synchronized (fakePrintStream) {
                    this.print(x);
                    this.log();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void println(double x) {
            if (this.passOn) {
                super.println(x);
            } else {
                FakePrintStream fakePrintStream = this;
                synchronized (fakePrintStream) {
                    this.print(x);
                    this.log();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void println(char[] x) {
            if (this.passOn) {
                super.println(x);
            } else {
                FakePrintStream fakePrintStream = this;
                synchronized (fakePrintStream) {
                    this.print(x);
                    this.log();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void println(String x) {
            if (this.passOn) {
                super.println(x);
            } else {
                FakePrintStream fakePrintStream = this;
                synchronized (fakePrintStream) {
                    this.print(x);
                    this.log();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void println(Object x) {
            if (this.passOn) {
                super.println(x);
            } else {
                FakePrintStream fakePrintStream = this;
                synchronized (fakePrintStream) {
                    this.print(x);
                    this.log();
                }
            }
        }

        private void log() {
            if (this.nextLine.startsWith("[JDI:")) {
                DebugJDI.this.logToConnectionLogs(this.nextLine);
            } else {
                this.passOn = true;
                super.println(this.nextLine);
                this.passOn = false;
            }
            this.nextLine = "";
        }
    }
}

