/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugAnnotationInfo;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.JDIInformationProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DebugJDIAnnotationInfo
extends JDIInformationProvider
implements DebugAnnotationInfo {
    DebugJDI dj;
    int stoppedCount;
    ObjectReference orAnnotation;
    Map<String, DebugDataInfo> properties;

    DebugJDIAnnotationInfo(DebugJDI dj, ObjectReference orAnnotation) {
        this.dj = dj;
        this.stoppedCount = dj.stoppedCount;
        this.orAnnotation = orAnnotation;
    }

    @Override
    public boolean hasExpired() {
        return this.dj.stoppedCount != this.stoppedCount;
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new IllegalStateException("Annotation has expired");
        }
    }

    @Override
    public DebugDataInfo getDataInfo() {
        this.throwIfExpired();
        return this.dj.makeData(this.orAnnotation, null);
    }

    @Override
    public DebugClassInfo getClassInfo() {
        block6: {
            this.throwIfExpired();
            try {
                ClassType ctAnnotation = (ClassType)this.orAnnotation.referenceType();
                Method mAnnotationType = ctAnnotation.concreteMethodByName("annotationType", "()Ljava/lang/Class;");
                if (mAnnotationType == null) break block6;
                List prev = this.dj.tempDisableRequests();
                try {
                    ClassObjectReference corAnnotationType = (ClassObjectReference)this.orAnnotation.invokeMethod(this.dj.eventThread, mAnnotationType, Collections.EMPTY_LIST, 1);
                    ReferenceType rtAnnotationType = corAnnotationType.reflectedType();
                    DebugJDIClassInfo c = this.dj.findClassByType(rtAnnotationType);
                    if (c == null) break block6;
                    DebugJDIClassInfo debugJDIClassInfo = c;
                    return debugJDIClassInfo;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    DebugJDIStackFrameInfo.rebuildCache(this.dj);
                    this.dj.tempReenableRequests(prev);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Map<String, DebugDataInfo> getProperties() {
        block9: {
            this.throwIfExpired();
            try {
                ClassType ctAnnotation;
                Method mAnnotationType;
                if (this.properties != null) break block9;
                this.properties = new TreeMap<String, DebugDataInfo>();
                if (this.dj.eventThread == null || (mAnnotationType = (ctAnnotation = (ClassType)this.orAnnotation.referenceType()).concreteMethodByName("annotationType", "()Ljava/lang/Class;")) == null) break block9;
                List prev = this.dj.tempDisableRequests();
                try {
                    ClassObjectReference corAnnotationType = (ClassObjectReference)this.orAnnotation.invokeMethod(this.dj.eventThread, mAnnotationType, Collections.EMPTY_LIST, 1);
                    ReferenceType rtAnnotationType = corAnnotationType.reflectedType();
                    List<Method> methods = rtAnnotationType.methods();
                    List arguments = Collections.emptyList();
                    for (Method m : methods) {
                        if (!m.signature().startsWith("()")) continue;
                        String name = m.name();
                        Value value = this.orAnnotation.invokeMethod(this.dj.eventThread, m, arguments, 1);
                        DebugJDIDataInfo data = null;
                        if (value != null) {
                            data = this.dj.makeData(value, null);
                        } else {
                            DebugJDIClassInfo dataClass = this.dj.findClassByType(m.returnType());
                            if (dataClass != null) {
                                data = this.dj.makeNullData(dataClass, null);
                            }
                        }
                        if (data == null) continue;
                        this.properties.put(name, data);
                    }
                }
                finally {
                    DebugJDIStackFrameInfo.rebuildCache(this.dj);
                    this.dj.tempReenableRequests(prev);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return this.properties;
    }

    @Override
    public Value getJDIValue() {
        return this.orAnnotation;
    }
}

