/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import java.util.List;
import oracle.ide.util.ModelUtil;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpointClass;

final class DebugJDIBreakpointClass
extends DebugJDIBreakpoint
implements DebugBreakpointClass {
    String className;

    DebugJDIBreakpointClass(DebugJDI dj, String className) {
        super(dj);
        this.className = className;
    }

    public String getClassname() {
        return this.className;
    }

    public void setClassname(String className) {
        if (ModelUtil.areDifferent((Object)this.className, (Object)className)) {
            this.prepareForChange();
            this.className = className;
            this.afterChange();
        }
    }

    String getClassPrepareFilter() {
        return this.className;
    }

    boolean verify(ReferenceType rt) {
        boolean identified = false;
        if (this.className.equals(rt.name())) {
            List<Method> methods = rt.methods();
            int im = 0;
            while (im < methods.size()) {
                try {
                    Method m = methods.get(im);
                    List<Location> list = m.allLineLocations();
                    Location location = DebugJDI.getFirstLocation(list);
                    if (location != null) {
                        this.locationIdentified(location);
                        identified = true;
                    }
                }
                catch (AbsentInformationException e) {
                    // empty catch block
                }
                ++im;
            }
        }
        return identified;
    }
}

