/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.util.ModelUtil;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpointFileLine;

class DebugJDIBreakpointFileLine
extends DebugJDIBreakpoint
implements DebugBreakpointFileLine {
    String filename;
    int line;

    DebugJDIBreakpointFileLine(DebugJDI dj, String filename, int line) {
        super(dj);
        this.filename = filename;
        this.line = line;
    }

    public String getFilename() {
        return this.filename;
    }

    public int getLine() {
        return this.line;
    }

    public void setFileLine(String filename, int line) {
        if (ModelUtil.areDifferent((Object)this.filename, (Object)filename) || this.line != line) {
            this.prepareForChange();
            this.filename = filename;
            this.line = line;
            this.afterChange();
        }
    }

    String getClassPrepareFilter() {
        return "";
    }

    boolean verify(ReferenceType rt) {
        boolean identified = false;
        try {
            int size;
            String defaultStratum = rt.defaultStratum();
            ArrayList<Location> locationsOfLine = null;
            try {
                locationsOfLine = DebugJDI.getLocationsOfLine(rt, defaultStratum, this.filename, this.line);
            }
            catch (ClassNotPreparedException cnpe) {
                boolean bl = false;
                return bl;
            }
            catch (AbsentInformationException aie) {
                // empty catch block
            }
            if (locationsOfLine == null) {
                List<Location> l = rt.allLineLocations(defaultStratum, this.filename);
                ArrayList<Location> v = new ArrayList<Location>();
                int size2 = l.size();
                int i = 0;
                while (i < size2) {
                    Location location = l.get(i);
                    if (DebugJDI.getLineNumber(location, defaultStratum) == this.line) {
                        v.add(location);
                    }
                    ++i;
                }
                locationsOfLine = v;
            }
            if ((size = locationsOfLine.size()) > 0) {
                int i = 0;
                while (i < size) {
                    Location location = (Location)locationsOfLine.get(i);
                    this.locationIdentified(location);
                    ++i;
                }
                identified = true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return identified;
    }
}

