/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import java.util.List;
import oracle.ide.util.ModelUtil;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpointMethod;

final class DebugJDIBreakpointMethod
extends DebugJDIBreakpoint
implements DebugBreakpointMethod {
    String method;
    String className;

    DebugJDIBreakpointMethod(DebugJDI dj, String method) {
        super(dj);
        this.method = method;
        int lastDot = method.lastIndexOf(".");
        this.className = lastDot == -1 ? "" : method.substring(0, lastDot);
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        if (ModelUtil.areDifferent((Object)this.method, (Object)method)) {
            this.prepareForChange();
            this.method = method;
            this.afterChange();
        }
    }

    String getClassPrepareFilter() {
        return this.className;
    }

    boolean verify(ReferenceType rt) {
        boolean identified = false;
        if (this.className.equals(rt.name())) {
            List<Method> methods = rt.methods();
            int im = 0;
            while (im < methods.size()) {
                Method m = methods.get(im);
                if (this.method.equals(this.className + "." + m.name())) {
                    try {
                        List<Location> list = m.allLineLocations();
                        Location location = DebugJDI.getFirstLocation(list);
                        if (location != null) {
                            this.locationIdentified(location);
                            identified = true;
                        }
                    }
                    catch (AbsentInformationException e) {
                        // empty catch block
                    }
                }
                ++im;
            }
        }
        return identified;
    }
}

