/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.ReferenceType;
import oracle.ide.util.ModelUtil;
import oracle.jdeveloper.model.J2eeSettings;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpointFileLine;
import oracle.jdevimpl.debugger.jdi.JspUtil;
import oracle.jdevimpl.debugger.support.DebugBreakpointPackageFileLine;

final class DebugJDIBreakpointPackageFileLine
extends DebugJDIBreakpointFileLine
implements DebugBreakpointPackageFileLine {
    String pkg;

    DebugJDIBreakpointPackageFileLine(DebugJDI dj, String pkg, String filename, int line) {
        super(dj, filename, line);
        this.pkg = pkg;
    }

    public String getPackage() {
        return this.pkg;
    }

    public void setPackageFileLine(String pkg, String filename, int line) {
        if (ModelUtil.areDifferent((Object)this.pkg, (Object)pkg) || ModelUtil.areDifferent((Object)this.filename, (Object)filename) || this.line != line) {
            this.prepareForChange();
            this.pkg = pkg;
            this.filename = filename;
            this.line = line;
            this.afterChange();
        }
    }

    String getClassPrepareFilter() {
        if (this.pkg.length() > 0) {
            if (this.pkg.charAt(0) == '*') {
                return "";
            }
            return this.pkg + ".*";
        }
        if (J2eeSettings.isJsp(this.filename)) {
            String jspClass = JspUtil.getFullClassNameFromURL(this.filename);
            return jspClass + "*";
        }
        return "";
    }

    boolean verify(ReferenceType rt) {
        String rtPkg;
        String name = rt.name();
        int i = name.lastIndexOf(".");
        String string = rtPkg = i == -1 ? "" : name.substring(0, i);
        if (rtPkg.equals(this.pkg)) {
            return super.verify(rt);
        }
        if (this.pkg.length() > 0 && this.pkg.charAt(0) == '*' && rtPkg.endsWith(this.pkg.substring(1))) {
            return super.verify(rt);
        }
        return false;
    }
}

