/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.WatchpointEvent;
import com.sun.jdi.request.AccessWatchpointRequest;
import com.sun.jdi.request.ModificationWatchpointRequest;
import java.util.List;
import oracle.ide.util.ModelUtil;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpointWatchpoint;

final class DebugJDIBreakpointWatchpoint
extends DebugJDIBreakpoint
implements DebugBreakpointWatchpoint {
    String classname;
    String fieldname;
    boolean access;
    boolean modify;

    DebugJDIBreakpointWatchpoint(DebugJDI dj, String classname, String fieldname, boolean access, boolean modify) {
        super(dj);
        this.classname = classname;
        this.fieldname = fieldname;
        this.access = access;
        this.modify = modify;
    }

    public String getWatchpointClassname() {
        return this.classname;
    }

    public String getWatchpointFieldname() {
        return this.fieldname;
    }

    public boolean getAccess() {
        return this.access;
    }

    public boolean getModify() {
        return this.modify;
    }

    public void setWatchpoint(String classname, String fieldname, boolean access, boolean modify) {
        if (ModelUtil.areDifferent((Object)this.classname, (Object)classname) || ModelUtil.areDifferent((Object)this.fieldname, (Object)fieldname) || this.access != access || this.modify != modify) {
            this.prepareForChange();
            this.classname = classname;
            this.fieldname = fieldname;
            this.access = access;
            this.modify = modify;
            this.afterChange();
        }
    }

    String getClassPrepareFilter() {
        return this.classname;
    }

    boolean verify(ReferenceType rt) {
        boolean identified = false;
        if (this.classname.equals(rt.name())) {
            this.classIdentified(rt);
            identified = true;
        }
        return identified;
    }

    private void classIdentified(ReferenceType rt) {
        List<Field> fields = rt.fields();
        if (fields != null) {
            for (Field field : fields) {
                if (!this.fieldname.equals(field.name())) continue;
                if (this.access) {
                    try {
                        AccessWatchpointRequest er = this.dj.erm.createAccessWatchpointRequest(field);
                        this.setOptions(er);
                        this.addRequest(er);
                    }
                    catch (UnsupportedOperationException e) {
                        // empty catch block
                    }
                }
                if (!this.modify) continue;
                try {
                    ModificationWatchpointRequest er = this.dj.erm.createModificationWatchpointRequest(field);
                    this.setOptions(er);
                    this.addRequest(er);
                }
                catch (UnsupportedOperationException e) {
                    // empty catch block
                }
            }
        }
    }

    protected ObjectReference getInstanceForEvent(Event e, ThreadReference tr) {
        if (e instanceof WatchpointEvent) {
            WatchpointEvent we = (WatchpointEvent)e;
            return we.object();
        }
        return null;
    }
}

