/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.ArrayType;
import com.sun.jdi.BooleanType;
import com.sun.jdi.ByteType;
import com.sun.jdi.CharType;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleType;
import com.sun.jdi.Field;
import com.sun.jdi.FloatType;
import com.sun.jdi.IntegerType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Location;
import com.sun.jdi.LongType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.VoidType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIAnnotationInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassLoaderInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIFieldInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIMethodInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIPlsqlTableElement;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugAnnotationInfo;
import oracle.jdevimpl.debugger.support.DebugArrayElementInfo;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugClassLoaderInfo;
import oracle.jdevimpl.debugger.support.DebugDataArrayInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.DebugHasAnnotations;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.JDIInformationProvider;
import oracle.jdevimpl.runner.xslt.XSLTRunnerAddin;

final class DebugJDIClassInfo
extends JDIInformationProvider
implements DebugClassInfo,
DebugHasAnnotations {
    private static final String SYNTHETIC_ENUM_MARKER1 = "$v";
    private static final String SYNTHETIC_ENUM_MARKER2 = "$VALUES";
    DebugJDI dj;
    Type type;
    private boolean classLoaderReferenceKnown;
    private ClassLoaderReference classLoaderReference;
    boolean rtCollected;
    String name;
    List methods;
    boolean debuggable;
    String justPackage;
    String packagePath;
    String nameWithoutPackage;
    private int hashCode;

    DebugJDIClassInfo(DebugJDI dj, Type type) {
        this.dj = dj;
        this.type = type;
        this.name = type.name();
        this.checkDebuggable();
    }

    DebugJDIClassInfo(String name) {
        this.name = name;
    }

    void checkDebuggable() {
        this.debuggable = this.type instanceof PrimitiveType || this.type instanceof VoidType ? true : this.dj.isClassDebuggable(this.name);
    }

    ReferenceType getReferenceType() {
        if (this.type instanceof ReferenceType) {
            return (ReferenceType)this.type;
        }
        return null;
    }

    public boolean hasExpired() {
        return this.rtCollected;
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new IllegalStateException("Class has expired " + this.name);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getPackage() {
        if (this.justPackage == null) {
            this.justPackage = DebugShared.getPackage(this.name);
        }
        return this.justPackage;
    }

    public String getPackagePath() {
        if (this.packagePath == null) {
            this.packagePath = DebugShared.getPackagePath(this.name);
        }
        return this.packagePath;
    }

    public String getNameWithoutPackage() {
        if (this.nameWithoutPackage == null) {
            this.nameWithoutPackage = DebugShared.getNameWithoutPackage(this.name);
        }
        return this.nameWithoutPackage;
    }

    public String getGenericSignature() {
        if (this.type instanceof ReferenceType) {
            return ((ReferenceType)this.type).genericSignature();
        }
        return null;
    }

    public int getAccess() {
        this.throwIfExpired();
        if (this.type instanceof ReferenceType) {
            ReferenceType rt = (ReferenceType)this.type;
            try {
                int n = rt.modifiers();
                return n;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public boolean isInterface() {
        this.throwIfExpired();
        return this.type instanceof InterfaceType;
    }

    public boolean isPrimitive() {
        this.throwIfExpired();
        return this.type instanceof PrimitiveType || this.type instanceof VoidType;
    }

    public boolean isObject() {
        this.throwIfExpired();
        return this.type instanceof ClassType;
    }

    public boolean isArray() {
        this.throwIfExpired();
        return this.type instanceof ArrayType;
    }

    public int getSizeOfObject() {
        this.throwIfExpired();
        if (this.type instanceof PrimitiveType || this.type instanceof VoidType) {
            if (this.type instanceof BooleanType) {
                return 1;
            }
            if (this.type instanceof ByteType) {
                return 1;
            }
            if (this.type instanceof CharType) {
                return 2;
            }
            if (this.type instanceof DoubleType) {
                return 8;
            }
            if (this.type instanceof FloatType) {
                return 4;
            }
            if (this.type instanceof IntegerType) {
                return 4;
            }
            if (this.type instanceof LongType) {
                return 8;
            }
            if (this.type instanceof ShortType) {
                return 2;
            }
            if (this.type instanceof VoidType) {
                return 0;
            }
        } else if (this.type instanceof ReferenceType) {
            ReferenceType rt = (ReferenceType)this.type;
            try {
                List<Field> allFields = rt.allFields();
                int size = 0;
                int i = 0;
                while (i < allFields.size()) {
                    Field field = allFields.get(i);
                    if (!field.isStatic()) {
                        String sig = field.signature();
                        char c = sig.charAt(0);
                        switch (c) {
                            case 'B': {
                                ++size;
                                break;
                            }
                            case 'C': {
                                size += 2;
                                break;
                            }
                            case 'D': {
                                size += 8;
                                break;
                            }
                            case 'F': {
                                size += 4;
                                break;
                            }
                            case 'I': {
                                size += 4;
                                break;
                            }
                            case 'J': {
                                size += 8;
                                break;
                            }
                            case 'S': {
                                size += 2;
                                break;
                            }
                            case 'Z': {
                                ++size;
                                break;
                            }
                            case 'L': 
                            case '[': {
                                size += 4;
                                break;
                            }
                        }
                    }
                    ++i;
                }
                int n = size;
                return n;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return 0;
    }

    public long countObjectsOfClass() {
        return 0L;
    }

    public int countMemoryOfClass() {
        return 0;
    }

    public DebugDataObjectInfo getClassObject() {
        this.throwIfExpired();
        ClassObjectReference cor = this.getClassObjectReference();
        if (cor != null) {
            return (DebugDataObjectInfo)((Object)this.dj.makeData(cor, null));
        }
        return null;
    }

    public ClassObjectReference getClassObjectReference() {
        this.throwIfExpired();
        if (this.type instanceof PrimitiveType || this.type instanceof VoidType) {
            try {
                Value typeFieldValue;
                Field typeField;
                ReferenceType rt;
                DebugJDIClassInfo wrapperClassInfo = null;
                if (this.type instanceof BooleanType) {
                    wrapperClassInfo = this.dj.findClassByName("java.lang.Boolean", false);
                } else if (this.type instanceof ByteType) {
                    wrapperClassInfo = this.dj.findClassByName("java.lang.Byte", false);
                } else if (this.type instanceof CharType) {
                    wrapperClassInfo = this.dj.findClassByName("java.lang.Char", false);
                } else if (this.type instanceof DoubleType) {
                    wrapperClassInfo = this.dj.findClassByName("java.lang.Double", false);
                } else if (this.type instanceof FloatType) {
                    wrapperClassInfo = this.dj.findClassByName("java.lang.Float", false);
                } else if (this.type instanceof IntegerType) {
                    wrapperClassInfo = this.dj.findClassByName("java.lang.Integer", false);
                } else if (this.type instanceof LongType) {
                    wrapperClassInfo = this.dj.findClassByName("java.lang.Long", false);
                } else if (this.type instanceof ShortType) {
                    wrapperClassInfo = this.dj.findClassByName("java.lang.Short", false);
                } else if (this.type instanceof VoidType) {
                    wrapperClassInfo = this.dj.findClassByName("java.lang.Void", false);
                }
                if (wrapperClassInfo != null && (rt = wrapperClassInfo.getReferenceType()) != null && (typeField = rt.fieldByName("TYPE")) != null && typeField.isStatic() && (typeFieldValue = rt.getValue(typeField)) instanceof ClassObjectReference) {
                    ClassObjectReference classObjectReference = (ClassObjectReference)typeFieldValue;
                    return classObjectReference;
                }
            }
            catch (Exception e) {}
        } else if (this.type instanceof ReferenceType) {
            ReferenceType rt = (ReferenceType)this.type;
            try {
                ClassObjectReference classObjectReference = rt.classObject();
                return classObjectReference;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    ClassLoaderReference getClassLoaderReference() {
        if (!this.classLoaderReferenceKnown) {
            try {
                if (this.type instanceof ReferenceType) {
                    ReferenceType rt = (ReferenceType)this.type;
                    this.classLoaderReference = this.dj.getClassLoader(rt);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.classLoaderReferenceKnown = true;
        }
        return this.classLoaderReference;
    }

    void setClassLoaderReference(ClassLoaderReference clr) {
        if (!this.classLoaderReferenceKnown) {
            this.classLoaderReference = clr;
            this.classLoaderReferenceKnown = true;
        }
    }

    public DebugDataObjectInfo getClassLoaderObject() {
        ClassLoaderReference clr;
        this.throwIfExpired();
        if (this.type instanceof ReferenceType && (clr = this.getClassLoaderReference()) != null) {
            return (DebugDataObjectInfo)((Object)this.dj.makeData(clr, null));
        }
        return null;
    }

    public DebugClassLoaderInfo getClassLoader() {
        this.throwIfExpired();
        if (this.type instanceof ReferenceType) {
            return DebugJDIClassLoaderInfo.makeClassLoaderInfo(this.dj, this.getClassLoaderReference());
        }
        return null;
    }

    public String getPrimarySourceFilename() {
        this.throwIfExpired();
        if (this.type instanceof ReferenceType && !(this.type instanceof ArrayType)) {
            ReferenceType rt = (ReferenceType)this.type;
            try {
                List<String> list = rt.sourceNames(rt.defaultStratum());
                if (list != null && list.size() > 0) {
                    String string = list.get(0);
                    return string;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.getSourceFilename();
    }

    public String getSourceFilename() {
        this.throwIfExpired();
        if (this.type instanceof ReferenceType && !(this.type instanceof ArrayType)) {
            ReferenceType rt = (ReferenceType)this.type;
            try {
                String string = rt.sourceName();
                return string;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    public DebugClassInfo getSuperClass(int level) {
        this.throwIfExpired();
        if (this.type instanceof ClassType) {
            ClassType ct = (ClassType)this.type;
            int i = 0;
            while (ct != null && i < level) {
                ct = ct.superclass();
                ++i;
            }
            if (ct != null) {
                return this.dj.findClass(ct);
            }
        }
        return null;
    }

    void redefiningClass() {
        this.methods = null;
    }

    private void getRTMethods() {
        if (this.methods == null) {
            ReferenceType rt = (ReferenceType)this.type;
            try {
                this.methods = rt.methods();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public int getMethodCount() {
        this.throwIfExpired();
        if (this.type instanceof ReferenceType) {
            this.getRTMethods();
            if (this.methods != null) {
                return this.methods.size();
            }
        }
        return 0;
    }

    public DebugMethodInfo[] getMethods() {
        this.throwIfExpired();
        if (this.type instanceof ReferenceType) {
            this.getRTMethods();
            if (this.methods != null) {
                DebugMethodInfo[] a = new DebugMethodInfo[this.methods.size()];
                int i = 0;
                while (i < this.methods.size()) {
                    a[i] = new DebugJDIMethodInfo(this.dj, this, (Method)this.methods.get(i));
                    ++i;
                }
                return a;
            }
        }
        return new DebugMethodInfo[0];
    }

    public int getStaticFieldCount() {
        return this.getStaticFieldCount(0, false);
    }

    public DebugFieldInfo[] getStaticFields() {
        return this.getStaticFields(0, false);
    }

    public DebugFieldInfo getStaticField(int index) {
        return this.getStaticField(0, false, index);
    }

    public int getStaticFieldCount(int classLevel) {
        return this.getStaticFieldCount(classLevel, false);
    }

    public DebugFieldInfo[] getStaticFields(int classLevel) {
        return this.getStaticFields(classLevel, false);
    }

    public DebugFieldInfo getStaticField(int classLevel, int index) {
        return this.getStaticField(classLevel, false, index);
    }

    public int getStaticFieldCount(int classLevel, boolean noFinal) {
        this.throwIfExpired();
        List fields = this.collectFields(classLevel, null, noFinal, Boolean.TRUE, false);
        return fields.size();
    }

    public DebugFieldInfo[] getStaticFields(int classLevel, boolean noFinal) {
        this.throwIfExpired();
        List fields = this.collectFields(classLevel, null, noFinal, Boolean.TRUE, false);
        int size = fields.size();
        DebugFieldInfo[] array = new DebugFieldInfo[size];
        int i = 0;
        while (i < size) {
            array[i] = new DebugJDIFieldInfo(this.dj, (Field)fields.get(i), this, null);
            ++i;
        }
        return array;
    }

    public DebugFieldInfo getStaticField(int classLevel, boolean noFinal, int index) {
        this.throwIfExpired();
        List fields = this.collectFields(classLevel, null, noFinal, Boolean.TRUE, false);
        int size = fields.size();
        if (index < size) {
            return new DebugJDIFieldInfo(this.dj, (Field)fields.get(index), this, null);
        }
        return null;
    }

    public DebugFieldInfo getStaticField(String fname) {
        block3: {
            try {
                ArrayList keys;
                String tableName;
                if (this.getLanguage() == 2 && (tableName = DebugJDIPlsqlTableElement.parseTableElement(fname, keys = new ArrayList())) != null) {
                    DebugFieldInfo debugFieldInfo = DebugJDIPlsqlTableElement.getTableElementField(this.getStaticFields(), tableName, keys, this.dj, fname, this, true);
                    return debugFieldInfo;
                }
            }
            catch (Throwable e) {
                if (!(e instanceof ThreadDeath)) break block3;
                throw (ThreadDeath)e;
            }
        }
        return null;
    }

    public int getFieldCount(int classLevel) {
        return this.getFieldCount(classLevel, false, false);
    }

    public DebugFieldInfo[] getFields(int classLevel) {
        return this.getFields(classLevel, false, false);
    }

    public DebugFieldInfo getField(int classLevel, int index) {
        return this.getField(classLevel, false, false, index);
    }

    public int getFieldCount(int classLevel, boolean noFinal) {
        return this.getFieldCount(classLevel, noFinal, false);
    }

    public DebugFieldInfo[] getFields(int classLevel, boolean noFinal) {
        return this.getFields(classLevel, noFinal, false);
    }

    public DebugFieldInfo getField(int classLevel, boolean noFinal, int index) {
        return this.getField(classLevel, noFinal, false, index);
    }

    public int getFieldCount(int classLevel, boolean noFinal, boolean noStatic) {
        this.throwIfExpired();
        Boolean staticFields = noStatic ? Boolean.FALSE : null;
        List fields = this.collectFields(classLevel, null, noFinal, staticFields, false);
        return fields.size();
    }

    public DebugFieldInfo[] getFields(int classLevel, boolean noFinal, boolean noStatic) {
        this.throwIfExpired();
        Boolean staticFields = noStatic ? Boolean.FALSE : null;
        List fields = this.collectFields(classLevel, null, noFinal, staticFields, false);
        int size = fields.size();
        DebugFieldInfo[] array = new DebugFieldInfo[size];
        int i = 0;
        while (i < size) {
            array[i] = new DebugJDIFieldInfo(this.dj, (Field)fields.get(i), this, null);
            ++i;
        }
        return array;
    }

    public DebugFieldInfo getField(int classLevel, boolean noFinal, boolean noStatic, int index) {
        this.throwIfExpired();
        Boolean staticFields = noStatic ? Boolean.FALSE : null;
        List fields = this.collectFields(classLevel, null, noFinal, staticFields, false);
        int size = fields.size();
        if (index < size) {
            return new DebugJDIFieldInfo(this.dj, (Field)fields.get(index), this, null);
        }
        return null;
    }

    List collectFields(int classLevel, ObjectReference or, boolean skipFinal, Boolean staticFields, boolean skipNulls) {
        ArrayList list = new ArrayList();
        try {
            if (this.type instanceof ClassType) {
                ClassType ct = (ClassType)this.type;
                int level = 0;
                while (ct != null) {
                    if (classLevel < 0 || level == classLevel) {
                        DebugJDIClassInfo.addFields(list, ct.fields(), or, skipFinal, staticFields, skipNulls);
                        if (classLevel < 0) {
                            DebugJDIClassInfo.addInterfaceFields(list, ct, or, skipFinal, staticFields, skipNulls);
                        }
                    }
                    ct = ct.superclass();
                    ++level;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    private static void addFields(List list, List fields, ObjectReference or, boolean skipFinal, Boolean staticFields, boolean skipNulls) {
        int fieldsSize = fields.size();
        int f = 0;
        while (f < fieldsSize) {
            Field field = (Field)fields.get(f);
            if (!DebugJDIClassInfo.skipField(field, or, skipFinal, staticFields, skipNulls)) {
                list.add(field);
            }
            ++f;
        }
    }

    private static boolean skipField(Field field, ObjectReference or, boolean skipFinal, Boolean staticFields, boolean skipNulls) {
        if (skipFinal && field.isFinal()) {
            return true;
        }
        if (staticFields != null && staticFields.booleanValue() != field.isStatic()) {
            return true;
        }
        return skipNulls && or != null && or.getValue(field) == null;
    }

    private static void addInterfaceFields(List list, ReferenceType rt, ObjectReference or, boolean skipFinal, Boolean staticFields, boolean skipNulls) {
        List<InterfaceType> interfaces = null;
        if (rt instanceof ClassType) {
            interfaces = ((ClassType)rt).interfaces();
        } else if (rt instanceof InterfaceType) {
            interfaces = ((InterfaceType)rt).superinterfaces();
        }
        if (interfaces != null) {
            int interfacesSize = interfaces.size();
            int i = 0;
            while (i < interfacesSize) {
                InterfaceType it = interfaces.get(i);
                DebugJDIClassInfo.addFields(list, it.fields(), or, skipFinal, staticFields, skipNulls);
                DebugJDIClassInfo.addInterfaceFields(list, it, or, skipFinal, staticFields, skipNulls);
                ++i;
            }
        }
    }

    Field fieldByName(String fname) {
        try {
            if (this.type instanceof ClassType) {
                ClassType ct = (ClassType)this.type;
                Field field = ct.fieldByName(fname);
                return field;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public boolean isDebuggable() {
        return this.debuggable;
    }

    public void setDebuggable(boolean debuggable) {
        this.debuggable = debuggable;
    }

    public boolean isObfuscated() {
        this.throwIfExpired();
        if (this.type instanceof ClassType) {
            ClassType ct = (ClassType)this.type;
            try {
                if (this.getMethodCount() > 0) {
                    String sourceName = ct.sourceName();
                    if (sourceName == null || sourceName.length() == 0) {
                        boolean bl = true;
                        return bl;
                    }
                    List<Location> allLines = ct.allLineLocations();
                    if (allLines == null || allLines.size() == 0) {
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            catch (Exception e) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public boolean isCodeCoverage() {
        return false;
    }

    public void setCodeCoverage(boolean codeCoverage) {
    }

    public void discardCodeCoverage() {
    }

    public double getCodeCoverageRatio() {
        return 0.0;
    }

    private void addAllInterfaces(Set v, InterfaceType iface) {
        DebugJDIClassInfo ci = this.dj.findClass(iface);
        if (ci != null) {
            v.add(ci);
        }
        List<InterfaceType> superinterfaces = iface.superinterfaces();
        int i = 0;
        while (i < superinterfaces.size()) {
            InterfaceType it = superinterfaces.get(i);
            this.addAllInterfaces(v, it);
            ++i;
        }
    }

    public DebugClassInfo[] getInterfaces() {
        return this.getInterfaces(0);
    }

    public DebugClassInfo[] getInterfaces(int classLevel) {
        this.throwIfExpired();
        HashSet<DebugJDIClassInfo> v = new HashSet<DebugJDIClassInfo>();
        try {
            if (this.type instanceof ClassType) {
                int countClassLevel = 0;
                ClassType ct = (ClassType)this.type;
                while (ct != null) {
                    if (classLevel == -1 || classLevel == countClassLevel) {
                        List<InterfaceType> ifaces = ct.interfaces();
                        int i = 0;
                        while (i < ifaces.size()) {
                            InterfaceType iface = ifaces.get(i);
                            this.addAllInterfaces(v, iface);
                            ++i;
                        }
                    }
                    ++countClassLevel;
                    ct = ct.superclass();
                }
            } else if (this.type instanceof InterfaceType) {
                if (classLevel == -1) {
                    this.addAllInterfaces(v, (InterfaceType)this.type);
                } else if (classLevel == 0) {
                    List<InterfaceType> superinterfaces = ((InterfaceType)this.type).superinterfaces();
                    int i = 0;
                    while (i < superinterfaces.size()) {
                        InterfaceType it = superinterfaces.get(i);
                        DebugJDIClassInfo ci = this.dj.findClass(it);
                        if (ci != null) {
                            v.add(ci);
                        }
                        ++i;
                    }
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        DebugClassInfo[] array = new DebugClassInfo[v.size()];
        return v.toArray(array);
    }

    public int getLanguage() {
        if (this.name.startsWith(XSLTRunnerAddin.getXSLTPackage())) {
            return 4;
        }
        if (this.name.startsWith("$Oracle.")) {
            return 2;
        }
        return 1;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.type != null ? this.type.hashCode() : this.name.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof DebugJDIClassInfo) {
            DebugJDIClassInfo other = (DebugJDIClassInfo)o;
            return (this.type == null ? other.type == null : this.type.equals(other.type)) && this.name.equals(this.name);
        }
        return false;
    }

    public int countAnnotations() {
        this.throwIfExpired();
        if (this.dj.isRIM()) {
            return 0;
        }
        return this.getAnnotations().length;
    }

    public DebugAnnotationInfo[] getAnnotations() {
        this.throwIfExpired();
        try {
            ClassObjectReference orClass = this.getClassObjectReference();
            if (orClass != null) {
                DebugAnnotationInfo[] debugAnnotationInfoArray = this.dj.getAnnotations(orClass);
                return debugAnnotationInfoArray;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new DebugJDIAnnotationInfo[0];
    }

    public Type getJDIType() {
        return this.type;
    }

    public Value getJDIValue() {
        try {
            if (this.type instanceof ReferenceType) {
                ClassObjectReference classObjectReference = ((ReferenceType)this.type).classObject();
                return classObjectReference;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public boolean isEnum() {
        ClassType classType;
        return this.type != null && this.type instanceof ClassType && ((classType = (ClassType)this.type).isEnum() || DebugJDIClassInfo.isAnonymousEnum(classType));
    }

    public DebugFieldInfo[] getEnumConstants() {
        if (!this.isEnum()) {
            return new DebugFieldInfo[0];
        }
        DebugFieldInfo[] fields = DebugJDIClassInfo.isAnonymousEnum((ClassType)this.type) ? this.getFields(1) : this.getFields(0);
        ArrayList<DebugFieldInfo> enumConstants = new ArrayList<DebugFieldInfo>();
        HashMap enumHashCode2ValuesMap = new HashMap();
        int i = 0;
        while (i < fields.length) {
            String fieldName = fields[i].getName();
            if (fieldName.equals(SYNTHETIC_ENUM_MARKER2) || fieldName.equals(SYNTHETIC_ENUM_MARKER1)) {
                DebugClassInfo classInfo = fields[i].getClassInfo();
                if (!classInfo.isArray()) break;
                DebugDataArrayInfo ddi = (DebugDataArrayInfo)fields[i].getDataInfo();
                DebugArrayElementInfo[] elems = ddi.getArrayElements();
                int i1 = 0;
                while (i1 < elems.length) {
                    DebugDataInfo dataInfo = elems[i1].getDataInfo();
                    enumHashCode2ValuesMap.put(new Integer(dataInfo.hashCode()), null);
                    ++i1;
                }
                break;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < fields.length) {
            DebugDataInfo ddi1 = fields[i2].getDataInfo();
            if (ddi1 != null && enumHashCode2ValuesMap.containsKey(new Integer(ddi1.hashCode()))) {
                enumConstants.add(0, fields[i2]);
            }
            ++i2;
        }
        return enumConstants.toArray(new DebugFieldInfo[enumConstants.size()]);
    }

    private static boolean isAnonymousEnum(ClassType classType) {
        int index;
        String name;
        if (classType.isEnum()) {
            return false;
        }
        ClassType superClass = classType.superclass();
        if (superClass != null && superClass.isEnum() && (name = classType.name()) != null && (index = name.lastIndexOf(36)) > 0) {
            String number = name.substring(index + 1);
            try {
                Integer.getInteger(number);
            }
            catch (Exception ex) {
                boolean bl = false;
                return bl;
            }
            return true;
        }
        return false;
    }
}

