/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.List;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIArrayElementInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataCompositeInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataInfo;
import oracle.jdevimpl.debugger.support.DebugArrayElementInfo;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataArrayInfo;

final class DebugJDIDataArrayInfo
extends DebugJDIDataCompositeInfo
implements DebugDataArrayInfo {
    DebugJDIDataArrayInfo(DebugJDI dj, DebugJDIClassInfo clazz, Value value, Object owner) {
        super(dj, clazz, value, owner);
    }

    public DebugClassInfo getArrayElementClassInfo() {
        this.throwIfExpired();
        ReferenceType rt = this.clazz.getReferenceType();
        if (rt instanceof ArrayType) {
            ArrayType at = (ArrayType)rt;
            try {
                DebugJDIClassInfo c = this.dj.findClassByType(at.componentType());
                if (c != null) {
                    DebugJDIClassInfo debugJDIClassInfo = c;
                    return debugJDIClassInfo;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return this.dj.findClassByName(at.componentTypeName(), true);
        }
        return null;
    }

    public int getArrayStart() {
        return 0;
    }

    public int getArrayCount() {
        return this.getArrayCount(false);
    }

    public DebugArrayElementInfo[] getArrayElements() {
        return this.getArrayElements(0, -1, false);
    }

    public DebugArrayElementInfo[] getArrayElements(int start, int count) {
        return this.getArrayElements(start, count, false);
    }

    public int getArrayCount(boolean nonNullCompositesOnly) {
        this.throwIfExpired();
        if (this.value == null) {
            return 0;
        }
        ArrayReference ar = (ArrayReference)this.value;
        int count = 0;
        if (nonNullCompositesOnly) {
            List<Value> values = ar.getValues(0, -1);
            int i = 0;
            while (i < values.size()) {
                Value value = values.get(i);
                if (value != null) {
                    ++count;
                }
                ++i;
            }
        } else {
            count = ar.length();
        }
        return count;
    }

    public DebugArrayElementInfo[] getArrayElements(boolean nonNullCompositesOnly) {
        return this.getArrayElements(0, -1, nonNullCompositesOnly);
    }

    public DebugArrayElementInfo[] getArrayElements(int start, int count, boolean nonNullCompositesOnly) {
        this.throwIfExpired();
        if (this.value == null) {
            return new DebugArrayElementInfo[0];
        }
        ArrayReference ar = (ArrayReference)this.value;
        ArrayType at = (ArrayType)ar.referenceType();
        if (at != null) {
            // empty if block
        }
        DebugJDIClassInfo clazz = (DebugJDIClassInfo)this.getArrayElementClassInfo();
        ArrayList<DebugJDIArrayElementInfo> v = new ArrayList<DebugJDIArrayElementInfo>();
        if (ar.length() > 0) {
            List<Value> values = ar.getValues(start, count);
            int i = 0;
            while (i < values.size()) {
                Value value = values.get(i);
                if (!nonNullCompositesOnly || value != null) {
                    DebugJDIDataInfo data = value != null ? this.dj.makeData(value, null) : this.dj.makeNullData(clazz, null);
                    v.add(new DebugJDIArrayElementInfo(this.dj, clazz, start + i, data, this));
                }
                ++i;
            }
            DebugArrayElementInfo[] array = new DebugArrayElementInfo[v.size()];
            return v.toArray(array);
        }
        return new DebugArrayElementInfo[0];
    }

    public boolean equals(Object o) {
        if (o instanceof DebugJDIDataArrayInfo) {
            return super.equals(o);
        }
        return false;
    }
}

