/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.LongValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import java.util.List;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIMonitorInfo;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugMonitorInfo;
import oracle.jdevimpl.debugger.support.DebugPinListener;
import oracle.jdevimpl.debugger.support.DebugPinnedInfo;

class DebugJDIDataCompositeInfo
extends DebugJDIDataInfo
implements DebugDataCompositeInfo {
    DebugJDIDataCompositeInfo(DebugJDI dj, DebugJDIClassInfo clazz, Value value, Object owner) {
        super(dj, clazz, value, owner);
    }

    public boolean isNull() {
        this.throwIfExpired();
        return this.value == null;
    }

    public long getAddressOfObject() {
        this.throwIfExpired();
        return this.getUniqueID();
    }

    public boolean canSetAddressOfObject() {
        return false;
    }

    public boolean canSetAddressOfObjectToNull() {
        return true;
    }

    public boolean setAddressOfObject(long address) {
        this.throwIfExpired();
        if (address == 0L) {
            return this.modifyData(null);
        }
        return false;
    }

    public DebugPinnedInfo pinObject(DebugPinListener pinListener) {
        this.throwIfExpired();
        if (this.value instanceof ObjectReference) {
            return this.dj.pinObject((ObjectReference)this.value, pinListener);
        }
        return null;
    }

    public long getUniqueID() {
        this.throwIfExpired();
        if (this.value instanceof ObjectReference) {
            return ((ObjectReference)this.value).uniqueID();
        }
        return 0L;
    }

    public String getCourtesyValue() {
        this.throwIfExpired();
        String s = DebugJDIDataCompositeInfo.getCourtesyValueForValue(this.value);
        return s;
    }

    public boolean canGetWholeThing() {
        ClassType ct;
        String name;
        ObjectReference or;
        ReferenceType rt;
        this.throwIfExpired();
        if (this.value instanceof StringReference) {
            return true;
        }
        if (this.value instanceof ArrayReference) {
            ArrayReference ar = (ArrayReference)this.value;
            ReferenceType rt2 = ar.referenceType();
            String name2 = rt2.name();
            if (name2.equals("char[]")) {
                return true;
            }
            if (name2.equals("byte[]")) {
                return true;
            }
            if (name2.equals("short[]")) {
                return true;
            }
            if (name2.equals("int[]")) {
                return true;
            }
            if (name2.equals("long[]")) {
                return true;
            }
        } else if (this.value instanceof ObjectReference && (rt = (or = (ObjectReference)this.value).referenceType()) instanceof ClassType && (name = (ct = (ClassType)rt).name()).equals("java.lang.StringBuffer")) {
            return true;
        }
        return false;
    }

    public Object getWholeThing() {
        ClassType ct;
        String name;
        ObjectReference or;
        ReferenceType rt;
        this.throwIfExpired();
        if (this.value instanceof StringReference) {
            return ((StringReference)this.value).value();
        }
        if (this.value instanceof ArrayReference) {
            ArrayReference ar = (ArrayReference)this.value;
            ReferenceType rt2 = ar.referenceType();
            String name2 = rt2.name();
            if (name2.equals("char[]")) {
                StringBuffer sb = new StringBuffer();
                int length = ar.length();
                int i = 0;
                while (i < length) {
                    char c = ((CharValue)ar.getValue(i)).value();
                    if (c == '\u0000') break;
                    sb.append(c);
                    ++i;
                }
                return sb.toString();
            }
            if (name2.equals("byte[]")) {
                int length = ar.length();
                byte[] b = new byte[length];
                int i = 0;
                while (i < length) {
                    b[i] = ((ByteValue)ar.getValue(i)).value();
                    ++i;
                }
                return b;
            }
            if (name2.equals("short[]")) {
                int length = ar.length();
                short[] b = new short[length];
                int i = 0;
                while (i < length) {
                    b[i] = ((ShortValue)ar.getValue(i)).value();
                    ++i;
                }
                return b;
            }
            if (name2.equals("int[]")) {
                int length = ar.length();
                int[] b = new int[length];
                int i = 0;
                while (i < length) {
                    b[i] = ((IntegerValue)ar.getValue(i)).value();
                    ++i;
                }
                return b;
            }
            if (name2.equals("long[]")) {
                int length = ar.length();
                long[] b = new long[length];
                int i = 0;
                while (i < length) {
                    b[i] = ((LongValue)ar.getValue(i)).value();
                    ++i;
                }
                return b;
            }
        } else if (this.value instanceof ObjectReference && (rt = (or = (ObjectReference)this.value).referenceType()) instanceof ClassType && (name = (ct = (ClassType)rt).name()).equals("java.lang.StringBuffer")) {
            ArrayReference ar = (ArrayReference)or.getValue(rt.fieldByName("value"));
            List<Value> values = ar.getValues();
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < values.size()) {
                char c = ((CharValue)values.get(i)).value();
                if (c == '\u0000') break;
                sb.append(c);
                ++i;
            }
            return sb.toString();
        }
        return null;
    }

    private static String getCourtesyValueForValue(Value value) {
        try {
            ObjectReference or;
            ReferenceType rt;
            if (value instanceof ClassObjectReference) {
                String string = ((ClassObjectReference)value).reflectedType().name();
                return string;
            }
            if (value instanceof StringReference) {
                String string = ((StringReference)value).value();
                return string;
            }
            if (value instanceof ArrayReference) {
                ArrayReference ar = (ArrayReference)value;
                ReferenceType rt2 = ar.referenceType();
                String name = rt2.name();
                if (name.equals("char[]")) {
                    StringBuffer sb = new StringBuffer();
                    int length = ar.length();
                    int i = 0;
                    while (i < length) {
                        char c = ((CharValue)ar.getValue(i)).value();
                        if (c == '\u0000') break;
                        sb.append(c);
                        ++i;
                    }
                    String string = sb.toString();
                    return string;
                }
            } else if (value instanceof ObjectReference && (rt = (or = (ObjectReference)value).referenceType()) instanceof ClassType) {
                ClassType ct = (ClassType)rt;
                while (ct != null) {
                    String name = ct.name();
                    if (name.equals("java.lang.StringBuffer")) {
                        ArrayReference ar = (ArrayReference)or.getValue(rt.fieldByName("value"));
                        List<Value> values = ar.getValues();
                        StringBuffer sb = new StringBuffer();
                        int i = 0;
                        while (i < values.size()) {
                            char c = ((CharValue)values.get(i)).value();
                            if (c == '\u0000') break;
                            sb.append(c);
                            ++i;
                        }
                        String string = sb.toString();
                        return string;
                    }
                    ct = ct.superclass();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public DebugMonitorInfo getMonitor() {
        this.throwIfExpired();
        if (this.dj.canGetMonitors() && this.value != null) {
            ObjectReference or = (ObjectReference)this.value;
            return new DebugJDIMonitorInfo(this.dj, or);
        }
        return null;
    }

    public String getValue() {
        this.throwIfExpired();
        if (this.value == null) {
            return "null";
        }
        return "";
    }

    public boolean equals(Object o) {
        if (o instanceof DebugJDIDataCompositeInfo) {
            return super.equals(o);
        }
        return false;
    }
}

