/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.LongValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import java.util.List;
import oracle.ide.util.Assert;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIArrayElementInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataObjectInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIFieldInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIMethodInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIStackFrameInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIVariableInfo;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DataExpiredException;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.debugger.support.JDIInformationProvider;

class DebugJDIDataInfo
extends JDIInformationProvider
implements DebugDataInfo {
    DebugJDI dj;
    DebugJDIClassInfo clazz;
    Value value;
    Object owner;
    int stoppedCount;
    DebugJDIFieldInfo staticField;
    private int hashCode;

    DebugJDIDataInfo(DebugJDI dj, DebugJDIClassInfo clazz, Value value, Object owner) {
        this.dj = dj;
        this.clazz = clazz;
        this.value = value;
        this.owner = owner;
        this.stoppedCount = dj.stoppedCount;
    }

    void setStaticField(DebugJDIFieldInfo staticField) {
        this.staticField = staticField;
    }

    public DebugVirtualMachine getVM() {
        return this.dj;
    }

    public boolean hasExpired() {
        if (this.dj.stoppedCount != this.stoppedCount && this.staticField != null && !this.staticField.hasExpired()) {
            this.value = this.staticField.updateStaticFieldValue();
            this.clazz = this.value != null ? this.dj.findClassByType(this.value.type()) : (DebugJDIClassInfo)this.staticField.getClassInfo();
            this.stoppedCount = this.dj.stoppedCount;
        }
        return this.dj.stoppedCount != this.stoppedCount;
    }

    protected void throwIfExpired() {
        if (this.hasExpired()) {
            throw new DataExpiredException();
        }
    }

    public DebugClassInfo getClassInfo() {
        return this.clazz;
    }

    public String getValue() {
        return "";
    }

    public String getHexValue() {
        return "";
    }

    public boolean canModifyDataWithString() {
        DebugDataInfo _valueFieldData;
        if (this.owner != null) {
            if (this.value instanceof BooleanValue || this.value instanceof ByteValue || this.value instanceof CharValue || this.value instanceof DoubleValue || this.value instanceof FloatValue || this.value instanceof IntegerValue || this.value instanceof LongValue || this.value instanceof ShortValue || this.value instanceof StringReference) {
                return !(this.owner instanceof DebugJDIFieldInfo) || !((DebugJDIFieldInfo)this.owner).isFinal();
            }
            if (this.value == null && this.clazz != null && this.clazz.name.equals("java.lang.String")) {
                return true;
            }
        }
        if (this instanceof DebugJDIDataObjectInfo && this.clazz != null && this.clazz.name.startsWith("$Oracle.Builtin.") && (_valueFieldData = DebugShared.findFieldData((DebugDataObjectInfo)((Object)this), "_value", "java.lang.String")) != null) {
            return _valueFieldData.canModifyDataWithString();
        }
        return false;
    }

    public boolean modifyDataWithString(String newValue) {
        DebugDataInfo _valueFieldData;
        Value v = null;
        if (this.value instanceof BooleanValue) {
            v = this.dj.makeBooleanValue(newValue);
        } else if (this.value instanceof ByteValue) {
            v = this.dj.makeByteValue(newValue);
        } else if (this.value instanceof CharValue) {
            v = this.dj.makeCharValue(newValue);
        } else if (this.value instanceof DoubleValue) {
            v = this.dj.makeDoubleValue(newValue);
        } else if (this.value instanceof FloatValue) {
            v = this.dj.makeFloatValue(newValue);
        } else if (this.value instanceof IntegerValue) {
            v = this.dj.makeIntegerValue(newValue);
        } else if (this.value instanceof LongValue) {
            v = this.dj.makeLongValue(newValue);
        } else if (this.value instanceof ShortValue) {
            v = this.dj.makeShortValue(newValue);
        } else if (this.value instanceof StringReference) {
            v = this.dj.makeStringValue(newValue);
        } else if (this.value == null && this.clazz != null && this.clazz.name.equals("java.lang.String")) {
            v = this.dj.makeStringValue(newValue);
        }
        if (v != null) {
            return this.modifyData(v);
        }
        if (this instanceof DebugJDIDataObjectInfo && this.clazz != null && this.clazz.name.startsWith("$Oracle.Builtin.") && (_valueFieldData = DebugShared.findFieldData((DebugDataObjectInfo)((Object)this), "_value", "java.lang.String")) != null) {
            return _valueFieldData.modifyDataWithString(newValue);
        }
        return false;
    }

    public boolean canModifyDataWithData() {
        return this.owner != null;
    }

    public boolean modifyDataWithData(DebugDataInfo newValue) {
        Value v = ((DebugJDIDataInfo)newValue).value;
        return this.modifyData(v);
    }

    public boolean canModifyDataWithNewObject() {
        return this.owner != null && this.value instanceof ObjectReference && this.dj.eventThread != null;
    }

    public boolean modifyDataWithNewObject(DebugMethodInfo method, String[] arguments) {
        boolean modified = false;
        if (this.value instanceof ObjectReference && this.dj.eventThread != null) {
            ObjectReference v = null;
            List prev = this.dj.tempDisableRequests();
            try {
                try {
                    DebugJDIMethodInfo jmi = (DebugJDIMethodInfo)method;
                    ClassType ct = (ClassType)jmi.ci.getReferenceType();
                    Method m = jmi.m;
                    List<Value> argList = this.dj.makeArgumentsFromStrings(m, arguments);
                    if (argList != null) {
                        v = ct.newInstance(this.dj.eventThread, m, argList, 1);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            finally {
                DebugJDIStackFrameInfo.rebuildCache(this.dj);
                this.dj.tempReenableRequests(prev);
                this.dj.incrementStoppedCount(false);
            }
            if (v != null) {
                try {
                    modified = this.modifyData(v);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return modified;
    }

    protected boolean modifyData(Value newValue) {
        try {
            if (this.owner instanceof DebugJDIVariableInfo) {
                DebugJDIVariableInfo var = (DebugJDIVariableInfo)this.owner;
                var.djsf.sf.setValue(var.lv, newValue);
                boolean bl = true;
                return bl;
            }
            if (this.owner instanceof DebugJDIFieldInfo) {
                DebugJDIFieldInfo field = (DebugJDIFieldInfo)this.owner;
                if (field.or != null) {
                    field.or.setValue(field.field, newValue);
                    boolean bl = true;
                    return bl;
                }
                if (field.isStatic) {
                    ((ClassType)field.declaringClass.getReferenceType()).setValue(field.field, newValue);
                    boolean bl = true;
                    return bl;
                }
            } else if (this.owner instanceof DebugJDIArrayElementInfo) {
                DebugJDIArrayElementInfo elem = (DebugJDIArrayElementInfo)this.owner;
                ((ArrayReference)elem.array.value).setValue(elem.index, newValue);
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.dj.hashCode();
            if (this.clazz != null) {
                this.hashCode += 17;
                int clazzHashCode = this.clazz.hashCode();
                if (clazzHashCode != 0) {
                    this.hashCode *= clazzHashCode;
                }
            }
            if (this.value != null) {
                this.hashCode -= 13;
                int valueHashCode = this.value.hashCode();
                if (valueHashCode != 0) {
                    this.hashCode *= valueHashCode;
                }
            }
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof DebugJDIDataInfo) {
            DebugJDIDataInfo other = (DebugJDIDataInfo)o;
            return this.dj.equals(other.dj) && this.clazz.equals(other.clazz) && (this.value == null ? other.value == null : this.value.equals(other.value));
        }
        return false;
    }

    public Value getJDIValue() {
        return this.value;
    }
}

