/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.List;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIAnnotationInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugAnnotationInfo;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.DebugHasAnnotations;
import oracle.jdevimpl.debugger.support.JDIInformationProvider;

final class DebugJDIFieldInfo
extends JDIInformationProvider
implements DebugFieldInfo,
DebugHasAnnotations {
    DebugJDI dj;
    Field field;
    DebugJDIClassInfo declaringClass;
    ObjectReference or;
    int stoppedCount;
    boolean isStatic;
    private int hashCode;

    DebugJDIFieldInfo(DebugJDI dj, Field field, DebugJDIClassInfo declaringClass, ObjectReference or) {
        this.dj = dj;
        this.field = field;
        this.declaringClass = declaringClass;
        this.or = or;
        this.stoppedCount = dj.stoppedCount;
        this.isStatic = field.isStatic();
    }

    public boolean hasExpired() {
        if (this.dj.stoppedCount != this.stoppedCount && !this.isStatic && !this.declaringClass.hasExpired()) {
            this.stoppedCount = this.dj.stoppedCount;
        }
        return this.dj.stoppedCount != this.stoppedCount;
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new IllegalStateException("Field has expired");
        }
    }

    public DebugClassInfo getClassInfo() {
        DebugJDIClassInfo c;
        this.throwIfExpired();
        try {
            DebugJDIClassInfo c2 = this.dj.findClassByType(this.field.type());
            if (c2 != null) {
                DebugJDIClassInfo debugJDIClassInfo = c2;
                return debugJDIClassInfo;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Value v = null;
        if (this.or != null) {
            v = this.or.getValue(this.field);
        } else if (this.isStatic) {
            v = this.declaringClass.getReferenceType().getValue(this.field);
        }
        if (v != null && (c = this.dj.findClassByType(v.type())) != null) {
            return c;
        }
        return this.dj.findClassByName(this.field.typeName(), true);
    }

    public String getGenericSignature() {
        return this.field.genericSignature();
    }

    public DebugClassInfo getDeclaringClassInfo() {
        this.hasExpired();
        return this.dj.findClassByType(this.field.declaringType());
    }

    public boolean isStatic() {
        this.throwIfExpired();
        return this.isStatic;
    }

    public boolean isFinal() {
        this.throwIfExpired();
        return this.field.isFinal();
    }

    public String getName() {
        this.throwIfExpired();
        return this.field.name();
    }

    public int getAccess() {
        this.throwIfExpired();
        return this.field.modifiers();
    }

    public DebugDataInfo getDataInfo() {
        this.throwIfExpired();
        boolean gotValue = false;
        Value v = null;
        if (this.or != null) {
            v = this.or.getValue(this.field);
            gotValue = true;
        } else if (this.isStatic) {
            v = this.declaringClass.getReferenceType().getValue(this.field);
            gotValue = true;
        }
        if (gotValue) {
            DebugJDIDataInfo data = v != null ? this.dj.makeData(v, this) : this.dj.makeNullData((DebugJDIClassInfo)this.getClassInfo(), this);
            if (this.isStatic) {
                data.setStaticField(this);
            }
            return data;
        }
        return null;
    }

    Value updateStaticFieldValue() {
        return this.declaringClass.getReferenceType().getValue(this.field);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.field.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof DebugJDIFieldInfo) {
            DebugJDIFieldInfo other = (DebugJDIFieldInfo)o;
            return this.field.equals(other.field);
        }
        return false;
    }

    public int countAnnotations() {
        this.throwIfExpired();
        if (this.dj.isRIM()) {
            return 0;
        }
        return this.getAnnotations().length;
    }

    public DebugAnnotationInfo[] getAnnotations() {
        this.throwIfExpired();
        try {
            ObjectReference orField = this.getReflectedField();
            if (orField != null) {
                DebugAnnotationInfo[] debugAnnotationInfoArray = this.dj.getAnnotations(orField);
                return debugAnnotationInfoArray;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new DebugJDIAnnotationInfo[0];
    }

    private ObjectReference getReflectedField() {
        try {
            ClassType ctClass;
            Method mGetDeclaredField;
            ClassObjectReference orClass;
            ReferenceType rt;
            if (this.dj.eventThread != null && (rt = this.field.declaringType()) != null && (orClass = rt.classObject()) != null && (mGetDeclaredField = (ctClass = (ClassType)orClass.referenceType()).concreteMethodByName("getDeclaredField", "(Ljava/lang/String;)Ljava/lang/reflect/Field;")) != null) {
                ArrayList<StringReference> argsGetDeclaredField = new ArrayList<StringReference>(1);
                argsGetDeclaredField.add(this.dj.vm.mirrorOf(this.field.name()));
                List prev = this.dj.tempDisableRequests();
                try {
                    ObjectReference orField;
                    ObjectReference objectReference = orField = (ObjectReference)orClass.invokeMethod(this.dj.eventThread, mGetDeclaredField, argsGetDeclaredField, 1);
                    return objectReference;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    DebugJDIStackFrameInfo.rebuildCache(this.dj);
                    this.dj.tempReenableRequests(prev);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    public Field getJDIField() {
        return this.field;
    }
}

