/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataCompositeInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIHeapAncestorOutsideHeap;
import oracle.jdevimpl.debugger.jdi.DebugJDIStackFrameInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIThreadInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIVariableInfo;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugHeapAncestorInStack;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;

final class DebugJDIHeapAncestorInStack
extends DebugJDIHeapAncestorOutsideHeap
implements DebugHeapAncestorInStack {
    DebugJDIThreadInfo thread;
    DebugJDIStackFrameInfo stackframe;
    DebugJDIVariableInfo variable;

    DebugJDIHeapAncestorInStack(DebugJDI dj, long address, DebugJDIThreadInfo thread, DebugJDIStackFrameInfo stackframe, DebugJDIVariableInfo variable) {
        super(dj, address);
        this.thread = thread;
        this.stackframe = stackframe;
        this.variable = variable;
    }

    public DebugThreadInfo getThread() {
        return this.thread;
    }

    public DebugStackFrameInfo getStackFrame() {
        return this.stackframe;
    }

    public DebugVariableInfo getVariableInfo() {
        return this.variable;
    }

    public DebugDataCompositeInfo getDataInfo() {
        DebugDataInfo variableData;
        if (this.data != null) {
            return this.data;
        }
        if (this.variable != null && (variableData = this.variable.getDataInfo()) instanceof DebugJDIDataCompositeInfo) {
            this.data = (DebugJDIDataCompositeInfo)variableData;
            return this.data;
        }
        return super.getDataInfo();
    }

    public boolean equals(Object o) {
        if (o instanceof DebugJDIHeapAncestorInStack) {
            DebugJDIHeapAncestorInStack other = (DebugJDIHeapAncestorInStack)o;
            return super.equals(o) && this.thread.equals(other.thread) && (this.stackframe == null ? other.stackframe == null : this.stackframe.equals(other.stackframe)) && (this.variable == null ? other.variable == null : this.variable.equals(other.variable));
        }
        return false;
    }
}

