/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIHeapAncestorInsideHeap;
import oracle.jdevimpl.debugger.jdi.DebugJDIHeapAncestorOutsideHeap;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugHeapAncestorInsideHeap;
import oracle.jdevimpl.debugger.support.DebugHeapAncestorOutsideHeap;
import oracle.jdevimpl.debugger.support.DebugHeapInfo;
import oracle.jdevimpl.debugger.support.DebugHeapObjectInfo;
import oracle.jdevimpl.debugger.support.DebugHeapSubset;
import oracle.jdevimpl.debugger.support.DebugHeapSubsetAncestors;

final class DebugJDIHeapInfo
implements DebugHeapInfo {
    DebugJDI dj;
    DebugHeapSubset subset;
    int stoppedCount;
    DebugJDIHeapAncestorOutsideHeap[] heapAncestorsOutsideHeap;
    long[] heapAddresses;
    int[] depths;
    DebugJDIHeapAncestorInsideHeap[] heapAncestorsInsideHeap;
    private int hashCode;

    DebugJDIHeapInfo(DebugJDI dj, DebugHeapSubset subset, DebugJDIHeapAncestorOutsideHeap[] heapAncestorsOutsideHeap, long[] heapAddresses, int[] depths) {
        this.dj = dj;
        this.subset = subset;
        this.stoppedCount = dj.stoppedCount;
        this.heapAddresses = heapAddresses;
        this.depths = depths;
        ArrayList<DebugJDIHeapAncestorOutsideHeap> temp = new ArrayList<DebugJDIHeapAncestorOutsideHeap>();
        int maxDepth = -1;
        if (subset instanceof DebugHeapSubsetAncestors) {
            maxDepth = ((DebugHeapSubsetAncestors)subset).getDepth();
        }
        int length = heapAncestorsOutsideHeap.length;
        int i = 0;
        while (i < length) {
            DebugJDIHeapAncestorOutsideHeap ancestor = heapAncestorsOutsideHeap[i];
            long address = ancestor.getAddress();
            int depth = this.getDepth(address) + 1;
            if (maxDepth == -1 || depth <= maxDepth) {
                ancestor.setDepth(depth);
                temp.add(ancestor);
            }
            ++i;
        }
        this.heapAncestorsOutsideHeap = temp.toArray(new DebugJDIHeapAncestorOutsideHeap[temp.size()]);
    }

    public boolean hasExpired() {
        return this.dj.stoppedCount != this.stoppedCount;
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new IllegalStateException("HeapInfo has expired");
        }
    }

    public DebugHeapAncestorOutsideHeap[] getAncestorsOutsideHeap() {
        return this.heapAncestorsOutsideHeap;
    }

    public DebugHeapAncestorInsideHeap[] getAncestorsInsideHeap() {
        if (this.heapAncestorsInsideHeap == null) {
            if (this.subset instanceof DebugHeapSubsetAncestors) {
                int length = this.heapAddresses.length;
                if (this.depths != null && this.depths.length == length) {
                    1HeapAddressAndDepth[] a = new 1HeapAddressAndDepth[this.heapAddresses.length];
                    int i = 0;
                    while (i < length) {
                        a[i] = new 1HeapAddressAndDepth(this.heapAddresses[i], this.depths[i]);
                        ++i;
                    }
                    Arrays.sort(a, new 1());
                    this.heapAncestorsInsideHeap = new DebugJDIHeapAncestorInsideHeap[length];
                    int i2 = 0;
                    while (i2 < length) {
                        this.heapAncestorsInsideHeap[i2] = new DebugJDIHeapAncestorInsideHeap(this.dj, a[i2].heapAddress);
                        this.heapAncestorsInsideHeap[i2].setDepth(a[i2].depth);
                        ++i2;
                    }
                } else {
                    this.heapAncestorsInsideHeap = new DebugJDIHeapAncestorInsideHeap[0];
                }
            } else {
                this.heapAncestorsInsideHeap = new DebugJDIHeapAncestorInsideHeap[0];
            }
        }
        return this.heapAncestorsInsideHeap;
    }

    public long[] getHeapAddresses() {
        return this.heapAddresses;
    }

    public int[] getHeapAncestorDepths() {
        return this.depths;
    }

    public int getDepth(long address) {
        if (this.subset instanceof DebugHeapSubsetAncestors) {
            int index;
            long searchedAddress = ((DebugHeapSubsetAncestors)this.subset).getAddress();
            if (address == searchedAddress) {
                return 0;
            }
            if (this.depths != null && (index = Arrays.binarySearch(this.heapAddresses, address)) >= 0) {
                return this.depths[index];
            }
        }
        return -1;
    }

    public int getDepth(DebugDataCompositeInfo data) {
        return this.getDepth(data.getAddressOfObject());
    }

    public DebugHeapObjectInfo[] getHeapObjects(int start, int count) {
        this.throwIfExpired();
        if (start == 0 && count == 0) {
            count = this.heapAddresses.length;
        }
        if (start + count > this.heapAddresses.length) {
            count = this.heapAddresses.length - start;
        }
        return this.dj.getHeapObjects(this.heapAddresses, start, count);
    }

    public int countHeapObjects() {
        return this.heapAddresses.length;
    }

    public DebugHeapSubset getHeapSubset() {
        return this.subset;
    }

    public int hashCode() {
        if (this.hashCode == 0 && this.subset != null) {
            this.hashCode = this.subset.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof DebugJDIHeapInfo) {
            DebugJDIHeapInfo other = (DebugJDIHeapInfo)o;
            return this.dj.equals(other.dj) && (this.subset == null ? other.subset == null : this.subset.equals(other.subset));
        }
        return false;
    }

    class 1HeapAddressAndDepth {
        long heapAddress;
        int depth;

        1HeapAddressAndDepth(long heapAddress, int depth) {
            this.heapAddress = heapAddress;
            this.depth = depth;
        }
    }

    final class 1
    implements Comparator {
        public int compare(Object o1, Object o2) {
            return ((1HeapAddressAndDepth)o1).depth - ((1HeapAddressAndDepth)o2).depth;
        }
    }
}

