/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import java.util.List;
import oracle.ide.util.Assert;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIMethodInfo;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;

public final class DebugJDILocation
implements DebugLocation {
    DebugJDI dj;
    Location location;
    DebugJDIClassInfo clazz;
    Method m;
    DebugJDIMethodInfo method;
    int line;
    boolean exactLine;

    DebugJDILocation(DebugJDI dj, Location location) {
        this.dj = dj;
        this.location = location;
        ReferenceType rt = location.declaringType();
        String defaultStratum = rt.defaultStratum();
        this.clazz = dj.findClass(rt);
        this.m = location.method();
        this.method = new DebugJDIMethodInfo(dj, this.clazz, this.m);
        try {
            if (!this.m.isNative()) {
                this.line = DebugJDI.getLineNumber(location, defaultStratum);
            }
        }
        catch (InternalError e) {
            Assert.println((String)("Ignoring " + e + " (while getting lineNumber from location)."));
        }
        if (this.line > 0) {
            try {
                List locationsOfLine = DebugJDI.getLocationsOfLine(this.m, null, null, this.line);
                Location first = DebugJDI.getFirstLocation(locationsOfLine);
                if (first != null && first.codeIndex() == location.codeIndex()) {
                    this.exactLine = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public DebugMethodInfo getMethod() {
        return this.method;
    }

    public DebugClassInfo getClassInfo() {
        return this.clazz;
    }

    public String getPath() {
        try {
            String string = this.location.sourcePath();
            return string;
        }
        catch (AbsentInformationException absentInformationException) {
            return "";
        }
    }

    public String getFilename() {
        try {
            String string = this.location.sourceName();
            return string;
        }
        catch (AbsentInformationException absentInformationException) {
        }
        catch (InternalError e) {
            Assert.println((String)("Ignoring " + e + " (while getting sourceName from location)."));
        }
        return "";
    }

    public long getAddress() {
        return 0L;
    }

    public int getBytecodeOffset() {
        if (!this.m.isNative()) {
            return (int)this.location.codeIndex();
        }
        return -1;
    }

    public boolean isBytecodeExact() {
        return true;
    }

    public int getLine() {
        return this.line;
    }

    public boolean isLineExact() {
        return this.exactLine;
    }

    public int hashCode() {
        return this.location.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof DebugJDILocation) {
            DebugJDILocation other = (DebugJDILocation)o;
            return this.location.equals(other.location);
        }
        return false;
    }
}

