/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.ide.model.Project;
import oracle.ide.util.Assert;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIAnnotationInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataObjectInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDILocation;
import oracle.jdevimpl.debugger.jdi.DebugJDIStackFrameInfo;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.shared.DebugSharedDisassemble;
import oracle.jdevimpl.debugger.support.DebugAnnotationInfo;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDisassembleInfo;
import oracle.jdevimpl.debugger.support.DebugHasAnnotations;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;

final class DebugJDIMethodInfo
implements DebugMethodInfo,
DebugHasAnnotations {
    static final String javaStratum = "Java";
    DebugJDI dj;
    DebugJDIClassInfo ci;
    Method m;
    String name;
    private static Map hashBytecodes;
    private static Map hashBytecodesStoppedCount;
    private List javaLineLocations;
    private int hashCode;

    DebugJDIMethodInfo(DebugJDI dj, DebugJDIClassInfo ci, Method m) {
        this.dj = dj;
        this.ci = ci;
        this.m = m;
        this.name = DebugJDIMethodInfo.getFullMethodName(ci.name, m);
        if (hashBytecodes == null) {
            hashBytecodes = new HashMap();
            hashBytecodesStoppedCount = new HashMap();
        }
    }

    public DebugVirtualMachine getVM() {
        return this.dj;
    }

    public boolean hasExpired() {
        return this.ci.hasExpired();
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new IllegalStateException("Method has expired");
        }
    }

    public DebugClassInfo getClassInfo() {
        return this.ci;
    }

    public boolean isCompiled() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getNameWithoutClass() {
        return DebugShared.getNameWithoutClass(this.name);
    }

    public String getNameWithoutSignature() {
        return DebugShared.getNameWithoutSignature(this.name);
    }

    public String getNameWithoutClassOrSignature() {
        return DebugShared.getNameWithoutClassOrSignature(this.name);
    }

    public String getParameterSignature() {
        return DebugShared.getMethodParameterSignature(this.name);
    }

    public int getAccess() {
        this.throwIfExpired();
        return this.m.modifiers();
    }

    private List getJavaLineLocations() {
        if (this.javaLineLocations == null) {
            try {
                List<String> filenames;
                ReferenceType rt = this.ci.getReferenceType();
                if (rt != null && (filenames = rt.sourceNames(javaStratum)) != null && filenames.size() >= 1) {
                    String filename = filenames.get(0);
                    this.javaLineLocations = this.m.allLineLocations(javaStratum, filename);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.javaLineLocations;
    }

    private byte[] getOldBytecodes() {
        return (byte[])hashBytecodes.get(this.name);
    }

    private byte[] getBytecodesSmart() {
        int bytecodesStoppedCount;
        byte[] bytecodes = (byte[])hashBytecodes.get(this.name);
        Integer i = (Integer)hashBytecodesStoppedCount.get(this.name);
        int n = bytecodesStoppedCount = i != null ? i : 0;
        if (bytecodes == null || bytecodesStoppedCount != this.dj.stoppedCount) {
            this.dj.tempDisableBreakpoints();
            try {
                try {
                    bytecodes = this.m.bytecodes();
                    bytecodesStoppedCount = this.dj.stoppedCount;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    bytecodes = new byte[]{};
                    bytecodesStoppedCount = this.dj.stoppedCount;
                }
            }
            finally {
                this.dj.tempReenableBreakpoints();
            }
            hashBytecodes.put(this.name, bytecodes);
            hashBytecodesStoppedCount.put(this.name, new Integer(bytecodesStoppedCount));
        }
        return bytecodes;
    }

    public int[] getMethodLineRange() {
        this.throwIfExpired();
        int[] lines = new int[]{0, 0};
        List locations = this.getJavaLineLocations();
        if (locations != null) {
            int i = 0;
            while (i < locations.size()) {
                Location location = (Location)locations.get(i);
                int line = DebugJDI.getLineNumber(location, javaStratum);
                if (line < lines[0] || lines[0] == 0) {
                    lines[0] = line;
                }
                if (line > lines[1] || lines[1] == 0) {
                    lines[1] = line;
                }
                ++i;
            }
        }
        return lines;
    }

    public int[] getMethodLines() {
        this.throwIfExpired();
        List locations = this.getJavaLineLocations();
        if (locations != null) {
            int[] lines = new int[locations.size()];
            int i = 0;
            while (i < locations.size()) {
                Location location = (Location)locations.get(i);
                lines[i] = DebugJDI.getLineNumber(location, javaStratum);
                ++i;
            }
            return lines;
        }
        return new int[0];
    }

    public int[] getCodeCoverage() {
        return new int[0];
    }

    public double getCodeCoverageRatio() {
        return 0.0;
    }

    public DebugLocation getFirstLocation() {
        this.throwIfExpired();
        try {
            int first = 0;
            Location firstLocation = null;
            String defaultStratum = this.ci.getReferenceType().defaultStratum();
            List locations = this.getJavaLineLocations();
            if (locations != null) {
                int i = 0;
                while (i < locations.size()) {
                    int line;
                    Location location = (Location)locations.get(i);
                    if (DebugJDI.getLineNumber(location, defaultStratum) != -1 && ((line = DebugJDI.getLineNumber(location, javaStratum)) < first || first == 0)) {
                        first = line;
                        firstLocation = location;
                    }
                    ++i;
                }
            }
            if (firstLocation != null) {
                DebugJDILocation debugJDILocation = this.dj.makeLocation(firstLocation);
                return debugJDILocation;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public DebugLocation getLocation(String filename, int line) {
        this.throwIfExpired();
        try {
            ReferenceType rt = this.ci.getReferenceType();
            if (rt != null) {
                List<String> availableStrata = rt.availableStrata();
                for (String stratum : availableStrata) {
                    List locationsOfLine = DebugJDI.getLocationsOfLine(this.m, stratum, filename, line);
                    Location first = DebugJDI.getFirstLocation(locationsOfLine);
                    if (first == null) continue;
                    DebugJDILocation debugJDILocation = this.dj.makeLocation(first);
                    return debugJDILocation;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public DebugDisassembleInfo[] disassembleMethod(boolean java, boolean bytecode, boolean assembly, Project project) {
        if (this.dj.canDisassembleMethod()) {
            int[] lineNumbers = null;
            int[] bcOffsets = null;
            if (java) {
                List lines = this.getJavaLineLocations();
                int size = lines.size();
                lineNumbers = new int[size];
                bcOffsets = new int[size];
                int i = 0;
                while (i < size) {
                    Location location = (Location)lines.get(i);
                    lineNumbers[i] = DebugJDI.getLineNumber(location, javaStratum);
                    bcOffsets[i] = (int)location.codeIndex();
                    ++i;
                }
            }
            String className = this.getClassInfo().getName();
            DebugSharedDisassemble d = new DebugSharedDisassemble(java, bytecode, this.getBytecodesSmart(), lineNumbers, bcOffsets, project, className);
            return d.getArray();
        }
        return new DebugDisassembleInfo[0];
    }

    public boolean hasMethodChanged() {
        byte[] oldBytecodes = this.getOldBytecodes();
        if (oldBytecodes == null) {
            return true;
        }
        byte[] newBytecodes = this.getBytecodesSmart();
        if (oldBytecodes == newBytecodes) {
            return false;
        }
        if (oldBytecodes.length != newBytecodes.length) {
            return true;
        }
        int i = 0;
        while (i < oldBytecodes.length) {
            if (oldBytecodes[i] != newBytecodes[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public byte[] getBytecodes() {
        byte[] bytecodes = this.getBytecodesSmart();
        byte[] b = new byte[bytecodes.length];
        System.arraycopy(bytecodes, 0, b, 0, bytecodes.length);
        return b;
    }

    public byte getBytecode(int offset) {
        byte[] bytecodes = this.getBytecodesSmart();
        if (offset >= 0 && offset < bytecodes.length) {
            return bytecodes[offset];
        }
        return 0;
    }

    public DebugDataInfo invoke(List arguments) {
        if (this.dj.eventThread != null) {
            Value value;
            block14: {
                Object o;
                int argumentsSize = arguments.size();
                int i = 0;
                ArrayList<Value> argList = new ArrayList<Value>(argumentsSize);
                ClassType ct = null;
                ObjectReference or = null;
                if (this.m.isStatic()) {
                    ct = (ClassType)this.ci.getReferenceType();
                } else if ((o = arguments.get(i++)) instanceof DebugJDIDataObjectInfo) {
                    DebugJDIDataObjectInfo ddoi = (DebugJDIDataObjectInfo)o;
                    or = (ObjectReference)ddoi.value;
                } else if (o instanceof String) {
                    or = this.dj.makeStringValue((String)o);
                }
                while (i < argumentsSize) {
                    Object argument = arguments.get(i++);
                    Value argValue = this.dj.makeValue(argument);
                    argList.add(argValue);
                }
                value = null;
                List prev = this.dj.tempDisableRequests();
                try {
                    try {
                        if (ct != null) {
                            value = ct.invokeMethod(this.dj.eventThread, this.m, argList, 1);
                            break block14;
                        }
                        value = or.invokeMethod(this.dj.eventThread, this.m, argList, 3);
                    }
                    catch (Exception e) {
                        Assert.println((String)("invokeMethod threw " + e));
                    }
                }
                finally {
                    DebugJDIStackFrameInfo.rebuildCache(this.dj);
                    this.dj.tempReenableRequests(prev);
                }
            }
            if (value != null) {
                return this.dj.makeData(value, null);
            }
        }
        return null;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.m.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof DebugJDIMethodInfo) {
            DebugJDIMethodInfo other = (DebugJDIMethodInfo)o;
            return this.m.equals(other.m);
        }
        return false;
    }

    public int countAnnotations() {
        this.throwIfExpired();
        if (this.dj.isRIM()) {
            return 0;
        }
        return this.getAnnotations().length;
    }

    public DebugAnnotationInfo[] getAnnotations() {
        this.throwIfExpired();
        try {
            ObjectReference orMethodOrConstructor = DebugJDIMethodInfo.getReflectedMethodOrConstructor(this.dj, this.m);
            if (orMethodOrConstructor != null) {
                DebugAnnotationInfo[] debugAnnotationInfoArray = this.dj.getAnnotations(orMethodOrConstructor);
                return debugAnnotationInfoArray;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new DebugJDIAnnotationInfo[0];
    }

    static ObjectReference getReflectedMethodOrConstructor(DebugJDI dj, Method m) {
        try {
            ClassObjectReference orClass;
            ReferenceType rt;
            if (dj.eventThread != null && (rt = m.declaringType()) != null && (orClass = rt.classObject()) != null) {
                Method mGetDeclaredMethodOrConstructor;
                ClassType ctClass = (ClassType)orClass.referenceType();
                boolean isConstructor = m.isConstructor();
                Method method = mGetDeclaredMethodOrConstructor = isConstructor ? ctClass.concreteMethodByName("getDeclaredConstructor", "([Ljava/lang/Class;)Ljava/lang/reflect/Constructor;") : ctClass.concreteMethodByName("getDeclaredMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;");
                if (mGetDeclaredMethodOrConstructor != null) {
                    ArrayList<ObjectReference> argsGetDeclaredMethodOrConstructor = new ArrayList<ObjectReference>(isConstructor ? 1 : 2);
                    if (!isConstructor) {
                        argsGetDeclaredMethodOrConstructor.add(dj.vm.mirrorOf(m.name()));
                    }
                    ArrayType atClass = (ArrayType)mGetDeclaredMethodOrConstructor.argumentTypes().get(isConstructor ? 0 : 1);
                    List<Type> argumentTypes = m.argumentTypes();
                    int countArguments = argumentTypes.size();
                    ArrayReference arParameterTypes = atClass.newInstance(countArguments);
                    int i = 0;
                    while (i < countArguments) {
                        DebugJDIClassInfo classInfo = dj.findClassByType(argumentTypes.get(i));
                        ClassObjectReference cor = classInfo.getClassObjectReference();
                        arParameterTypes.setValue(i, (Value)cor);
                        ++i;
                    }
                    argsGetDeclaredMethodOrConstructor.add(arParameterTypes);
                    List prev = dj.tempDisableRequests();
                    try {
                        ObjectReference orMethodOrConstructor;
                        ObjectReference objectReference = orMethodOrConstructor = (ObjectReference)orClass.invokeMethod(dj.eventThread, mGetDeclaredMethodOrConstructor, argsGetDeclaredMethodOrConstructor, 1);
                        return objectReference;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        DebugJDIStackFrameInfo.rebuildCache(dj);
                        dj.tempReenableRequests(prev);
                    }
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    static String getFullMethodName(String c, Method m) {
        String s = m.returnTypeName() + " " + c + "." + m.name() + "(";
        List<String> args = m.argumentTypeNames();
        int i = 0;
        while (i < args.size()) {
            s = s + args.get(i);
            if (i + 1 < args.size()) {
                s = s + ", ";
            }
            ++i;
        }
        s = s + ")";
        return s;
    }

    public Method getJDIMethod() {
        return this.m;
    }
}

