/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.ide.util.Assert;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIStackFrameInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIThreadInfo;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMonitorInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;

final class DebugJDIMonitorInfo
implements DebugMonitorInfo {
    DebugJDI dj;
    ObjectReference or;
    int stoppedCount;
    private int hashCode;

    DebugJDIMonitorInfo(DebugJDI dj, ObjectReference or) {
        this.dj = dj;
        this.or = or;
        this.stoppedCount = dj.stoppedCount;
    }

    public boolean hasExpired() {
        return this.dj.stoppedCount != this.stoppedCount;
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new IllegalStateException("MonitorInfo has expired");
        }
    }

    public boolean isClassMonitor() {
        return this.or instanceof ClassObjectReference;
    }

    public boolean isInstanceMonitor() {
        return this.or instanceof ClassObjectReference ^ true;
    }

    public int getEntryCount() {
        this.throwIfExpired();
        try {
            int n = this.or.entryCount();
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int getWaiterCount() {
        this.throwIfExpired();
        try {
            int countWaiting = 0;
            List<ThreadReference> threads = this.or.waitingThreads();
            int i = 0;
            while (i < threads.size()) {
                ThreadReference tr = threads.get(i);
                if (tr.status() == 4) {
                    ++countWaiting;
                }
                ++i;
            }
            List otherThreads = this.dj.getOtherWaitingThreads(this.or);
            if (otherThreads != null) {
                int i2 = 0;
                while (i2 < otherThreads.size()) {
                    ThreadReference tr = (ThreadReference)otherThreads.get(i2);
                    if (!threads.contains(tr)) {
                        ++countWaiting;
                    }
                    ++i2;
                }
            }
            int n = countWaiting;
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public DebugThreadInfo getOwnerThread() {
        this.throwIfExpired();
        try {
            ThreadReference tr = this.or.owningThread();
            if (tr != null) {
                DebugJDIThreadInfo debugJDIThreadInfo = DebugJDIThreadInfo.makeThreadInfo(this.dj, tr);
                return debugJDIThreadInfo;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public DebugThreadInfo[] listWaitingThreads() {
        this.throwIfExpired();
        try {
            ArrayList<DebugJDIThreadInfo> v = new ArrayList<DebugJDIThreadInfo>();
            List<ThreadReference> threads = this.or.waitingThreads();
            int i = 0;
            while (i < threads.size()) {
                ThreadReference tr = threads.get(i);
                if (tr.status() == 4) {
                    v.add(DebugJDIThreadInfo.makeThreadInfo(this.dj, tr));
                }
                ++i;
            }
            List otherThreads = this.dj.getOtherWaitingThreads(this.or);
            if (otherThreads != null) {
                int i2 = 0;
                while (i2 < otherThreads.size()) {
                    ThreadReference tr = (ThreadReference)otherThreads.get(i2);
                    if (!threads.contains(tr)) {
                        v.add(DebugJDIThreadInfo.makeThreadInfo(this.dj, tr));
                    }
                    ++i2;
                }
            }
            DebugThreadInfo[] array = new DebugThreadInfo[v.size()];
            DebugThreadInfo[] debugThreadInfoArray = v.toArray(array);
            return debugThreadInfoArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new DebugThreadInfo[0];
        }
    }

    public DebugThreadInfo[] listBlockedThreads() {
        this.throwIfExpired();
        try {
            List<ThreadReference> threads = this.or.waitingThreads();
            ArrayList<DebugJDIThreadInfo> v = new ArrayList<DebugJDIThreadInfo>();
            int i = 0;
            while (i < threads.size()) {
                ThreadReference tr = threads.get(i);
                if (tr.status() == 3) {
                    v.add(DebugJDIThreadInfo.makeThreadInfo(this.dj, tr));
                }
                ++i;
            }
            DebugThreadInfo[] array = new DebugThreadInfo[v.size()];
            DebugThreadInfo[] debugThreadInfoArray = v.toArray(array);
            return debugThreadInfoArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new DebugThreadInfo[0];
        }
    }

    public DebugDataCompositeInfo getAssociatedObject() {
        this.throwIfExpired();
        return (DebugDataCompositeInfo)((Object)this.dj.makeData(this.or, null));
    }

    public DebugLocation getEntryLocation() {
        return null;
    }

    public boolean canDoNotify() {
        try {
            if (this.dj.eventThread != null && this.dj.eventThread == this.or.owningThread()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void doNotify() {
        this.invokeNotify("notify");
    }

    public void doNotifyAll() {
        this.invokeNotify("notifyAll");
    }

    private void invokeNotify(String methodName) {
        Method method;
        DebugJDIClassInfo objectClass;
        if (this.canDoNotify() && (objectClass = this.dj.findClassByName("java.lang.Object", false)) != null && objectClass.type instanceof ClassType && (method = ((ClassType)objectClass.type).concreteMethodByName(methodName, "()V")) != null) {
            List prev = this.dj.tempDisableRequests();
            try {
                try {
                    this.or.invokeMethod(this.dj.eventThread, method, Collections.EMPTY_LIST, 1);
                }
                catch (Exception e) {
                    Assert.printStackTrace((Throwable)e);
                }
            }
            finally {
                DebugJDIStackFrameInfo.rebuildCache(this.dj);
                this.dj.tempReenableRequests(prev);
            }
        }
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.or.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof DebugJDIMonitorInfo) {
            DebugJDIMonitorInfo other = (DebugJDIMonitorInfo)o;
            return this.or.equals(other.or);
        }
        return false;
    }
}

