/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDILocation;
import oracle.jdevimpl.debugger.jdi.DebugJDIPlsqlTableElement;
import oracle.jdevimpl.debugger.jdi.DebugJDIStoppedListener;
import oracle.jdevimpl.debugger.jdi.DebugJDIVariableInfo;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugStackSlotInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;
import oracle.jdevimpl.debugger.support.JDIInformationProvider;

final class DebugJDIStackFrameInfo
extends JDIInformationProvider
implements DebugStackFrameInfo,
DebugJDIStoppedListener {
    DebugJDI dj;
    ThreadReference tr;
    int frameNumber;
    StackFrame sf;
    int stoppedCount;
    boolean popped;
    DebugJDILocation location;
    private boolean stoppedListener;
    private SoftReference sfThisObject;
    private SoftReference sfMethodVariables;
    private SoftReference sfArguments;
    private SoftReference sfLocals;
    private int hashCode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DebugJDIStackFrameInfo makeStackFrameInfo(DebugJDI dj, ThreadReference tr, int frameNumber, StackFrame sf) {
        DebugJDI debugJDI = dj;
        synchronized (debugJDI) {
            try {
                DebugJDIStackFrameInfo stackFrameInfo;
                SoftReference soft = (SoftReference)dj.stackFrameInfos.get(sf);
                if (soft != null && (stackFrameInfo = (DebugJDIStackFrameInfo)soft.get()) != null) {
                    DebugJDIStackFrameInfo debugJDIStackFrameInfo = stackFrameInfo;
                    return debugJDIStackFrameInfo;
                }
            }
            catch (Exception e) {
                DebugJDIStackFrameInfo.clearCache(dj);
            }
            DebugJDIStackFrameInfo stackFrameInfo = new DebugJDIStackFrameInfo(dj, tr, frameNumber, sf);
            dj.stackFrameInfos.put(sf, new SoftReference<DebugJDIStackFrameInfo>(stackFrameInfo));
            DebugJDIStackFrameInfo debugJDIStackFrameInfo = stackFrameInfo;
            return debugJDIStackFrameInfo;
        }
    }

    private DebugJDIStackFrameInfo(DebugJDI dj, ThreadReference tr, int frameNumber, StackFrame sf) {
        this.dj = dj;
        this.tr = tr;
        this.frameNumber = frameNumber;
        this.sf = sf;
        this.stoppedCount = dj.stoppedCount;
        this.location = dj.makeLocation(sf.location());
    }

    public void stopped(boolean stopped) {
        this.clearSoftReferences();
        this.stoppedListener = false;
        this.dj.removeStoppedListener(this);
    }

    private void clearSoftReferences() {
        this.sfThisObject = null;
        this.sfMethodVariables = null;
        this.sfArguments = null;
        this.sfLocals = null;
    }

    public boolean hasExpired() {
        return this.stoppedCount != this.dj.stoppedCount || this.popped;
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new IllegalStateException("StackFrame has expired");
        }
    }

    public int getFrameNumber() {
        return this.frameNumber;
    }

    public DebugLocation getLocation() {
        return this.location;
    }

    private ObjectReference getThisObject() {
        try {
            Object o;
            if (this.sfThisObject != null && (o = this.sfThisObject.get()) != null) {
                ObjectReference objectReference = (ObjectReference)o;
                return objectReference;
            }
            if (this.dj.isMethodObsolete(this.sf.location().method())) {
                ObjectReference objectReference = null;
                return objectReference;
            }
            ObjectReference thisObject = this.sf.thisObject();
            if (thisObject != null) {
                this.sfThisObject = new SoftReference<ObjectReference>(thisObject);
                if (!this.stoppedListener) {
                    this.stoppedListener = true;
                    this.dj.addStoppedListener(this);
                }
            }
            ObjectReference objectReference = thisObject;
            return objectReference;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private List getVariables() {
        try {
            ArrayList<LocalVariable> variables;
            Object o;
            if (this.sfMethodVariables != null && (o = this.sfMethodVariables.get()) != null) {
                List list = (List)o;
                return list;
            }
            Method method = this.sf.location().method();
            if (method.isNative()) {
                variables = new ArrayList(0);
            } else {
                variables = new ArrayList<LocalVariable>();
                for (LocalVariable var : method.variables()) {
                    if (var.isArgument()) continue;
                    variables.add(var);
                }
                Collections.sort(variables, new 1());
                int argumentPosition = 0;
                for (LocalVariable var : method.arguments()) {
                    variables.add(argumentPosition, var);
                    ++argumentPosition;
                }
            }
            if (variables != null) {
                this.sfMethodVariables = new SoftReference(variables);
                if (!this.stoppedListener) {
                    this.stoppedListener = true;
                    this.dj.addStoppedListener(this);
                }
            }
            ArrayList<LocalVariable> arrayList = variables;
            return arrayList;
        }
        catch (VMDisconnectedException e) {
        }
        catch (AbsentInformationException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private DebugVariableInfo findVariableByName(DebugVariableInfo[] vars, String name) {
        int varsLength = vars.length;
        int i = 0;
        while (i < varsLength) {
            if (name.equals(vars[i].getName())) {
                return vars[i];
            }
            ++i;
        }
        return null;
    }

    public DebugVariableInfo[] listArguments() {
        List variables;
        Object o;
        this.throwIfExpired();
        if (this.sfArguments != null && (o = this.sfArguments.get()) != null) {
            return (DebugVariableInfo[])o;
        }
        ArrayList<DebugJDIVariableInfo> v = new ArrayList<DebugJDIVariableInfo>();
        ObjectReference thisObject = this.getThisObject();
        if (thisObject != null) {
            v.add(new DebugJDIVariableInfo(this.dj, this, thisObject));
        }
        if ((variables = this.getVariables()) != null) {
            int i = 0;
            while (i < variables.size()) {
                LocalVariable lv = (LocalVariable)variables.get(i);
                if (lv.isArgument()) {
                    v.add(new DebugJDIVariableInfo(this.dj, this, lv, i));
                }
                ++i;
            }
        }
        DebugVariableInfo[] arguments = v.toArray(new DebugVariableInfo[v.size()]);
        this.sfArguments = new SoftReference<DebugVariableInfo[]>(arguments);
        if (!this.stoppedListener) {
            this.stoppedListener = true;
            this.dj.addStoppedListener(this);
        }
        return arguments;
    }

    public DebugVariableInfo[] listLocals() {
        Object o;
        this.throwIfExpired();
        if (this.sfLocals != null && (o = this.sfLocals.get()) != null) {
            return (DebugVariableInfo[])o;
        }
        ArrayList<DebugJDIVariableInfo> v = new ArrayList<DebugJDIVariableInfo>();
        List variables = this.getVariables();
        if (variables != null) {
            int i = 0;
            while (i < variables.size()) {
                LocalVariable lv = (LocalVariable)variables.get(i);
                if (!lv.isArgument()) {
                    v.add(new DebugJDIVariableInfo(this.dj, this, lv));
                }
                ++i;
            }
        }
        DebugVariableInfo[] locals = v.toArray(new DebugVariableInfo[v.size()]);
        this.sfLocals = new SoftReference<DebugVariableInfo[]>(locals);
        if (!this.stoppedListener) {
            this.stoppedListener = true;
            this.dj.addStoppedListener(this);
        }
        return locals;
    }

    public DebugVariableInfo getVariable(String name) {
        block6: {
            this.throwIfExpired();
            try {
                if (this.getLanguage() == 2) {
                    ArrayList keys = new ArrayList();
                    String tableName = DebugJDIPlsqlTableElement.parseTableElement(name, keys);
                    if (tableName != null) {
                        DebugVariableInfo var = DebugJDIPlsqlTableElement.getTableElementVariable(this.listArguments(), tableName, keys, this.dj, name, true, false);
                        if (var == null) {
                            var = DebugJDIPlsqlTableElement.getTableElementVariable(this.listLocals(), tableName, keys, this.dj, name, false, true);
                        }
                        DebugVariableInfo debugVariableInfo = var;
                        return debugVariableInfo;
                    }
                    break block6;
                }
                DebugVariableInfo var = this.findVariableByName(this.listArguments(), name);
                if (var == null) {
                    var = this.findVariableByName(this.listLocals(), name);
                }
                DebugVariableInfo debugVariableInfo = var;
                return debugVariableInfo;
            }
            catch (Throwable e) {
                if (!(e instanceof ThreadDeath)) break block6;
                throw (ThreadDeath)e;
            }
        }
        return null;
    }

    public DebugStackSlotInfo[] listSlots() {
        this.throwIfExpired();
        return new DebugStackSlotInfo[0];
    }

    public int getLanguage() {
        DebugClassInfo classInfo;
        if (this.location != null && (classInfo = this.location.getClassInfo()) != null) {
            return classInfo.getLanguage();
        }
        return 0;
    }

    public boolean popBackToHere() {
        int popFrameNumber;
        this.throwIfExpired();
        if (this.dj.canPopFrames() && (popFrameNumber = this.frameNumber - 1) >= 0) {
            try {
                DebugJDIStackFrameInfo.clearCache(this.dj);
                this.tr.popFrames(this.tr.frame(popFrameNumber));
                this.dj.incrementStoppedCount(false);
                boolean bl = true;
                return bl;
            }
            catch (VMDisconnectedException vMDisconnectedException) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.tr.hashCode() + this.frameNumber;
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof DebugJDIStackFrameInfo) {
            DebugJDIStackFrameInfo other = (DebugJDIStackFrameInfo)o;
            return this.dj.equals(other.dj) && this.tr.equals(other.tr) && this.frameNumber == other.frameNumber && (this.location == null ? other.location == null : this.location.equals(other.location));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearCache(DebugJDI dj) {
        DebugJDI debugJDI = dj;
        synchronized (debugJDI) {
            dj.stackFrameInfos.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void rebuildCache(DebugJDI dj) {
        DebugJDI debugJDI = dj;
        synchronized (debugJDI) {
            ArrayList<DebugJDIStackFrameInfo> list = new ArrayList<DebugJDIStackFrameInfo>();
            for (SoftReference soft : dj.stackFrameInfos.values()) {
                DebugJDIStackFrameInfo stackFrameInfo;
                if (soft == null || (stackFrameInfo = (DebugJDIStackFrameInfo)soft.get()) == null) continue;
                list.add(stackFrameInfo);
                boolean invalid = false;
                try {
                    stackFrameInfo.sf.equals(stackFrameInfo.sf);
                }
                catch (Exception e) {
                    invalid = true;
                }
                try {
                    if (!invalid) continue;
                    stackFrameInfo.sf = stackFrameInfo.tr.frame(stackFrameInfo.frameNumber);
                    stackFrameInfo.clearSoftReferences();
                }
                catch (VMDisconnectedException e) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            dj.stackFrameInfos.clear();
            int size = list.size();
            int i = 0;
            while (i < size) {
                DebugJDIStackFrameInfo stackFrame = (DebugJDIStackFrameInfo)list.get(i);
                dj.stackFrameInfos.put(stackFrame.sf, new SoftReference<DebugJDIStackFrameInfo>(stackFrame));
                ++i;
            }
        }
    }

    public Location getJDILocation() {
        try {
            Location location = this.sf.location();
            return location;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Method getJDIMethod() {
        try {
            Method method = this.sf.location().method();
            return method;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public StackFrame getJDIStackFrame() {
        return this.sf;
    }

    final class 1
    implements Comparator {
        public int compare(LocalVariable lv1, LocalVariable lv2) {
            return lv1.compareTo(lv2);
        }
    }
}

