/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Location;
import com.sun.jdi.LongType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.event.MethodExitEvent;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassLoaderInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataObjectInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIMethodInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIMonitorInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIStackFrameInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIThreadGroupInfo;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.shared.DebugSharedDisassemble;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugClassLoaderInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugMonitorInfo;
import oracle.jdevimpl.debugger.support.DebugRegisterInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadGroupInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;
import oracle.jdevimpl.debugger.support.JDIInformationProvider;

final class DebugJDIThreadInfo
extends JDIInformationProvider
implements DebugThreadInfo {
    private static final String CONSTR_NAME = "<init>";
    private static final String EMPTY_PARAM_SIGNATURE = "()";
    DebugJDI dj;
    ThreadReference tr;
    boolean suspended;
    boolean interrupted;
    boolean debuggerStopped;
    private int hashCode;

    private void $init$() {
        this.interrupted = false;
        this.debuggerStopped = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DebugJDIThreadInfo makeThreadInfo(DebugJDI dj, ThreadReference tr) {
        Map map = dj.threadInfos;
        synchronized (map) {
            DebugJDIThreadInfo threadInfo;
            SoftReference soft = (SoftReference)dj.threadInfos.get(tr);
            if (soft != null && (threadInfo = (DebugJDIThreadInfo)soft.get()) != null) {
                DebugJDIThreadInfo debugJDIThreadInfo = threadInfo;
                return debugJDIThreadInfo;
            }
            DebugJDIThreadInfo threadInfo2 = new DebugJDIThreadInfo(dj, tr);
            dj.threadInfos.put(tr, new SoftReference<DebugJDIThreadInfo>(threadInfo2));
            DebugJDIThreadInfo debugJDIThreadInfo = threadInfo2;
            return debugJDIThreadInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void getThreadContextClassLoaders(DebugJDI dj) {
        Map map = dj.threadInfos;
        synchronized (map) {
            if (dj.stoppedCountThreadContextClassLoaders == dj.stoppedCount) {
                return;
            }
            ArrayList temp = new ArrayList();
            Iterator i = dj.threadInfos.keySet().iterator();
            while (i.hasNext()) {
                temp.add(i.next());
            }
            for (ThreadReference tr : temp) {
                DebugJDIThreadInfo threadInfo = DebugJDIThreadInfo.makeThreadInfo(dj, tr);
                threadInfo.getContextClassLoader();
            }
            dj.stoppedCountThreadContextClassLoaders = dj.stoppedCount;
        }
    }

    private DebugJDIThreadInfo(DebugJDI dj, ThreadReference tr) {
        this.$init$();
        this.dj = dj;
        this.tr = tr;
    }

    public boolean hasExited() {
        try {
            boolean bl = this.tr.status() == 0;
            return bl;
        }
        catch (ObjectCollectedException e) {
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public long getThreadId() {
        return this.tr.uniqueID();
    }

    public String getName() {
        return this.tr.name();
    }

    public String getGroupName() {
        return this.tr.threadGroup().name();
    }

    public DebugThreadGroupInfo getThreadGroup() {
        return new DebugJDIThreadGroupInfo(this.dj, this.tr.threadGroup());
    }

    public int getStatus() {
        try {
            switch (this.tr.status()) {
                default: {
                    int n = 0;
                    return n;
                }
                case 5: {
                    int n = 1;
                    return n;
                }
                case 3: {
                    int n = 2;
                    return n;
                }
                case 4: {
                    int n = 3;
                    return n;
                }
                case 2: {
                    int n = 4;
                    return n;
                }
                case 1: {
                    int n = 5;
                    return n;
                }
                case 0: 
            }
            int n = 6;
            return n;
        }
        catch (ObjectCollectedException e) {
            int n = 6;
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean isThreadSuspended() {
        return this.suspended;
    }

    public void suspendThread() {
        if (!this.suspended) {
            this.suspended = true;
            this.tr.suspend();
        }
    }

    public void resumeThread() {
        if (this.suspended) {
            this.suspended = false;
            this.tr.resume();
        }
    }

    public void interruptThread() {
        if (this.suspended) {
            this.suspended = false;
            this.tr.resume();
        }
        this.interrupted = true;
        this.tr.interrupt();
    }

    public void stopThread() {
        DebugJDIClassInfo classInfo = (DebugJDIClassInfo)this.dj.findFirstClassByName("java.lang.Throwable");
        if (classInfo == null) {
            DebugClassInfo[] list = this.dj.listClasses();
            int i = 0;
            while (i < list.length) {
                if (list[i].getName().equals("java.lang.Throwable")) {
                    classInfo = (DebugJDIClassInfo)list[i];
                    break;
                }
                ++i;
            }
        }
        if (classInfo != null) {
            DebugMethodInfo[] meths = classInfo.getMethods();
            DebugJDIMethodInfo meth = null;
            int i = 0;
            while (i < meths.length) {
                if (meths[i].getNameWithoutClassOrSignature().equals(CONSTR_NAME) && meths[i].getParameterSignature().equals(EMPTY_PARAM_SIGNATURE)) {
                    meth = (DebugJDIMethodInfo)meths[i];
                    break;
                }
                ++i;
            }
            if (meth != null) {
                this.debuggerStopped = true;
                Type type = ((DebugJDIClassInfo)meth.getClassInfo()).getJDIType();
                if (type instanceof ClassType) {
                    ClassType ct = (ClassType)type;
                    ObjectReference or = null;
                    List prev = this.dj.tempDisableRequests();
                    try {
                        try {
                            or = ct.newInstance(this.tr, meth.getJDIMethod(), Collections.EMPTY_LIST, 1);
                        }
                        catch (IncompatibleThreadStateException e) {
                            e.printStackTrace();
                        }
                        catch (InvocationException e) {
                            e.printStackTrace();
                        }
                        catch (InvalidTypeException e) {
                            e.printStackTrace();
                        }
                        catch (ClassNotLoadedException e) {
                            e.printStackTrace();
                        }
                    }
                    finally {
                        DebugJDIStackFrameInfo.rebuildCache(this.dj);
                        this.dj.tempReenableRequests(prev);
                    }
                    if (or != null) {
                        try {
                            this.tr.stop(or);
                        }
                        catch (InvalidTypeException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    public DebugDataObjectInfo getThreadObject() {
        return (DebugDataObjectInfo)((Object)this.dj.makeData(this.tr, null));
    }

    public void stepInto() {
        this.dj.stepInto(this);
    }

    public void stepOver() {
        this.dj.stepOver(this);
    }

    public void stepIntoBC() {
        this.dj.stepIntoBC(this);
    }

    public void stepOverBC() {
        this.dj.stepOverBC(this);
    }

    public void stepOut() {
        this.dj.stepOut(this);
    }

    public boolean isAtEndOfMethod() {
        try {
            short opcode;
            StackFrame sf = this.tr.frame(0);
            Location location = sf.location();
            Method m = location.method();
            long bc = location.codeIndex();
            byte[] bytecodes = m.bytecodes();
            if (bc >= 0L && bc < (long)bytecodes.length && DebugSharedDisassemble.isReturnBytecode(opcode = (short)(bytecodes[(int)bc] & 0xFF))) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }

    public void stepToEndOfMethod() {
        this.dj.stepToEndOfMethod(this);
    }

    public void stepIntoMethod(String methodName, String callerPackage, String callerFileName, int callerLine) {
        this.dj.stepIntoMethod(this, methodName, callerPackage, callerFileName, callerLine);
    }

    public int getStackFrameCount() {
        try {
            int n = this.tr.frameCount();
            return n;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public DebugStackFrameInfo getStackFrame(int frame) {
        try {
            if (frame < this.tr.frameCount()) {
                DebugJDIStackFrameInfo debugJDIStackFrameInfo = DebugJDIStackFrameInfo.makeStackFrameInfo(this.dj, this.tr, frame, this.tr.frame(frame));
                return debugJDIStackFrameInfo;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public DebugStackFrameInfo[] listStack() {
        try {
            List<StackFrame> frames = this.tr.frames();
            int size = frames.size();
            DebugStackFrameInfo[] a = new DebugStackFrameInfo[size];
            int i = 0;
            while (i < size) {
                a[i] = DebugJDIStackFrameInfo.makeStackFrameInfo(this.dj, this.tr, i, frames.get(i));
                ++i;
            }
            DebugStackFrameInfo[] debugStackFrameInfoArray = a;
            return debugStackFrameInfoArray;
        }
        catch (Exception e) {
            return new DebugStackFrameInfo[0];
        }
    }

    public DebugMonitorInfo[] listOwnedMonitors() {
        if (this.dj.canGetMonitors()) {
            try {
                List<ObjectReference> monitors = this.tr.ownedMonitors();
                DebugMonitorInfo[] a = new DebugMonitorInfo[monitors.size()];
                int i = 0;
                while (i < monitors.size()) {
                    ObjectReference or = monitors.get(i);
                    a[i] = new DebugJDIMonitorInfo(this.dj, or);
                    ++i;
                }
                DebugMonitorInfo[] debugMonitorInfoArray = a;
                return debugMonitorInfoArray;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return new DebugMonitorInfo[0];
    }

    public DebugMonitorInfo getMonitorThreadWaitingFor() {
        if (this.dj.canGetMonitors()) {
            try {
                ObjectReference or = this.dj.getWaitMonitor(this.tr);
                if (or != null) {
                    DebugJDIMonitorInfo debugJDIMonitorInfo = new DebugJDIMonitorInfo(this.dj, or);
                    return debugJDIMonitorInfo;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public DebugMonitorInfo getMonitorThreadBlockedFor() {
        if (this.dj.canGetMonitors()) {
            try {
                ObjectReference or;
                if (this.tr.status() == 3 && (or = this.tr.currentContendedMonitor()) != null) {
                    DebugJDIMonitorInfo debugJDIMonitorInfo = new DebugJDIMonitorInfo(this.dj, or);
                    return debugJDIMonitorInfo;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public DebugRegisterInfo[] listRegisters() {
        return new DebugRegisterInfo[0];
    }

    public DebugRegisterInfo[] listFloatRegisters() {
        return new DebugRegisterInfo[0];
    }

    public DebugVariableInfo getReturnValue() {
        if (this.tr == null) {
            return null;
        }
        return null;
    }

    public DebugVariableInfo getReturnedValue() {
        if (this.tr == null) {
            return null;
        }
        return null;
    }

    public boolean setLocation(DebugLocation location) {
        return false;
    }

    public DebugDataObjectInfo getContextClassLoaderObject() {
        return DebugShared.getContextClassLoaderObject(this);
    }

    public DebugClassLoaderInfo getContextClassLoader() {
        DebugJDIDataObjectInfo classLoaderObject = (DebugJDIDataObjectInfo)this.getContextClassLoaderObject();
        if (classLoaderObject != null) {
            ClassLoaderReference clr = (ClassLoaderReference)classLoaderObject.value;
            return DebugJDIClassLoaderInfo.makeClassLoaderInfo(this.dj, clr);
        }
        return null;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.tr.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof DebugJDIThreadInfo) {
            DebugJDIThreadInfo other = (DebugJDIThreadInfo)o;
            return this.tr.equals(other.tr);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearCache(DebugJDI dj, boolean stopped) {
        Map map = dj.threadInfos;
        synchronized (map) {
            ArrayList<ThreadReference> list = new ArrayList<ThreadReference>();
            boolean removeCollectedThreads = stopped && dj.isConnected();
            for (Map.Entry entry : dj.threadInfos.entrySet()) {
                ThreadReference tr = (ThreadReference)entry.getKey();
                if (removeCollectedThreads && dj.isObjectCollected(tr)) {
                    list.add(tr);
                    continue;
                }
                SoftReference soft = (SoftReference)entry.getValue();
                if (soft == null || soft.get() != null) continue;
                list.add(tr);
            }
            int size = list.size();
            int i = 0;
            while (i < size) {
                dj.threadInfos.remove(list.get(i));
                ++i;
            }
        }
    }

    public boolean isThreadInterrupted() {
        return this.interrupted;
    }

    public boolean isThreadDebuggerStopped() {
        return this.debuggerStopped;
    }

    private DebugVariableInfo makeReturnOrReturnedVariableInfo(MethodExitEvent mee, DebugDataInfo dataInfo, boolean isReturned) {
        Method m = mee.method();
        return new ReturnDebugVariableInfo(m, dataInfo, isReturned);
    }

    public Value getJDIValue() {
        return this.tr;
    }

    public boolean canDebuggerStopThread() {
        try {
            if (this.dj.eventThread != null && this.dj.eventThread == this.tr) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    class ReturnDebugVariableInfo
    implements DebugVariableInfo {
        private boolean isReturned;
        private Method m;
        private DebugDataInfo dataInfo;

        private void $init$() {
            this.isReturned = false;
        }

        ReturnDebugVariableInfo(Method m, DebugDataInfo dataInfo, boolean isReturned) {
            this.$init$();
            this.isReturned = isReturned;
            this.m = m;
            this.dataInfo = dataInfo;
        }

        private void throwIfExpired() {
            if (this.hasExpired()) {
                throw new IllegalStateException("Return value has expired");
            }
        }

        public boolean hasExpired() {
            return this.dataInfo.hasExpired();
        }

        public DebugClassInfo getClassInfo() {
            this.throwIfExpired();
            try {
                DebugJDIClassInfo debugJDIClassInfo = DebugJDIThreadInfo.this.dj.findClassByType(this.m.returnType());
                return debugJDIClassInfo;
            }
            catch (Exception exception) {
                return null;
            }
        }

        public String getGenericSignature() {
            this.throwIfExpired();
            return this.m.genericSignature();
        }

        public String getName() {
            if (this.isReturned()) {
                return this.m.name();
            }
            return "";
        }

        public boolean isInScope() {
            return true;
        }

        public boolean isArgument() {
            return false;
        }

        public boolean isLocal() {
            return false;
        }

        public boolean isReturn() {
            return this.isReturned ^ true;
        }

        public boolean isReturned() {
            return this.isReturned;
        }

        public DebugDataInfo getDataInfo() {
            this.throwIfExpired();
            return this.dataInfo;
        }

        public int getSlotSize() {
            this.throwIfExpired();
            try {
                Type type = this.m.returnType();
                if (type instanceof LongType || type instanceof DoubleType) {
                    int n = 2;
                    return n;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 1;
        }
    }
}

