/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.Collections;
import java.util.List;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIAnnotationInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIArb;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIMethodInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugAnnotationInfo;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugHasAnnotations;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;
import oracle.jdevimpl.debugger.support.JDIInformationProvider;

final class DebugJDIVariableInfo
extends JDIInformationProvider
implements DebugVariableInfo,
DebugHasAnnotations {
    DebugJDI dj;
    DebugJDIStackFrameInfo djsf;
    LocalVariable lv;
    int argumentPosition;
    boolean argument;
    boolean local;
    ObjectReference thisObject;
    int stoppedCount;
    private Value value;
    static final /* synthetic */ boolean $assertionsDisabled;
    private int hashCode;

    DebugJDIVariableInfo(DebugJDI dj, DebugJDIStackFrameInfo djsf, ObjectReference thisObject) {
        this.dj = dj;
        this.djsf = djsf;
        this.thisObject = thisObject;
        this.argument = true;
        this.argumentPosition = -1;
        this.stoppedCount = dj.stoppedCount;
    }

    DebugJDIVariableInfo(DebugJDI dj, DebugJDIStackFrameInfo djsf, LocalVariable lv, int argumentPosition) {
        this.dj = dj;
        this.djsf = djsf;
        this.lv = lv;
        this.argumentPosition = argumentPosition;
        this.argument = true;
        this.stoppedCount = dj.stoppedCount;
    }

    DebugJDIVariableInfo(DebugJDI dj, DebugJDIStackFrameInfo djsf, LocalVariable lv) {
        this.dj = dj;
        this.djsf = djsf;
        this.lv = lv;
        this.local = true;
        this.stoppedCount = dj.stoppedCount;
    }

    DebugJDIVariableInfo(DebugJDI dj, DebugJDIStackFrameInfo djsf, Value value, int argumentPosition) {
        this.dj = dj;
        this.djsf = djsf;
        this.argumentPosition = argumentPosition;
        this.value = value;
        this.argument = true;
        this.stoppedCount = dj.stoppedCount;
    }

    public boolean hasExpired() {
        return this.stoppedCount != this.dj.stoppedCount;
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new IllegalStateException("Variable has expired");
        }
    }

    public DebugClassInfo getClassInfo() {
        DebugJDIClassInfo c;
        this.throwIfExpired();
        if (this.thisObject != null) {
            return this.dj.findClass(this.thisObject.referenceType());
        }
        try {
            DebugJDIClassInfo c2 = this.dj.findClassByType(this.lv != null ? this.lv.type() : this.value.type());
            if (c2 != null) {
                DebugJDIClassInfo debugJDIClassInfo = c2;
                return debugJDIClassInfo;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Value v = null;
        if (this.lv.isVisible(this.djsf.sf)) {
            Value value = v = this.value == null ? this.djsf.sf.getValue(this.lv) : this.value;
        }
        if (v != null && (c = this.dj.findClassByType(v.type())) != null) {
            return c;
        }
        if (this.lv != null) {
            return this.dj.findClassByName(this.lv.typeName(), true);
        }
        return this.dj.findClassByName(v.type().name(), true);
    }

    public String getGenericSignature() {
        if (this.lv != null) {
            return this.lv.genericSignature();
        }
        return null;
    }

    static {
        $assertionsDisabled = DebugJDIVariableInfo.class.desiredAssertionStatus() ^ true;
    }

    public String getName() {
        this.throwIfExpired();
        if (this.thisObject != null) {
            return "this";
        }
        if (this.lv != null) {
            return this.lv.name();
        }
        if (this.value != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(DebugJDIArb.getString(2));
            sb.append(this.argumentPosition);
            return sb.toString();
        }
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"lv and value not set!");
        }
        return "";
    }

    public boolean isInScope() {
        this.throwIfExpired();
        if (this.thisObject != null) {
            return true;
        }
        if (this.lv != null) {
            return this.lv.isVisible(this.djsf.sf);
        }
        return true;
    }

    public boolean isArgument() {
        return this.argument;
    }

    public boolean isLocal() {
        return this.local;
    }

    public boolean isReturn() {
        return false;
    }

    public boolean isReturned() {
        return false;
    }

    public DebugDataInfo getDataInfo() {
        this.throwIfExpired();
        if (this.thisObject != null) {
            return this.dj.makeData(this.thisObject, this);
        }
        Value v = null;
        if (this.lv != null) {
            if (this.lv.isVisible(this.djsf.sf)) {
                v = this.djsf.sf.getValue(this.lv);
            }
        } else {
            v = this.value;
        }
        if (v != null) {
            return this.dj.makeData(v, this);
        }
        return this.dj.makeNullData((DebugJDIClassInfo)this.getClassInfo(), this);
    }

    public int getSlotSize() {
        String sig;
        String string = sig = this.lv != null ? this.lv.signature() : this.value.type().signature();
        if (sig.equals("J") || sig.equals("D")) {
            return 2;
        }
        return 1;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.thisObject != null ? this.thisObject.hashCode() : (this.lv != null ? this.lv.hashCode() : this.value.hashCode());
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof DebugJDIVariableInfo) {
            DebugJDIVariableInfo other = (DebugJDIVariableInfo)o;
            return this.dj.equals(other.dj) && (this.thisObject == null ? other.thisObject == null : this.thisObject.equals(other.thisObject)) && (this.lv == null ? other.lv == null : this.lv.equals(other.lv)) && (this.value == null ? other.value == null : this.value.equals(other.value));
        }
        return false;
    }

    public int countAnnotations() {
        this.throwIfExpired();
        if (this.dj.isRIM()) {
            return 0;
        }
        if (this.argument && this.argumentPosition >= 0) {
            return this.getAnnotations().length;
        }
        return 0;
    }

    public DebugAnnotationInfo[] getAnnotations() {
        this.throwIfExpired();
        if (this.argument && this.argumentPosition >= 0) {
            try {
                Method method = this.djsf.sf.location().method();
                ObjectReference orMethodOrConstructor = DebugJDIMethodInfo.getReflectedMethodOrConstructor(this.dj, method);
                if (orMethodOrConstructor != null) {
                    DebugAnnotationInfo[] debugAnnotationInfoArray = this.getParameterAnnotations(orMethodOrConstructor);
                    return debugAnnotationInfoArray;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new DebugJDIAnnotationInfo[0];
    }

    private DebugJDIAnnotationInfo[] getParameterAnnotations(ObjectReference orMethod) {
        block7: {
            try {
                ClassType ctMethod = (ClassType)orMethod.referenceType();
                Method mGetParameterAnnotations = ctMethod.concreteMethodByName("getParameterAnnotations", "()[[Ljava/lang/annotation/Annotation;");
                if (mGetParameterAnnotations == null) break block7;
                List prev = this.dj.tempDisableRequests();
                try {
                    ArrayReference arAnnotations;
                    ArrayReference arParameterAnnotations = (ArrayReference)orMethod.invokeMethod(this.dj.eventThread, mGetParameterAnnotations, Collections.EMPTY_LIST, 1);
                    if (arParameterAnnotations == null || this.argumentPosition >= arParameterAnnotations.length() || (arAnnotations = (ArrayReference)arParameterAnnotations.getValue(this.argumentPosition)) == null) break block7;
                    DebugJDIAnnotationInfo[] array = new DebugJDIAnnotationInfo[arAnnotations.length()];
                    int i = 0;
                    for (Value annotation : arAnnotations.getValues()) {
                        array[i] = new DebugJDIAnnotationInfo(this.dj, (ObjectReference)annotation);
                        ++i;
                    }
                    DebugJDIAnnotationInfo[] debugJDIAnnotationInfoArray = array;
                    return debugJDIAnnotationInfoArray;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    DebugJDIStackFrameInfo.rebuildCache(this.dj);
                    this.dj.tempReenableRequests(prev);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return new DebugJDIAnnotationInfo[0];
    }

    public LocalVariable getJDILocalVariable() {
        return this.lv;
    }
}

