/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import sun.io.CharacterEncoding;

final class JspUtil {
    public static final String DEFAULT_PAGE = "index.jsp";
    private static final String WEB_INF_TAGS = "/WEB-INF/tags/";
    private static final String META_INF_TAGS = "/META-INF/tags/";
    public static final String INCLUDED_REQUEST_URI = "javax.servlet.include.request_uri";
    public static final String INCLUDED_SERVLET_PATH = "javax.servlet.include.servlet_path";
    public static final String INCLUDED_PATH_INFO = "javax.servlet.include.path_info";
    public static final String WEB_TAG_PACKAGE = "/oracle/jsp/tag/";
    public static final String META_TAG_PACKAGE = "/oracle/jsp/tag/meta/";
    private static final String MESSAGE_FILE = "oracle.jsp.util.LocalStrings";
    private static byte[] utf16bigend = new byte[]{-2, -1};
    private static byte[] utf16littleend = new byte[]{-1, -2};
    private static byte[] utf8 = new byte[]{-17, -69, -65};
    private static byte[] iso88591 = new byte[]{60, 63, 120, 109};
    private static byte[] ibm037 = new byte[]{76, 111, -89, -108};
    private static byte[] ucs4_1 = new byte[]{0, 0, -2, -1};
    private static byte[] ucs4_2 = new byte[]{-1, -2, 0, 0};
    private static byte[] ucs4_3 = new byte[]{0, 0, -1, -2};
    private static byte[] ucs4_4 = new byte[]{-2, -1, 0, 0};
    public static boolean encodeToJavaFlag = true;
    public static String THAI_CHARSET_IANA = "TIS-620";
    public static String THAI_CHARSET_JAVA = "TIS620";
    public static String SIMPLIFIED_CHINESE_CHARSET_JAVA = "GBK";
    public static String KOREAN_CHARSET_ALTERNATE = "EUC_KR";
    public static String KOREAN_CHARSET_JAVA = "EUC-KR";
    public static String IBM037_CHARSET_IANA = "IBM037";
    public static String IBM037_CHARSET_JAVA = "cp037";

    public static String getFullClassNameFromURL(String request) {
        request = JspUtil.stripProtocol(request);
        String className = JspUtil.getClassNameFromURL(request);
        String packageName = JspUtil.encodeToJavaIdentifier(JspUtil.stripTarget(request).toLowerCase(), '/');
        packageName = packageName.length() <= 1 ? "" : packageName.substring(1).replace('/', '.');
        return packageName.length() > 0 ? packageName + "." + className : className;
    }

    public static String getClassNameFromURL(String request) {
        String className = JspUtil.getTarget(request);
        int end = className.lastIndexOf(46);
        if (end == -1) {
            return JspUtil.encodeToJavaIdentifier(className);
        }
        if (className.substring(end + 1).equals("jsp") || !JspUtil.isFileCaseSensitive() && className.substring(end + 1).equals("JSP")) {
            return JspUtil.encodeToJavaIdentifier(className.substring(0, end));
        }
        return JspUtil.encodeToJavaIdentifier(className.substring(0, end)) + "_" + className.substring(end + 1);
    }

    public static String getPackageNameFromRelPath(String relPath, char sep) {
        if (relPath.length() == 0) {
            relPath = "" + sep;
        } else if (relPath.charAt(0) != sep) {
            relPath = sep + relPath;
        }
        String packageName = JspUtil.encodeToJavaIdentifier(JspUtil.stripTarget(relPath, File.separatorChar).toLowerCase(), sep);
        packageName = packageName.length() <= 1 ? "" : packageName.substring(1).replace(sep, '.');
        return packageName;
    }

    public static String getClassNameFromRelPath(String relPath, char sep) {
        String s;
        int end = relPath.lastIndexOf(sep);
        if (end < 0) {
            s = relPath;
        } else {
            if (end == relPath.length() - 1) {
                return null;
            }
            s = relPath.substring(end + 1);
        }
        end = s.lastIndexOf(46);
        if (end == -1) {
            return JspUtil.encodeToJavaIdentifier(s);
        }
        if (s.substring(end + 1).equals("jsp") || !JspUtil.isFileCaseSensitive() && s.substring(end + 1).equals("JSP")) {
            return JspUtil.encodeToJavaIdentifier(s.substring(0, end));
        }
        return JspUtil.encodeToJavaIdentifier(s.substring(0, end)) + "_" + s.substring(end + 1);
    }

    public static String encodeToJavaIdentifier(String s, char sep) {
        if (!encodeToJavaFlag) {
            return s;
        }
        if (s == null) {
            return null;
        }
        int length = s.length();
        if (length == 0) {
            return s;
        }
        StringBuffer sb = new StringBuffer();
        if (s.charAt(0) != sep) {
            sb.append('_');
        }
        int i = 0;
        while (i < length) {
            char c = s.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
                sb.append(c);
            } else if (c == sep) {
                sb.append(sep);
                if (i != length - 1) {
                    sb.append('_');
                }
            } else if (c == '_') {
                sb.append("__");
            } else {
                sb.append("_" + Integer.toHexString(c) + "_");
            }
            ++i;
        }
        return new String(sb);
    }

    public static String encodeToJavaIdentifier(String s) {
        return JspUtil.encodeToJavaIdentifier(s, '\uffff');
    }

    public static String stripProtocol(String s) {
        int length = s.length();
        if (s == null || length == 0) {
            return "/";
        }
        if (s.charAt(0) != '/') {
            int start = s.indexOf("/");
            if (start == -1) {
                return s;
            }
            if (start < length - 1 && s.charAt(start + 1) == '/') {
                ++start;
            }
            return s.substring(start);
        }
        return s;
    }

    public static String getTarget(String s) {
        int end = 0;
        end = s.indexOf("?");
        if (end != -1) {
            s = s.substring(0, end);
        }
        if ((end = s.lastIndexOf("/")) < 0) {
            return s;
        }
        if (end == s.length() - 1) {
            return DEFAULT_PAGE;
        }
        return s.substring(end + 1);
    }

    public static String stripTarget(String s) {
        return JspUtil.stripTarget(s, '/');
    }

    public static String stripTarget(String s, char sep) {
        String newS = JspUtil.handleDotsInPath(s, sep);
        if (newS == null) {
            throw new IllegalArgumentException("invalid_dots");
        }
        s = newS;
        int end = s.lastIndexOf(sep);
        if (end <= 0) {
            return "" + sep;
        }
        return s.substring(0, end);
    }

    public static String handleDotsInPath(String s) {
        return JspUtil.handleDotsInPath(s, '/');
    }

    public static String handleDotsInPath(String origStr, char sep) {
        String queryStr;
        String s;
        int qMark = origStr.indexOf(63);
        if (qMark == -1) {
            s = origStr;
            queryStr = "";
        } else {
            s = origStr.substring(0, qMark);
            queryStr = origStr.substring(qMark, origStr.length());
        }
        char[] c0 = s.toCharArray();
        StringBuffer sb0 = new StringBuffer();
        int len = c0.length;
        int i = 0;
        while (i < len) {
            if (c0[i] == sep) {
                if (i <= 0 || c0[i - 1] != sep) {
                    sb0.append(c0[i]);
                }
            } else {
                sb0.append(c0[i]);
            }
            ++i;
        }
        char[] c = new String(sb0).toCharArray();
        int begin = 0;
        int index = s.indexOf(sep, begin);
        StringBuffer sb = new StringBuffer();
        do {
            if (c[begin] == '.') {
                if (c.length == begin + 1 || c[begin + 1] == sep) {
                    if ((begin += 2) > c.length) {
                        begin = c.length;
                    }
                } else if (c[begin + 1] == '.' && (c.length == begin + 2 || c[begin + 2] == sep)) {
                    if (sb.length() < 2) {
                        return null;
                    }
                    int lastIndex = -1;
                    int i2 = sb.length() - 2;
                    while (i2 >= 0) {
                        if (sb.charAt(i2) == sep) {
                            lastIndex = i2;
                            break;
                        }
                        --i2;
                    }
                    sb.setLength(lastIndex + 1);
                    if ((begin += 3) > c.length) {
                        begin = c.length;
                    }
                } else {
                    if (index == -1) break;
                    sb.append(c, begin, index + 1 - begin);
                    begin = index + 1;
                }
            } else {
                if (index == -1) break;
                sb.append(c, begin, index + 1 - begin);
                begin = index + 1;
            }
            index = s.indexOf(sep, begin);
        } while (begin < c.length && index < c.length);
        if (begin < c.length) {
            sb.append(c, begin, c.length - begin);
        }
        sb.append(queryStr);
        return new String(sb);
    }

    public static String filePathAfterAppPath(String absFilePath, String appFilePath) throws IOException {
        absFilePath = new File(absFilePath).getAbsolutePath();
        appFilePath = new File(appFilePath).getAbsolutePath();
        return JspUtil.pathAfterAppPath(absFilePath, appFilePath, File.separatorChar);
    }

    public static String pathAfterAppPath(String absPath, String appPath, char sep) {
        absPath = JspUtil.handleDotsInPath(absPath, sep);
        appPath = JspUtil.handleDotsInPath(appPath, sep);
        int appLen = appPath.length();
        if (appPath == null || appLen == 0) {
            return absPath;
        }
        int index = absPath.indexOf(appPath);
        if (index == 0) {
            if (appPath.charAt(appLen - 1) == sep) {
                return absPath.substring(appLen);
            }
            if (absPath.length() > appLen && absPath.charAt(appLen) == sep) {
                return absPath.substring(appLen + 1);
            }
            return absPath;
        }
        return absPath;
    }

    public static String replaceTargetExtension(String s, String ext) {
        int end = s.lastIndexOf(".");
        if (end == -1) {
            if (ext.charAt(0) == '.') {
                return s + ext;
            }
            return s + "." + ext;
        }
        if (ext == null || ext.equals("")) {
            return s.substring(0, end);
        }
        if (ext.charAt(0) == '.') {
            return s.substring(0, end) + ext;
        }
        return s.substring(0, end + 1) + ext;
    }

    public static boolean isFileCaseSensitive() {
        return File.separatorChar == '/';
    }

    public static String convIANAtoJavaEncoding(String ianaEncoding, boolean privileged) {
        if (ianaEncoding == null) {
            return null;
        }
        if (ianaEncoding.equals("UnicodeBig") || ianaEncoding.equals("UnicodeLittle")) {
            return ianaEncoding;
        }
        if (ianaEncoding.equalsIgnoreCase(THAI_CHARSET_IANA)) {
            return THAI_CHARSET_JAVA;
        }
        if (ianaEncoding.equalsIgnoreCase(SIMPLIFIED_CHINESE_CHARSET_JAVA)) {
            return SIMPLIFIED_CHINESE_CHARSET_JAVA;
        }
        if (ianaEncoding.equalsIgnoreCase(KOREAN_CHARSET_ALTERNATE)) {
            return KOREAN_CHARSET_JAVA;
        }
        if (ianaEncoding.equalsIgnoreCase(IBM037_CHARSET_IANA)) {
            return IBM037_CHARSET_JAVA;
        }
        if (privileged) {
            String enc_arg = ianaEncoding.toUpperCase();
            String jdkEncoding = (String)AccessController.doPrivileged(new 1(enc_arg));
            return jdkEncoding;
        }
        return CharacterEncoding.aliasName((String)ianaEncoding.toUpperCase());
    }

    public static String scanForByteOrderMark(InputStream in) throws IOException {
        byte[] buf = new byte[4];
        BufferedInputStream buffer = new BufferedInputStream(in);
        buffer.mark(4);
        if (buffer.read(buf) < 4) {
            buffer.reset();
            return null;
        }
        if (buf[0] == utf8[0] && buf[1] == utf8[1] && buf[2] == utf8[2]) {
            return "UTF-8";
        }
        if (buf[0] == utf16bigend[0] && buf[1] == utf16bigend[1]) {
            return "UnicodeBig";
        }
        if (buf[0] == utf16littleend[0] && buf[1] == utf16littleend[1]) {
            return "UnicodeLittle";
        }
        if (buf[0] == iso88591[0] && buf[1] == iso88591[1] && buf[2] == iso88591[2] && buf[3] == iso88591[3]) {
            return "ISO-8859-1";
        }
        if (buf[0] == ibm037[0] && buf[1] == ibm037[1] && buf[2] == ibm037[2] && buf[3] == ibm037[3]) {
            return "IBM037";
        }
        if (buf[0] == ucs4_1[0] && buf[1] == ucs4_1[1] & buf[2] == ucs4_1[2] && buf[3] == ucs4_1[3] || buf[0] == ucs4_2[0] && buf[1] == ucs4_2[1] & buf[2] == ucs4_2[2] && buf[3] == ucs4_2[3] || buf[0] == ucs4_3[0] && buf[1] == ucs4_3[1] & buf[2] == ucs4_3[2] && buf[3] == ucs4_3[3] || buf[0] == ucs4_4[0] && buf[1] == ucs4_4[1] & buf[2] == ucs4_4[2] && buf[3] == ucs4_4[3]) {
            throw new IOException(MessageFormat.format("unsupported_encoding", "UCS-4"));
        }
        return null;
    }

    public static int getBOMLengthInBytes(String enc) {
        if (enc.equals("UnicodeBig")) {
            return utf16bigend.length;
        }
        if (enc.equals("UnicodeLittle")) {
            return utf16littleend.length;
        }
        if (enc.equals("UTF-8")) {
            return utf8.length;
        }
        if (enc.equals("ISO-8859-1")) {
            return iso88591.length;
        }
        if (enc.equals("IBM037")) {
            return ibm037.length;
        }
        return 0;
    }

    public static boolean needToSkipBOM(String byteOrderMarkEncoding, String currentEncoding) {
        if (byteOrderMarkEncoding != null && (byteOrderMarkEncoding.equals("ISO-8859-1") || byteOrderMarkEncoding.equals("IBM037"))) {
            return false;
        }
        return byteOrderMarkEncoding != null && currentEncoding != null && (!byteOrderMarkEncoding.equals("UnicodeBig") && !byteOrderMarkEncoding.equals("UnicodeLittle") || !currentEncoding.equals("UTF-16"));
    }

    public static String getTagHandlerClassName(String path) {
        int index;
        String className = null;
        int begin = 0;
        String suffix = ".tag";
        if (path.endsWith(".tagx")) {
            suffix = ".tagx";
        }
        if ((index = path.lastIndexOf(".tag")) != -1) {
            path = path.substring(0, index);
        }
        if ((index = path.indexOf(WEB_INF_TAGS)) != -1) {
            className = WEB_TAG_PACKAGE;
            begin = index + WEB_INF_TAGS.length();
        } else {
            index = path.indexOf(META_INF_TAGS);
            if (index != -1) {
                className = META_TAG_PACKAGE;
                begin = index + META_INF_TAGS.length();
            }
        }
        className = className + path.substring(begin) + suffix;
        return className;
    }

    JspUtil() {
    }

    static final class 1
    implements PrivilegedAction {
        private final /* synthetic */ String v$enc_arg;

        public Object run() {
            return CharacterEncoding.aliasName((String)this.v$enc_arg);
        }

        public 1(String string) {
            this.v$enc_arg = string;
        }
    }
}

