/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.shared;

import java.util.Set;
import oracle.jdevimpl.debugger.support.DebugBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpointClass;
import oracle.jdevimpl.debugger.support.DebugBreakpointFileLine;
import oracle.jdevimpl.debugger.support.DebugBreakpointMethod;
import oracle.jdevimpl.debugger.support.DebugBreakpointMethodBytecode;
import oracle.jdevimpl.debugger.support.DebugBreakpointWatchpoint;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;

public class DebugSharedBreakpoint {
    public boolean isInstanceFilterAppropriate(DebugDataObjectInfo data, Set classNames) {
        if (this instanceof DebugBreakpointWatchpoint) {
            String watchpointClassName;
            if (classNames.isEmpty()) {
                DebugSharedBreakpoint.fillClassNamesSet(data, classNames);
            }
            if (classNames.contains(watchpointClassName = ((DebugBreakpointWatchpoint)((Object)this)).getWatchpointClassname())) {
                return true;
            }
        } else if (this instanceof DebugBreakpointFileLine || this instanceof DebugBreakpointMethod || this instanceof DebugBreakpointMethodBytecode || this instanceof DebugBreakpointClass) {
            if (classNames.isEmpty()) {
                DebugSharedBreakpoint.fillClassNamesSet(data, classNames);
            }
            DebugLocation[] locations = ((DebugBreakpoint)((Object)this)).getLocations();
            int i = locations.length - 1;
            while (i >= 0) {
                String locationClassName = locations[i].getClassInfo().getName();
                if (classNames.contains(locationClassName)) {
                    return true;
                }
                --i;
            }
        }
        return false;
    }

    private static void fillClassNamesSet(DebugDataObjectInfo data, Set classNames) {
        DebugClassInfo clazz = data.getClassInfo();
        while (clazz != null) {
            classNames.add(clazz.getName());
            clazz = clazz.getSuperClass(1);
        }
    }
}

