/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.shared;

import java.util.ArrayList;
import oracle.ide.model.Project;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.shared.DebugSharedDisassembleBytecode;
import oracle.jdevimpl.debugger.shared.DebugSharedDisassembleJava;
import oracle.jdevimpl.debugger.support.DebugDisassembleInfo;

public final class DebugSharedDisassemble {
    static final short opc_nop = 0;
    static final short opc_aconst_null = 1;
    static final short opc_iconst_m1 = 2;
    static final short opc_iconst_0 = 3;
    static final short opc_iconst_1 = 4;
    static final short opc_iconst_2 = 5;
    static final short opc_iconst_3 = 6;
    static final short opc_iconst_4 = 7;
    static final short opc_iconst_5 = 8;
    static final short opc_lconst_0 = 9;
    static final short opc_lconst_1 = 10;
    static final short opc_fconst_0 = 11;
    static final short opc_fconst_1 = 12;
    static final short opc_fconst_2 = 13;
    static final short opc_dconst_0 = 14;
    static final short opc_dconst_1 = 15;
    static final short opc_bipush = 16;
    static final short opc_sipush = 17;
    static final short opc_ldc = 18;
    static final short opc_ldc_w = 19;
    static final short opc_ldc2_w = 20;
    static final short opc_iload = 21;
    static final short opc_lload = 22;
    static final short opc_fload = 23;
    static final short opc_dload = 24;
    static final short opc_aload = 25;
    static final short opc_iload_0 = 26;
    static final short opc_iload_1 = 27;
    static final short opc_iload_2 = 28;
    static final short opc_iload_3 = 29;
    static final short opc_lload_0 = 30;
    static final short opc_lload_1 = 31;
    static final short opc_lload_2 = 32;
    static final short opc_lload_3 = 33;
    static final short opc_fload_0 = 34;
    static final short opc_fload_1 = 35;
    static final short opc_fload_2 = 36;
    static final short opc_fload_3 = 37;
    static final short opc_dload_0 = 38;
    static final short opc_dload_1 = 39;
    static final short opc_dload_2 = 40;
    static final short opc_dload_3 = 41;
    static final short opc_aload_0 = 42;
    static final short opc_aload_1 = 43;
    static final short opc_aload_2 = 44;
    static final short opc_aload_3 = 45;
    static final short opc_iaload = 46;
    static final short opc_laload = 47;
    static final short opc_faload = 48;
    static final short opc_daload = 49;
    static final short opc_aaload = 50;
    static final short opc_baload = 51;
    static final short opc_caload = 52;
    static final short opc_saload = 53;
    static final short opc_istore = 54;
    static final short opc_lstore = 55;
    static final short opc_fstore = 56;
    static final short opc_dstore = 57;
    static final short opc_astore = 58;
    static final short opc_istore_0 = 59;
    static final short opc_istore_1 = 60;
    static final short opc_istore_2 = 61;
    static final short opc_istore_3 = 62;
    static final short opc_lstore_0 = 63;
    static final short opc_lstore_1 = 64;
    static final short opc_lstore_2 = 65;
    static final short opc_lstore_3 = 66;
    static final short opc_fstore_0 = 67;
    static final short opc_fstore_1 = 68;
    static final short opc_fstore_2 = 69;
    static final short opc_fstore_3 = 70;
    static final short opc_dstore_0 = 71;
    static final short opc_dstore_1 = 72;
    static final short opc_dstore_2 = 73;
    static final short opc_dstore_3 = 74;
    static final short opc_astore_0 = 75;
    static final short opc_astore_1 = 76;
    static final short opc_astore_2 = 77;
    static final short opc_astore_3 = 78;
    static final short opc_iastore = 79;
    static final short opc_lastore = 80;
    static final short opc_fastore = 81;
    static final short opc_dastore = 82;
    static final short opc_aastore = 83;
    static final short opc_bastore = 84;
    static final short opc_castore = 85;
    static final short opc_sastore = 86;
    static final short opc_pop = 87;
    static final short opc_pop2 = 88;
    static final short opc_dup = 89;
    static final short opc_dup_x1 = 90;
    static final short opc_dup_x2 = 91;
    static final short opc_dup2 = 92;
    static final short opc_dup2_x1 = 93;
    static final short opc_dup2_x2 = 94;
    static final short opc_swap = 95;
    static final short opc_iadd = 96;
    static final short opc_ladd = 97;
    static final short opc_fadd = 98;
    static final short opc_dadd = 99;
    static final short opc_isub = 100;
    static final short opc_lsub = 101;
    static final short opc_fsub = 102;
    static final short opc_dsub = 103;
    static final short opc_imul = 104;
    static final short opc_lmul = 105;
    static final short opc_fmul = 106;
    static final short opc_dmul = 107;
    static final short opc_idiv = 108;
    static final short opc_ldiv = 109;
    static final short opc_fdiv = 110;
    static final short opc_ddiv = 111;
    static final short opc_irem = 112;
    static final short opc_lrem = 113;
    static final short opc_frem = 114;
    static final short opc_drem = 115;
    static final short opc_ineg = 116;
    static final short opc_lneg = 117;
    static final short opc_fneg = 118;
    static final short opc_dneg = 119;
    static final short opc_ishl = 120;
    static final short opc_lshl = 121;
    static final short opc_ishr = 122;
    static final short opc_lshr = 123;
    static final short opc_iushr = 124;
    static final short opc_lushr = 125;
    static final short opc_iand = 126;
    static final short opc_land = 127;
    static final short opc_ior = 128;
    static final short opc_lor = 129;
    static final short opc_ixor = 130;
    static final short opc_lxor = 131;
    static final short opc_iinc = 132;
    static final short opc_i2l = 133;
    static final short opc_i2f = 134;
    static final short opc_i2d = 135;
    static final short opc_l2i = 136;
    static final short opc_l2f = 137;
    static final short opc_l2d = 138;
    static final short opc_f2i = 139;
    static final short opc_f2l = 140;
    static final short opc_f2d = 141;
    static final short opc_d2i = 142;
    static final short opc_d2l = 143;
    static final short opc_d2f = 144;
    static final short opc_i2b = 145;
    static final short opc_i2c = 146;
    static final short opc_i2s = 147;
    static final short opc_lcmp = 148;
    static final short opc_fcmpl = 149;
    static final short opc_fcmpg = 150;
    static final short opc_dcmpl = 151;
    static final short opc_dcmpg = 152;
    static final short opc_ifeq = 153;
    static final short opc_ifne = 154;
    static final short opc_iflt = 155;
    static final short opc_ifge = 156;
    static final short opc_ifgt = 157;
    static final short opc_ifle = 158;
    static final short opc_if_icmpeq = 159;
    static final short opc_if_icmpne = 160;
    static final short opc_if_icmplt = 161;
    static final short opc_if_icmpge = 162;
    static final short opc_if_icmpgt = 163;
    static final short opc_if_icmple = 164;
    static final short opc_if_acmpeq = 165;
    static final short opc_if_acmpne = 166;
    static final short opc_goto = 167;
    static final short opc_jsr = 168;
    static final short opc_ret = 169;
    static final short opc_tableswitch = 170;
    static final short opc_lookupswitch = 171;
    static final short opc_ireturn = 172;
    static final short opc_lreturn = 173;
    static final short opc_freturn = 174;
    static final short opc_dreturn = 175;
    static final short opc_areturn = 176;
    static final short opc_return = 177;
    static final short opc_getstatic = 178;
    static final short opc_putstatic = 179;
    static final short opc_getfield = 180;
    static final short opc_putfield = 181;
    static final short opc_invokevirtual = 182;
    static final short opc_invokespecial = 183;
    static final short opc_invokestatic = 184;
    static final short opc_invokeinterface = 185;
    static final short opc_new = 187;
    static final short opc_newarray = 188;
    static final short opc_anewarray = 189;
    static final short opc_arraylength = 190;
    static final short opc_athrow = 191;
    static final short opc_checkcast = 192;
    static final short opc_instanceof = 193;
    static final short opc_monitorenter = 194;
    static final short opc_monitorexit = 195;
    static final short opc_wide = 196;
    static final short opc_multianewarray = 197;
    static final short opc_ifnull = 198;
    static final short opc_ifnonnull = 199;
    static final short opc_goto_w = 200;
    static final short opc_jsr_w = 201;
    static final short opc_breakpoint = 202;
    static final short opc_ldc_quick = 203;
    static final short opc_ldc_w_quick = 204;
    static final short opc_ldc2_w_quick = 205;
    static final short opc_getfield_quick = 206;
    static final short opc_putfield_quick = 207;
    static final short opc_getfield2_quick = 208;
    static final short opc_putfield2_quick = 209;
    static final short opc_getstatic_quick = 210;
    static final short opc_putstatic_quick = 211;
    static final short opc_getstatic2_quick = 212;
    static final short opc_putstatic2_quick = 213;
    static final short opc_invokevirtual_quick = 214;
    static final short opc_invokenonvirtual_quick = 215;
    static final short opc_invokesuper_quick = 216;
    static final short opc_invokestatic_quick = 217;
    static final short opc_invokeinterface_quick = 218;
    static final short opc_invokevirtualobject_quick = 219;
    static final short opc_new_quick = 221;
    static final short opc_anewarray_quick = 222;
    static final short opc_multianewarray_quick = 223;
    static final short opc_checkcast_quick = 224;
    static final short opc_instanceof_quick = 225;
    static final short opc_invokevirtual_quick_w = 226;
    static final short opc_getfield_quick_w = 227;
    static final short opc_putfield_quick_w = 228;
    private static final String[] opcodeNames = new String[]{"nop            ", "aconst_null    ", "iconst_m1      ", "iconst_0       ", "iconst_1       ", "iconst_2       ", "iconst_3       ", "iconst_4       ", "iconst_5       ", "lconst_0       ", "lconst_1       ", "fconst_0       ", "fconst_1       ", "fconst_2       ", "dconst_0       ", "dconst_1       ", "bipush         ", "sipush         ", "ldc            ", "ldc_w          ", "ldc2_w         ", "iload          ", "lload          ", "fload          ", "dload          ", "aload          ", "iload_0        ", "iload_1        ", "iload_2        ", "iload_3        ", "lload_0        ", "lload_1        ", "lload_2        ", "lload_3        ", "fload_0        ", "fload_1        ", "fload_2        ", "fload_3        ", "dload_0        ", "dload_1        ", "dload_2        ", "dload_3        ", "aload_0        ", "aload_1        ", "aload_2        ", "aload_3        ", "iaload         ", "laload         ", "faload         ", "daload         ", "aaload         ", "baload         ", "caload         ", "saload         ", "istore         ", "lstore         ", "fstore         ", "dstore         ", "astore         ", "istore_0       ", "istore_1       ", "istore_2       ", "istore_3       ", "lstore_0       ", "lstore_1       ", "lstore_2       ", "lstore_3       ", "fstore_0       ", "fstore_1       ", "fstore_2       ", "fstore_3       ", "dstore_0       ", "dstore_1       ", "dstore_2       ", "dstore_3       ", "astore_0       ", "astore_1       ", "astore_2       ", "astore_3       ", "iastore        ", "lastore        ", "fastore        ", "dastore        ", "aastore        ", "bastore        ", "castore        ", "sastore        ", "pop            ", "pop2           ", "dup            ", "dup_x1         ", "dup_x2         ", "dup2           ", "dup2_x1        ", "dup2_x2        ", "swap           ", "iadd           ", "ladd           ", "fadd           ", "dadd           ", "isub           ", "lsub           ", "fsub           ", "dsub           ", "imul           ", "lmul           ", "fmul           ", "dmul           ", "idiv           ", "ldiv           ", "fdiv           ", "ddiv           ", "irem           ", "lrem           ", "frem           ", "drem           ", "ineg           ", "lneg           ", "fneg           ", "dneg           ", "ishl           ", "lshl           ", "ishr           ", "lshr           ", "iushr          ", "lushr          ", "iand           ", "land           ", "ior            ", "lor            ", "ixor           ", "lxor           ", "iinc           ", "i2l            ", "i2f            ", "i2d            ", "l2i            ", "l2f            ", "l2d            ", "f2i            ", "f2l            ", "f2d            ", "d2i            ", "d2l            ", "d2f            ", "i2b            ", "i2c            ", "i2s            ", "lcmp           ", "fcmpl          ", "fcmpg          ", "dcmpl          ", "dcmpg          ", "ifeq           ", "ifne           ", "iflt           ", "ifge           ", "ifgt           ", "ifle           ", "if_icmpeq      ", "if_icmpne      ", "if_icmplt      ", "if_icmpge      ", "if_icmpgt      ", "if_icmple      ", "if_acmpeq      ", "if_acmpne      ", "goto           ", "jsr            ", "ret            ", "tableswitch    ", "lookupswitch   ", "ireturn       ", "lreturn       ", "freturn       ", "dreturn       ", "areturn       ", "return        ", "getstatic      ", "putstatic      ", "getfield       ", "putfield       ", "invokevirtual  ", "invokespecial  ", "invokestatic   ", "invokeinterface", null, "new            ", "newarray       ", "anewarray      ", "arraylength    ", "athrow         ", "checkcast      ", "instanceof     ", "monitorenter   ", "monitorexit    ", "wide           ", "multianewarray ", "ifnull         ", "ifnonnull      ", "goto_w         ", "jsr_w          ", "breakpoint     ", "ldc_quick      ", "ldc_w_quick    ", "ldc2_w_quick   ", "getfield_quick ", "putfield_quick ", "getfield2_quick", "putfield2_quick", "getstatic_quick", "putstatic_quick", "getstatic2_quick", "putstatic2_quick", "invokevirtual_quick", "invokenonvirtual_quick", "invokesuper_quick", "invokestatic_quick", "invokeinterface_quick", "invokevirtualobject_quick", null, "new_quick      ", "anewarray_quick", "multianewarray_quick", "checkcast_quick", "instanceof_quick", "invokevirtual_quick_w", "getfield_quick_w", "putfield_quick_w"};
    private static final byte[] opcodeLength = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 2, 3, 3, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 0, 0, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 5, 0, 3, 2, 3, 1, 1, 3, 3, 1, 1, 0, 4, 3, 3, 5, 5, 0, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 5, 3, 0, 3, 3, 4, 3, 3, 3, 3, 3};
    private static final String[] arrayTypeName = new String[]{null, null, null, null, "T_BOOLEAN", "T_CHAR", "T_FLOAT", "T_DOUBLE", "T_BYTE", "T_SHORT", "T_INT", "T_LONG"};
    byte[] bc;
    DebugDisassembleInfo[] array;

    /*
     * Unable to fully structure code
     */
    public DebugSharedDisassemble(boolean java, boolean bytecode, byte[] bc, int[] lineNumbers, int[] bcOffsets, Project project, String className) {
        super();
        v = new ArrayList<DebugDisassembleInfo>();
        this.bc = bc;
        if (project != null) {
            // empty if block
        }
        countLines = lineNumbers != null ? lineNumbers.length : 0;
        i = 0;
        lineNumber = -1;
        bcOffset = -1;
        if (i < countLines) {
            lineNumber = lineNumbers[i];
            bcOffset = bcOffsets[i];
        }
        countBC = bc.length;
        offset = 0;
        ** GOTO lbl35
        {
            if (java) {
                v.add(new DebugSharedDisassembleJava(lineNumber));
            }
            if (++i < countLines) {
                lineNumber = lineNumbers[i];
                bcOffset = bcOffsets[i];
            } else {
                lineNumber = -1;
                bcOffset = -1;
            }
            do {
                if (bcOffset == offset) continue block0;
                s = DebugSharedDisassemble.disassBytecode(bc, offset);
                if (bytecode) {
                    v.add(new DebugSharedDisassembleBytecode(offset, s.trim()));
                }
                if ((instructionLength = DebugSharedDisassemble.getInstructionLength(bc, offset)) == 0) {
                    v.clear();
                    break block0;
                }
                offset += instructionLength;
lbl35:
                // 2 sources

            } while (offset < countBC);
        }
        this.array = v.toArray(new DebugDisassembleInfo[v.size()]);
    }

    public DebugDisassembleInfo[] getArray() {
        return this.array;
    }

    private static String disassBytecode(byte[] bc, int offset) {
        int code = DebugSharedDisassemble.getUnsigned8(bc, offset);
        switch (code) {
            case 16: {
                return opcodeNames[code] + " " + DebugSharedDisassemble.getSigned8(bc, offset + 1);
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 169: {
                return opcodeNames[code] + DebugSharedDisassemble.formatNumber(DebugSharedDisassemble.getUnsigned8(bc, offset + 1));
            }
            case 17: {
                return opcodeNames[code] + " " + DebugSharedDisassemble.getSigned16(bc, offset + 1);
            }
            case 188: {
                return opcodeNames[code] + " " + DebugSharedDisassemble.getArrayTypeName(bc, offset + 1);
            }
            case 132: {
                return opcodeNames[code] + DebugSharedDisassemble.formatNumber(DebugSharedDisassemble.getUnsigned8(bc, offset + 1)) + " " + DebugSharedDisassemble.getSigned8(bc, offset + 2);
            }
            case 197: 
            case 223: {
                return opcodeNames[code] + DebugSharedDisassemble.getConstantPoolIndex16(bc, offset + 1) + " " + DebugSharedDisassemble.getUnsigned8(bc, offset + 3);
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: {
                return opcodeNames[code] + "   " + (offset + DebugSharedDisassemble.getSigned16(bc, offset + 1));
            }
            case 200: 
            case 201: {
                return opcodeNames[code] + "   " + (offset + DebugSharedDisassemble.getSigned32(bc, offset + 1));
            }
            case 18: 
            case 203: {
                return opcodeNames[code] + DebugSharedDisassemble.getConstantPoolIndex8(bc, offset + 1);
            }
            case 19: 
            case 20: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 187: 
            case 189: 
            case 192: 
            case 193: 
            case 204: 
            case 205: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 215: 
            case 216: 
            case 217: 
            case 221: 
            case 222: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: {
                return opcodeNames[code] + DebugSharedDisassemble.getConstantPoolIndex16(bc, offset + 1);
            }
            case 185: {
                return opcodeNames[code] + DebugSharedDisassemble.getConstantPoolIndex16(bc, offset + 1) + " " + DebugSharedDisassemble.getUnsigned8(bc, offset + 3);
            }
            case 171: {
                return opcodeNames[code];
            }
            case 170: {
                return opcodeNames[code];
            }
            case 206: 
            case 207: 
            case 208: 
            case 209: {
                return opcodeNames[code] + " " + DebugSharedDisassemble.getUnsigned8(bc, offset + 1);
            }
            case 214: 
            case 219: {
                return opcodeNames[code] + " " + DebugSharedDisassemble.getUnsigned8(bc, offset + 1) + " " + DebugSharedDisassemble.getUnsigned8(bc, offset + 2);
            }
            case 218: {
                return opcodeNames[code] + " " + DebugSharedDisassemble.getUnsigned16(bc, offset + 1) + " " + DebugSharedDisassemble.getUnsigned8(bc, offset + 3) + " " + DebugSharedDisassemble.getUnsigned8(bc, offset + 4);
            }
            case 196: {
                int code2 = DebugSharedDisassemble.getUnsigned8(bc, offset + 1);
                switch (code2) {
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 169: {
                        return opcodeNames[code2] + DebugSharedDisassemble.formatNumber(DebugSharedDisassemble.getUnsigned16(bc, offset + 2));
                    }
                    case 132: {
                        return opcodeNames[code2] + DebugSharedDisassemble.formatNumber(DebugSharedDisassemble.getUnsigned16(bc, offset + 2)) + " " + DebugSharedDisassemble.getSigned16(bc, offset + 4);
                    }
                }
                return opcodeNames[code];
            }
        }
        return opcodeNames[code];
    }

    private static int getSigned8(byte[] bc, int offset) {
        return bc[offset];
    }

    private static int getUnsigned8(byte[] bc, int offset) {
        return bc[offset] & 0xFF;
    }

    private static int getSigned16(byte[] bc, int offset) {
        int i = bc[offset];
        i <<= 8;
        return i |= bc[offset + 1] & 0xFF;
    }

    private static int getUnsigned16(byte[] bc, int offset) {
        int i = bc[offset] & 0xFF;
        i <<= 8;
        return i |= bc[offset + 1] & 0xFF;
    }

    private static int getSigned32(byte[] bc, int offset) {
        int i = bc[offset];
        i <<= 8;
        i |= bc[offset + 1] & 0xFF;
        i <<= 8;
        i |= bc[offset + 2] & 0xFF;
        i <<= 8;
        return i |= bc[offset + 3] & 0xFF;
    }

    private static String getConstantPoolIndex8(byte[] bc, int offset) {
        return DebugSharedDisassemble.formatNumber(DebugSharedDisassemble.getUnsigned8(bc, offset));
    }

    private static String getConstantPoolIndex16(byte[] bc, int offset) {
        return DebugSharedDisassemble.formatNumber(DebugSharedDisassemble.getUnsigned16(bc, offset));
    }

    private static String formatNumber(int i) {
        return "   #" + DebugShared.prepad(Integer.toString(i), ' ', 4);
    }

    private static String getArrayTypeName(byte[] bc, int offset) {
        int i = bc[offset] & 0xFF;
        return arrayTypeName[i];
    }

    public static boolean isReturnBytecode(short opcode) {
        return opcode == 169 || opcode == 172 || opcode == 173 || opcode == 174 || opcode == 175 || opcode == 176 || opcode == 177;
    }

    public static int getInstructionLength(byte[] bc, int offset) {
        int code = DebugSharedDisassemble.getUnsigned8(bc, offset);
        int size = opcodeLength[code];
        switch (code) {
            case 171: {
                size = (offset + 1 + 3 & 0xFFFFFFFC) - offset;
                int count = DebugSharedDisassemble.getSigned32(bc, offset + size + 4);
                size += 8 + count * 8;
                break;
            }
            case 170: {
                size = (offset + 1 + 3 & 0xFFFFFFFC) - offset;
                int count = DebugSharedDisassemble.getSigned32(bc, offset + size + 8) - DebugSharedDisassemble.getSigned32(bc, offset + size + 4) + 1;
                size += 12 + count * 4;
                break;
            }
            case 196: {
                int code2 = DebugSharedDisassemble.getUnsigned8(bc, offset + 1);
                size = 2 * opcodeLength[code2];
                break;
            }
        }
        return size;
    }
}

