/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.shared;

import java.io.File;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;

public final class DebugSharedLocation
implements DebugLocation {
    DebugMethodInfo method;
    long address;
    int bytecodeOffset;
    boolean exactBC;
    String path;
    String filename;
    int line;
    boolean exactLine;

    public DebugSharedLocation(DebugMethodInfo method, long address, int bytecodeOffset, boolean exactBC, String path, String filename, int line, boolean exactLine) {
        this.method = method;
        this.address = address;
        this.bytecodeOffset = bytecodeOffset;
        this.exactBC = exactBC;
        if (path == null) {
            path = method.getClassInfo().getPackage().replace('.', File.separatorChar) + File.separator + filename;
        }
        this.path = path;
        this.filename = filename;
        this.line = line;
        this.exactLine = exactLine;
    }

    public DebugMethodInfo getMethod() {
        return this.method;
    }

    public DebugClassInfo getClassInfo() {
        return this.method.getClassInfo();
    }

    public String getPath() {
        return this.path;
    }

    public String getFilename() {
        return this.filename;
    }

    public long getAddress() {
        return this.address;
    }

    public int getBytecodeOffset() {
        return this.bytecodeOffset;
    }

    public boolean isBytecodeExact() {
        return this.exactBC;
    }

    public int getLine() {
        return this.line;
    }

    public boolean isLineExact() {
        return this.exactLine;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public void setLineExact(boolean exactLine) {
        this.exactLine = exactLine;
    }

    public int hashCode() {
        return this.method.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof DebugSharedLocation) {
            DebugSharedLocation other = (DebugSharedLocation)o;
            return this.method.equals(other.method) && this.address == other.address && this.bytecodeOffset == other.bytecodeOffset && this.exactBC == other.exactBC && this.line == other.line && this.exactLine == other.exactLine;
        }
        return false;
    }
}

