/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.shared;

import java.util.HashMap;
import java.util.Map;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugClassLoaderInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;

public final class DebugSharedPrimitives {
    private static String[] hexPrefixes = new String[]{"#", "0X", "0x"};
    private static Map mapPrimitiveClasses = null;

    public static boolean booleanDecode(String value) throws IllegalArgumentException {
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new IllegalArgumentException(value);
    }

    public static byte byteFromHexString(String hex) throws NumberFormatException {
        int digit;
        boolean msb = false;
        if (hex.length() == 2 && (digit = Character.digit(hex.charAt(0), 16)) >= 8 && digit <= 15) {
            msb = true;
            char c = Character.forDigit(digit - 8, 16);
            hex = c + hex.substring(1);
        }
        byte b = Byte.parseByte(hex, 16);
        if (msb) {
            b = (byte)(b | 0x80);
        }
        return b;
    }

    public static byte byteDecode(String value) throws NumberFormatException {
        int i = hexPrefixes.length - 1;
        while (i >= 0) {
            if (value.startsWith(hexPrefixes[i])) {
                return DebugSharedPrimitives.byteFromHexString(value.substring(hexPrefixes[i].length()));
            }
            --i;
        }
        return Byte.decode(value);
    }

    public static char charDecode(String value) throws IllegalArgumentException, NumberFormatException {
        int i = hexPrefixes.length - 1;
        while (i >= 0) {
            if (value.startsWith(hexPrefixes[i])) {
                return (char)DebugSharedPrimitives.intFromHexString(value.substring(hexPrefixes[i].length()));
            }
            --i;
        }
        if (value.startsWith("\\u")) {
            return (char)DebugSharedPrimitives.intFromHexString(value.substring(2));
        }
        char c = value.charAt(0);
        if (Character.isDigit(c)) {
            return (char)Integer.parseInt(value);
        }
        if (c == '\'' && value.length() == 3 && value.charAt(2) == '\'') {
            return value.charAt(1);
        }
        throw new IllegalArgumentException();
    }

    public static short shortFromHexString(String hex) throws NumberFormatException {
        int digit;
        boolean msb = false;
        if (hex.length() == 4 && (digit = Character.digit(hex.charAt(0), 16)) >= 8 && digit <= 15) {
            msb = true;
            char c = Character.forDigit(digit - 8, 16);
            hex = c + hex.substring(1);
        }
        short s = Short.parseShort(hex, 16);
        if (msb) {
            s = (short)(s | 0x8000);
        }
        return s;
    }

    public static short shortDecode(String value) throws NumberFormatException {
        int i = hexPrefixes.length - 1;
        while (i >= 0) {
            if (value.startsWith(hexPrefixes[i])) {
                return DebugSharedPrimitives.shortFromHexString(value.substring(hexPrefixes[i].length()));
            }
            --i;
        }
        return Short.decode(value);
    }

    public static int intFromHexString(String hex) throws NumberFormatException {
        int digit;
        boolean msb = false;
        if (hex.length() == 8 && (digit = Character.digit(hex.charAt(0), 16)) >= 8 && digit <= 15) {
            msb = true;
            char c = Character.forDigit(digit - 8, 16);
            hex = c + hex.substring(1);
        }
        int i = Integer.parseInt(hex, 16);
        if (msb) {
            i |= Integer.MIN_VALUE;
        }
        return i;
    }

    public static int intDecode(String value) throws NumberFormatException {
        int i = hexPrefixes.length - 1;
        while (i >= 0) {
            if (value.startsWith(hexPrefixes[i])) {
                return DebugSharedPrimitives.intFromHexString(value.substring(hexPrefixes[i].length()));
            }
            --i;
        }
        return Integer.decode(value);
    }

    public static long longFromHexString(String hex) throws NumberFormatException {
        int digit;
        boolean msb = false;
        if (hex.length() == 16 && (digit = Character.digit(hex.charAt(0), 16)) >= 8 && digit <= 15) {
            msb = true;
            char c = Character.forDigit(digit - 8, 16);
            hex = c + hex.substring(1);
        }
        long l = Long.parseLong(hex, 16);
        if (msb) {
            l |= Long.MIN_VALUE;
        }
        return l;
    }

    public static long longDecode(String value) throws NumberFormatException {
        int i = hexPrefixes.length - 1;
        while (i >= 0) {
            if (value.startsWith(hexPrefixes[i])) {
                return DebugSharedPrimitives.longFromHexString(value.substring(hexPrefixes[i].length()));
            }
            --i;
        }
        return Long.decode(value);
    }

    public static float floatDecode(String value) throws NumberFormatException {
        int i = hexPrefixes.length - 1;
        while (i >= 0) {
            if (value.startsWith(hexPrefixes[i])) {
                return Float.intBitsToFloat(DebugSharedPrimitives.intFromHexString(value.substring(hexPrefixes[i].length())));
            }
            --i;
        }
        return Float.parseFloat(value);
    }

    public static double doubleDecode(String value) throws NumberFormatException {
        int i = hexPrefixes.length - 1;
        while (i >= 0) {
            if (value.startsWith(hexPrefixes[i])) {
                return Double.longBitsToDouble(DebugSharedPrimitives.longFromHexString(value.substring(hexPrefixes[i].length())));
            }
            --i;
        }
        return Double.parseDouble(value);
    }

    public static synchronized DebugClassInfo getPrimitiveClassInfo(String name) {
        if (mapPrimitiveClasses == null) {
            mapPrimitiveClasses = new HashMap();
            mapPrimitiveClasses.put("boolean", new DebugPrimitiveClassInfo("boolean"));
            mapPrimitiveClasses.put("byte", new DebugPrimitiveClassInfo("byte"));
            mapPrimitiveClasses.put("char", new DebugPrimitiveClassInfo("char"));
            mapPrimitiveClasses.put("double", new DebugPrimitiveClassInfo("double"));
            mapPrimitiveClasses.put("float", new DebugPrimitiveClassInfo("float"));
            mapPrimitiveClasses.put("int", new DebugPrimitiveClassInfo("int"));
            mapPrimitiveClasses.put("long", new DebugPrimitiveClassInfo("long"));
            mapPrimitiveClasses.put("short", new DebugPrimitiveClassInfo("short"));
        }
        return (DebugClassInfo)mapPrimitiveClasses.get(name);
    }

    static class DebugPrimitiveClassInfo
    implements DebugClassInfo {
        private final String name;

        public DebugPrimitiveClassInfo(String name) {
            this.name = name;
        }

        public boolean hasExpired() {
            return false;
        }

        public String getName() {
            return this.name;
        }

        public String getPackage() {
            return "";
        }

        public String getPackagePath() {
            return "";
        }

        public String getNameWithoutPackage() {
            return this.name;
        }

        public String getGenericSignature() {
            return null;
        }

        public int getAccess() {
            return 0;
        }

        public boolean isInterface() {
            return false;
        }

        public boolean isPrimitive() {
            return true;
        }

        public boolean isObject() {
            return false;
        }

        public boolean isArray() {
            return false;
        }

        public int getSizeOfObject() {
            if (this.name.equals("boolean")) {
                return 1;
            }
            if (this.name.equals("byte")) {
                return 1;
            }
            if (this.name.equals("char")) {
                return 2;
            }
            if (this.name.equals("double")) {
                return 8;
            }
            if (this.name.equals("float")) {
                return 4;
            }
            if (this.name.equals("integer")) {
                return 4;
            }
            if (this.name.equals("long")) {
                return 8;
            }
            if (this.name.equals("short")) {
                return 2;
            }
            return 0;
        }

        public long countObjectsOfClass() {
            return 0L;
        }

        public int countMemoryOfClass() {
            return 0;
        }

        public DebugDataObjectInfo getClassObject() {
            return null;
        }

        public DebugDataObjectInfo getClassLoaderObject() {
            return null;
        }

        public DebugClassLoaderInfo getClassLoader() {
            return null;
        }

        public String getPrimarySourceFilename() {
            return "";
        }

        public String getSourceFilename() {
            return "";
        }

        public DebugClassInfo getSuperClass(int level) {
            return null;
        }

        public int getMethodCount() {
            return 0;
        }

        public DebugMethodInfo[] getMethods() {
            return new DebugMethodInfo[0];
        }

        public int getStaticFieldCount() {
            return 0;
        }

        public DebugFieldInfo[] getStaticFields() {
            return new DebugFieldInfo[0];
        }

        public DebugFieldInfo getStaticField(int index) {
            return null;
        }

        public int getStaticFieldCount(int classLevel) {
            return 0;
        }

        public DebugFieldInfo[] getStaticFields(int classLevel) {
            return new DebugFieldInfo[0];
        }

        public DebugFieldInfo getStaticField(int classLevel, int index) {
            return null;
        }

        public int getStaticFieldCount(int classLevel, boolean noFinal) {
            return 0;
        }

        public DebugFieldInfo[] getStaticFields(int classLevel, boolean noFinal) {
            return new DebugFieldInfo[0];
        }

        public DebugFieldInfo getStaticField(int classLevel, boolean noFinal, int index) {
            return null;
        }

        public DebugFieldInfo getStaticField(String name) {
            return null;
        }

        public int getFieldCount(int classLevel) {
            return 0;
        }

        public DebugFieldInfo[] getFields(int classLevel) {
            return new DebugFieldInfo[0];
        }

        public DebugFieldInfo getField(int classLevel, int index) {
            return null;
        }

        public int getFieldCount(int classLevel, boolean noFinal) {
            return 0;
        }

        public DebugFieldInfo[] getFields(int classLevel, boolean noFinal) {
            return new DebugFieldInfo[0];
        }

        public DebugFieldInfo getField(int classLevel, boolean noFinal, int index) {
            return null;
        }

        public int getFieldCount(int classLevel, boolean noFinal, boolean noStatic) {
            return 0;
        }

        public DebugFieldInfo[] getFields(int classLevel, boolean noFinal, boolean noStatic) {
            return new DebugFieldInfo[0];
        }

        public DebugFieldInfo getField(int classLevel, boolean noFinal, boolean noStatic, int index) {
            return null;
        }

        public boolean isDebuggable() {
            return false;
        }

        public void setDebuggable(boolean debuggable) {
        }

        public boolean isObfuscated() {
            return false;
        }

        public boolean isCodeCoverage() {
            return false;
        }

        public void setCodeCoverage(boolean codeCoverage) {
        }

        public void discardCodeCoverage() {
        }

        public double getCodeCoverageRatio() {
            return 0.0;
        }

        public DebugClassInfo[] getInterfaces() {
            return new DebugClassInfo[0];
        }

        public DebugClassInfo[] getInterfaces(int classLevel) {
            return new DebugClassInfo[0];
        }

        public int getLanguage() {
            return 1;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof DebugPrimitiveClassInfo) {
                DebugPrimitiveClassInfo other = (DebugPrimitiveClassInfo)o;
                return this.name.equals(this.name);
            }
            return false;
        }

        public boolean isEnum() {
            return false;
        }

        public DebugFieldInfo[] getEnumConstants() {
            return new DebugFieldInfo[0];
        }
    }
}

