/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.support;

import oracle.jdevimpl.debugger.ant.DebugAntConnector;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxJavaScriptConnector;
import oracle.jdevimpl.debugger.jdi.DebugJDIConnectorAttach;
import oracle.jdevimpl.debugger.jdi.DebugJDIConnectorListen;
import oracle.jdevimpl.debugger.support.DebugConnector;

public final class DebugFactory {
    public static final int FACTORY_JPDA_Attach = 0;
    public static final int FACTORY_JPDA = 0;
    public static final int FACTORY_JPDA_Listen = 1;
    public static final int FACTORY_Probe_Attach = 2;
    public static final int FACTORY_Probe = 2;
    public static final int FACTORY_ANT_Attach = 3;
    public static final int FACTORY_MOZILLA_FIREFOX_Attach = 4;
    private static final int FACTORY_COUNT = 5;
    private static final String[] names = new String[]{"JPDA Attach", "JPDA Listen", "Probe", "Apache Ant", "Mozilla/FireFox JavaScript"};
    private static final String[] versions = new String[5];
    private static final Class[] connectorClasses = new Class[5];

    private DebugFactory() {
    }

    static {
        DebugFactory.registerDebugConnector(0, DebugJDIConnectorAttach.class, DebugJDIConnectorAttach.getVersion());
        DebugFactory.registerDebugConnector(1, DebugJDIConnectorListen.class, DebugJDIConnectorListen.getVersion());
        DebugFactory.registerDebugConnector(3, DebugAntConnector.class, DebugAntConnector.getVersion());
        DebugFactory.registerDebugConnector(4, DebugMozillaFireFoxJavaScriptConnector.class, DebugMozillaFireFoxJavaScriptConnector.getVersion());
    }

    public static void registerDebugConnector(int i, Class connectorClass, String version) {
        if (i >= 0 && i < 5) {
            DebugFactory.versions[i] = version;
            DebugFactory.connectorClasses[i] = connectorClass;
        }
    }

    public static String[] getNames() {
        String[] n = new String[5];
        System.arraycopy(names, 0, n, 0, 5);
        return n;
    }

    public static String getName(int i) {
        if (i >= 0 && i < 5) {
            return names[i];
        }
        return null;
    }

    public static int getFactoryForName(String s) {
        if (s != null) {
            int i = 0;
            while (i < 5) {
                if (s.equals(names[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static String[] getVersions() {
        String[] v = new String[5];
        System.arraycopy(versions, 0, v, 0, 5);
        return v;
    }

    public static String getVersion(int i) {
        if (i >= 0 && i < 5) {
            return versions[i];
        }
        return null;
    }

    public static DebugConnector newInstance(int i) {
        Class c;
        if (i >= 0 && i < 5 && (c = connectorClasses[i]) != null) {
            try {
                DebugConnector debugConnector = (DebugConnector)c.newInstance();
                return debugConnector;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

