/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy;

import java.io.PrintWriter;
import java.net.URL;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.DataContainer;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.jdeveloper.deploy.DefaultDeployShellFactory;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.DeployUtil;
import oracle.jdeveloper.deploy.DeploymentConstants;
import oracle.jdeveloper.deploy.PlatformDeployable;
import oracle.jdeveloper.deploy.dt.DeployProfileDt;
import oracle.jdeveloper.deploy.dt.Deployment;
import oracle.jdeveloper.deploy.dt.DeploymentOptions;
import oracle.jdeveloper.deploy.dt.Profile;
import oracle.jdeveloper.deploy.meta.Platform;
import oracle.jdeveloper.deploy.meta.PlatformRegistry;
import oracle.jdevimpl.deploy.res.LogArb;

abstract class AbstractProfileDt
extends DeployProfileDt {
    protected String getBasePath(URL saveURL) {
        URL containerURL = AbstractProfileDt.getContainerURL(this.getCreationContext());
        if (containerURL == null && (containerURL = AbstractProfileDt.getContainerURL(Context.newIdeContext())) == null) {
            containerURL = saveURL;
        }
        return URLFileSystem.getPathNoExt((URL)DeployUtil.getDeployPathURL(containerURL, saveURL));
    }

    protected static DeployShell getDeployShellImpl(Profile profile, Context context, PrintWriter log) {
        Assert.check((profile != null ? 1 : 0) != 0, (String)"Profile cannot be null");
        if (profile instanceof PlatformDeployable) {
            Platform platform;
            boolean platformIsSet;
            boolean bl = platformIsSet = DeployUtil.getPlatform(context) != null;
            if (!platformIsSet && (platform = ((PlatformDeployable)((Object)profile)).getPlatform()) != null) {
                DeployUtil.setPlatform(context, platform);
                platformIsSet = true;
            }
            if (!platformIsSet) {
                DeployUtil.setPlatform(context, PlatformRegistry.getDefaultPlatform());
                log.println(LogArb.getString(9));
            }
        }
        DeployUtil.setProfile(context, profile);
        DefaultDeployShellFactory dsf = new DefaultDeployShellFactory();
        DeployShell dsh = dsf.create(DeploymentConstants.DEFAULT_SEQUENCE, context, null);
        return AbstractProfileDt.initDeployShell(dsh, false);
    }

    static DeployShell getDeployShell(Profile profile, Context context, PrintWriter log) {
        DeployShell dsh = AbstractProfileDt.getDeployShellImpl(profile, context, log);
        DeploymentOptions opts = DeployUtil.getDeploymentOptions(context);
        if (opts.isCompileBeforeDeploy()) {
            dsh.put("isCompileBeforeDeploy", Boolean.TRUE);
        }
        if (opts.isCleanBeforeCompile()) {
            dsh.put("isCleanBeforeCompile", Boolean.TRUE);
        }
        return dsh;
    }

    private static DeployShell initDeployShell(DeployShell dsh, boolean isConnectionDefault) {
        dsh.put("isConnectionDefault", isConnectionDefault ? Boolean.TRUE : Boolean.FALSE);
        return dsh;
    }

    static DeployShell getDeployShell(Profile profile, Context context) {
        DeployShell dsh = AbstractProfileDt.getDeployShell(profile, context, (PrintWriter)Deployment.getLogPrintWriter());
        return dsh;
    }

    private static URL getContainerURL(Context context) {
        DataContainer container;
        if (context != null && (container = DeployUtil.getProfileDataContainer(context)) != null) {
            return container.getURL();
        }
        return null;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        String cmdName = action != null ? this.getShortCommandName(action.getCommand()) : this.getDefaultCommand();
        return this.handleEventImpl(cmdName, action, context);
    }

    abstract boolean handleEventImpl(String var1, IdeAction var2, Context var3);

    AbstractProfileDt() {
    }
}

