/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.jdeveloper.deploy.common.CdaFilter;
import oracle.jdeveloper.deploy.common.CdaFilters;
import oracle.jdevimpl.deploy.CdaPacket;
import oracle.jdevimpl.deploy.res.UtilArb;

public final class ClassDependencyAnalyzer {
    private final HashSet _initialSet;
    private final URLPath _libPath;
    private final URLPath _classPath;
    private final URLPath _sourcePath;
    private CdaFilters _beforeFilters;
    private CdaFilters _duringFilters;
    private CdaFilters _afterFilters;
    private boolean _resolve;
    private boolean _recurse;
    private static final int CONSTANT_Class = 7;
    private static final int CONSTANT_Fieldref = 9;
    private static final int CONSTANT_Methodref = 10;
    private static final int CONSTANT_InterfaceMethodref = 11;
    private static final int CONSTANT_String = 8;
    private static final int CONSTANT_Integer = 3;
    private static final int CONSTANT_Float = 4;
    private static final int CONSTANT_Long = 5;
    private static final int CONSTANT_Double = 6;
    private static final int CONSTANT_NameAndType = 12;
    private static final int CONSTANT_Utf8 = 1;

    private void $init$() {
        this._initialSet = new HashSet();
        this._resolve = true;
        this._recurse = true;
    }

    public ClassDependencyAnalyzer(URLPath classPath, URLPath libPath, URLPath sourcePath) {
        this.$init$();
        this._classPath = classPath != null ? classPath : new URLPath();
        this._libPath = libPath != null ? libPath : new URLPath();
        this._sourcePath = sourcePath != null ? sourcePath : new URLPath();
    }

    public void addInitialEntry(String dottedClassName) {
        if (dottedClassName != null) {
            this._initialSet.add(dottedClassName);
        }
    }

    public void addInitialEntries(Collection dottedClassNames) {
        if (dottedClassNames != null) {
            this._initialSet.addAll(dottedClassNames);
        }
    }

    public Map analyze(Map output) {
        if (output == null) {
            output = new HashMap();
        }
        HashSet classesToAnalyze = new HashSet(this._initialSet);
        ClassDependencyAnalyzer.applyFilters(this._beforeFilters, classesToAnalyze.iterator());
        HashMap activeIncludes = new HashMap();
        this.applyIncludes(this._beforeFilters, activeIncludes);
        this.applyIncludes(this._duringFilters, activeIncludes);
        classesToAnalyze.addAll(activeIncludes.keySet());
        HashMap newClasses = new HashMap();
        while (classesToAnalyze.size() > 0) {
            Iterator iter = classesToAnalyze.iterator();
            while (iter.hasNext()) {
                String className = iter.next().toString();
                this.getNewDirectDependencies(newClasses, className, output);
            }
            classesToAnalyze.clear();
            ClassDependencyAnalyzer.applyFilters(this._duringFilters, newClasses.keySet().iterator());
            output.putAll(newClasses);
            classesToAnalyze.addAll(newClasses.keySet());
            if (!this._recurse) break;
            newClasses.clear();
        }
        this.applyIncludes(this._afterFilters, output);
        return output;
    }

    public Map getNewDirectDependencies(Map results, String className) {
        this.getNewDirectDependencies(results, className, null);
        return results;
    }

    public Map getNewDirectDependencies(String className) {
        return this.getNewDirectDependencies(new HashMap(), className);
    }

    public CdaFilters getBeforeFilters() {
        return this._beforeFilters;
    }

    public void setBeforeFilters(CdaFilters beforeFilters) {
        this._beforeFilters = beforeFilters;
    }

    public CdaFilters getDuringFilters() {
        return this._duringFilters;
    }

    public void setDuringFilters(CdaFilters duringFilters) {
        this._duringFilters = duringFilters;
    }

    public CdaFilters getAfterFilters() {
        return this._afterFilters;
    }

    public void setAfterFilters(CdaFilters afterFilters) {
        this._afterFilters = afterFilters;
    }

    public void setRecurse(boolean recurse) {
        this._recurse = recurse;
    }

    public void setResolve(boolean resolve) {
        this._resolve = resolve;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getNewDirectDependencies(Map newClasses, String className, Map currentClasses) {
        if (className == null) throw new NullPointerException();
        if (newClasses == null) {
            throw new NullPointerException();
        }
        String classResourceName = ClassDependencyAnalyzer.toSlashNotation(className) + ".class";
        FilterInputStream dis = null;
        try {
            try {
                URL classURL = this._classPath.toQualifiedURL(classResourceName);
                if (classURL == null) {
                    URL libURL = this._libPath.toQualifiedURL(classResourceName);
                    if (libURL != null) {
                        return;
                    }
                    URL resourceURL = this._classPath.toQualifiedURL(className);
                    if (resourceURL != null) {
                        if (currentClasses != null) {
                            if (currentClasses.containsKey(className)) return;
                        }
                        ClassDependencyAnalyzer.addToNewClasses(newClasses, className, className, resourceURL);
                        return;
                    }
                    if (currentClasses != null) {
                        if (currentClasses.containsKey(className)) return;
                    }
                    ClassDependencyAnalyzer.addToNewClasses(newClasses, className, className, null);
                    return;
                }
                InputStream is = URLFileSystem.openInputStream((URL)classURL);
                dis = new DataInputStream(is);
                HashSet<Integer> classIndexes = new HashSet<Integer>();
                HashMap<Integer, String> utf8Strings = new HashMap<Integer, String>();
                ((DataInputStream)dis).skipBytes(8);
                int constant_pool_count = ((DataInputStream)dis).readUnsignedShort();
                int i = 1;
                while (i < constant_pool_count) {
                    byte tag = ((DataInputStream)dis).readByte();
                    switch (tag) {
                        case 7: {
                            int name_index = ((DataInputStream)dis).readUnsignedShort();
                            classIndexes.add(new Integer(name_index));
                            break;
                        }
                        case 12: {
                            ((DataInputStream)dis).skipBytes(2);
                            int descriptor_index = ((DataInputStream)dis).readUnsignedShort();
                            classIndexes.add(new Integer(descriptor_index));
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 9: 
                        case 10: 
                        case 11: {
                            ((DataInputStream)dis).skipBytes(4);
                            break;
                        }
                        case 8: {
                            ((DataInputStream)dis).skipBytes(2);
                            break;
                        }
                        case 5: 
                        case 6: {
                            ++i;
                            ((DataInputStream)dis).skipBytes(8);
                            break;
                        }
                        case 1: {
                            String str = ((DataInputStream)dis).readUTF();
                            str = ClassDependencyAnalyzer.fieldDescriptorToClassName(str);
                            utf8Strings.put(new Integer(i), str);
                            break;
                        }
                        default: {
                            System.err.println(UtilArb.format(14, classResourceName, new Integer(tag)));
                        }
                    }
                    ++i;
                }
                ((DataInputStream)dis).skipBytes(6);
                int interfaces_count = ((DataInputStream)dis).readUnsignedShort();
                ((DataInputStream)dis).skipBytes(2 * interfaces_count);
                int fields_count = ((DataInputStream)dis).readUnsignedShort();
                int i2 = 0;
                while (i2 < fields_count) {
                    ((DataInputStream)dis).skipBytes(4);
                    int descriptor_index = ((DataInputStream)dis).readUnsignedShort();
                    classIndexes.add(new Integer(descriptor_index));
                    int attributes_count = ((DataInputStream)dis).readUnsignedShort();
                    int j = 0;
                    while (j < attributes_count) {
                        ((DataInputStream)dis).skipBytes(2);
                        int attribute_length = ((DataInputStream)dis).readInt();
                        ((DataInputStream)dis).skipBytes(attribute_length);
                        ++j;
                    }
                    ++i2;
                }
                int methods_count = ((DataInputStream)dis).readUnsignedShort();
                int i3 = 0;
                while (i3 < methods_count) {
                    ((DataInputStream)dis).skipBytes(4);
                    int descriptor_index = ((DataInputStream)dis).readUnsignedShort();
                    classIndexes.add(new Integer(descriptor_index));
                    int attribute_count = ((DataInputStream)dis).readUnsignedShort();
                    int j = 0;
                    while (j < attribute_count) {
                        ((DataInputStream)dis).skipBytes(2);
                        int attribute_length = ((DataInputStream)dis).readInt();
                        ((DataInputStream)dis).skipBytes(attribute_length);
                        ++j;
                    }
                    ++i3;
                }
                HashSet<String> methodDescriptors = new HashSet<String>();
                for (Integer i4 : classIndexes) {
                    String classNameToAdd = (String)utf8Strings.get(i4);
                    if (classNameToAdd == null) continue;
                    if (classNameToAdd.charAt(0) == '(') {
                        methodDescriptors.add(classNameToAdd);
                        continue;
                    }
                    if (currentClasses != null && currentClasses.containsKey(classNameToAdd)) continue;
                    this.addUnresolvedClass(classNameToAdd, newClasses);
                }
                for (String methodDescriptor : methodDescriptors) {
                    HashSet classNames = ClassDependencyAnalyzer.methodDescriptorToClassNames(methodDescriptor);
                    for (String classNameToAdd : classNames) {
                        if (currentClasses != null && currentClasses.containsKey(classNameToAdd)) continue;
                        this.addUnresolvedClass(classNameToAdd, newClasses);
                    }
                }
                return;
            }
            finally {
                try {
                    if (dis == null) return;
                    dis.close();
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    private static String fieldDescriptorToClassName(String fieldDescriptor) {
        if (fieldDescriptor == null || fieldDescriptor.length() == 0) {
            return fieldDescriptor;
        }
        if (fieldDescriptor.charAt(0) == '(') {
            return fieldDescriptor;
        }
        int beginIndex = fieldDescriptor.lastIndexOf(91) + 1;
        int endIndex = fieldDescriptor.length();
        if (endIndex - beginIndex <= 1) {
            return null;
        }
        if (fieldDescriptor.endsWith(";")) {
            ++beginIndex;
            --endIndex;
        }
        return fieldDescriptor.substring(beginIndex, endIndex);
    }

    private static HashSet methodDescriptorToClassNames(String methodDescriptor) {
        HashSet<String> classes = new HashSet<String>();
        if (methodDescriptor == null || methodDescriptor.length() == 0 || methodDescriptor.charAt(0) != '(') {
            return classes;
        }
        char[] chars = methodDescriptor.toCharArray();
        int charsLen = chars.length;
        boolean inReturnType = false;
        int i = 1;
        while (i < charsLen) {
            char curChar = chars[i];
            switch (curChar) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': 
                case '[': {
                    break;
                }
                case ')': {
                    if (inReturnType) {
                        System.err.println(UtilArb.getString(3));
                        break;
                    }
                    inReturnType = true;
                    break;
                }
                case 'L': {
                    int semicolonIndex = methodDescriptor.indexOf(59, ++i);
                    classes.add(methodDescriptor.substring(i, semicolonIndex));
                    i = semicolonIndex;
                    break;
                }
                case 'V': {
                    if (inReturnType) break;
                }
                default: {
                    System.err.println(UtilArb.format(18, new Character(curChar)));
                    break;
                }
            }
            ++i;
        }
        return classes;
    }

    private static void addToNewClasses(Map newClasses, String className, String entryName, URL url) {
        CdaPacket cdaPacket = new CdaPacket(entryName, url);
        newClasses.put(className, cdaPacket);
    }

    private void addUnresolvedClass(String className, Map newClasses) {
        String resourceName = className + ".class";
        if (this._resolve) {
            URL libURL;
            URL resourceURL = this._classPath.toQualifiedURL(resourceName);
            if (resourceURL == null && (libURL = this._libPath.toQualifiedURL(resourceName)) != null) {
                return;
            }
            ClassDependencyAnalyzer.addToNewClasses(newClasses, className, resourceName, resourceURL);
        } else {
            ClassDependencyAnalyzer.addToNewClasses(newClasses, className, resourceName, null);
        }
    }

    private void applyIncludes(CdaFilters cdaFilters, Map cdaPackets) {
        if (cdaFilters == null) {
            return;
        }
        ClassDependencyAnalyzer.applyIncludes(cdaFilters, this._classPath, cdaPackets);
        ClassDependencyAnalyzer.applyIncludes(cdaFilters, this._libPath, cdaPackets);
        ClassDependencyAnalyzer.applyFilters(cdaFilters, cdaPackets.keySet().iterator());
    }

    private static void applyIncludes(CdaFilters cdaFilters, URLPath urlPath, Map cdaPackets) {
        CdaFilter[] filters = cdaFilters.getFilters();
        if (filters == null) {
            return;
        }
        int n = filters.length;
        int i = n - 1;
        while (i >= 0) {
            CdaFilter filter = filters[i];
            if (filter.getType() == 0) {
                String name = ClassDependencyAnalyzer.toSlashNotation(filter.getName());
                switch (filter.getScope()) {
                    case 4: {
                        String resourceName = name + ".class";
                        URL resourceURL = urlPath.toQualifiedURL(resourceName);
                        ClassDependencyAnalyzer.addToNewClasses(cdaPackets, name, resourceName, resourceURL);
                        break;
                    }
                    case 2: {
                        List fileList = urlPath.getFiles(name);
                        for (URL resourceURL : fileList) {
                            String resourceName = urlPath.toRelativePath(resourceURL);
                            String urlName = URLFileSystem.getName((URL)resourceURL);
                            ClassDependencyAnalyzer.addToNewClasses(cdaPackets, name + "/" + urlName, resourceName, resourceURL);
                        }
                        break;
                    }
                    case 0: {
                        ArrayList<String> dirs = new ArrayList<String>();
                        dirs.add(name);
                        ArrayList newDirs = new ArrayList();
                        while (dirs.size() > 0) {
                            Iterator dirsIter = dirs.iterator();
                            while (dirsIter.hasNext()) {
                                String dir = dirsIter.next().toString();
                                dirsIter.remove();
                                List fileList = urlPath.getFiles(dir);
                                for (URL resourceURL : fileList) {
                                    String resourceName = urlPath.toRelativePath(resourceURL);
                                    String urlName = URLFileSystem.getName((URL)resourceURL);
                                    ClassDependencyAnalyzer.addToNewClasses(cdaPackets, dir + "/" + urlName, resourceName, resourceURL);
                                }
                                newDirs.addAll(urlPath.getDirectories(dir));
                            }
                            dirs.clear();
                            dirs.addAll(newDirs);
                            newDirs.clear();
                        }
                        break;
                    }
                }
            }
            --i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void applyFilters(CdaFilters filters, Iterator iter) {
        if (filters != null) ** GOTO lbl7
        return;
lbl-1000:
        // 1 sources

        {
            nextClass = iter.next().toString();
            dotted = ClassDependencyAnalyzer.toDotNotation(nextClass);
            if (filters.isIncluded(dotted)) continue;
            iter.remove();
lbl7:
            // 3 sources

            ** while (iter.hasNext())
        }
lbl8:
        // 1 sources

    }

    private static final String toDotNotation(String name) {
        return name.replace('/', '.');
    }

    private static final String toSlashNotation(String name) {
        return name.replace('.', '/');
    }
}

