/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy;

import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.ide.util.macro.StringMacroConverter;

public class CommandLineTokenizer {
    public String[] toArgs(String cmd, Map macros) {
        return CommandLineTokenizer.expandMacros(CommandLineTokenizer.extractArgs(cmd), macros);
    }

    static String[] expandMacros(String[] args, Map macros) {
        ArrayList<String> result = new ArrayList<String>();
        int n = args.length;
        StringMacroConverter converter = StringMacroConverter.getConverter((int)3);
        int i = 0;
        while (i < n) {
            String expandedArg = converter.expandString(args[i], macros);
            if (expandedArg != null && expandedArg.length() > 0) {
                StringTokenizer st = new StringTokenizer(expandedArg, "\u0000");
                while (st.hasMoreTokens()) {
                    result.add(st.nextToken());
                }
            }
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    static String[] extractArgs(String cmd) {
        StringBuffer curArg = new StringBuffer();
        int n = cmd.length();
        boolean doubleQuoteSeen = false;
        boolean singleQuoteSeen = false;
        ArrayList<String> args = new ArrayList<String>();
        int i = 0;
        while (i < n) {
            char c = cmd.charAt(i);
            block0 : switch (c) {
                case '\\': {
                    if (++i < n) {
                        char c2 = cmd.charAt(i);
                        switch (c2) {
                            case '\"': 
                            case '\'': 
                            case '\\': {
                                curArg.append(c2);
                                break block0;
                            }
                        }
                        curArg.append('\\').append(c2);
                        break;
                    }
                    curArg.append('\\');
                    break;
                }
                case '\"': {
                    if (singleQuoteSeen) {
                        curArg.append('\"');
                        break;
                    }
                    doubleQuoteSeen ^= true;
                    break;
                }
                case '\'': {
                    if (doubleQuoteSeen) {
                        curArg.append('\'');
                        break;
                    }
                    singleQuoteSeen ^= true;
                    break;
                }
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (doubleQuoteSeen || singleQuoteSeen) {
                        curArg.append(c);
                        break;
                    }
                    if (curArg.length() <= 0) break;
                    args.add(curArg.toString());
                    curArg.setLength(0);
                    break;
                }
                default: {
                    curArg.append(c);
                }
            }
            ++i;
        }
        if (curArg.length() > 0) {
            args.add(curArg.toString());
        }
        return args.toArray(new String[args.size()]);
    }
}

