/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy;

import java.awt.Component;
import java.awt.Container;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.gallery.GalleryManager;
import oracle.ide.gallery.ObjectGallery;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.SwingWorker;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.deploy.DeployUtil;
import oracle.jdeveloper.deploy.dt.DeployMenuItem;
import oracle.jdeveloper.deploy.dt.DeployProfileDt;
import oracle.jdeveloper.deploy.dt.Deployment;
import oracle.jdeveloper.deploy.dt.DeploymentProfiles;
import oracle.jdeveloper.deploy.dt.Profile;
import oracle.jdeveloper.deploy.res.DeployArb;
import oracle.jdevimpl.deploy.res.DtArb;

final class DeployMainMenu
implements Controller,
MenuListener {
    private final JMenu _deployMenu;
    private final DeployMenuItem _deployProject;
    private Worker _worker;
    private static final String GALLERY_CATEGORY_KEY = "Deployment Profiles";
    private static final String DEPLOY_NODE_KEY = "deployNode";
    private static final String ACTION_NEW_DEPLOYMENT_PROFILE = "Deployment.newDeploymentProfile";
    private static final String ACTION_DEPLOY_PREFIX = "Deployment.main";
    private static final String PROFILE_CONTAINER = "DataContainer";
    private static final float SECTION_ONE = 1.0f;
    private static final float SECTION_TWO = 2.0f;

    DeployMainMenu() {
        if (Ide.getMainWindow() != null) {
            Menubar menuMgr = Ide.getMenubar();
            this._deployMenu = menuMgr.createSubMenu(DtArb.getString(23), DtArb.getInteger(31), JDeveloperMenuConstants.WEIGHT_RUN_DEPLOY);
            MenuManager.setMenuId((JMenu)this._deployMenu, (String)"run.deploymenu");
            this._deployMenu.addMenuListener(this);
            menuMgr.add((Component)this._deployMenu, MenuManager.getJMenu((String)"Build"), JDeveloperMenuConstants.SECTION_BUILD_TOOLS);
            this._deployProject = new DeployMenuItem(ACTION_NEW_DEPLOYMENT_PROFILE, DtArb.getString(39), this);
        } else {
            this._deployMenu = null;
            this._deployProject = null;
            this._worker = null;
        }
    }

    public boolean handleEvent(IdeAction action, Context context) {
        if (this._deployProject != null) {
            int cmdID = action.getCommandId();
            if (cmdID == this._deployProject.id) {
                DeployMainMenu.launchGallery(context, GALLERY_CATEGORY_KEY);
                return true;
            }
            if (action.getValue(DEPLOY_NODE_KEY) != null) {
                Node node = (Node)action.getValue(DEPLOY_NODE_KEY);
                Context actionContext = new Context(context);
                actionContext.setNode(node);
                actionContext.setElement((Element)node);
                Deployment.deploy(actionContext);
                return true;
            }
            if (DeployUtil.getProfile((Action)action) != null) {
                Profile profile = DeployUtil.getProfile((Action)action);
                DataContainer container = (DataContainer)action.getValue(PROFILE_CONTAINER);
                Context actionContext = new Context(context);
                DeployUtil.setProfile(actionContext, profile);
                actionContext.setNode((Node)container);
                actionContext.setElement((Element)profile);
                Deployment.deploy(actionContext);
                return true;
            }
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        String cmd;
        if (!(action == this._deployProject.action || (cmd = action.getCommand()) != null && cmd.startsWith(ACTION_DEPLOY_PREFIX))) {
            return false;
        }
        boolean contextHasProject = context.getProject() != null;
        action.setEnabled(contextHasProject);
        return true;
    }

    public void menuCanceled(MenuEvent e) {
        this.cancelRebuildDeploySubmenu();
    }

    public void menuDeselected(MenuEvent e) {
        this.cancelRebuildDeploySubmenu();
    }

    public void menuSelected(MenuEvent e) {
        this.scheduleRebuildDeploySubmenu();
    }

    private static void launchGallery(Context context, String category) {
        ObjectGallery gallery;
        GalleryManager gm = GalleryManager.getGalleryManager();
        if (gm != null && (gallery = gm.getGallery()) != null) {
            gallery.runDialog(context, category, null);
        }
    }

    private void cancelRebuildDeploySubmenu() {
        Assert.checkAWTThread();
        if (this._worker != null) {
            this._worker.cancel();
        }
    }

    private void scheduleRebuildDeploySubmenu() {
        Assert.checkAWTThread();
        this._deployMenu.removeAll();
        Menubar menuMgr = Ide.getMenubar();
        JMenuItem loadingItem = new JMenuItem("Scanning...");
        loadingItem.setEnabled(false);
        menuMgr.add((Component)loadingItem, this._deployMenu, 1.0f);
        menuMgr.add((Component)this._deployProject.menuItem, this._deployMenu, 2.0f);
        this._worker = new Worker(null);
        this._worker.start();
    }

    static JMenu ra$_deployMenu(DeployMainMenu deployMainMenu) {
        return deployMainMenu._deployMenu;
    }

    static DeployMenuItem ra$_deployProject(DeployMainMenu deployMainMenu) {
        return deployMainMenu._deployProject;
    }

    static void wa$_worker(DeployMainMenu deployMainMenu, Worker worker) {
        deployMainMenu._worker = worker;
    }

    private final class Worker
    extends SwingWorker {
        private volatile boolean _canceled;

        void cancel() {
            this._canceled = true;
        }

        public Object construct() {
            Workspace workspace;
            ArrayList<ProfileData> deploymentProfiles = new ArrayList<ProfileData>();
            Context context = Context.newIdeContext();
            DeployMainMenu.this.update(DeployMainMenu.ra$_deployProject((DeployMainMenu)DeployMainMenu.this).action, context);
            Project project = context.getProject();
            if (project != null) {
                DeploymentProfiles profiles = DeploymentProfiles.getInstance((DataContainer)project);
                Map profileMap = profiles.getDefinedProfiles(true);
                Set entrySet = profileMap.entrySet();
                for (Map.Entry entry : entrySet) {
                    Profile profile = (Profile)entry.getValue();
                    deploymentProfiles.add(new ProfileData((DataContainer)project, profile));
                }
            }
            if ((workspace = context.getWorkspace()) != null) {
                DeploymentProfiles wprofiles = DeploymentProfiles.getInstance((DataContainer)workspace);
                Map wprofileMap = wprofiles.getDefinedProfiles(true);
                Set wentrySet = wprofileMap.entrySet();
                for (Map.Entry entry : wentrySet) {
                    Profile profile = (Profile)entry.getValue();
                    deploymentProfiles.add(new ProfileData((DataContainer)workspace, profile));
                }
            }
            if (this._canceled) {
                deploymentProfiles.clear();
            }
            return deploymentProfiles;
        }

        public void finished() {
            if (!this._canceled) {
                DeployMainMenu.ra$_deployMenu(DeployMainMenu.this).removeAll();
                Menubar menuMgr = Ide.getMenubar();
                menuMgr.add((Component)DeployMainMenu.ra$_deployProject((DeployMainMenu)DeployMainMenu.this).menuItem, DeployMainMenu.ra$_deployMenu(DeployMainMenu.this), 2.0f);
                ArrayList deploymentProfiles = (ArrayList)this.get();
                int profileCount = 0;
                Iterator profileIter = deploymentProfiles.iterator();
                while (profileIter.hasNext()) {
                    Icon icon;
                    String profileName;
                    ++profileCount;
                    Object obj = profileIter.next();
                    String deployToString = "";
                    String deployToTarget = "";
                    if (obj instanceof ProfileData) {
                        Profile profile = ((ProfileData)obj).getProfile();
                        profileName = profile.getName();
                        icon = profile.getIcon();
                        DeployProfileDt dt = Deployment.getProfileDesignTime(profile.getClass());
                        deployToTarget = dt.getMostRecentDeployTarget();
                        deployToString = deployToTarget != null ? "  (" + deployToTarget + ")" : "  (" + DeployArb.getString(50) + ")";
                    } else {
                        Node node = (Node)obj;
                        URL profileURL = node.getURL();
                        profileName = URLFileSystem.getFileName((URL)profileURL);
                        icon = node.getIcon();
                    }
                    boolean hasMnemonic = profileCount <= 9;
                    String menuLabel = hasMnemonic ? DtArb.format(100, "&" + new Integer(profileCount), profileName + deployToString) : profileName;
                    DeployMenuItem dmi = new DeployMenuItem(DeployMainMenu.ACTION_DEPLOY_PREFIX + profileCount, menuLabel, DeployMainMenu.this);
                    dmi.menuItem.setIcon(icon);
                    ResourceUtils.resButton((AbstractButton)dmi.menuItem, (String)menuLabel);
                    if (deployToTarget == null) {
                        dmi.menuItem.setEnabled(false);
                    }
                    if (obj instanceof ProfileData) {
                        DeployUtil.setProfile((Action)dmi.action, ((ProfileData)obj).getProfile());
                        DeployUtil.setProfileDataContainer((Action)dmi.action, ((ProfileData)obj).getContainer());
                    } else {
                        dmi.action.putValue(DeployMainMenu.DEPLOY_NODE_KEY, obj);
                    }
                    menuMgr.add((Component)dmi.menuItem, DeployMainMenu.ra$_deployMenu(DeployMainMenu.this), 1.0f);
                }
                if (profileCount == 0) {
                    JMenuItem noProfilesItem = new JMenuItem(DtArb.getString(20));
                    noProfilesItem.setEnabled(false);
                    menuMgr.add((Component)noProfilesItem, DeployMainMenu.ra$_deployMenu(DeployMainMenu.this), 1.0f);
                }
                menuMgr.sortContainer((Container)DeployMainMenu.ra$_deployMenu(DeployMainMenu.this));
                DeployMainMenu.ra$_deployMenu(DeployMainMenu.this).getPopupMenu().pack();
            }
            DeployMainMenu.wa$_worker(DeployMainMenu.this, null);
        }

        private Worker() {
        }

        Worker(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    protected class ProfileData {
        private DataContainer _container;
        private Profile _profile;

        public ProfileData(DataContainer container, Profile profile) {
            this._container = container;
            this._profile = profile;
        }

        public Profile getProfile() {
            return this._profile;
        }

        public DataContainer getContainer() {
            return this._container;
        }
    }
}

