/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy;

import java.io.File;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.config.IdeSettings;
import oracle.ide.config.IdeSettingsMigrator;
import oracle.ide.migration.MigrationManager;
import oracle.ide.migration.Migrator;
import oracle.ide.migration.XMLMigrator;
import oracle.jdeveloper.deploy.dt.Deployment;
import oracle.jdeveloper.deploy.dt.DeploymentOptions;

public class DeployMigrator
extends XMLMigrator {
    private static final int DEPLOY_SETTINGS = 23891;

    public DeployMigrator() {
        super(new int[]{23891});
    }

    public String[] migrate(File sourceDir, File destDir) {
        Ide.addIdeListener((IdeListener)new Impl(sourceDir, destDir, MigrationManager.getMigrationManager()));
        return null;
    }

    public String getDescription(int category) {
        return null;
    }

    protected String getFileName() {
        return "settings.xml";
    }

    protected String getNamespaceURI() {
        return IdeSettings.NAMESPACE_URI;
    }

    protected String getRootTag() {
        return "ide-settings";
    }

    private class Impl
    implements IdeListener {
        private final File _sourceDir;
        private final File _destDir;
        private final MigrationManager _mm;

        Impl(File sourceDir, File destDir, MigrationManager mm) {
            this._sourceDir = sourceDir;
            this._destDir = destDir;
            this._mm = mm;
        }

        public void addinsLoaded(IdeEvent e) {
            Ide.removeIdeListener((IdeListener)this);
            try {
                DeploymentOptions opts = Deployment.getDeploymentOptions();
                File curOc4jHome = opts.getOc4jHome();
                if (curOc4jHome != null) {
                    boolean userKeptDefault;
                    File oracleHome;
                    Migrator migrator;
                    Migrator migrator2 = migrator = this._mm != null ? this._mm.getMigrator(IdeSettingsMigrator.class) : null;
                    if (migrator != null && migrator.isSelected(0) && (oracleHome = this._mm.getOracleHomeDirectory(this._sourceDir)) != null && (userKeptDefault = curOc4jHome.equals(new File(oracleHome, "j2ee/home")))) {
                        opts.setOc4jHome(null);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public void mainWindowOpened(IdeEvent e) {
        }

        public void mainWindowClosing(IdeEvent e) {
        }
    }
}

