/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.ide.net.URLTextField;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.deploy.dt.DeploymentOptions;
import oracle.jdevimpl.deploy.common.MaxHeapSizeComboBox;
import oracle.jdevimpl.deploy.res.DtArb;

public class DeploymentOptionsPanel
extends DefaultTraversablePanel
implements ActionListener {
    private final JRadioButton rbAppDeployOutputRelative;
    private final JTextField tfAppDeployOutputRelative;
    private final JRadioButton rbAppDeployOutputAbsolute;
    private final URLTextField tfAppDeployOutputAbsolute;
    private final JRadioButton rbDeployOutputFolder;
    private final JTextField tfDeployOutputFolder;
    private final JRadioButton rbDeployAbsoluteOutputFolder;
    private final URLTextField tfDeployAbsoluteOutputFolder;
    private final JButton browseAppAbsolute;
    private final JButton jbBrowse;
    private final ButtonGroup appGroup;
    private final ButtonGroup group;
    private final JCheckBox cbCompileBeforeDeploy;
    private final JCheckBox cbAutoFillEjbRefElems;
    private final JCheckBox cbForceJarRewrite;
    private final JCheckBox cbIncludeDataSources;
    private final JCheckBox cbAutoGenerateMar;
    private final JCheckBox cbAccessInternalOC4JClasses;
    private final MaxHeapSizeComboBox cbMaxHeapSize;
    private final OutputDirectorySettings _projectOutputSettings;
    private final OutputDirectorySettings _applicationOutputSettings;
    private static boolean enableMarOptions = false;

    private void $init$() {
        this.rbAppDeployOutputRelative = new JRadioButton();
        this.tfAppDeployOutputRelative = new JTextField();
        this.rbAppDeployOutputAbsolute = new JRadioButton();
        this.tfAppDeployOutputAbsolute = new URLTextField(null, true, false);
        this.rbDeployOutputFolder = new JRadioButton();
        this.tfDeployOutputFolder = new JTextField();
        this.rbDeployAbsoluteOutputFolder = new JRadioButton();
        this.tfDeployAbsoluteOutputFolder = new URLTextField(null, true, false);
        this.browseAppAbsolute = new JButton();
        this.jbBrowse = new JButton();
        this.appGroup = new ButtonGroup();
        this.group = new ButtonGroup();
        this.cbCompileBeforeDeploy = new JCheckBox();
        this.cbAutoFillEjbRefElems = new JCheckBox();
        this.cbForceJarRewrite = new JCheckBox();
        this.cbIncludeDataSources = new JCheckBox();
        this.cbAutoGenerateMar = new JCheckBox();
        this.cbAccessInternalOC4JClasses = new JCheckBox();
        this.cbMaxHeapSize = new MaxHeapSizeComboBox();
    }

    public DeploymentOptionsPanel() {
        this.$init$();
        JLabel lblAppDeployOutputDirectory = new JLabel();
        JLabel lblDeployOutputDirectory = new JLabel();
        ResourceUtils.resLabel((JLabel)lblAppDeployOutputDirectory, (Component)lblAppDeployOutputDirectory, (String)DtArb.getString(51));
        ResourceUtils.resLabel((JLabel)lblDeployOutputDirectory, (Component)lblDeployOutputDirectory, (String)DtArb.getString(110));
        ResourceUtils.resButton((AbstractButton)this.cbCompileBeforeDeploy, (String)DtArb.getString(123));
        ResourceUtils.resButton((AbstractButton)this.cbAutoFillEjbRefElems, (String)DtArb.getString(88));
        ResourceUtils.resButton((AbstractButton)this.rbAppDeployOutputRelative, (String)DtArb.getString(62));
        ResourceUtils.resButton((AbstractButton)this.rbAppDeployOutputAbsolute, (String)DtArb.getString(15));
        ResourceUtils.resButton((AbstractButton)this.rbDeployOutputFolder, (String)DtArb.getString(104));
        ResourceUtils.resButton((AbstractButton)this.rbDeployAbsoluteOutputFolder, (String)DtArb.getString(55));
        ResourceUtils.resButton((AbstractButton)this.browseAppAbsolute, (String)DtArb.getString(94));
        ResourceUtils.resButton((AbstractButton)this.jbBrowse, (String)DtArb.getString(5));
        ResourceUtils.resButton((AbstractButton)this.cbForceJarRewrite, (String)DtArb.getString(54));
        ResourceUtils.resButton((AbstractButton)this.cbIncludeDataSources, (String)DtArb.getString(43));
        ResourceUtils.resButton((AbstractButton)this.cbAutoGenerateMar, (String)DtArb.getString(65));
        ResourceUtils.resButton((AbstractButton)this.cbAccessInternalOC4JClasses, (String)DtArb.getString(44));
        JLabel lblDefaultDeployHeapSize = new JLabel();
        ResourceUtils.resLabel((JLabel)lblDefaultDeployHeapSize, (Component)this.cbMaxHeapSize, (String)DtArb.getString(48));
        this.appGroup.add(this.rbAppDeployOutputRelative);
        this.appGroup.add(this.rbAppDeployOutputAbsolute);
        this.group.add(this.rbDeployOutputFolder);
        this.group.add(this.rbDeployAbsoluteOutputFolder);
        this._projectOutputSettings = new OutputDirectorySettings(new ProjectDirectorySettings(null), this.rbDeployOutputFolder, this.tfDeployOutputFolder, this.rbDeployAbsoluteOutputFolder, this.tfDeployAbsoluteOutputFolder, this.jbBrowse);
        this._applicationOutputSettings = new OutputDirectorySettings(new ApplicationDirectorySettings(null), this.rbAppDeployOutputRelative, this.tfAppDeployOutputRelative, this.rbAppDeployOutputAbsolute, this.tfAppDeployOutputAbsolute, this.browseAppAbsolute);
        Insets in5555 = new Insets(5, 5, 5, 5);
        this.setLayout(new GridBagLayout());
        int y = 0;
        this.add(lblAppDeployOutputDirectory, this.gbc(0, ++y, 2, 1, 0.0, 0.0, 18, 0, in5555));
        this.add(this.rbAppDeployOutputRelative, this.gbc(0, ++y, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 15, 5, 5)));
        this.add(this.tfAppDeployOutputRelative, this.gbc(1, y, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 5, 5)));
        this.add(this.rbAppDeployOutputAbsolute, this.gbc(0, ++y, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 15, 5, 5)));
        this.add((Component)this.tfAppDeployOutputAbsolute, this.gbc(1, y, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 5, 5)));
        this.add(this.browseAppAbsolute, this.gbc(2, y, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 5, 5)));
        this.add(lblDeployOutputDirectory, this.gbc(0, ++y, 2, 1, 0.0, 0.0, 18, 0, in5555));
        this.add(this.rbDeployOutputFolder, this.gbc(0, ++y, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 15, 5, 5)));
        this.add(this.tfDeployOutputFolder, this.gbc(1, y, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 5, 5)));
        this.add(this.rbDeployAbsoluteOutputFolder, this.gbc(0, ++y, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 15, 5, 5)));
        this.add((Component)this.tfDeployAbsoluteOutputFolder, this.gbc(1, y, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 5, 5)));
        this.add(this.jbBrowse, this.gbc(2, y, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 5, 5)));
        this.add(this.cbCompileBeforeDeploy, this.gbc(0, ++y, 3, 1, 0.0, 0.0, 18, 0, in5555));
        this.add(this.cbAutoFillEjbRefElems, this.gbc(0, ++y, 3, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 5, 5)));
        this.add(this.cbForceJarRewrite, this.gbc(0, ++y, 3, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 5, 5)));
        this.add(this.cbIncludeDataSources, this.gbc(0, ++y, 3, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 5, 5)));
        if (enableMarOptions) {
            this.add(this.cbAutoGenerateMar, this.gbc(0, ++y, 3, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 5, 5)));
        }
        this.add(this.cbAccessInternalOC4JClasses, this.gbc(0, ++y, 3, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 5, 5)));
        this.add(lblDefaultDeployHeapSize, this.gbc(0, ++y, 3, 1, 0.0, 0.0, 18, 0, in5555));
        this.add(this.cbMaxHeapSize, this.gbc(0, ++y, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 15, 5, 5)));
        this.add(new JLabel(), this.gbc(0, ++y, 1, 1, 0.0, 1.0, 18, 3, in5555));
        this.setHelpID("f1_depideoptdep_html");
        this.rbDeployOutputFolder.addActionListener(this);
        this.rbDeployAbsoluteOutputFolder.addActionListener(this);
        this.rbAppDeployOutputAbsolute.addActionListener(this);
        this.rbAppDeployOutputRelative.addActionListener(this);
        this.jbBrowse.addActionListener(this);
        this.browseAppAbsolute.addActionListener(this);
    }

    public void onEntry(TraversableContext tc) {
        DeploymentOptions options = (DeploymentOptions)((Object)tc.find("deployment-options"));
        this.cbCompileBeforeDeploy.setSelected(options.isCompileBeforeDeploy());
        this.cbAutoFillEjbRefElems.setSelected(options.isAutoUpdateWebXmlEjbRefs());
        this.cbForceJarRewrite.setSelected(options.isForceJarRewrite());
        this.cbIncludeDataSources.setSelected(options.isIncludeDataSources());
        this.cbAutoGenerateMar.setSelected(options.isAutoGenerateMar());
        this.cbAccessInternalOC4JClasses.setSelected(options.isAccessInternalOC4JClasses());
        this._applicationOutputSettings.handleOnEntry(options);
        this._projectOutputSettings.handleOnEntry(options);
        this.cbMaxHeapSize.setMaxHeapSize(options.getDefaultDeployHeapSize());
        this.setState();
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        DeploymentOptions options = (DeploymentOptions)((Object)tc.find("deployment-options"));
        options.setCompileBeforeDeploy(this.cbCompileBeforeDeploy.isSelected());
        options.setAutoUpdateWebXmlEjbRefs(this.cbAutoFillEjbRefElems.isSelected());
        options.setForceJarRewrite(this.cbForceJarRewrite.isSelected());
        options.setIncludeDataSources(this.cbIncludeDataSources.isSelected());
        options.setAutoGenerateMar(this.cbAutoGenerateMar.isSelected());
        options.setAccessInternalOC4JClasses(this.cbAccessInternalOC4JClasses.isSelected());
        this._applicationOutputSettings.handleOnExit(options);
        this._projectOutputSettings.handleOnExit(options);
        options.setDefaultDeployHeapSize(this.cbMaxHeapSize.getMaxHeapSize());
    }

    private void setState() {
        this._applicationOutputSettings.handleSetState();
        this._projectOutputSettings.handleSetState();
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        this._applicationOutputSettings.handleActionPerformed(source);
        this._projectOutputSettings.handleActionPerformed(source);
    }

    public static void EnableMarOptions() {
        enableMarOptions = true;
    }

    static JTextField ra$tfAppDeployOutputRelative(DeploymentOptionsPanel deploymentOptionsPanel) {
        return deploymentOptionsPanel.tfAppDeployOutputRelative;
    }

    private class OutputDirectorySettings {
        private DirectorySettingsMarshaller _dsm;
        private JRadioButton _rbRelative;
        private JTextField _tfRelativeFolder;
        private JRadioButton _rbAbsolute;
        private URLTextField _tfAbsoluteURL;
        private JButton _browseAbsolute;

        OutputDirectorySettings(DirectorySettingsMarshaller dsm, JRadioButton rbRelative, JTextField tfRelativeFolder, JRadioButton rbAbsolute, URLTextField tfAbsoluteURL, JButton browseAbsolute) {
            this._dsm = dsm;
            this._rbRelative = rbRelative;
            this._tfRelativeFolder = tfRelativeFolder;
            this._rbAbsolute = rbAbsolute;
            this._tfAbsoluteURL = tfAbsoluteURL;
            this._browseAbsolute = browseAbsolute;
        }

        void handleOnEntry(DeploymentOptions options) {
            URL url = this._dsm.getAbsoluteURL(options);
            if (url != null) {
                this._rbAbsolute.setSelected(true);
                this._tfAbsoluteURL.setURL(url);
            } else {
                this._rbRelative.setSelected(true);
                String folder = this._dsm.getRelativeFolder(options);
                if (folder != null) {
                    this._tfRelativeFolder.setText(folder);
                } else {
                    DeploymentOptionsPanel.ra$tfAppDeployOutputRelative(DeploymentOptionsPanel.this).setText("deploy");
                }
            }
        }

        void handleOnExit(DeploymentOptions options) {
            String folder = null;
            if (this._rbRelative.isSelected()) {
                folder = this._tfRelativeFolder.getText();
                if (!ModelUtil.hasLength((String)folder)) {
                    folder = "deploy";
                } else if (File.separatorChar != '/') {
                    folder = folder.replace(File.separatorChar, '/');
                }
                this._dsm.setRelativeFolder(options, folder);
            } else if (this._rbAbsolute.isSelected()) {
                URL url = this._tfAbsoluteURL.getURL();
                if (url != null) {
                    this._dsm.setAbsoluteURL(options, url);
                } else {
                    this._dsm.setRelativeFolder(options, "deploy");
                }
            }
        }

        void handleSetState() {
            boolean isRelative = this._rbRelative.isSelected();
            this._tfRelativeFolder.setEnabled(isRelative);
            this._tfAbsoluteURL.setEnabled(isRelative ^ true);
            this._browseAbsolute.setEnabled(isRelative ^ true);
            if (isRelative && !ModelUtil.hasLength((String)this._tfRelativeFolder.getText())) {
                this._tfRelativeFolder.setText("deploy");
            }
        }

        void handleActionPerformed(Object source) {
            if (source == this._rbRelative || source == this._rbAbsolute) {
                this.handleSetState();
            } else if (source == this._browseAbsolute) {
                this._tfAbsoluteURL.browseForURL();
            }
        }
    }

    private interface DirectorySettingsMarshaller {
        public void setRelativeFolder(DeploymentOptions var1, String var2);

        public void setAbsoluteURL(DeploymentOptions var1, URL var2);

        public String getRelativeFolder(DeploymentOptions var1);

        public URL getAbsoluteURL(DeploymentOptions var1);
    }

    private class ProjectDirectorySettings
    implements DirectorySettingsMarshaller {
        public void setRelativeFolder(DeploymentOptions opt, String relativeFolder) {
            opt.setDeployOutputFolder(relativeFolder);
        }

        public void setAbsoluteURL(DeploymentOptions opt, URL absoluteURL) {
            opt.setDeployOutputURL(absoluteURL);
        }

        public String getRelativeFolder(DeploymentOptions opt) {
            return opt.getDeployOutputFolder();
        }

        public URL getAbsoluteURL(DeploymentOptions opt) {
            return opt.getDeployOutputURL();
        }

        private ProjectDirectorySettings() {
        }

        ProjectDirectorySettings(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class ApplicationDirectorySettings
    implements DirectorySettingsMarshaller {
        public void setRelativeFolder(DeploymentOptions opt, String relativeFolder) {
            opt.setApplicationRelativeOutputFolder(relativeFolder);
        }

        public void setAbsoluteURL(DeploymentOptions opt, URL absoluteURL) {
            opt.setApplicationAbsoluteOutputURL(absoluteURL);
        }

        public String getRelativeFolder(DeploymentOptions opt) {
            return opt.getApplicationRelativeOutputFolder();
        }

        public URL getAbsoluteURL(DeploymentOptions opt) {
            return opt.getApplicationAbsoluteOutputURL();
        }

        private ApplicationDirectorySettings() {
        }

        ApplicationDirectorySettings(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

