/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.ide.index.Index;
import oracle.ide.index.IndexManager;
import oracle.ide.index.QueryCriteria;
import oracle.ide.index.task.BackgroundTask;
import oracle.ide.migration.MigrationInfo;
import oracle.ide.migration.NodeMigratorHelper;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.model.XMLDataNode;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.jdeveloper.deploy.dt.AbstractHashDependable;
import oracle.jdeveloper.deploy.dt.Deployment;
import oracle.jdeveloper.deploy.dt.DeploymentProfiles;
import oracle.jdeveloper.deploy.dt.Profile;
import oracle.jdevimpl.deploy.common.DataContainerNodeDependable;
import oracle.jdevimpl.deploy.common.DefaultProfileDependable;
import oracle.jdevimpl.deploy.common.DependableContainer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentProfilesMigrator
extends NodeMigratorHelper {
    private TraversableContext _traversableContext;
    private static String NUMBER_OF_PROJECTS_IN_WORKSPACE = "NumOfProjects";
    private static String MIGRATION_PROJECT_COUNTER = "ProjectCounter";
    public static String DEPLOYMENT_PROFILES_MIGRATOR = "DeploymentProfilesMigrator";
    public static String PROFILE_NODE = "ProfileNode";
    public static String WORKSPACE_PROFILE_MAP = "WorkspaceProfileMap";
    public static String MIGRATION_FROM_VERSION = "MigrationFromVersion";
    public static String MIGRATION_FROM_JM9 = "JM9";
    public static String MIGRATION_FROM_10 = "V10";
    public static String[] PROFILE_TYPE_TO_CLASS_CONVERTER = new String[]{"oracle.jdeveloper.deploy.dt.Profile", "oracle.jdeveloper.deploy.jar.ArchiveProfile", "oracle.jdeveloper.deploy.ear.EarProfile", "oracle.jdeveloper.deploy.ejb.EjbProfile", "oracle.jdeveloper.deploy.war.WarProfile", "oracle.jdeveloper.deploy.jar.ClientProfile", "oracle.jdeveloper.deploy.jar.ConnectorProfile", "oracle.jdeveloper.deploy.jar.TaglibProfile", "oracle.jdeveloper.deploy.sp.StoredProcProfile", "oracle.jdevimpl.webservices.deploy.WebServicesArchiveProfile", "oracle.jdeveloper.deploy.oar.OarProfile", "oracle.jdeveloper.deploy.mar.MetadataProfile", "oracle.jdeveloper.deploy.sar.SarProfile", "oracle.jbo.dt.jdevx.deploy.JbdEJBProfile", "oracle.jbo.dt.jdevx.deploy.JbdJboProfile", "oracle.jdeveloper.deploy.jar.AppClientProfile", "oracle.adfdt.common.deploy.impl.AdfLibraryProfile", "oracle.jbo.dt.jdevx.deploy.jbdSDOProfile"};

    DeploymentProfilesMigrator() {
    }

    public String getNodeMigratorHelperVersion() {
        String version = super.getNodeMigratorHelperVersion();
        if (version.equals("11.1.1.0.0")) {
            return "11.1.1.0.0.1";
        }
        return version;
    }

    public boolean isLastProjectToMigrate() {
        Integer counter = (Integer)this._traversableContext.get(MIGRATION_PROJECT_COUNTER);
        Integer numberOfProjects = (Integer)this._traversableContext.get(NUMBER_OF_PROJECTS_IN_WORKSPACE);
        return counter != null && numberOfProjects != null && counter.equals(numberOfProjects);
    }

    public void migrate(MigrationInfo[] infos, TraversableContext context) {
        this._traversableContext = context;
        this._traversableContext.put(DEPLOYMENT_PROFILES_MIGRATOR, (Object)this);
        Integer migrationProjectCounter = (Integer)this._traversableContext.get(MIGRATION_PROJECT_COUNTER);
        if (migrationProjectCounter == null) {
            migrationProjectCounter = new Integer(0);
        }
        this._traversableContext.put(MIGRATION_PROJECT_COUNTER, (Object)new Integer(migrationProjectCounter + 1));
        int infosLength = infos.length;
        int i = 0;
        while (i < infosLength) {
            Node node = infos[i].getNode();
            if (node instanceof Project) {
                Deployment.processLoad();
                if (this._traversableContext.get(WORKSPACE_PROFILE_MAP) == null) {
                    this.buildWorkspaceProfileMaps();
                }
                DeploymentProfiles.projectMigrating((Project)node, context);
            }
            ++i;
        }
    }

    private static void addChildren(Map profileMap, Project project) {
        Index index = IndexManager.getIndexManager().getIndex(project);
        QueryCriteria criteria = new QueryCriteria();
        criteria.put((Object)"file.extension", (Object)".bcdeploy|.deploy");
        BackgroundTask query = index.query(criteria);
        try {
            try {
                URL[] results;
                URL[] uRLArray = results = (URL[])query.get();
                int n = 0;
                while (n < uRLArray.length) {
                    URL url = uRLArray[n];
                    try {
                        Node node = NodeFactory.findOrCreate((URL)url);
                        if (node instanceof XMLDataNode) {
                            Object xmlDataNode = node.getData();
                            if (xmlDataNode instanceof Profile) {
                                Profile profile = (Profile)node.getData();
                                String newProfileRef = DeploymentProfilesMigrator.getNewProfileRef((oracle.ide.model.Element)project, (Locatable)node);
                                if (profile.mayHaveChildren()) {
                                    profileMap.put(node.getURL(), newProfileRef);
                                    Iterator iter = node.getChildren();
                                    while (iter != null && iter.hasNext()) {
                                        XMLDataNode subXmlDataNode;
                                        Object object;
                                        Object subChild = iter.next();
                                        if (!(subChild instanceof XMLDataNode) || !((object = (subXmlDataNode = (XMLDataNode)subChild).getData()) instanceof Profile)) continue;
                                        String subProfileRef = DeploymentProfilesMigrator.getNewProfileRef((oracle.ide.model.Element)node, (Locatable)subXmlDataNode);
                                        profileMap.put(subXmlDataNode.getURL(), subProfileRef);
                                    }
                                } else if (!profileMap.containsKey(node.getURL())) {
                                    profileMap.put(node.getURL(), newProfileRef);
                                }
                            } else if (URLFileSystem.hasSuffix((URL)node.getURL(), (String)".deploy")) {
                                profileMap.put(node.getURL(), null);
                            }
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    ++n;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                index.release();
                return;
            }
        }
        finally {
            index.release();
        }
    }

    public static Map<URL, String> buildProjectProfileMap(Project project) {
        HashMap<URL, String> profileMap = new HashMap<URL, String>();
        DeploymentProfilesMigrator.addChildren(profileMap, project);
        return profileMap;
    }

    public void buildWorkspaceProfileMaps() {
        Workspace workspace = (Workspace)this._traversableContext.get("workspace-node-instance");
        int numberOfProjects = 0;
        if (workspace != null) {
            HashMap<URL, Map<URL, String>> workspaceProfileMap = new HashMap<URL, Map<URL, String>>();
            Iterator workspaceIterator = workspace.getChildren();
            while (workspaceIterator != null && workspaceIterator.hasNext()) {
                Object child = workspaceIterator.next();
                if (!(child instanceof Project)) continue;
                Project project = (Project)child;
                Map<URL, String> projectProfileMap = DeploymentProfilesMigrator.buildProjectProfileMap(project);
                workspaceProfileMap.put(project.getURL(), projectProfileMap);
                ++numberOfProjects;
            }
            this._traversableContext.put(WORKSPACE_PROFILE_MAP, workspaceProfileMap);
        } else {
            this._traversableContext.put(WORKSPACE_PROFILE_MAP, null);
        }
        this._traversableContext.put(NUMBER_OF_PROJECTS_IN_WORKSPACE, (Object)new Integer(numberOfProjects));
    }

    public String getProfileRefPart(URL projectURL, URL profileURL) {
        Map workspaceProfileMap = (Map)this._traversableContext.get(WORKSPACE_PROFILE_MAP);
        if (workspaceProfileMap != null) {
            Map projectProfileMap = (Map)workspaceProfileMap.get(projectURL);
            return (String)projectProfileMap.get(profileURL);
        }
        return null;
    }

    private static List getOldProfileDepsList(URL profileNodeURL) {
        ArrayList<DepAttributes> depsList = new ArrayList<DepAttributes>();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder domBuilder = null;
            Document doc = null;
            factory.setValidating(false);
            factory.setIgnoringElementContentWhitespace(true);
            domBuilder = factory.newDocumentBuilder();
            String path = profileNodeURL.getPath();
            doc = domBuilder.parse(new File(path));
            Element el = doc.getDocumentElement();
            NodeList deps = el.getElementsByTagName("profileDeps");
            int size = deps.getLength();
            if (size != 0) {
                org.w3c.dom.Node depsNode = deps.item(0);
                NodeList items = depsNode.getChildNodes();
                int ii = 0;
                while (ii < items.getLength()) {
                    org.w3c.dom.Node itemNode = items.item(ii);
                    if (itemNode.getNodeName().equals("Item")) {
                        NodeList depsItemNodes = itemNode.getChildNodes();
                        DepAttributes depAttributes = new DepAttributes();
                        int iii = 0;
                        while (iii < depsItemNodes.getLength()) {
                            org.w3c.dom.Node depsItemNode = depsItemNodes.item(iii);
                            NamedNodeMap attr = depsItemNode.getAttributes();
                            if (attr != null) {
                                depAttributes.setAttribute(depsItemNode.getNodeName(), attr.item(0).getNodeValue());
                            }
                            ++iii;
                        }
                        depsList.add(depAttributes);
                    }
                    ++ii;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return depsList;
    }

    public static String getDependableProfileName(AbstractHashDependable dep) {
        HashStructure depHash = dep.getHashStructure();
        return depHash.getString("profileName");
    }

    public static void setDependableProfileName(AbstractHashDependable dep, String profileName) {
        HashStructure depHash = dep.getHashStructure();
        depHash.putString("profileName", profileName);
    }

    public static URL getDependableContainerURL(AbstractHashDependable dep) {
        HashStructure depHash = dep.getHashStructure();
        return depHash.getURL("ownerURL");
    }

    public static Profile getProfileFromPreFusionProfileNode(TraversableContext tc) {
        Node profileNode = (Node)tc.get(PROFILE_NODE);
        List depsList = DeploymentProfilesMigrator.getOldProfileDepsList(profileNode.getURL());
        Profile profile = (Profile)profileNode.getData();
        try {
            profileNode.markDirty(false);
            profileNode.close();
            NodeFactory.uncache((URL)profileNode.getURL());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Project project = (Project)tc.get("Project");
        profile.setDataContainer((DataContainer)project);
        ListStructure dependencyListHash = ListStructure.newInstance();
        int i = 0;
        while (i < depsList.size()) {
            DepAttributes dep = (DepAttributes)depsList.get(i);
            String profileURLString = dep.profileURL;
            String projectURLString = dep.projectURL;
            String pathInEar = dep.pathInEar;
            String urls = profileNode.getURL().toString();
            urls = urls.substring(0, urls.lastIndexOf("/"));
            URL baseURL = URLFactory.newURL((String)urls);
            URL projectURL = URLFactory.newURL((URL)baseURL, (String)projectURLString);
            URL profileURL = URLFactory.newURL((URL)baseURL, (String)profileURLString);
            HashStructure itemHash = HashStructure.newInstance();
            if (URLFileSystem.hasSuffix((URL)profileURL, (String)".jar")) {
                itemHash.putString("adapterClass", DataContainerNodeDependable.class.getName());
                itemHash.putURL("ownerURL", projectURL);
                itemHash.putURL("sourceURL", profileURL);
            } else {
                itemHash.putString("adapterClass", DefaultProfileDependable.class.getName());
                itemHash.putURL("ownerURL", projectURL);
                itemHash.putString("profileName", profileURL.toString());
                if (pathInEar != null && pathInEar.length() != 0) {
                    itemHash.putString("pathInEar", pathInEar);
                }
            }
            dependencyListHash.add((Object)itemHash);
            ++i;
        }
        HashStructure dependenciesHash = HashStructure.newInstance();
        dependenciesHash.putListStructure(DependableContainer.DEPENDENCY_KEY, dependencyListHash);
        HashStructure profileHash = profile.getHashStructure();
        profileHash.putHashStructure(Profile.PROFILE_DEPENDENCIES, dependenciesHash);
        return profile;
    }

    public Map<URL, String> getWorkspaceProfileMap() {
        HashMap<URL, String> result = new HashMap<URL, String>();
        Map workspaceProfileMap = (Map)this._traversableContext.get(WORKSPACE_PROFILE_MAP);
        Collection profileMapCollection = workspaceProfileMap.values();
        Iterator profileMapIterator = profileMapCollection.iterator();
        while (profileMapIterator != null && profileMapIterator.hasNext()) {
            Map projectProfileMap = (Map)profileMapIterator.next();
            Set projectProfileMapSet = projectProfileMap.entrySet();
            if (projectProfileMapSet == null || projectProfileMapSet.size() == 0) continue;
            Iterator profileIter = projectProfileMapSet.iterator();
            while (profileIter != null && profileIter.hasNext()) {
                Map.Entry entry = profileIter.next();
                URL profileURL = (URL)entry.getKey();
                String newRefPart = (String)entry.getValue();
                if (result.containsKey(profileURL)) continue;
                result.put(profileURL, newRefPart);
            }
        }
        return result;
    }

    public Map<URL, String> getProjectProfileMap(URL projectURL) {
        Map workspaceProfileMap = (Map)this._traversableContext.get(WORKSPACE_PROFILE_MAP);
        if (workspaceProfileMap != null) {
            Map projectProfileMap = (Map)workspaceProfileMap.get(projectURL);
            return projectProfileMap;
        }
        return null;
    }

    public Map<URL, String> getProjectProfileMap(Project project) {
        return this.getProjectProfileMap(project.getURL());
    }

    private static String getProfileNameFromPreFusionURL(URL profileURL) {
        String result = profileURL.toString();
        result = result.substring(0, result.lastIndexOf("."));
        result = result.substring(result.lastIndexOf("/") + 1);
        return result;
    }

    private static String getNewProfileRef(oracle.ide.model.Element parent, Locatable profileLoc) {
        String refPartPrefix = "";
        if (Deployment.isDeploymentContainerProfile(parent)) {
            URL parentURL = ((Locatable)parent).getURL();
            String profileName = DeploymentProfilesMigrator.getProfileNameFromPreFusionURL(parentURL);
            refPartPrefix = profileName + "#" + profileName + "_";
        }
        String refPartSuffix = DeploymentProfilesMigrator.getProfileNameFromPreFusionURL(profileLoc.getURL());
        return refPartPrefix + refPartSuffix;
    }

    public static class DepAttributes {
        public String pathInEar = "";
        public String profileURL = "";
        public String projectURL = "";

        public void setAttribute(String attrName, String attrValue) {
            if (attrName.equals("pathInEar")) {
                if (!attrValue.equals("java.lang.String")) {
                    this.pathInEar = attrValue;
                }
            } else if (attrName.equals("profileURL")) {
                this.profileURL = attrValue;
            } else if (attrName.equals("projectURL")) {
                this.projectURL = attrValue;
            }
        }
    }
}

